/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.nocode.converter.NoCodeConverterConstants;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeNodeJsonConverter;

public class NoCodeNotifyTaskJsonConverter
extends NoCodeNodeJsonConverter {
    private static final String PHONES = "phones";
    private static final String EMAILS = "emails";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String phones = noCodeJson.getString(PHONES);
        this.setNoCodePropertyValue(properties, PHONES, phones);
        String emails = noCodeJson.getString(EMAILS);
        this.setNoCodePropertyValue(properties, EMAILS, emails);
        JSONArray inMsgs = new JSONArray();
        inMsgs.add((Object)this.createInMsgJson(noCodeJson, properties));
        properties.put("inMsg", (Object)inMsgs);
        return workflowJson;
    }

    private JSONObject createInMsgJson(JSONObject noCodeJson, JSONObject properties) {
        JSONObject inMsg = super.createInMsgJson(noCodeJson, "content", "start");
        Object noCodeReceiver = noCodeJson.get((Object)"receiver");
        if (noCodeReceiver != null) {
            this.setNoCodePropertyValue(properties, "inMsg.receiver", noCodeReceiver);
            JSONArray participants = this.createParticipantJson(noCodeReceiver, "inMsg.receiver");
            inMsg.put("receiver", (Object)participants);
        }
        return inMsg;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        JSONArray inMsg = properties.getJSONArray("inMsg");
        if (inMsg == null || inMsg.isEmpty()) {
            return noCodeJson;
        }
        String phones = (String)this.getNoCodePropertyValue(properties, PHONES);
        noCodeJson.put(PHONES, (Object)phones);
        String emails = (String)this.getNoCodePropertyValue(properties, EMAILS);
        noCodeJson.put(EMAILS, (Object)emails);
        JSONObject item = inMsg.getJSONObject(0);
        String content = item.getString(this.getOriginalContentKey("content"));
        noCodeJson.put("content", (Object)content);
        String notifyType = item.getString("notifytype");
        noCodeJson.put("notifytype", (Object)notifyType);
        JSONArray receivers = item.getJSONArray("receiver");
        Object noCodeReceivers = this.getNoCodeParticipant(receivers, "inMsg.receiver", properties);
        noCodeJson.put("receiver", noCodeReceivers);
        return noCodeJson;
    }

    @Override
    protected String getStencilType(String type) {
        return "NotifyTask";
    }

    @Override
    protected Long getTemplateId() {
        return NoCodeConverterConstants.TEMPLATEID_NOCODENOTIFYTASK;
    }
}

