/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.nocode.NoCodeEntityInfo;
import kd.bos.workflow.nocode.converter.AbstractNoCodeJsonConverter;
import kd.bos.workflow.nocode.converter.INoCodeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeJsonConverterFactory;

public class NoCodeProcessJsonConverter
extends AbstractNoCodeJsonConverter {
    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = new JSONObject();
        JSONArray nodes = noCodeJson.getJSONArray("nodes");
        JSONArray edges = noCodeJson.getJSONArray("edges");
        if (nodes == null) {
            nodes = new JSONArray();
        }
        if (edges == null) {
            edges = new JSONArray();
        }
        workflowJson.put("stencil", (Object)this.createStencilJson("BPMNDiagram"));
        String id = noCodeJson.getString("id");
        workflowJson.put("resourceId", (Object)id);
        JSONObject properties = new JSONObject();
        String name = noCodeJson.getString("name");
        String number = noCodeJson.getString("key");
        properties.put("name", (Object)name);
        properties.put("process_id", (Object)number);
        properties.put("businessId", (Object)number);
        properties.put("processType", (Object)ModelType.NoCodeFlow.name());
        Long orgId = noCodeJson.getLong("orgUnitId");
        if (WfUtils.isEmpty(orgId)) {
            orgId = RequestContext.get().getOrgId();
        }
        if (WfUtils.isEmpty(orgId)) {
            orgId = OrgUnitServiceHelper.getRootOrgId();
        }
        properties.put("orgUnitId", (Object)orgId);
        properties.put("billExceptionOp", (Object)this.createBillExceptionOpJson());
        properties.put("executionlisteners", (Object)this.createExecutionListenersJson());
        JSONObject startNode = this.getStartNodeJson(nodes);
        if (startNode != null) {
            String triggerMode = startNode.getString("fireType");
            String fireKind = startNode.getString("fireKind");
            if (fireKind != null && fireKind.contains("bizOperate")) {
                String operation = "bizOperate";
                triggerMode = WfUtils.isNotEmpty(triggerMode) ? String.format("%s,%s", triggerMode, operation) : operation;
            }
            properties.put("triggerMode", (Object)triggerMode);
            String entityNumber = startNode.getString("formId");
            if (WfUtils.isNotEmpty(entityNumber)) {
                try {
                    NoCodeEntityInfo entityInfo = context.getEntityInfo(entityNumber);
                    properties.put("entraBillId", (Object)entityInfo.getEntityId());
                    properties.put("entraBill", (Object)entityInfo.getEntityNumber());
                    properties.put("entraBillName", (Object)entityInfo.getEntityName());
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        }
        this.initConvertContext(context, properties);
        workflowJson.put("properties", (Object)properties);
        JSONArray childShapes = new JSONArray(nodes.size() + edges.size());
        HashMap<String, ArrayList<String>> outgoingMap = new HashMap<String, ArrayList<String>>(nodes.size());
        HashMap<String, ArrayList<String>> incomingMap = new HashMap<String, ArrayList<String>>(nodes.size());
        INoCodeJsonConverter converter = NoCodeJsonConverterFactory.getConverter("SequenceFlow");
        for (Object edgeObj : edges) {
            JSONObject edge = (JSONObject)edgeObj;
            String source = edge.getString("source");
            String target = edge.getString("target");
            ArrayList<String> targets = (ArrayList<String>)outgoingMap.get(source);
            if (targets == null) {
                targets = new ArrayList<String>();
                outgoingMap.put(source, targets);
            }
            targets.add(edge.getString("itemId"));
            ArrayList<String> sources = (ArrayList<String>)incomingMap.get(target);
            if (sources == null) {
                sources = new ArrayList<String>();
                incomingMap.put(target, sources);
            }
            sources.add(edge.getString("itemId"));
            JSONObject workflowEdge = converter.convertToWorkflowJson(context, edge);
            childShapes.add((Object)workflowEdge);
        }
        for (Object nodeObj : nodes) {
            JSONObject node = (JSONObject)nodeObj;
            String type = node.getString("_Type_");
            String itemId = node.getString("itemId");
            converter = NoCodeJsonConverterFactory.getConverter(type);
            JSONObject workflowNode = converter.convertToWorkflowJson(context, node);
            List targets = (List)outgoingMap.get(itemId);
            if (targets != null) {
                workflowNode.put("outgoing", (Object)this.createOutgoingJson(targets.toArray(new String[0])));
            }
            List sources = (List)incomingMap.get(itemId);
            JSONObject nodeProperties = workflowNode.getJSONObject("properties");
            if (sources != null && sources.size() > 1) {
                nodeProperties.put("join", (Object)true);
                nodeProperties.put("inSet", (Object)"enterwhenallarrive");
            }
            if (targets != null && targets.size() > 1) {
                nodeProperties.put("fork", (Object)true);
                String outSet = nodeProperties.getString("outSet");
                if (outSet == null) {
                    nodeProperties.put("outSet", (Object)"leavewhenallmeet");
                }
            }
            childShapes.add((Object)workflowNode);
        }
        workflowJson.put("childShapes", (Object)childShapes);
        return workflowJson;
    }

    private JSONArray createExecutionListenersJson() {
        JSONArray listeners = new JSONArray();
        listeners.add((Object)this.createExecutionListenerJson("start"));
        listeners.add((Object)this.createExecutionListenerJson("end"));
        listeners.add((Object)this.createExecutionListenerJson("terminate"));
        listeners.add((Object)this.createExecutionListenerJson("procInstWithdraw"));
        return listeners;
    }

    private JSONObject createExecutionListenerJson(String event) {
        JSONObject listener = new JSONObject();
        listener.put("implementationtype", (Object)"class");
        listener.put("event", (Object)event);
        String implementation = ExternalInterfaceUtil.getFormattedValue("class", "kd.bos.workflow.nocode.NoCodeProcessPlugin");
        listener.put("implementation", (Object)implementation);
        listener.put("id", (Object)BpmnDiffUtil.getListElementId("executionListeners"));
        return listener;
    }

    private JSONArray createBillExceptionOpJson() {
        JSONArray ops = new JSONArray();
        JSONObject op = new JSONObject();
        op.put("id", (Object)BpmnDiffUtil.getListElementId("billExceptionOp"));
        op.put("oper", (Object)"delete");
        op.put("procaction", (Object)"terminate");
        ops.add((Object)op);
        return ops;
    }

    private void initConvertContext(NoCodeJsonConvertContext context, JSONObject properties) {
        String procNumber = properties.getString("process_id");
        String entityId = properties.getString("entraBillId");
        String entityNumber = properties.getString("entraBill");
        String entityName = properties.getString("entraBillName");
        context.setProcNumber(procNumber);
        context.setEntityId(entityId);
        context.setEntityName(entityName);
        context.setEntityNumber(entityNumber);
    }

    private JSONObject getStartNodeJson(JSONArray nodes) {
        for (Object nodeObj : nodes) {
            JSONObject node = (JSONObject)nodeObj;
            if (!"StartSignalEvent".equals(node.getString("_Type_"))) continue;
            return node;
        }
        return null;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject noCodeJson = new JSONObject();
        JSONObject properties = workflowJson.getJSONObject("properties");
        String id = workflowJson.getString("resourceId");
        String name = properties.getString("name");
        String number = properties.getString("process_id");
        noCodeJson.put("id", (Object)id);
        noCodeJson.put("name", (Object)name);
        noCodeJson.put("key", (Object)number);
        noCodeJson.put("_Type_", (Object)"NoCodeWfMetaData");
        JSONArray nodes = new JSONArray();
        JSONArray edges = new JSONArray();
        JSONObject startNode = null;
        INoCodeJsonConverter converter = null;
        INoCodeJsonConverter edgeConverter = NoCodeJsonConverterFactory.getConverter("SequenceFlow");
        JSONArray childShapes = workflowJson.getJSONArray("childShapes");
        if (childShapes == null) {
            childShapes = new JSONArray();
        }
        for (Object childObj : childShapes) {
            String template;
            JSONObject child = (JSONObject)childObj;
            JSONObject stencil = child.getJSONObject("stencil");
            String stencilType = this.getStencilIdFromJson(stencil);
            if ("SequenceFlow".equals(stencilType)) {
                edges.add((Object)edgeConverter.convertToNoCodeJson(context, child));
                continue;
            }
            JSONObject childProperties = child.getJSONObject("properties");
            if (childProperties != null && WfUtils.isNotEmpty(template = childProperties.getString("template"))) {
                stencilType = template;
            }
            converter = NoCodeJsonConverterFactory.getConverter(stencilType);
            JSONObject noCodeNode = converter.convertToNoCodeJson(context, child);
            nodes.add((Object)noCodeNode);
            if (!"StartSignalEvent".equals(stencilType)) continue;
            startNode = noCodeNode;
        }
        if (!nodes.isEmpty()) {
            noCodeJson.put("nodes", (Object)nodes);
        }
        if (!edges.isEmpty()) {
            noCodeJson.put("edges", (Object)edges);
        }
        if (startNode != null) {
            String entityNumber = properties.getString("entraBill");
            startNode.put("formId", (Object)entityNumber);
        }
        return noCodeJson;
    }
}

