/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeNodeJsonConverter;

public class NoCodeStartEventJsonConverter
extends NoCodeNodeJsonConverter {
    private static final String VALUE_TIME = "time";
    private static final String ORIGINAL_STENCIL = "originalStencil";
    private static final String PROPERTY_TRIGGERMODE = "triggerMode";
    private static final String PROPERTY_STARTTIME = "startTime";
    private static final String PROPERTY_ENDTIME = "endTime";
    private static final String PROPERTY_LOOPTYPE = "loopType";
    private static final String PROPERTY_TRIGGERTIME = "triggerTime";
    private static final String PROPERTY_QUERYFORMID = "queryFormId";
    private static final String PROPERTY_FILTER = "filter";
    private static final String PROPERTY_ORDERBY = "orderBy";
    private static final String PROPERTY_QUERYNUMBER = "queryNumber";
    private static final String PROPERTY_TOPNUMBER = "topNumber";
    private static final String PROPERTY_CRONEXPRESSION = "cronExpression";
    private static final String PROPERTY_PARAMS = "params";
    private static final String PROPERTY_AUTOSERVICE = "autoService";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        properties.put("signalref", (Object)context.getProcNumber());
        String fireKind = noCodeJson.getString("fireKind");
        this.setNoCodePropertyValue(properties, "fireKind", fireKind);
        String fireType = noCodeJson.getString("fireType");
        this.setNoCodePropertyValue(properties, "fireType", fireType);
        this.convertTimingConfigToWorkflowJson(workflowJson, noCodeJson);
        return workflowJson;
    }

    private void convertTimingConfigToWorkflowJson(JSONObject workflowJson, JSONObject noCodeJson) {
        JSONObject properties = workflowJson.getJSONObject("properties");
        String triggerMode = noCodeJson.getString(PROPERTY_TRIGGERMODE);
        this.setNoCodePropertyValue(properties, PROPERTY_TRIGGERMODE, triggerMode);
        if (VALUE_TIME.equals(triggerMode)) {
            this.setNoCodePropertyValue(properties, ORIGINAL_STENCIL, this.getStencilIdFromJson(workflowJson.getJSONObject("stencil")));
            workflowJson.put("stencil", (Object)this.createStencilJson("StartTimerEvent"));
        }
        String startTime = noCodeJson.getString(PROPERTY_STARTTIME);
        this.setNoCodePropertyValue(properties, PROPERTY_STARTTIME, startTime);
        String endTime = noCodeJson.getString(PROPERTY_ENDTIME);
        this.setNoCodePropertyValue(properties, PROPERTY_ENDTIME, endTime);
        String loopType = noCodeJson.getString(PROPERTY_LOOPTYPE);
        this.setNoCodePropertyValue(properties, PROPERTY_LOOPTYPE, loopType);
        Object triggerTime = noCodeJson.get((Object)PROPERTY_TRIGGERTIME);
        this.setNoCodePropertyValue(properties, PROPERTY_TRIGGERTIME, triggerTime);
        String queryFormId = noCodeJson.getString(PROPERTY_QUERYFORMID);
        this.setNoCodePropertyValue(properties, PROPERTY_QUERYFORMID, queryFormId);
        Object filter = noCodeJson.get((Object)PROPERTY_FILTER);
        this.setNoCodePropertyValue(properties, PROPERTY_FILTER, filter);
        Object orderBy = noCodeJson.get((Object)PROPERTY_ORDERBY);
        this.setNoCodePropertyValue(properties, PROPERTY_ORDERBY, orderBy);
        String queryNumber = noCodeJson.getString(PROPERTY_QUERYNUMBER);
        this.setNoCodePropertyValue(properties, PROPERTY_QUERYNUMBER, queryNumber);
        String topNumber = noCodeJson.getString(PROPERTY_TOPNUMBER);
        this.setNoCodePropertyValue(properties, PROPERTY_TOPNUMBER, topNumber);
        List cronExpressions = (List)noCodeJson.get((Object)PROPERTY_CRONEXPRESSION);
        this.setNoCodePropertyValue(properties, PROPERTY_CRONEXPRESSION, cronExpressions);
        Object params = noCodeJson.get((Object)PROPERTY_PARAMS);
        this.setNoCodePropertyValue(properties, PROPERTY_PARAMS, params);
        Object autoService = noCodeJson.get((Object)PROPERTY_AUTOSERVICE);
        this.setNoCodePropertyValue(properties, PROPERTY_AUTOSERVICE, autoService);
        String timeRegex = "(\\d{4}-\\d{2}-\\d{2}) (\\d{2}:\\d{2}:\\d{2})";
        if (cronExpressions == null || cronExpressions.isEmpty() || startTime == null || endTime == null || !startTime.matches(timeRegex) || !endTime.matches(timeRegex)) {
            this.log.warn("cron expressions is null or startTime is invalid or endTime is inValid.");
            return;
        }
        String timeTpl = "$1T$2";
        JSONArray timingConfigs = new JSONArray();
        for (String cronExpression : cronExpressions) {
            JSONObject timingConfig = new JSONObject();
            timingConfig.put("timeCycle", (Object)cronExpression);
            timingConfig.put("startDate", (Object)startTime.replaceFirst(timeRegex, timeTpl));
            timingConfig.put("endDate", (Object)endTime.replaceFirst(timeRegex, timeTpl));
            timingConfigs.add((Object)timingConfig);
        }
        properties.put("timingConfigs", (Object)timingConfigs);
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String fireKind = (String)this.getNoCodePropertyValue(properties, "fireKind");
        noCodeJson.put("fireKind", (Object)fireKind);
        String fireType = (String)this.getNoCodePropertyValue(properties, "fireType");
        noCodeJson.put("fireType", (Object)fireType);
        this.convertTimingConfigToNoCodeJson(properties, noCodeJson);
        return noCodeJson;
    }

    private void convertTimingConfigToNoCodeJson(JSONObject properties, JSONObject noCodeJson) {
        String originalStencil = (String)this.getNoCodePropertyValue(properties, ORIGINAL_STENCIL);
        if (WfUtils.isNotEmpty(originalStencil)) {
            noCodeJson.put("_Type_", (Object)originalStencil);
        }
        String triggerMode = (String)this.getNoCodePropertyValue(properties, PROPERTY_TRIGGERMODE);
        noCodeJson.put(PROPERTY_TRIGGERMODE, (Object)triggerMode);
        String startTime = (String)this.getNoCodePropertyValue(properties, PROPERTY_STARTTIME);
        noCodeJson.put(PROPERTY_STARTTIME, (Object)startTime);
        String endTime = (String)this.getNoCodePropertyValue(properties, PROPERTY_ENDTIME);
        noCodeJson.put(PROPERTY_ENDTIME, (Object)endTime);
        String loopType = (String)this.getNoCodePropertyValue(properties, PROPERTY_LOOPTYPE);
        noCodeJson.put(PROPERTY_LOOPTYPE, (Object)loopType);
        Object triggerTime = this.getNoCodePropertyValue(properties, PROPERTY_TRIGGERTIME);
        noCodeJson.put(PROPERTY_TRIGGERTIME, triggerTime);
        String queryFormId = (String)this.getNoCodePropertyValue(properties, PROPERTY_QUERYFORMID);
        noCodeJson.put(PROPERTY_QUERYFORMID, (Object)queryFormId);
        Object filter = this.getNoCodePropertyValue(properties, PROPERTY_FILTER);
        noCodeJson.put(PROPERTY_FILTER, filter);
        Object orderBy = this.getNoCodePropertyValue(properties, PROPERTY_ORDERBY);
        noCodeJson.put(PROPERTY_ORDERBY, orderBy);
        String queryNumber = (String)this.getNoCodePropertyValue(properties, PROPERTY_QUERYNUMBER);
        noCodeJson.put(PROPERTY_QUERYNUMBER, (Object)queryNumber);
        String topNumber = (String)this.getNoCodePropertyValue(properties, PROPERTY_TOPNUMBER);
        noCodeJson.put(PROPERTY_TOPNUMBER, (Object)topNumber);
        Object cronExpressions = this.getNoCodePropertyValue(properties, PROPERTY_CRONEXPRESSION);
        noCodeJson.put(PROPERTY_CRONEXPRESSION, cronExpressions);
        Object params = this.getNoCodePropertyValue(properties, PROPERTY_PARAMS);
        noCodeJson.put(PROPERTY_PARAMS, params);
        Object autoService = this.getNoCodePropertyValue(properties, PROPERTY_AUTOSERVICE);
        noCodeJson.put(PROPERTY_AUTOSERVICE, autoService);
    }
}

