/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.nocode.NoCodeEntityInfo;
import kd.bos.workflow.nocode.converter.AbstractNoCodeArtificialTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeConverterConstants;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;

public class NoCodeUserTaskJsonConverter
extends AbstractNoCodeArtificialTaskJsonConverter {
    private static final String KEY_ENTITYID = "entityId";
    private static final String KEY_ENTITYNUMBER = "entityNumber";
    private static final String KEY_ENTITYNAME = "entityName";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        this.convertEntityInfo(properties, noCodeJson, context);
        String billId = noCodeJson.getString("billId");
        this.setNoCodePropertyValue(properties, "billId", billId);
        String refNodeId = noCodeJson.getString("refNodeId");
        this.setNoCodePropertyValue(properties, "refNodeId", refNodeId);
        Object inputContent = noCodeJson.get((Object)"inputContent");
        this.setNoCodePropertyValue(properties, "inputContent", inputContent);
        Object triggerProcess = noCodeJson.get((Object)"triggerProcess");
        this.setNoCodePropertyValue(properties, "triggerProcess", triggerProcess);
        return workflowJson;
    }

    private void convertEntityInfo(JSONObject properties, JSONObject noCodeJson, NoCodeJsonConvertContext context) {
        String entityNumber = noCodeJson.getString("formId");
        properties.put(KEY_ENTITYNUMBER, (Object)entityNumber);
        try {
            NoCodeEntityInfo entityInfo = context.getEntityInfo(entityNumber);
            properties.put(KEY_ENTITYID, (Object)entityInfo.getEntityId());
            properties.put(KEY_ENTITYNAME, (Object)entityInfo.getEntityName());
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String entityNumber = properties.getString(KEY_ENTITYNUMBER);
        noCodeJson.put("formId", (Object)entityNumber);
        String billId = (String)this.getNoCodePropertyValue(properties, "billId");
        noCodeJson.put("billId", (Object)billId);
        String refNodeId = (String)this.getNoCodePropertyValue(properties, "refNodeId");
        noCodeJson.put("refNodeId", (Object)refNodeId);
        Object inputContent = this.getNoCodePropertyValue(properties, "inputContent");
        noCodeJson.put("inputContent", inputContent);
        Object triggerProcess = this.getNoCodePropertyValue(properties, "triggerProcess");
        noCodeJson.put("triggerProcess", triggerProcess);
        return noCodeJson;
    }

    @Override
    protected String getNoCodeParticipantProperty() {
        return "inputUser";
    }

    @Override
    protected String getStencilType(String type) {
        return "UserTask";
    }

    @Override
    protected Long getTemplateId() {
        return NoCodeConverterConstants.TEMPLATEID_NOCODEUSERTASK;
    }
}

