/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.relservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.delegate.event.impl.BusinessExecuteEvent;
import kd.bos.workflow.engine.idempotent.IdempotentHelper;
import kd.bos.workflow.engine.idempotent.IdempotentInfo;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class BusinessLogicServiceHelper {
    private static Log logger = LogFactory.getLog(BusinessLogicServiceHelper.class);

    public static OperationResult invokeOperationService(String opNum, String entityNumber, Object[] params, Map<String, String> variable, Object context, AgentExecution execution) {
        try (TraceSpan tracer = Tracer.create((String)"WF_BIZINVOKE", (String)WfTracerHelper.wrapTagValue("invokeOperationService", opNum, entityNumber));){
            long start = System.currentTimeMillis();
            OperationResult result = BusinessLogicServiceHelper.invokeOperationServiceAsyc(opNum, entityNumber, params, variable, context, execution);
            long end = System.currentTimeMillis();
            logger.debug(String.format("operation [%s] cost [%s]", opNum, end - start));
            OperationResult operationResult = result;
            return operationResult;
        }
    }

    public static OperationResult invokeOperationService(String opNum, String entityNumber, Object[] params, Object context, AgentExecution execution) {
        return BusinessLogicServiceHelper.invokeOperationService(opNum, entityNumber, params, null, context, execution);
    }

    public static void dispatchExecuteBusinessExtItfEvent(AgentExecution execution, String value, Object params, boolean success, Object ret) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        if (configuration != null && configuration.getEventDispatcher().isEnabled()) {
            ActivitiEventType type = success ? ActivitiEventType.BUSINESS_EXECUTE_SUCCESS : ActivitiEventType.BUSINESS_EXECUTE_FAIL;
            BusinessExecuteEvent event = ActivitiEventBuilder.createBusinessExecuteEvent(type, execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), execution.getCurrentTaskId(), execution.getBusinessKey(), value, params, ret != null ? ret.toString() : "");
            configuration.getEventDispatcher().dispatchEvent(event);
        }
    }

    private static OperationResult invokeOperationServiceAsyc(String opNum, String entityNumber, Object[] ids, Map<String, String> variable, Object context, AgentExecution execution) {
        if (WfUtils.isEmpty(opNum) || ids == null || ids.length == 0) {
            logger.debug(String.format("invoke operation [%s],param ids.length is [%s]", opNum, ids == null || ids.length == 0 ? 0 : ids.length));
            return null;
        }
        try {
            HistoricActivityInstanceEntity actInst = IdempotentHelper.getLatestHistoricActivityInstance(execution);
            String xid = IdempotentHelper.generateXid(new StringBuilder(opNum), execution, actInst);
            logger.debug(String.format("[%s-%s-%s] xid=[%s]", opNum, entityNumber, execution.getBusinessKey(), xid));
            OperateOption options = OperateOption.create();
            if (variable != null && variable.size() > 0) {
                for (Map.Entry<String, String> entry : variable.entrySet()) {
                    options.setVariableValue(entry.getKey(), entry.getValue());
                }
            }
            options.setVariableValue("WF", "TRUE");
            options.setVariableValue("needlog", String.valueOf(true));
            options.setVariableValue("ishasright", String.valueOf(true));
            options.setVariableValue("skipCheckDataPermission", String.valueOf(true));
            options.setVariableValue("mutex_ignoremodify", "true");
            options.setVariableValue("ignoreinteraction", String.valueOf(true));
            options.setVariableValue("ignorewarn", String.valueOf(true));
            options.setVariableValue("cancle_standard_caSign", String.valueOf(true));
            options.setVariableValue("cancle_standard_caVerify", String.valueOf(true));
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            OperationResult ret = null;
            StringBuilder log = new StringBuilder();
            log.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\uff1a%1$s\uff0c\u5b9e\u4f53\uff1a%2$s\uff0c\u4e3b\u952e\uff1a%3$s\u3002", (String)"BusinessLogicServiceHelper_1", (String)"bos-wf-engine", (Object[])new Object[0]), opNum, entityNumber, ids[0]));
            if (entity.getPrimaryKey() instanceof LongProp) {
                Object[] tmp = new Object[ids.length];
                int i = 0;
                for (Object obj : ids) {
                    tmp[i] = obj instanceof String ? Long.valueOf((String)obj) : obj;
                    ++i;
                }
                ret = BusinessLogicServiceHelper.execute(execution, xid, entityNumber, opNum, tmp, options, actInst);
            } else {
                ret = BusinessLogicServiceHelper.execute(execution, xid, entityNumber, opNum, ids, options, actInst);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("xid", xid);
            params.put("entityNumber", entityNumber);
            params.put("ids", ids);
            BusinessLogicServiceHelper.dispatchExecuteBusinessExtItfEvent(execution, opNum, params, ret != null && ret.isSuccess(), ret);
            if (ret != null && ids.length != ret.getSuccessPkIds().size()) {
                StringBuilder sb = new StringBuilder();
                sb.append(ret.getMessage());
                List errs = ret.getAllErrorOrValidateInfo();
                String errorCode = null;
                if (errs != null && errs.size() > 0) {
                    for (IOperateInfo info : errs) {
                        if (info == null) continue;
                        if (info instanceof OperateErrorInfo && WfUtils.isEmpty(errorCode)) {
                            errorCode = ((OperateErrorInfo)info).getErrorCode();
                        }
                        sb.append(info.getTitle()).append(":").append(info.getMessage());
                    }
                }
                KDBizException e = new KDBizException(WFErrorCode.businessBizOperationValidateError(errorCode), new Object[]{sb.toString()});
                WFBizOperationException bizErr = new WFBizOperationException(e, WFErrorCode.businessBizOperationError(), sb.toString());
                bizErr.setOperationResult(ret);
                throw bizErr;
            }
            if (ret != null) {
                if (ret.isSuccess()) {
                    log.append(String.format(ResManager.loadKDString((String)"\uff1b\u7ed3\u679c[%s]", (String)"BusinessLogicServiceHelper_2", (String)"bos-wf-engine", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u529f", (String)"BusinessLogicServiceHelper_3", (String)"bos-wf-engine", (Object[])new Object[0])));
                } else {
                    log.append(String.format(ResManager.loadKDString((String)"\uff1b\u7ed3\u679c[%1$s],\u5931\u8d25\u4fe1\u606f[%2$s]", (String)"BusinessLogicServiceHelper_4", (String)"bos-wf-engine", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u8d25", (String)"BusinessLogicServiceHelper_5", (String)"bos-wf-engine", (Object[])new Object[0]), ret.getMessage()));
                }
            } else {
                log.append(",OperationResult is null!");
            }
            WfUtils.addOpLog("wf_execution", "executeBusinessLogic", new MultiLangEnumBridge("\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c", "BusinessLogicServiceHelper_6", "bos-wf-engine"), null, log.toString());
            return ret;
        }
        catch (KDBizException e) {
            WFBizOperationException bizErr = new WFBizOperationException(e, WFErrorCode.businessBizOperationError(), e.getMessage());
            throw bizErr;
        }
        catch (Exception e) {
            throw ExceptionUtil.createBusinessException(opNum, entityNumber, ids, context, e);
        }
    }

    private static OperationResult execute(AgentExecution execution, String xid, String entityNumber, String operation, Object[] ids, OperateOption options, HistoricActivityInstanceEntity actInst) {
        boolean ignoreFlag;
        String ignoreIdempotent = options.getVariableValue("ignoreIdempotent", String.valueOf(false));
        boolean bl = ignoreFlag = null == ignoreIdempotent ? false : Boolean.parseBoolean(ignoreIdempotent);
        if (IdempotentHelper.isEnableIdempotent() && BusinessLogicServiceHelper.supportIdempotent(execution) && !ignoreFlag) {
            return BusinessLogicServiceHelper.idepotentExecute(execution, xid, entityNumber, operation, ids, options, actInst);
        }
        return WfCommonUtil.executeOperate((String)operation, (String)entityNumber, (Object[])ids, (OperateOption)options);
    }

    private static boolean supportIdempotent(AgentExecution execution) {
        String eventName = null;
        AgentTask task = execution.getCurrentTask();
        if (task != null) {
            eventName = task.getEventName();
        }
        if (eventName == null) {
            eventName = execution.getEventName();
        }
        return eventName == null || !eventName.startsWith("approverModify") && !eventName.startsWith("afterCoordReq") && !eventName.startsWith("afterCoordReply") && !eventName.startsWith("afterCoordCancel");
    }

    private static OperationResult idepotentExecute(AgentExecution execution, String xid, String entityNumber, String operation, Object[] ids, OperateOption options, HistoricActivityInstanceEntity actInst) {
        String jsonResult = "";
        OperationResult ret = null;
        String businessKey = execution.getBusinessKey();
        Long instanceId = execution.getProcessInstanceId();
        String scene = IdempotentHelper.getExecuteScene("operation", execution);
        try {
            IdempotentInfo xidInfo = IdempotentHelper.findIdempotentInfoByXid(xid);
            if (xidInfo != null && "successed".equals(xidInfo.getState())) {
                logger.debug(String.format("operation %s has been executed!", operation));
                jsonResult = xidInfo.getResult();
                if (WfUtils.isNotEmpty(jsonResult)) {
                    try {
                        ret = (OperationResult)DataEntitySerializer.deSerializerFromString((String)jsonResult, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                        return ret;
                    }
                    catch (Exception e) {
                        IdempotentHelper.delete(xid);
                        logger.error(WfUtils.getExceptionStacktrace(e));
                    }
                }
            }
            if ((ret = WfCommonUtil.executeOperate((String)operation, (String)entityNumber, (Object[])ids, (OperateOption)options)) != null && ids.length != ret.getSuccessPkIds().size()) {
                return ret;
            }
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            jsonResult = DataEntitySerializer.serializerToString((Object)ret, (DataEntitySerializerOption)option);
            IdempotentHelper.success(xid, operation, businessKey, instanceId, jsonResult, actInst, scene);
            return ret;
        }
        catch (Exception e) {
            IdempotentHelper.fail(xid, operation, businessKey, instanceId, WfUtils.getExceptionStacktrace(e), actInst, scene);
            throw e;
        }
    }
}

