/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.relservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.relservice.position.WorkflowPositionQuery;

public class WorkflowUserRelQueryHelper {
    private static final Log logger = LogFactory.getLog(WorkflowUserRelQueryHelper.class);

    public static WorkflowPositionQuery getPositionQueryProvider() {
        WorkflowPositionQuery workflowPositionQuery = null;
        try {
            workflowPositionQuery = (WorkflowPositionQuery)ExtensionFactory.getExtensionFacotry(WorkflowPositionQuery.class).getExtension(WorkflowUserRelQueryHelper.getExtName());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u540d\u79f0\u4e3a%s\u7684\u5c97\u4f4d\u67e5\u8be2\u5b9e\u73b0\u7c7b\u5931\u8d25", (String)"WorkflowUserRelQueryHelper_1", (String)"bos-wf-engine", (Object[])new Object[]{WorkflowUserRelQueryHelper.getExtName()}));
        }
        return workflowPositionQuery;
    }

    private static String getExtName() {
        return "default";
    }

    public static Map<Long, ILocaleString> getUsernames(List<Long> userIds) {
        HashMap<Long, ILocaleString> userNameImapping = new HashMap<Long, ILocaleString>();
        if (WfUtils.isEmptyForCollection(userIds)) {
            return userNameImapping;
        }
        userIds.stream().forEach(userId -> {
            ILocaleString userName = WfCacheHelper.getUserName(String.valueOf(userId));
            if (WfUtils.isNotEmpty(userName)) {
                LocaleString userNameTemp = new LocaleString();
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    if (WfUtils.isEmpty((String)userName.get((Object)lang.name()))) continue;
                    userNameTemp.put((Object)lang.name(), userName.get((Object)lang.name()));
                }
                if (WfUtils.isNotEmpty((String)userName.get((Object)"GLang"))) {
                    userNameTemp.put((Object)"GLang", userName.get((Object)"GLang"));
                }
                userNameImapping.put((Long)userId, (ILocaleString)userNameTemp);
            }
        });
        Set userIds4Cache = userNameImapping.keySet();
        List userIds4NotCache = userIds.stream().filter(userId -> !userIds4Cache.contains(userId)).collect(Collectors.toList());
        if (userIds4NotCache == null || userIds4NotCache.isEmpty()) {
            return userNameImapping;
        }
        Map users = null;
        try {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIds4NotCache)};
            users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name,number", (QFilter[])filters);
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        if (users == null || users.isEmpty()) {
            return userNameImapping;
        }
        Collection values = users.values();
        List<String> uns = values.stream().map(user -> user.getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
        List<String> userNameRepeat = WorkflowUserRelQueryHelper.getUserNameRepeat(uns);
        values.stream().forEach(user -> {
            LocaleString lastUserName = new LocaleString();
            UserInfo userInfo = new UserInfo((DynamicObject)user);
            String userId = userInfo.getId();
            ILocaleString name = userInfo.getName();
            if (WfUtils.isEmpty(name)) {
                lastUserName = null;
            } else {
                LocaleString userNameTemp = new LocaleString();
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    if (WfUtils.isEmpty((String)name.get((Object)lang.name()))) continue;
                    userNameTemp.put((Object)lang.name(), name.get((Object)lang.name()));
                }
                userNameTemp.put((Object)"GLang", (Object)name.toString());
                if (userNameRepeat.contains(userNameTemp.getLocaleValue())) {
                    String number = userInfo.getNumber();
                    Set userKeySet = userNameTemp.keySet();
                    for (String key : userKeySet) {
                        String value = (String)userNameTemp.get((Object)key);
                        if (value == null || WfUtils.isEmpty(value)) continue;
                        if (WfUtils.isNotEmptyString(number) && !value.contains(number.toString())) {
                            lastUserName.put((Object)key, (Object)String.format("%s(%s)", value, number));
                            continue;
                        }
                        lastUserName.put((Object)key, (Object)String.format("%s", value));
                    }
                } else {
                    lastUserName = userNameTemp;
                }
            }
            userNameImapping.put(Long.parseLong(userId), (ILocaleString)lastUserName);
            WfCacheHelper.putUserName(userId, (ILocaleString)lastUserName);
        });
        return userNameImapping;
    }

    private static List<String> getUserNameRepeat(List<String> userNames) {
        if (WfUtils.isEmptyForCollection(userNames)) {
            return new ArrayList<String>();
        }
        boolean enableUserNameRepeatFormat = WfConfigurationUtil.isEnableUserNameRepeatFormat();
        if (!enableUserNameRepeatFormat) {
            return new ArrayList<String>();
        }
        StringBuilder sql = new StringBuilder("select ftruename from t_wf_secuserrepeat where ftruename in (");
        for (int i = 0; i < userNames.size(); ++i) {
            if (i == userNames.size() - 1) {
                sql.append("'").append(userNames.get(i)).append("') and flocaleid = '").append(RequestContext.get().getLang()).append("';");
                continue;
            }
            sql.append("'").append(userNames.get(i)).append("' ,");
        }
        ArrayList<String> uns = new ArrayList<String>();
        try (DataSet ds = DB.queryDataSet((String)"isUserNameRepeat", (DBRoute)DBRoute.workflow, (String)sql.toString(), null);){
            if (ds != null) {
                for (Row next : ds) {
                    uns.add(next.getString("ftruename"));
                }
            }
        }
        return uns;
    }
}

