/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.relservice.biz;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.relservice.biz.context.BusinessObjectQueryContext;

public class BusinessObjectQueryContextHelper {
    private static final Log logger = LogFactory.getLog(BusinessObjectQueryContextHelper.class);

    public static BusinessObjectQueryContext buildContext(String businessKey, String entityNumber, Map<String, Object> variables) {
        if (WfUtils.isEmptyForMap(variables)) {
            Map<String, Object> dataSourceMap = BusinessObjectQueryContextHelper.getDataSourceMap(businessKey, entityNumber);
            if (dataSourceMap == null) {
                return null;
            }
            variables = dataSourceMap;
        }
        String dataSourceType = "";
        if (WfUtils.isNotEmptyForMap(variables)) {
            boolean isCrossTenant = Boolean.parseBoolean(String.valueOf(variables.get("isCrossTenant")));
            dataSourceType = isCrossTenant ? "CT" : String.valueOf(variables.get("dataSourceType"));
        }
        BusinessObjectQueryContext context = null;
        HashMap<String, Object> dataSourceDetailsMap = new HashMap<String, Object>();
        if ("".equals(dataSourceType)) {
            dataSourceDetailsMap.put("dataSourceType", "LOCAL");
        } else if ("CT".equals(dataSourceType)) {
            String currentTenantId = String.valueOf(variables.get("currentTenantId"));
            String targetTenantId = String.valueOf(variables.get("targetTenantId"));
            String crossTenantInfoStr = (String)variables.get("crossTenantInfo");
            context = new BusinessObjectQueryContext();
            context.setDataSourceType("CT");
            context.addExtraQueryParam("currentTenantId", (Object)currentTenantId);
            context.addExtraQueryParam("targetTenantId", (Object)targetTenantId);
            context.addExtraQueryParam("crossTenantInfo", (Object)crossTenantInfoStr);
            dataSourceDetailsMap.put("dataSourceType", dataSourceType);
            dataSourceDetailsMap.put("currentTenantId", currentTenantId);
            dataSourceDetailsMap.put("targetTenantId", targetTenantId);
            dataSourceDetailsMap.put("crossTenantInfo", crossTenantInfoStr);
        }
        BusinessObjectQueryContextHelper.putDataSourceInThreadTruck(businessKey, entityNumber, dataSourceDetailsMap);
        return context;
    }

    private static void putDataSourceInThreadTruck(String businessKey, String entityNumber, Map<String, Object> dataSourceDetailsMap) {
        try {
            HashMap<String, Map<String, Object>> dataSourceMap = (HashMap<String, Map<String, Object>>)ThreadTruck.get((Object)"businessObjectDataSource");
            if (dataSourceMap == null) {
                dataSourceMap = new HashMap<String, Map<String, Object>>();
            }
            String key = String.format("%s_%s_%s", entityNumber, businessKey, "dataSource");
            if (dataSourceMap.isEmpty() || !dataSourceMap.containsKey(key)) {
                dataSourceMap.put(key, dataSourceDetailsMap);
                ThreadTruck.put((Object)"businessObjectDataSource", dataSourceMap);
            }
        }
        catch (Exception e) {
            logger.error(String.format("put dataSource in ThreadTruck error! error msg:[%s]", WfUtils.getExceptionStacktrace(e)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> getDataSourceMap(String businessKey, String entityNumber) {
        List<String> whiteList;
        try {
            String key;
            Map details;
            Map dataSourceMap = (Map)ThreadTruck.get((Object)"businessObjectDataSource");
            if (WfUtils.isNotEmptyForMap(dataSourceMap) && WfUtils.isNotEmptyForMap(details = (Map)dataSourceMap.get(key = String.format("%s_%s_%s", entityNumber, businessKey, "dataSource")))) {
                String dataSourceType = String.valueOf(details.get("dataSourceType"));
                if (!"LOCAL".equals(dataSourceType)) return details;
                return null;
            }
        }
        catch (Exception e) {
            logger.error(String.format("get businessObject dataSource from threadTruck error!, errorMsg:[%s]", WfUtils.getExceptionStacktrace(e)));
        }
        try {
            String source = WfCacheHelper.getTrdBusinessObjectDataSource(entityNumber, businessKey);
            if (StringUtils.isNotBlank((CharSequence)source)) {
                JSONObject json = (JSONObject)SerializationUtils.fromJsonString((String)source, JSONObject.class);
                return new HashMap<String, Object>((Map<String, Object>)json);
            }
        }
        catch (Exception e) {
            logger.error(String.format("get trd businessObject dataSource from redis error!, errorMsg:[%s]", WfUtils.getExceptionStacktrace(e)));
        }
        String configValue = WfConfigurationUtil.getCrossTenantEntityNumberWhiteList();
        if (StringUtils.isNotBlank((CharSequence)configValue) && !(whiteList = Arrays.asList(configValue.split(","))).contains(entityNumber)) {
            return null;
        }
        String sql = "select top 1 fsourcetype,fsourcedetailsjson from t_wf_trddatasourcerecord where fentitynumber = ? and fbusinesskey = ? order by fcreatedate desc";
        try (DataSet ds = DB.queryDataSet((String)"BusinessObjectQueryContext.trdDataSourceRecord", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{entityNumber, businessKey});){
            Iterator iter = ds.iterator();
            Map<String, Object> queryRet = new HashMap<String, Object>();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                String sourceType = row.getString("fsourcetype");
                String sourceDetailsJson = row.getString("fsourcedetailsjson");
                queryRet = (Map)SerializationUtils.fromJsonString((String)sourceDetailsJson, Map.class);
                queryRet.put("dataSourceType", sourceType);
            }
            if (!WfUtils.isNotEmptyForMap(queryRet)) return new HashMap<String, Object>();
            HashMap<String, Object> hashMap = queryRet;
            return hashMap;
        }
        catch (Exception e) {
            logger.error(String.format("get trdBusinessObject dataSource from DB error!, errorMsg:[%s]", WfUtils.getExceptionStacktrace(e)));
        }
        return new HashMap<String, Object>();
    }
}

