/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.relservice.position;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.participant.PositionRelationParser;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.relservice.position.WorkflowPositionQuery;

public class DefaultWorkflowPositionQuery
implements WorkflowPositionQuery {
    private static final Log logger = LogFactory.getLog(PositionRelationParser.class);

    @Override
    public List<Long> getSuperiorPositions(List<Long> positionIds, Long reportTypeId, Map<String, Object> params) {
        ArrayList<Long> superPositionIds = new ArrayList<Long>(positionIds.size());
        if (WfUtils.isEmptyForCollection(positionIds) || WfUtils.isEmpty(reportTypeId)) {
            return superPositionIds;
        }
        QFilter reportTypeIdFilter = new QFilter("reporttype.id", "=", (Object)reportTypeId);
        QFilter positionIdFilter = new QFilter("position.id", "in", positionIds);
        Map reportRelationObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_reportrelation", (QFilter[])new QFilter[]{reportTypeIdFilter, positionIdFilter});
        if (reportRelationObjMap.isEmpty()) {
            logger.debug(ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"DefaultWorkflowPositionQuery_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
        } else {
            reportRelationObjMap.forEach((positionId, positionObj) -> {
                if (positionObj != null && WfUtils.isNotEmpty(positionObj.getLong("superiorposition.id"))) {
                    superPositionIds.add(positionObj.getLong("superiorposition.id"));
                }
            });
        }
        return superPositionIds;
    }

    @Override
    public List<Long> getIndirectSuperiorPositions(List<Long> positions, Long reportTypeId, Map<String, Object> params) {
        ArrayList<Long> resultPositions = new ArrayList<Long>();
        if (WfUtils.isEmptyForCollection(positions) || WfUtils.isEmpty(reportTypeId)) {
            return resultPositions;
        }
        List<Long> superiorPositions = this.getSuperiorPositions(positions, reportTypeId, params);
        if (WfUtils.isNotEmptyForCollection(superiorPositions)) {
            resultPositions.addAll(this.getSuperiorPositions(superiorPositions, reportTypeId, params));
        }
        return resultPositions;
    }

    @Override
    public List<Long> getPosiontsByUserIdsAndOrgIds(List<Long> referencePersons, List<Long> referenceOrgIds, Map<String, Object> params) {
        if (WfUtils.isEmptyForCollection(referencePersons)) {
            return Collections.emptyList();
        }
        List userPositions = UserServiceHelper.getPosition(referencePersons);
        HashSet<Long> positions = new HashSet<Long>();
        for (Map userPosition : userPositions) {
            if (userPosition.get("entryentity") == null) {
                logger.info(String.format(ParticipantParseProcess.POSITIONRELATIONPARSER_2.getDesc(), userPosition.get("id")));
                return Collections.emptyList();
            }
            Long mainPosition = 0L;
            boolean hasMatchpPosition = false;
            List entryentitys = (List)userPosition.get("entryentity");
            int len = entryentitys.size();
            for (int i = 0; i < len; ++i) {
                Long postId;
                Map entryentity = (Map)entryentitys.get(i);
                Long dptId = entryentity.get("dpt") != null ? Long.valueOf(((DynamicObject)entryentity.get("dpt")).getLong("id")) : null;
                Long l = postId = entryentity.get("post") != null ? Long.valueOf(((DynamicObject)entryentity.get("post")).getLong("id")) : null;
                if (WfUtils.isNotEmptyForCollection(referenceOrgIds) && referenceOrgIds.contains(dptId)) {
                    if (WfUtils.isNotEmpty(postId)) {
                        positions.add(postId);
                    }
                    hasMatchpPosition = true;
                    continue;
                }
                if (WfUtils.isEmpty(postId) || hasMatchpPosition || !Boolean.FALSE.equals(entryentity.get("ispartjob"))) continue;
                mainPosition = postId;
            }
            if (hasMatchpPosition || !WfUtils.isNotEmpty(mainPosition)) continue;
            logger.info(String.format(ParticipantParseProcess.POSITIONRELATIONPARSER_3.getDesc(), userPosition.get("id")));
            positions.add(mainPosition);
        }
        return new ArrayList<Long>(positions);
    }

    @Override
    public LinkedHashMap<Long, ILocaleString> getReportTypes(Set<Object> filterReportTypeIds) {
        DynamicObject[] reportTypes;
        LinkedHashMap<Long, ILocaleString> reportTypeMaps = new LinkedHashMap<Long, ILocaleString>();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(1);
        if (WfUtils.isNotEmptyForCollection(filterReportTypeIds)) {
            qfilters.add(new QFilter("id", "in", filterReportTypeIds));
        }
        for (DynamicObject reportType : reportTypes = BusinessDataServiceHelper.load((String)"bos_reporttype", (String)"id,name", (QFilter[])qfilters.toArray(new QFilter[0]))) {
            reportTypeMaps.put(reportType.getLong("id"), reportType.getLocaleString("name"));
        }
        return reportTypeMaps;
    }
}

