/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.EvtLogUtils;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.impl.jobexecutor.EvtJobUtil;
import kd.bos.bec.engine.persistence.job.EvtJobEntityImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.dynprocess.FreeFlowUtil;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.log.entity.EventLogEsEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class TryTriggerProcessTask {
    private Log logger = LogFactory.getLog(this.getClass());

    public boolean canSendWfMsg(String entityNumber, String operation, Map<String, String> variable) {
        boolean canRun = WfConfigurationUtil.canRunWorkflow();
        if (!canRun) {
            this.logger.warn("\u672a\u914d\u7f6e\u4f7f\u7528\u4e0b\u4e00\u4ee3\u5de5\u4f5c\u6d41\u6216\u8005\u6d41\u7a0b\u5f15\u64ce\u542f\u52a8\u5931\u8d25!");
            return false;
        }
        return true;
    }

    public void sendEventMq(Map<Long, String> evtJobMsg) {
        try {
            ArrayList<EvtJobEntityImpl> jobs = new ArrayList<EvtJobEntityImpl>();
            if (evtJobMsg != null) {
                for (Map.Entry<Long, String> entry : evtJobMsg.entrySet()) {
                    String[] values;
                    String value = entry.getValue();
                    if (!WfUtils.isNotEmpty(value) || (values = value.split(",")).length <= 0) continue;
                    this.logger.debug(String.format("jobId:%s--routeKey:%s", entry.getKey(), value));
                    EvtJobEntityImpl job = new EvtJobEntityImpl();
                    job.setId(entry.getKey());
                    job.setRootJobId(entry.getKey());
                    job.setSource(values[0]);
                    job.setJobType("event");
                    if (values.length > 1) {
                        job.setAppNumForSubApp(values[1]);
                    }
                    if (values.length > 2) {
                        job.setProcessInstanceId(Long.valueOf(values[2]));
                    }
                    jobs.add(job);
                }
            }
            if (jobs.size() < 1) {
                this.logger.error("event msg send no jobs");
                return;
            }
            EvtJobUtil.sendMqDirect(jobs);
        }
        catch (Exception e) {
            this.logger.error(String.format("bec msg send error. %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    public void sendWfJob(Map<Long, String> wfJobs) {
        try {
            ArrayList<JobEntity> jobs = new ArrayList<JobEntity>();
            if (wfJobs != null) {
                if (!WfUtils.isSyncRun()) {
                    for (Map.Entry<Long, String> entry : wfJobs.entrySet()) {
                        String string = entry.getValue();
                        if (!WfUtils.isNotEmpty(string)) continue;
                        String[] values = string.split(",");
                        if (values.length > 0) {
                            this.logger.debug(String.format("jobId:%s--routeKey:%s", entry.getKey(), string));
                            JobEntityImpl job = new JobEntityImpl();
                            job.setId(entry.getKey());
                            job.setSource(values[0]);
                            if (values.length > 1) {
                                job.setJobHandlerType(values[1]);
                            }
                            if (values.length > 2) {
                                job.setEntityNumber(values[2]);
                            }
                            job.setAppNumForSubApp("simpleJob");
                            jobs.add(job);
                            continue;
                        }
                        this.logger.error(String.format("workflow msg send no job : %s", entry.getKey()));
                    }
                } else {
                    HashMap<String, ArrayList<Long>> queryMap = new HashMap<String, ArrayList<Long>>(1);
                    if (wfJobs != null) {
                        for (Map.Entry<Long, String> entry : wfJobs.entrySet()) {
                            String[] values;
                            String value = entry.getValue();
                            if (!WfUtils.isNotEmpty(value) || (values = value.split(",")).length <= 0 || !WfUtils.isNotEmpty(values[0])) continue;
                            ArrayList<Long> idList = (ArrayList<Long>)queryMap.get(values[0]);
                            if (idList == null) {
                                idList = new ArrayList<Long>();
                            }
                            idList.add(entry.getKey());
                            queryMap.put(values[0], idList);
                        }
                        for (Map.Entry<Long, String> entry : queryMap.entrySet()) {
                            this.logger.debug(String.format("jobIds:%s--routeKey:%s", entry.getValue(), entry.getKey()));
                            JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy((String)((Object)entry.getKey()), "");
                            strategy.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration());
                            List<ExecuteJob> result = strategy.findJobs((List)((Object)entry.getValue()), true);
                            if (result == null || result.size() <= 0) continue;
                            for (ExecuteJob res : result) {
                                jobs.add((JobEntity)res);
                            }
                        }
                    }
                }
            }
            if (jobs.size() < 1) {
                this.logger.error("workflow msg send no jobs");
                return;
            }
            JobUtil.sendJobToMQ(jobs);
        }
        catch (Exception e) {
            this.logger.error(String.format("workflow msg send error. %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerEvent(DynamicObject[] objs, String operation, Map<String, String> variable) {
        boolean insertToDB = false;
        EventLogEsEntityImpl eventLog = EventLogEsEntityImpl.create();
        try {
            String entityNumber = objs[0].getDataEntityType().getName();
            StringBuilder pks = new StringBuilder();
            for (DynamicObject o : objs) {
                pks.append(',').append(o.getPkValue());
            }
            if (pks.length() > 1) {
                eventLog.setEntitynumber(entityNumber);
                eventLog.setBusinesskey(pks.substring(1));
                eventLog.setScene("judeHaveEvent");
            }
            if (this.existEvent(entityNumber, operation)) {
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                wfService.triggerEventSubscribeJobs(objs, operation, variable);
            }
        }
        catch (Exception e) {
            insertToDB = true;
            if (e instanceof KDBizException && ((KDBizException)((Object)e)).getErrorCode() != null && "triggerEventMaxCountError".equalsIgnoreCase(((KDBizException)((Object)e)).getErrorCode().getCode())) {
                throw e;
            }
        }
        finally {
            if (insertToDB) {
                eventLog.setContent(eventLog.toString());
                EvtLogUtils.saveEvtLog(eventLog);
            }
        }
    }

    public void sendTriggerEventMsg(DynamicObject[] objs, String operation, Map<String, String> variable) {
        this.triggerEvent(objs, operation, variable);
    }

    public void sendTriggerProcessMsg(DynamicObject[] objs, String operation, Map<String, String> variable) {
        if (objs == null || objs.length == 0) {
            this.logger.debug(String.format("sendTriggerProcessMsg,bill is empty,operation[%s]", operation));
            return;
        }
        String entityNumber = objs[0].getDataEntityType().getName();
        StringBuilder sb = new StringBuilder();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                sb.append(obj.getPkValue()).append(",");
            }
        }
        String logInfo = String.format("bill[%s],operation[%s],entityNumber[%s]", sb.toString(), operation, entityNumber);
        if (variable != null && variable.size() > 0 && variable.get("WF") != null) {
            this.logger.debug(String.format("From WF Invoke [%s]", logInfo));
            return;
        }
        if (!FreeFlowUtil.isFreeFlow(variable) && !this.existProcess(entityNumber, operation)) {
            this.logger.debug(String.format("Not exist process OR Not Free FLOW [%s]", logInfo));
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        try {
            HashMap<String, Object> params = null;
            if (variable != null && variable.size() > 0) {
                params = new HashMap<String, Object>(variable.size());
                int limit = this.getOperationVariableValueLenLimit();
                Set<String> whiteList = this.getVariableNameWhiteList();
                for (Map.Entry<String, String> entry : variable.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value != null && value.length() > limit && !whiteList.contains(key)) continue;
                    params.put(key, value);
                }
                params.put("_fromOperation_", Boolean.TRUE);
                if (FreeFlowUtil.isFreeFlow(variable)) {
                    String procdefId = variable.get("procdefid");
                    if (WfUtils.isEmpty(procdefId)) {
                        procdefId = "886006942529487872";
                    }
                    params.put("procdefid", procdefId);
                    params.put("dynType", "freeflow");
                    params.put("entityNumber", entityNumber);
                }
            }
            wfService.tryTriggerProcess(objs, operation, params);
        }
        catch (Exception e) {
            if (ProcessEngines.isInitialized()) {
                throw new KDException(WFErrorCode.sendWorkflowMsgError(), new Object[]{e.getMessage()});
            }
            this.logger.warn(String.format("\u672a\u914d\u7f6e\u4f7f\u7528\u4e0b\u4e00\u4ee3\u5de5\u4f5c\u6d41\u6216\u8005\u6d41\u7a0b\u5f15\u64ce\u542f\u52a8\u5931\u8d25\uff0c\u4e1a\u52a1\u4fe1\u606f:[%s-%s],\u9519\u8bef\u4fe1\u606f[%s]", objs, operation, e.getMessage()));
        }
    }

    public boolean existProcess(String entityNumber, String operation) {
        Boolean ret = WfCacheHelper.cacheableOfProcessDefByEntityAndOperation(entityNumber, operation);
        if (ret != null) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid from t_wf_procdef a ");
        sb.append("inner join t_wf_procdefinfo b on a.FID = b.FPROCDEFID ");
        sb.append("where a.fenable = '").append("enable").append("' ");
        sb.append("and b.FENTITYNUMBER= ? and b.FOPERATION=? ");
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])new Object[]{entityNumber, operation}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) {
                ArrayList<String> ids = new ArrayList<String>(5);
                try {
                    while (rs.next()) {
                        ids.add(rs.getString("fid"));
                    }
                }
                catch (Exception e) {
                    throw new WFException(e.getMessage(), e);
                }
                return ids;
            }
        });
        boolean t = ids != null && !ids.isEmpty();
        WfCacheHelper.putProcessToCacheDefByEntityAndOperation(entityNumber, operation, ids);
        return t;
    }

    public boolean existEvent(String entityNumber, String operation) {
        boolean ret = false;
        String[] cachedEvtNumbers = EvtCacheHelper.getCacheEvent(entityNumber);
        String eventNumber = String.format("%s.%s", entityNumber, operation);
        if (cachedEvtNumbers == null || cachedEvtNumbers.length == 0) {
            String sql = "SELECT a.FNUMBER eventNumber FROM t_evt_event a INNER JOIN t_evt_subscription b on b.FEVENT = a.fid WHERE a.FSTATUS = '1' AND b.FSTATUS = '1' AND a.fentity = ? ";
            ArrayList<String> evtNumbers = (ArrayList<String>)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{entityNumber}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) {
                    ArrayList<String> evtNumbers = new ArrayList<String>(5);
                    try {
                        while (rs.next()) {
                            evtNumbers.add(rs.getString("eventNumber"));
                        }
                    }
                    catch (Exception e) {
                        throw new WFException(e.getMessage(), e);
                    }
                    return evtNumbers;
                }
            });
            boolean bl = ret = evtNumbers != null && evtNumbers.contains(eventNumber);
            if (evtNumbers == null || evtNumbers.isEmpty()) {
                evtNumbers = new ArrayList<String>(1);
                evtNumbers.add("-1");
            }
            EvtCacheHelper.addCacheEvent(entityNumber, evtNumbers.toArray(new String[0]));
            return ret;
        }
        return Arrays.asList(cachedEvtNumbers).contains(eventNumber);
    }

    private int getOperationVariableValueLenLimit() {
        int limit = 10000;
        try {
            String limitConfig = (String)WfConfigurationUtil.getConfigCenterVal("workflow.config.operationVariableValueLenLimit");
            if (limitConfig != null && limitConfig.matches("^\\d{1,9}$")) {
                limit = Integer.parseInt(limitConfig);
            }
        }
        catch (Exception e) {
            limit = Integer.MAX_VALUE;
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return limit;
    }

    private Set<String> getVariableNameWhiteList() {
        HashSet<String> whiteList = new HashSet<String>(30);
        whiteList.add("dynparticipant");
        whiteList.add("freeflowmodelstr");
        whiteList.add("nextnodedealperson");
        whiteList.add("_initiator_");
        whiteList.add("_operation_");
        whiteList.add("auditType");
        whiteList.add("auditName");
        whiteList.add("auditNumber");
        whiteList.add("auditMessage");
        whiteList.add("dynType");
        whiteList.add("dynName");
        whiteList.add("nextNodeId");
        whiteList.add("batchOpType");
        whiteList.add("_entityNumber_");
        whiteList.add("signature");
        whiteList.add("skipReason");
        whiteList.add("executionType");
        whiteList.add("reason");
        whiteList.add("jobAction");
        whiteList.add("biztraceno");
        whiteList.add("addressKey");
        whiteList.add("calledWay");
        whiteList.add("modeltypeforwf");
        whiteList.add("wfassigncallbackflag");
        whiteList.add("callActivityProcDefKey");
        whiteList.add("procdefid");
        whiteList.add("_businessKey_");
        whiteList.add("newprocessdefinitionid");
        whiteList.add("newschmeid");
        whiteList.add("addressbusinesskey");
        return whiteList;
    }
}

