/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.ThreadLocals;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.RepeatJobModel;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class WfTraceType {
    private static ThreadLocal<WfTraceType> instance = ThreadLocals.create();
    private String traceType;
    private boolean testing;
    private WfTraceJobInfo jobInfo = null;
    private Long childJob;

    public static WfTraceType create() {
        WfTraceType type = new WfTraceType();
        instance.set(type);
        return type;
    }

    public static WfTraceType get() {
        return instance.get();
    }

    public static WfTraceType getOrCreate() {
        if (WfTraceType.get() == null) {
            WfTraceType.create();
        }
        return instance.get();
    }

    public void setTraceType(String traceType) {
        this.traceType = traceType;
    }

    public String getTraceType() {
        return this.traceType;
    }

    public Long getChildJob() {
        return this.childJob;
    }

    public void setChildJob(Long childJob) {
        this.childJob = childJob;
    }

    public void setTesting(boolean unitTest) {
        this.testing = unitTest;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setJobInfo(AbstractJobEntity jobInfo, RepeatJobModel repeatJob) {
        this.jobInfo = new WfTraceJobInfo(jobInfo, repeatJob);
    }

    public void setJobInfo(AbstractJobEntity jobInfo) {
        this.jobInfo = new WfTraceJobInfo(jobInfo, null);
    }

    public WfTraceJobInfo getEmptyJobInfo() {
        this.jobInfo = new WfTraceJobInfo();
        return this.jobInfo;
    }

    public WfTraceJobInfo getJobInfo() {
        return this.jobInfo;
    }

    public void clear() {
        if (this.jobInfo != null) {
            this.jobInfo.clearJobsAfterJobExecute();
        }
        this.jobInfo = null;
        this.testing = false;
    }

    public static class WfTraceJobInfo {
        private Long currentJobId;
        private Long srcJobId;
        private Long rootJobId;
        private String jobType;
        private String elementId;
        private String entityNumber;
        private String businessKey;
        private Long processInstanceId;
        private Long processDefinitionId;
        private String billNo;
        private String lockKey;
        private List<JobEntity> jobsAfterJobExecute = new ArrayList<JobEntity>(2);
        private Boolean isUpdate;

        public WfTraceJobInfo() {
        }

        public Boolean getIsUpdate() {
            return this.isUpdate;
        }

        public void setIsUpdate(Boolean isUpdate) {
            this.isUpdate = isUpdate;
        }

        public WfTraceJobInfo(AbstractJobEntity job, RepeatJobModel repeatJob) {
            this.currentJobId = job.getId();
            this.jobType = job.getJobHandlerType();
            this.srcJobId = job.getSrcJobId();
            this.elementId = job.getElementId();
            this.businessKey = job.getBusinessKey();
            this.rootJobId = job instanceof JobEntity ? ((JobEntity)job).getRootJobId() : job.getId();
            this.businessKey = job.getBusinessKey();
            this.entityNumber = job.getEntityNumber();
            this.processDefinitionId = job.getProcessDefinitionId();
            this.processInstanceId = job.getProcessInstanceId();
            this.lockKey = repeatJob == null ? null : repeatJob.getLockKey();
            this.setBillNoIfNeed(job);
        }

        private void setBillNoIfNeed(AbstractJobEntity job) {
            Map payload;
            if (job instanceof JobEntity && WfUtils.isNotEmpty(job.getJobHandlerConfiguration()) && (payload = (Map)SerializationUtils.fromJsonString((String)job.getJobHandlerConfiguration(), Map.class)) != null && payload.get("_billno_") != null && WfUtils.isEmpty(this.billNo)) {
                this.setBillNo((String)payload.get("_billno_"));
            }
        }

        public void setCurrentJobId(Long jobId) {
            this.currentJobId = jobId;
        }

        public Long getCurrentJobId() {
            return this.currentJobId;
        }

        public void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public void setSrcJobId(Long srcJobId) {
            this.srcJobId = srcJobId;
        }

        public String getJobType() {
            return this.jobType;
        }

        public Long getRootJobId() {
            return this.rootJobId;
        }

        public Long getSrcJobId() {
            return this.srcJobId;
        }

        public String getElementId() {
            return this.elementId;
        }

        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public Long getProcessDefinitionId() {
            return this.processDefinitionId;
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public String getLockKey() {
            return this.lockKey;
        }

        public void addJobsAfterJobExecute(JobEntity nextJob) {
            this.jobsAfterJobExecute.add(nextJob);
        }

        public List<JobEntity> getJobsAfterJobExecute() {
            return this.jobsAfterJobExecute;
        }

        public void clearJobsAfterJobExecute() {
            this.jobsAfterJobExecute.clear();
        }
    }
}

