/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.session.impl.CodelessShareSessionServiceImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.api.INoCodeWorkflowService;
import kd.bos.workflow.api.model.NodeMacro;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessInitiator;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.api.model.ProcessTemplate;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class NoCodeWorkflowServiceImpl
implements INoCodeWorkflowService {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String TRIGGERMODE_NEWSUBMIT = "newSubmit";
    private static final String TRIGGERMODE_EDITSUBMIT = "editSubmit";
    private static final String TRIGGERMODE_NEWANDEDITSUBMIT = "newAndEditSubmit";
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;
    private HistoryService historyService;

    private RuntimeService getRuntimeService() {
        if (this.runtimeService == null) {
            this.init();
        }
        if (this.runtimeService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.runtimeService;
    }

    private RepositoryService getRepositoryService() {
        if (this.repositoryService == null) {
            this.init();
        }
        if (this.repositoryService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.repositoryService;
    }

    public HistoryService getHistoryService() {
        if (this.historyService == null) {
            this.init();
        }
        if (this.historyService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.historyService;
    }

    private TaskService getTaskService() {
        if (this.taskService == null) {
            this.init();
        }
        if (this.taskService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.taskService;
    }

    private void init() {
        boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
        if (!canRunWf) {
            throw new KDException(WFErrorCode.workflowEngineNotConfiguration(), new Object[0]);
        }
        try {
            if (!ProcessEngines.isInitialized()) {
                ProcessEngines.init();
            }
            this.repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
            this.runtimeService = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
            this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
            this.historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
            this.logger.debug("success to fetch relative service.");
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.engineStartErrored(), new Object[]{e.getMessage()});
        }
    }

    public List<ProcessModel> getAllProcesses(String procType, String appOrCloudId) {
        return this.getRepositoryService().loadAllProcessModels(procType, appOrCloudId);
    }

    public void tryTriggerProcessByTriggerMode(String entityNumber, String billId, String triggerMode) {
        String triggerModeFilter = this.getFilterTypeByTriggerMode(triggerMode);
        this.logger.debug(String.format("try trigger process by triggerMode[%s], triggerModeFilter[%s], entityNumber[%s], billId[%s]", triggerMode, triggerModeFilter, entityNumber, billId));
        List<ProcessDefinitionInfo> processDefInfoList = this.getProcessDefinitionsByTriggerMode(entityNumber, triggerModeFilter);
        if (processDefInfoList != null && !processDefInfoList.isEmpty()) {
            String processDefinitionId = null;
            String processType = null;
            HashMap<String, Object> variables = new HashMap<String, Object>(8);
            try (TXHandle tx = TX.requiresNew();){
                boolean isNoLoginRequired = this.isNoLoginRequired();
                for (ProcessDefinitionInfo processDefInfo : processDefInfoList) {
                    variables.clear();
                    processDefinitionId = String.valueOf(processDefInfo.getId());
                    processType = processDefInfo.getProcessType();
                    variables.put("procdefid", processDefinitionId);
                    variables.put("processType", processType);
                    if (isNoLoginRequired) {
                        variables.put("noLoginRequired", true);
                    }
                    this.logger.debug(String.format("try trigger process by triggerMode[%s], processDefinitionId[%s], processType[%s], billId[%s], entityNumber[%s]", triggerMode, processDefinitionId, processType, billId, entityNumber));
                    WorkflowServiceHelper.tryTriggerProcess((String)billId, (String)this.getOperationByTriggerMode(triggerMode, processDefInfo.getOperation()), (String)entityNumber, variables);
                }
            }
        }
    }

    public List<ProcessDefinitionInfo> getProcessDefinitionsByTriggerMode(String entityNumber, String triggerMode) {
        QFilter[] filters;
        if (entityNumber == null) {
            this.logger.debug("entityNumber is null");
            return new ArrayList<ProcessDefinitionInfo>();
        }
        List procDefs = null;
        String fields = "id,name,key,version,enable,versionstate,entrabill,entrabillid,orgunitid,operation,type,modelid,createdate,creatorid";
        if (triggerMode == null) {
            filters = new QFilter[]{new QFilter("entrabill", "=", (Object)entityNumber), new QFilter("enable", "=", (Object)"enable")};
            procDefs = this.getRepositoryService().findEntitiesByFilters("wf_processdefinition", filters, fields, "createdate desc");
        } else {
            filters = new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber), new QFilter("operation", "in", (Object)triggerMode.split(","))};
            List entities = this.getRepositoryService().findEntitiesByFilters("wf_processdefinitioninfo", filters, "processDefinitionId", null);
            if (entities.isEmpty()) {
                this.logger.debug(String.format("no ProcessDefinitionInfo found. entityNumber: %s, triggerMode: %s", entityNumber, triggerMode));
                return new ArrayList<ProcessDefinitionInfo>();
            }
            HashSet<Long> procDefIds = new HashSet<Long>(entities.size());
            for (ProcessDefinitionInfoEntity entity : entities) {
                procDefIds.add(entity.getProcessDefinitionId());
            }
            filters = new QFilter[]{new QFilter("id", "in", procDefIds), new QFilter("enable", "=", (Object)"enable"), new QFilter("versionstate", "=", (Object)"newest")};
            procDefs = this.getRepositoryService().findEntitiesByFilters("wf_processdefinition", filters, fields, "createdate desc");
        }
        if (procDefs.isEmpty()) {
            this.logger.debug(String.format("no ProcessDefinitionEntity found. entityNumber: %s, triggerMode: %s", entityNumber, triggerMode));
            return new ArrayList<ProcessDefinitionInfo>();
        }
        ArrayList<ProcessDefinitionInfo> infos = new ArrayList<ProcessDefinitionInfo>(procDefs.size());
        for (ProcessDefinitionEntity procDef : procDefs) {
            infos.add(this.getProcessDefinitionInfo(procDef));
        }
        return infos;
    }

    public void tryTriggerProcess(Long modelId, String businessKey, String operation) {
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "=", (Object)modelId), new QFilter("enable", "=", (Object)"enable")};
        String fields = String.format("%s,%s,%s,%s,%s", "id", "entrabill", "type", "version", "primarysubprocess");
        List processDefinitions = this.getRepositoryService().findEntitiesByFilters("wf_processdefinition", filters, fields, "id desc");
        if (processDefinitions.isEmpty()) {
            this.logger.debug(String.format("No processes that meet the conditions. modelId: %s", modelId));
            return;
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processDefinitions.get(0);
        Long processDefinitionId = processDefinition.getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("procdefid", String.valueOf(processDefinitionId));
        variables.put("processType", processDefinition.getType());
        if (this.isNoLoginRequired()) {
            variables.put("noLoginRequired", true);
        }
        this.logger.debug(String.format("tryTriggerProcess. procDefId: %s, modelId: %s, businessKey: %s, operation: %s", processDefinitionId, modelId, businessKey, operation));
        String timerStartId = null;
        BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(processDefinitionId, null);
        List<FlowElement> elements = bpmnModel.getMainProcess().getFlowElementList();
        for (FlowElement element : elements) {
            if (!(element instanceof StartEvent)) continue;
            if (!"StartTimerEvent".equals(element.getType())) break;
            timerStartId = element.getId();
            break;
        }
        if (timerStartId != null) {
            this.getRuntimeService().startProcessInstance(processDefinition, timerStartId);
        } else {
            WorkflowServiceHelper.tryTriggerProcess((String)businessKey, (String)operation, (String)processDefinition.getEntraBill(), variables);
        }
    }

    private boolean isNoLoginRequired() {
        RequestContext context = RequestContext.get();
        if (context == null) {
            return false;
        }
        String sessionId = context.getGlobalSessionId();
        if (WfUtils.isEmpty(sessionId)) {
            return false;
        }
        CodelessShareSessionServiceImpl sessionService = new CodelessShareSessionServiceImpl();
        return sessionService.isNocodeShareSession(sessionId);
    }

    public List<NodeMacro> getNodeMacros(Long modelId, String macroType) {
        return this.getRepositoryService().getNodeMacros(modelId, macroType);
    }

    public List<NodeMacro> getNodeMacros(String modelJson, String macroType) {
        return this.getRepositoryService().getNodeMacros(modelJson, macroType);
    }

    public List<NodeMacro> getNodeMacros(String procType, String nodeJson, String macroType) {
        return this.getRepositoryService().getNodeMacros(procType, nodeJson, macroType);
    }

    public Map<String, Integer> getNoCodeFlowTaskCounts(String userId) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        countMap.put("todoCount", this.getNoCodeFlowTaskCountByType(userId, "toHandle").intValue());
        countMap.put("doneCount", this.getNoCodeFlowTaskCountByType(userId, "handled").intValue());
        countMap.put("myTodoCount", this.getNoCodeFlowTaskCountByType(userId, "toApply").intValue());
        countMap.put("myDoneCount", this.getNoCodeFlowTaskCountByType(userId, "applyed").intValue());
        return countMap;
    }

    public List<ProcessTemplate> getProcessTemplatesByAppId(String appId) {
        return this.getRepositoryService().getProcessTemplatesByAppId(appId);
    }

    public Map<Long, Long> createProcessesByTemplates(String appId, List<Long> templateIds, Map<String, String> entityMap, Map<String, String> roleMap) {
        return this.getRepositoryService().createProcessesByTemplates(appId, templateIds, entityMap, roleMap);
    }

    public Map<Long, Long> saveProcessesAsTemplates(String appId, List<Long> modelIds, Map<String, String> entityMap, Map<String, String> roleMap) {
        return this.getRepositoryService().saveProcessesAsTemplates(appId, modelIds, entityMap, roleMap);
    }

    public void deleteProcessTemplates(List<Long> templateIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", templateIds), new QFilter("status", "=", (Object)"enable").or(new QFilter("preset", "=", (Object)true))};
        Long count = this.getRepositoryService().getEntityCountByFilter("wf_proctemplate", filters);
        if (count > 0L) {
            throw new WFException(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u5df2\u542f\u7528\u7684\u6216\u9884\u7f6e\u7684\u6d41\u7a0b\u6a21\u677f\u3002", (String)"NoCodeWorkflowServiceImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.getRepositoryService().deleteProcTemplates(templateIds);
        this.logger.debug(String.format("delete process templates: %s", templateIds));
    }

    public String createBlankProcessResource(String procType, Map<String, Object> config) {
        return this.getRepositoryService().createBlankProcessResource(procType, config);
    }

    public boolean inProcessByProcessInstanceId(Long processInstanceId) {
        try {
            this.assertInServiceAndLog("inProcessByProcessInstanceId", processInstanceId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return false;
            }
            throw e;
        }
        if (WfUtils.isEmpty(processInstanceId)) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u662f\u5426\u5728\u6d41\u7a0b\u4e2d", (String)"WorkflowServiceImpl_4", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        this.runtimeService = this.getRuntimeService();
        return this.runtimeService.inProcessByProcessInstanceId(processInstanceId);
    }

    public DynamicObjectCollection getNoCodeFlowProcessInstanceInfoByProcessCode(int start, int limit, String processCode) {
        this.assertInServiceAndLog("getNoCodeFlowProcessInstanceInfoByProcessCode", start, limit, processCode);
        HashMap<String, Object> checkParams = new HashMap<String, Object>();
        checkParams.put("start", start);
        checkParams.put("limit", limit);
        checkParams.put("processCode", processCode);
        this.checkParamsEmpty(checkParams);
        return this.getTaskService().getNoCodeFlowProcessInstanceInfoByProcessCode(start, limit, processCode);
    }

    public long getNoCodeFlowProcessInstanceCountByProcessCode(String processCode) {
        this.assertInServiceAndLog("getNoCodeFlowProcessInstanceCountByProcessCode", processCode);
        HashMap<String, Object> checkParams = new HashMap<String, Object>();
        checkParams.put("processCode", processCode);
        this.checkParamsEmpty(checkParams);
        return this.getTaskService().getNoCodeFlowProcessInstanceCountByProcessCode(processCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<IApprovalRecordGroup> getNoCodeFlowApprovalRecords(String entityNumber, String businessKey) {
        try {
            ThreadLocalVariables.putVariable(ModelType.NoCodeFlow.name());
            List list = WorkflowServiceHelper.getApprovalRecords((String)entityNumber, (String)businessKey, (boolean)true);
            return list;
        }
        finally {
            ThreadLocalVariables.remove();
        }
    }

    public Map<Long, ProcessInitiator> getProcessesInitiator(List<Long> procInstIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", procInstIds)};
        String fields = "id,startuserid,startname,createdate";
        List entities = this.getRepositoryService().findEntitiesByFilters("wf_hiprocinst", filters, fields, null);
        if (entities.isEmpty()) {
            return new HashMap<Long, ProcessInitiator>();
        }
        HashMap<Long, ProcessInitiator> ret = new HashMap<Long, ProcessInitiator>(entities.size());
        for (HistoricProcessInstanceEntity entity : entities) {
            ProcessInitiator initiator = new ProcessInitiator();
            initiator.setId(entity.getStartUserId());
            initiator.setName(entity.getStartName());
            initiator.setStartTime(entity.getCreateDate());
            ret.put(entity.getId(), initiator);
        }
        return ret;
    }

    public Map<String, List<BizProcessStatus>> getNoCodeFlowBizProcessStatus(String[] businessKeys) {
        try {
            this.assertInServiceAndLog("getNoCodeFlowBizProcessStatus", businessKeys);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return Collections.emptyMap();
            }
            throw e;
        }
        this.runtimeService = this.getRuntimeService();
        return this.runtimeService.getNoCodeFlowBizProcessStatus(businessKeys);
    }

    public DynamicObjectCollection getNoCodeFlowApprovalRecordsFromDetailLog(String businessKey, String entityNumber) {
        this.assertInServiceAndLog("getNoCodeFlowApprovalRecordsFromDetailLog", businessKey, entityNumber);
        HashMap<String, Object> checkParams = new HashMap<String, Object>();
        checkParams.put("businessKey", businessKey);
        checkParams.put("entityNumber", entityNumber);
        this.checkParamsEmpty(checkParams);
        return this.getTaskService().getNoCodeFlowApprovalRecordsFromDetailLog(businessKey, entityNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection getNoCodeFlowToHandleTasksByUserId(int start, int limit, String uid) {
        try {
            ThreadLocalVariables.putVariable(ModelType.NoCodeFlow.name());
            DynamicObjectCollection dynamicObjectCollection = WorkflowServiceHelper.getToHandleTasksByUserId((int)start, (int)limit, (String)uid);
            return dynamicObjectCollection;
        }
        finally {
            ThreadLocalVariables.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNoCodeFlowTaskCountByType(String uid, String type) {
        try {
            ThreadLocalVariables.putVariable(ModelType.NoCodeFlow.name());
            Long l = WorkflowServiceHelper.getTaskCountByType((String)uid, (String)type);
            return l;
        }
        finally {
            ThreadLocalVariables.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection getNoCodeFlowApplyTasksByStartId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        try {
            ThreadLocalVariables.putVariable(ModelType.NoCodeFlow.name());
            DynamicObjectCollection dynamicObjectCollection = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getApplyTasksByStartId(start, limit, uid, sqlFilterMap);
            return dynamicObjectCollection;
        }
        finally {
            ThreadLocalVariables.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection getNoCodeFlowHandledTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        try {
            ThreadLocalVariables.putVariable(ModelType.NoCodeFlow.name());
            DynamicObjectCollection dynamicObjectCollection = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getHandledTasksByUserId(start, limit, uid, sqlFilterMap, "");
            return dynamicObjectCollection;
        }
        finally {
            ThreadLocalVariables.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection getNoCodeFlowApplyedProcessAssistantCollection(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, Map<String, Object> paramFilter) {
        try {
            ThreadLocalVariables.putVariable(ModelType.NoCodeFlow.name());
            DynamicObjectCollection dynamicObjectCollection = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getApplyedProcessAssistantCollection(userId, start, limit, starterOrSubjectFilter, timeFilter, paramFilter);
            return dynamicObjectCollection;
        }
        finally {
            ThreadLocalVariables.remove();
        }
    }

    public String getBusinessKeyByProcessInstanceId(Long processInstanceId) {
        return this.getRuntimeService().getBusinessKeyByProcessInstanceId(processInstanceId);
    }

    public List<Long> getProcDefIdsByEntityNumber(String entityNumber) {
        return this.getRepositoryService().getProcDefIdsByEntityNumber(entityNumber);
    }

    public List<Long> getProcInstIdsByProcDefId(int start, int limit, Long procDefId) {
        return this.getRepositoryService().getProcInstIdsByProcDefId(start, limit, procDefId);
    }

    public Long getProcessInstanceCountByProcDefId(Long procDefId) {
        return this.getRepositoryService().getProcessInstanceCountByProcDefId(procDefId);
    }

    public List<Long> getProcInstIdsByEntityNumberOrBusinessKey(int start, int limit, String entityNumber, String businessKey) {
        return this.getRepositoryService().getProcInstIdsByEntityNumberOrBusinessKey(start, limit, entityNumber, businessKey);
    }

    public Long getProcessInstanceCountByEntityNumberOrBusinessKey(String entityNumber, String businessKey) {
        return this.getRepositoryService().getProcessInstanceCountByEntityNumberOrBusinessKey(entityNumber, businessKey);
    }

    public List<Long> getProcDefIdsByModelId(Long modelId) {
        return this.getRepositoryService().getProcDefIdsByModelId(modelId);
    }

    public void deleteProcessInstanceInfoByProcInstId(Long procInstId) {
        HistoricProcessInstanceEntity entity = this.getHistoryService().getHistoricProcessInstance(procInstId);
        if (entity == null) {
            return;
        }
        if (ModelType.NoCodeFlow.name().equalsIgnoreCase(entity.getProcessType())) {
            this.getRepositoryService().deleteProcessInstanceInfoByProcInstId(procInstId);
        }
    }

    public void deleteProcessByProcDefId(Long procDefId) {
        ProcessDefinitionEntity entity = this.getRepositoryService().getProcessdefineById(procDefId);
        if (entity == null) {
            return;
        }
        if (ModelType.NoCodeFlow.name().equalsIgnoreCase(entity.getType())) {
            this.getRepositoryService().deleteProcessByProcDefId(procDefId);
        }
    }

    public boolean deleteProcessByModelId(Long modelId) {
        boolean ret = false;
        ModelEntity model = (ModelEntity)this.getRepositoryService().getModel(modelId);
        if (model == null) {
            return ret;
        }
        if (ModelType.NoCodeFlow.name().equals(model.getType()) && !model.isPublish()) {
            ret = this.getRepositoryService().deleteProcessByModelId(modelId);
        } else {
            this.logger.info(String.format("modelId: %s, type: %s, isPublish: %s", modelId, model.getType(), model.isPublish()));
        }
        return ret;
    }

    public String getProcTemplatePresetSQL(Long templateId) {
        return this.getRepositoryService().getProcTemplatePresetSQL("nocode", templateId);
    }

    public String getExportedProcessFileContent(Long modelId) {
        return this.getRepositoryService().getExportedProcessFileContent(modelId);
    }

    public Map<String, Object> importProcessFileContent(String content) {
        return this.getRepositoryService().importProcessFileContent(content, ModelType.NoCodeFlow.name());
    }

    public Map<String, Object> importProcessFileContent(String content, boolean forceNew) {
        return this.getRepositoryService().importProcessFileContent(content, ModelType.NoCodeFlow.name(), forceNew);
    }

    private void checkParamsEmpty(Map<String, Object> checkParams) {
        if (null == checkParams || checkParams.isEmpty()) {
            return;
        }
        StringBuilder exceptionMsg = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = checkParams.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!WfUtils.isEmptyString(entry.getValue())) continue;
            exceptionMsg.append(entry.getKey()).append(",");
        }
        if (0 == exceptionMsg.length()) {
            return;
        }
        String checkMsgStr = exceptionMsg.substring(0, exceptionMsg.length() - 1);
        throw new KDBizException(String.format(TaskErrorCodeEnum.PARAMS_CHECK_ERROR_WITHPARAM.getDesc(), checkMsgStr));
    }

    private String getFilterTypeByTriggerMode(String triggerMode) {
        if (triggerMode != null) {
            switch (triggerMode) {
                case "newSubmit": {
                    return "newSubmit,newAndEditSubmit";
                }
                case "editSubmit": {
                    return "editSubmit,newAndEditSubmit";
                }
            }
            return triggerMode;
        }
        return null;
    }

    private ProcessDefinitionInfo getProcessDefinitionInfo(ProcessDefinitionEntity entity) {
        ProcessDefinitionInfo info = new ProcessDefinitionInfo();
        info.setId(entity.getId());
        info.setModelId(entity.getModelId());
        info.setName(entity.getName());
        info.setNumber(entity.getKey());
        info.setVersion(entity.getVersion());
        info.setState(entity.getEnable());
        info.setVersionState(entity.getVersionState());
        info.setEntityNumber(entity.getEntraBill());
        info.setEntityId(entity.getEntraBillId());
        info.setOrgId(entity.getOrgUnitId());
        info.setOperation(entity.getOperation());
        info.setProcessType(entity.getType());
        info.setCreateDate(entity.getCreateDate());
        info.setCreatorId(entity.getCreatorId());
        return info;
    }

    private String getOperationByTriggerMode(String triggerMode, String operation) {
        if (triggerMode != null && operation != null) {
            switch (triggerMode) {
                case "newSubmit": {
                    return operation.contains(TRIGGERMODE_NEWSUBMIT) ? TRIGGERMODE_NEWSUBMIT : TRIGGERMODE_NEWANDEDITSUBMIT;
                }
                case "editSubmit": {
                    return operation.contains(TRIGGERMODE_EDITSUBMIT) ? TRIGGERMODE_EDITSUBMIT : TRIGGERMODE_NEWANDEDITSUBMIT;
                }
            }
            return triggerMode;
        }
        return triggerMode;
    }

    private void assertInServiceAndLog(Object ... args) {
        boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
        this.dispatchBizInvokeLog(args);
        if (!canRunWf) {
            throw new KDException(WFErrorCode.workflowEngineNotConfiguration(), new Object[0]);
        }
    }

    private void dispatchBizInvokeLog(Object ... args) {
        List<Object> params;
        if (args != null && (params = Arrays.asList(args)) != null && params.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String s1 = String.format("OuterInvoke-Method:[%s]", params.get(0));
            sb.append(s1).append("Params:[");
            for (int i = 1; i < params.size(); ++i) {
                sb.append(params.get(i)).append(",");
            }
            sb.append("]");
            this.logger.debug(sb.toString());
        }
    }
}

