/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service.impl;

import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.impl.WorkflowEngineStatus;

public class WorkflowEngineService
implements Service {
    public static final String STARTSOURCE = "workflowStartSource";
    public static final String SOURCE_LIFECYCLE = "LifeCycle";
    private static Log logger = LogFactory.getLog(WorkflowEngineService.class);
    private WorkflowEngineStatus status = WorkflowEngineStatus.STOPPED;
    private static final String ENGINENAME = "WorkflowEngineService";

    public String getName() {
        return ENGINENAME;
    }

    public void start() {
        try {
            boolean canRun = WfConfigurationUtil.canRunWorkflow();
            if (canRun) {
                logger.debug(this.getName() + " is prepared for start!");
                this.status = WorkflowEngineStatus.STARTING;
                ThreadTruck.put((Object)STARTSOURCE, (Object)SOURCE_LIFECYCLE);
                ProcessEngines.init();
                this.status = WorkflowEngineStatus.STARTED;
                logger.debug(this.getName() + " is ready for serve!");
            } else {
                logger.debug(this.getName() + " is set to false!");
            }
        }
        catch (Exception e) {
            this.status = WorkflowEngineStatus.ERRORED;
            throw new KDException((Throwable)e, WFErrorCode.engineStartErrored(), new Object[]{e.getMessage()});
        }
        finally {
            ThreadTruck.remove((Object)STARTSOURCE);
        }
    }

    public void stop() {
        try {
            logger.debug(this.getName() + " is prepared for stop!");
            this.status = WorkflowEngineStatus.STOPPING;
            ProcessEngines.destroy();
            this.status = WorkflowEngineStatus.STOPPED;
        }
        catch (Exception e) {
            this.status = WorkflowEngineStatus.ERRORED;
            throw new KDException((Throwable)e, WFErrorCode.engineStopErrord(), new Object[]{e.getMessage()});
        }
    }

    public boolean isStarted() {
        return WorkflowEngineStatus.STARTED == this.status;
    }
}

