/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventService;
import kd.bos.bec.engine.EvtConfigurationUtil;
import kd.bos.bec.engine.EvtJobDAO;
import kd.bos.bec.engine.asyncexecutor.EvtJobManager;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.impl.jobexecutor.EvtJobUtil;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.pojo.BusinessObject;
import kd.bos.bec.engine.pojo.TriggerEventResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.ThreadLocals;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.api.EnabledProcessInfo;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.api.model.BillCard;
import kd.bos.workflow.api.model.ProcPublishResult;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.api.model.ProcessNode;
import kd.bos.workflow.basedata.role.WorkflowRole;
import kd.bos.workflow.basedata.role.WorkflowRoleResult;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.ArchiveService;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.crosstenant.CrossTenantInfo;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.dynprocess.billpage.BillPageAttributeConfig;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ParticipantRangeUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.startup.AssignPersonUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.dynprocess.FreeFlowUtil;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManagerImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.BillSummaryRebuildUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.engine.process.ProcessInstData;
import kd.bos.workflow.engine.runtime.GetNextUseableUserTaskNodeUtil;
import kd.bos.workflow.engine.task.AddYunzhijiaTaskParam;
import kd.bos.workflow.engine.task.AuditPointResult;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.BusinessKeyQueryParams;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.ThirdCommentInfo;
import kd.bos.workflow.exception.EngineAPIExceptionEnum;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.nocode.NoCodeFlowUtil;
import kd.bos.workflow.service.TryTriggerProcessTask;
import kd.bos.workflow.service.WfJobThreadTruck;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.beanutils.MethodUtils;

public class WorkflowServiceImpl
implements WorkflowService,
IEventService {
    private static final Object TRIGGEREVENTSUBSCRIPTJOB = "triggerEventSubscribeJobs";
    private static final String NUMBER = "number";
    private static final Object COMPLETETASK = "completeTaskInvoke";
    private static final String SUBJECTLIKESQL = " and ( b.fsubject like ? ) ";
    private static final String NAME = "name";
    private static final String NODEID = "nodeId";
    private static final String NEXTNODE = "nextNode";
    private static final String CONTENT = "content";
    private static final String EMPTYALLOW = "emptyallow";
    private static final String AFTERASSIGNNODE = "afterAssignNode";
    private static final String DATAENTITY = "dataentity";
    private static final String WF_TASKNODEHANDLERLISTF7 = "wf_tasknodehandlerlistf7";
    private static final String ALLINSTANCE = "all";
    private static final Object BATCHWITHDRAW = "bathWithdraw";
    private static final String ORDER_BY_DESC = "%s DESC";
    private static final String TRIGGERMODE_NEWSUBMIT = "newSubmit";
    private static final String TRIGGERMODE_EDITSUBMIT = "editSubmit";
    private static final String TRIGGERMODE_NEWANDEDITSUBMIT = "newAndEditSubmit";
    private Log logger = LogFactory.getLog(this.getClass());
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;
    private HistoryService historyService;
    private ManagementService managementService;
    private static final ThreadLocal<String> threadLocalForWfs = ThreadLocals.create();

    @Override
    public RuntimeService getRuntimeService() {
        if (this.runtimeService == null) {
            this.init();
        }
        if (this.runtimeService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.runtimeService;
    }

    @Override
    public RepositoryService getRepositoryService() {
        if (this.repositoryService == null) {
            this.init();
        }
        if (this.repositoryService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.repositoryService;
    }

    @Override
    public HistoryService getHistoryService() {
        if (this.historyService == null) {
            this.init();
        }
        if (this.historyService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.historyService;
    }

    @Override
    public TaskService getTaskService() {
        if (this.taskService == null) {
            this.init();
        }
        if (this.taskService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.taskService;
    }

    @Override
    public ManagementService getManagementService() {
        if (this.managementService == null) {
            this.init();
        }
        if (this.managementService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.managementService;
    }

    public <T> T getService(Class<T> clazz) {
        if (this.runtimeService == null) {
            this.init();
        }
        return ProcessEngines.getDefaultProcessEngine().getService(clazz);
    }

    public <T> T getJobManager(Class<T> clazz) {
        if (this.runtimeService == null) {
            this.init();
        }
        return ProcessEngines.getDefaultProcessEngine().getJobManager(clazz);
    }

    @Override
    public List<MessageServiceConfig> getMessageServiceConfigs() {
        return ((ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration()).getMessageServiceConfigs();
    }

    protected void init() {
        boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
        if (!canRunWf) {
            throw new KDException(WFErrorCode.workflowEngineNotConfiguration(), new Object[0]);
        }
        try {
            if (!ProcessEngines.isInitialized()) {
                ProcessEngines.init();
            }
            this.repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
            this.runtimeService = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
            this.historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
            this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
            this.managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.engineStartErrored(), new Object[]{e.getMessage()});
        }
    }

    public Object invokeBizPlugin(String clazz, String method, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object obj = TypesContainer.createInstance((String)clazz);
        Object result = false;
        try {
            result = MethodUtils.invokeMethod((Object)obj, (String)method, (Object[])args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                if (t instanceof KDBizException) {
                    throw (KDBizException)t;
                }
                throw new KDBizException(t, new ErrorCode("wf.invokeBizPlugin", "%s"), new Object[]{t.getMessage()});
            }
            throw e;
        }
        return result;
    }

    public Object invokeEventPlugin(String clazz, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object obj = TypesContainer.createInstance((String)clazz);
        Object result = false;
        try {
            result = MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                if (t instanceof KDBizException) {
                    throw (KDBizException)t;
                }
                throw new KDBizException(t, new ErrorCode("bec.invokeEventPlugin", "%s"), new Object[]{t.getMessage()});
            }
            throw e;
        }
        return result;
    }

    public Object invokeParseExpression(String clazz, String method, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object obj = TypesContainer.createInstance((String)clazz);
        Object result = false;
        try {
            result = MethodUtils.invokeMethod((Object)obj, (String)method, (Object[])args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                if (t instanceof KDBizException) {
                    throw (KDBizException)t;
                }
                throw new KDBizException(t, new ErrorCode("wf.invokeParseExpression", "%s"), new Object[]{t.getMessage()});
            }
            throw e;
        }
        return result;
    }

    public Object invokeBillRelationMethod(String clazz, String method, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object obj = TypesContainer.createInstance((String)clazz);
        Object result = false;
        try {
            result = MethodUtils.invokeMethod((Object)obj, (String)method, (Object[])args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                if (t instanceof KDBizException) {
                    throw (KDBizException)t;
                }
                throw new KDBizException(t, new ErrorCode("wf.invokeBillRelationMethod", "%s"), new Object[]{t.getMessage()});
            }
            throw e;
        }
        return result;
    }

    public void discardProcesses(List<Long> modelIds, boolean disableProcDefinition, boolean terminalProcInst) {
        this.getRepositoryService().discardProcesses(modelIds, disableProcDefinition, terminalProcInst);
    }

    public Long saveProcess(ProcessModel model) {
        return this.getRepositoryService().saveProcessModel(model);
    }

    public ProcPublishResult publishProcess(Long modelId, Map<String, Object> deploymentProperty) {
        return this.getRepositoryService().publishProcess(modelId, deploymentProperty);
    }

    public void updateLatestProcessDefaultScheme(Long modelId) {
        this.getRepositoryService().updateLatestProcessDefaultScheme(modelId);
    }

    public ProcessModel getProcess(Long modelId) {
        return this.getRepositoryService().loadProcessModel(modelId);
    }

    public List<ProcessModel> getProcessesByEntityNumber(String entityNumber) {
        return this.getRepositoryService().getProcessesByEntityNumber(entityNumber);
    }

    public ProcessDefinitionInfo getProcessDefinitionInfoById(Long procDefId) {
        ProcessDefinitionEntity entity = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(procDefId, "wf_processdefinition", "id,name,key,version,enable,versionstate,entrabill,entrabillid,orgunitid,operation,type,modelid,resourceid,createdate,creatorid");
        if (entity != null) {
            ProcessDefinitionInfo info = this.getProcessDefinitionInfo(entity);
            ResourceEntity resource = (ResourceEntity)this.getRepositoryService().findEntityById(entity.getResourceId(), "wf_resource");
            if (ModelType.NoCodeFlow.name().equals(info.getProcessType())) {
                info.setData(NoCodeFlowUtil.convertWorkflowJsonToNoCodeJson(JSONObject.parseObject((String)resource.getData())).toJSONString());
            } else {
                info.setData(resource.getData());
            }
            return info;
        }
        return null;
    }

    public ProcessDefinitionInfo getProcessDefinitionInfoByProcInstId(Long procInstId) {
        HistoricProcessInstanceEntity hiProcInst = (HistoricProcessInstanceEntity)this.getRepositoryService().findEntityById(procInstId, "wf_hiprocinst", "processDefinitionId");
        if (hiProcInst == null) {
            return null;
        }
        return this.getProcessDefinitionInfoById(hiProcInst.getProcessDefinitionId());
    }

    private ProcessDefinitionInfo getProcessDefinitionInfo(ProcessDefinitionEntity entity) {
        ProcessDefinitionInfo info = new ProcessDefinitionInfo();
        info.setId(entity.getId());
        info.setModelId(entity.getModelId());
        info.setName(entity.getName());
        info.setNumber(entity.getKey());
        info.setVersion(entity.getVersion());
        info.setState(entity.getEnable());
        info.setVersionState(entity.getVersionState());
        info.setEntityNumber(entity.getEntraBill());
        info.setEntityId(entity.getEntraBillId());
        info.setOrgId(entity.getOrgUnitId());
        info.setOperation(entity.getOperation());
        info.setProcessType(entity.getType());
        info.setCreateDate(entity.getCreateDate());
        info.setCreatorId(entity.getCreatorId());
        return info;
    }

    public List<ProcessNode> getProcessNodes(String procType) {
        return this.getRepositoryService().getProcessNodes(procType);
    }

    public WFProcess getProcessInfo(DynamicObject bill, String operation) {
        return this.getRepositoryService().getProcessInfo(bill, operation);
    }

    public List<WFFlowElement> getProcessElements(DynamicObject bill, String operation) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("bill", bill);
        params.put("operation", operation);
        return this.getRepositoryService().getProcessElements(params);
    }

    public WFProcess getProcessInfo(String number, String version) {
        return this.getRepositoryService().getProcessInfo(number, version);
    }

    public List<WFFlowElement> getProcessElements(String number, String version) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(NUMBER, number);
        params.put("version", version);
        return this.getRepositoryService().getProcessElements(params);
    }

    public void addNodeTemplate(NodeTemplate template) {
        this.getRepositoryService().addNodeTemplate(template);
    }

    public void updateNodeTemplateInfo(String nodeTemplateNumber, Map<String, Object> nodeTemplateInfo) {
        this.getRepositoryService().updateNodeTemplateInfo(nodeTemplateNumber, nodeTemplateInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tryTriggerProcess(String billId, String operation, String entityNumber, Map<String, Object> variable) {
        this.logger.debug(String.format("tryTriggerProcess,bill[%s],operation[%s],entityNumber[%s]", billId, operation, entityNumber));
        this.assertInServiceAndLog("tryTriggerProcess", billId, operation, entityNumber);
        TryTriggerProcessTask tryTrigger = new TryTriggerProcessTask();
        if (FreeFlowUtil.isFreeFlow(variable) || tryTrigger.existProcess(entityNumber, operation)) {
            this.variablesCorrection(variable);
            DynamicObject obj = WfUtils.findBusinessObject(billId, entityNumber, null, variable);
            if (obj == null) throw new KDBizException("no bill exist!");
            DynamicObject[] objs = new DynamicObject[]{obj};
            this.tryTriggerProcess(objs, operation, variable);
            return;
        } else {
            this.logger.debug(String.format("no process exist,operation[%s],entityNumber[%s]", operation, entityNumber));
        }
    }

    private void variablesCorrection(Map<String, Object> variable) {
        if (variable == null || variable.get("isCrossTenant") == null || Boolean.FALSE.equals(variable.get("isCrossTenant"))) {
            return;
        }
        Object targetTenantId = variable.get("targetTenantId");
        Object currentTenantId = variable.get("currentTenantId");
        variable.put("targetTenantId", currentTenantId);
        variable.put("currentTenantId", targetTenantId);
        CrossTenantInfo crossTenantInfo = null;
        if (variable.get("crossTenantInfo") != null) {
            String crossTenantInfoStr = (String)variable.get("crossTenantInfo");
            crossTenantInfo = (CrossTenantInfo)SerializationUtils.fromJsonString((String)crossTenantInfoStr, CrossTenantInfo.class);
        }
        if (crossTenantInfo != null) {
            crossTenantInfo.setTargetTenantAccountId((String)variable.get("currentTenantAccountId"));
            crossTenantInfo.setTargetTenantId((String)currentTenantId);
            variable.put("crossTenantInfo", SerializationUtils.toJsonString((Object)crossTenantInfo));
        }
    }

    public void tryTriggerProcessByProcNumber(String businessKey, String processNumber, String entityNumber, Map<String, Object> variables) {
        this.logger.debug(String.format("tryTriggerProcessByProcNumber: entityNumber: %s, businessKey: %s, processNumber: %s", entityNumber, businessKey, processNumber));
        this.assertInServiceAndLog("tryTriggerProcessByProcNumber", entityNumber, businessKey, processNumber);
        DynamicObject obj = WfUtils.findBusinessObject(businessKey, entityNumber);
        if (obj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"WorkflowServiceImpl_60", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber), new QFilter("enable", "=", (Object)"enable")};
        if (!QueryServiceHelper.exists((String)"wf_processdefinition", (QFilter[])filters)) {
            throw new KDBizException("process does not exist or is not enabled.");
        }
        if (this.getRuntimeService().inProcess(businessKey)) {
            throw new KDBizException(String.format("the businessKey %s is already in process.", businessKey));
        }
        DynamicObject[] objs = new DynamicObject[]{obj};
        this.tryTriggerProcessByProcNumber(objs, processNumber, variables);
    }

    public void tryTriggerProcessByEvent(String entityNumber, String[] billIds, final String eventNumber, Map<String, Object> variables) {
        try (TXHandle tx = TX.required();){
            JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
            final List<JobEntity> jobs = this.runtimeService.tryTriggerProcessByEvent(entityNumber, billIds, eventNumber, variables);
            if (jobs != null && !jobs.isEmpty()) {
                dao.insert(jobs, eventNumber, entityNumber);
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        if (rollbacked) {
                            WorkflowServiceImpl.this.logger.debug(String.format("rollback is true,don't send.%s", eventNumber));
                            return;
                        }
                        JobUtil.sendJobToMQ(jobs);
                    }
                });
            }
        }
    }

    public void tryTriggerProcess(DynamicObject[] objs, String operation, Map<String, Object> variable) {
        this.tryTriggerProcess(objs, operation, null, variable);
    }

    public void tryTriggerProcessByProcNumber(DynamicObject[] objs, String processNumber, Map<String, Object> variables) {
        this.tryTriggerProcess(objs, null, processNumber, variables);
    }

    private void tryTriggerProcess(DynamicObject[] objs, String operation, String procNumber, Map<String, Object> variable) {
        this.assertInServiceAndLog("tryTriggerProcess", objs == null ? null : Integer.valueOf(objs.length), operation, variable);
        if (objs == null || objs.length == 0) {
            this.logger.debug(String.format("obj is null for [%s]", operation));
            return;
        }
        HashMap<String, DynamicObject> objsMap = new HashMap<String, DynamicObject>(objs.length);
        for (DynamicObject o : objs) {
            String bill = o.getPkValue().toString();
            objsMap.put(bill, o);
        }
        final ArrayList pks = new ArrayList(objsMap.keySet());
        final String entityNumber = objs[0].getDataEntityType().getName();
        JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        Collection<DynamicObject> insertObjs = dao.createTableAndFilter(operation, entityNumber, objsMap);
        RuntimeService rs = this.getRuntimeService();
        Object fromOperation = WfUtils.pop(variable, "_fromOperation_");
        if (this.runtimeService != null) {
            List<JobEntity> jobs;
            if (variable != null && !variable.isEmpty() && variable.get("serialexecutecount") == null && insertObjs.size() > 1) {
                variable.put("serialexecutecount", insertObjs.size());
            }
            if ((jobs = rs.tryTriggerProcess(insertObjs.toArray(new DynamicObject[insertObjs.size()]), operation, procNumber, variable)) != null && !jobs.isEmpty()) {
                boolean ifSendNotDirectly;
                dao.insert(jobs, operation, entityNumber);
                final String key = String.format("release-wfJobMsg-%1$s-%2$s", entityNumber, operation);
                boolean bl = WfConfigurationUtil.ifSendMqDirect() != false ? false : (ifSendNotDirectly = fromOperation != null);
                if (ifSendNotDirectly) {
                    WfJobThreadTruck.put(key, "false");
                    this.logger.debug(key);
                }
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        if (!rollbacked) {
                            WfCacheHelper.putAddressPks(entityNumber, pks);
                            if (ifSendNotDirectly && "false".equalsIgnoreCase((String)WfJobThreadTruck.get(key))) {
                                WfJobThreadTruck.remove(key);
                                HashMap<Long, String> wfJobMsg = (HashMap<Long, String>)WfJobThreadTruck.get("wfJobMsg");
                                if (wfJobMsg == null) {
                                    wfJobMsg = new HashMap<Long, String>(jobs.size());
                                }
                                for (JobEntity job : jobs) {
                                    wfJobMsg.put(job.getId(), String.format("%1$s,%2$s,%3$s", job.getSource(), job.getJobHandlerType(), job.getEntityNumber()));
                                }
                                WfJobThreadTruck.put("wfJobMsg", wfJobMsg);
                                WorkflowServiceImpl.this.logger.debug(String.format("workflow onEnded %s", WfUtils.mapToStr(wfJobMsg)));
                                return;
                            }
                            if (WfJobThreadTruck.exists(key)) {
                                WfJobThreadTruck.remove(key);
                            }
                            JobUtil.sendJobToMQ(jobs);
                        } else {
                            if (WfJobThreadTruck.exists(key)) {
                                WfJobThreadTruck.remove(key);
                            }
                            WorkflowServiceImpl.this.logger.debug("entityNumber:" + entityNumber + "+pks:" + WfUtils.listToString(pks, ",") + " error\uff01");
                        }
                    }
                });
            }
        } else {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        objsMap = null;
    }

    private Map<String, String> existEvent(String evtNumber) {
        Map<String, String> eventParams = null;
        if (StringUtils.isNotEmpty((CharSequence)evtNumber) && (eventParams = EvtCacheHelper.getCacheEventMap(evtNumber)) != null && eventParams.size() > 0 && eventParams.get("id") != null) {
            return eventParams;
        }
        String appid = "";
        String sql = "select top 1 b.ftype ftype, b.fsource fsource, b.fid fid from t_evt_subscription a INNER JOIN t_evt_event b on a.FEVENT = b.fid where a.FSTATUS = '1' and a.feventnumber = ? AND b.FSTATUS = '1'";
        try (DataSet ds = DB.queryDataSet((String)"be.event", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{evtNumber});){
            for (Row row : ds) {
                if (eventParams == null) {
                    eventParams = new HashMap<String, String>();
                }
                appid = row.getString("fsource");
                eventParams.put("id", row.getString("fid"));
                eventParams.put("type", row.getString("ftype"));
            }
        }
        if (eventParams != null && eventParams.size() > 0) {
            String appNum;
            if (appid != null && appid.trim().length() > 0 && WfUtils.isNotEmpty(appNum = BizAppServiceHelp.getAppNumByAppId((String)appid))) {
                eventParams.put("source", appNum);
            }
            EvtCacheHelper.addCacheEventMap(evtNumber, eventParams);
            return eventParams;
        }
        return null;
    }

    @Override
    public Object triggerEventSubscribe(String eventNumber, String json) {
        this.assertInServiceAndLog(TRIGGEREVENTSUBSCRIPTJOB, eventNumber, json);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884ctriggerEventSubscribe\uff1a%s", (String)"WorkflowServiceImpl_63", (String)"bos-wf-engine", (Object[])new Object[0]), System.currentTimeMillis()));
        TriggerEventResult result = new TriggerEventResult();
        try {
            Map<String, String> eventParams = this.existEvent(eventNumber);
            if (eventParams == null || eventParams.isEmpty()) {
                result.setType("fail");
                result.setDesc(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e8b\u4ef6\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u4e8b\u4ef6\uff0c\u6216\u672a\u542f\u7528\u670d\u52a1\u3002\uff01", (String)"WorkflowServiceImpl_44", (String)"bos-wf-engine", (Object[])new Object[0]), eventNumber));
                return result;
            }
            if ("custom".equals(eventParams.get("type"))) {
                String businesskeys;
                sb.append(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u3010%1$s\u3011\u88ab\u89e6\u53d1\uff0c\u53c2\u6570\u3010%2$s\u3011\uff1b", (String)"WorkflowServiceImpl_25", (String)"bos-wf-engine", (Object[])new Object[0]), eventNumber, json));
                this.assertInServiceAndLog(TRIGGEREVENTSUBSCRIPTJOB, eventNumber, json);
                if (WfUtils.isEmpty(json)) {
                    result.setType("fail");
                    String info = "has not event source data for[" + eventNumber + "] ! ";
                    result.setDesc(info);
                    this.logger.debug(info);
                    return result;
                }
                ProcessEngineConfigurationImpl impl = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
                EvtJobManager jobManager = impl.getEvtJobManager();
                ArrayList<EvtJobEntity> jobs = new ArrayList<EvtJobEntity>();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("eventType", "jsonEvent");
                params.put("eventNumber", eventNumber);
                params.put("json", json);
                params.put("eventParamsId", eventParams.get("id"));
                String appNum = eventParams.get("source");
                if (appNum != null && appNum.trim().length() > 0) {
                    sb.append(String.format("triggerEventSubscribeAppId--[%s]", appNum));
                    params.put("appNumForSubApp", appNum);
                }
                EvtJobEntity job = jobManager.createEventDispatchJob(params, null);
                Long id = ORM.create().genLongId("evt_job");
                job.setId(id);
                JSONObject jobj = JSON.parseObject((String)json);
                if (jobj != null && (businesskeys = jobj.getString("businesskey")) != null && businesskeys.trim().length() > 0) {
                    if (businesskeys.contains(",")) {
                        int maxCount;
                        String[] pk = businesskeys.split("\\,");
                        if (pk.length > 100 && pk.length > (maxCount = EvtConfigurationUtil.getBecTriggerBusinesskeyMaxCount().intValue())) {
                            throw new KDBizException(new ErrorCode("triggerEventMaxCountError", String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3\u89e6\u53d1\u5355\u636e\u6570\u91cf\u8d85\u8fc7\u9650\u5236:%s\u3002", (String)"WorkflowServiceImpl_159", (String)"bos-wf-engine", (Object[])new Object[0]), maxCount)), new Object[0]);
                        }
                        if (pk.length > 0 && pk[0] != null) {
                            job.setBusinessKey(pk[0]);
                        }
                    } else {
                        job.setBusinessKey(businesskeys);
                    }
                }
                jobs.add(job);
                sb.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e8b\u4ef6\u5206\u53d1job\u3010%d\u3011\u3002", (String)"WorkflowServiceImpl_27", (String)"bos-wf-engine", (Object[])new Object[0]), job.getId()));
                try (TXHandle tx = TX.required();){
                    Map evtData = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                    this.sendAndInsertEventJobs("", (String)evtData.get("entityNumber"), jobs, sb, (String)evtData.get("appId"));
                }
                result.setType("success");
                return result;
            }
            if (WfUtils.isEmpty(json)) {
                result.setType("fail");
                String errorInfo = ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"WorkflowServiceImpl_38", (String)"bos-wf-engine", (Object[])new Object[0]);
                result.setDesc(errorInfo);
                sb.append(errorInfo);
            } else {
                Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                String businesskey = (String)map.get("businesskey");
                String entityNumber = (String)map.get("entityNumber");
                if (WfUtils.isEmpty(businesskey) || WfUtils.isEmpty(entityNumber)) {
                    result.setType("fail");
                    String errorInfo = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u6ca1\u6709\u5b9e\u4f53\u7f16\u7801\uff08entityNumber\uff09\u548c\u4e3b\u952e\uff08businesskey\uff09\u3002", (String)"WorkflowServiceImpl_39", (String)"bos-wf-engine", (Object[])new Object[0]);
                    result.setDesc(errorInfo);
                    sb.append(errorInfo);
                } else {
                    result.setType("success");
                    this.triggerEventSubscribeJobs(eventNumber, businesskey, entityNumber);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            sb.append(ResManager.loadKDString((String)"\u51fa\u73b0error\uff0c\u3010/r/n", (String)"WorkflowServiceImpl_28", (String)"bos-wf-engine", (Object[])new Object[0])).append(WfUtils.getExceptionStacktrace(e)).append("/r/n\u3011");
            this.logger.error(sb.toString());
            if (e instanceof KDBizException && ((KDBizException)((Object)e)).getErrorCode() != null && "triggerEventMaxCountError".equalsIgnoreCase(((KDBizException)((Object)e)).getErrorCode().getCode())) {
                throw e;
            }
            result.setThrowable(e);
            result.setType("fail");
            result.setDesc(e.getMessage());
            return result;
        }
    }

    public void triggerEventSubscribeJobs(String eventNumber, String businessKey, String entityNumber) {
        this.assertInServiceAndLog(TRIGGEREVENTSUBSCRIPTJOB, eventNumber, businessKey, entityNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])new Object[]{businessKey}, (DynamicObjectType)type);
        this.triggerEventSubscribeJobs(eventNumber, objs);
    }

    @Override
    public void triggerEventSubscribeJobs(DynamicObject[] objs, String operation, Map<String, Object> variable) {
        this.assertInServiceAndLog(TRIGGEREVENTSUBSCRIPTJOB, objs == null ? null : Integer.valueOf(objs.length), operation, variable);
        if (objs != null) {
            String entityNumber = objs[0].getDataEntityType().getName();
            String eventNumber = String.format("%s.%s", entityNumber, operation);
            this.triggerEventSubscribeJobs(eventNumber, objs, variable);
        }
    }

    public void triggerEventSubscribeJobs(String businessKey, String operation, String entityNumber, Map<String, Object> variable) {
        this.assertInServiceAndLog(TRIGGEREVENTSUBSCRIPTJOB, businessKey, entityNumber, operation, variable);
        String eventNumber = String.format("%s.%s", entityNumber, operation);
        this.triggerEventSubscribeJobs(eventNumber, businessKey, entityNumber);
    }

    public void triggerEventSubscribeJobs(String eventNumber, DynamicObject[] objs) {
        Map<String, String> eventParams;
        if (StringUtils.isNotEmpty((CharSequence)eventNumber) && ((eventParams = this.existEvent(eventNumber)) == null || eventParams.size() < 1)) {
            String info = "has not event source data for[" + eventNumber + "] ! ";
            this.logger.debug(info);
            return;
        }
        this.triggerEventSubscribeJobs(eventNumber, objs, null);
    }

    private void triggerEventSubscribeJobs(String eventNumber, DynamicObject[] objs, Map<String, Object> variable) {
        StringBuilder sb = new StringBuilder();
        long begin = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884ctriggerEventSubscribeJobs\uff1a%s", (String)"WorkflowServiceImpl_65", (String)"bos-wf-engine", (Object[])new Object[0]), begin));
        try {
            int maxCount;
            ProcessEngineConfigurationImpl impl = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
            EvtJobManager jobManager = impl.getEvtJobManager();
            String entityNumber = objs[0].getDataEntityType().getName();
            ArrayList<String> pkVals = new ArrayList<String>(objs.length);
            String pkVal = "";
            for (DynamicObject obj : objs) {
                pkVal = String.valueOf(obj.getPkValue());
                pkVals.add(pkVal);
            }
            String operation = eventNumber.split("\\.")[1];
            sb.append(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u4e8b\u4ef6\u3010%1$s\u3011\u88ab\u89e6\u53d1\uff0c\u5b9e\u4f53\u7f16\u7801\u3010%2$s\u3011\uff0cpk\u3010%3$s\u3011\uff0c\u64cd\u4f5c\u3010%4$s\u3011\uff1b", (String)"WorkflowServiceImpl_29", (String)"bos-wf-engine", (Object[])new Object[0]), eventNumber, entityNumber, WfUtils.listToString(pkVals, ","), operation));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("eventType", "entityEvent");
            params.put("eventNumber", eventNumber);
            params.put("entityNumber", entityNumber);
            params.put("businesskeys", pkVals);
            params.put("operation", operation);
            if (objs.length > 100 && objs.length > (maxCount = EvtConfigurationUtil.getBecTriggerBusinesskeyMaxCount().intValue())) {
                throw new KDBizException(new ErrorCode("triggerEventMaxCountError", String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3\u89e6\u53d1\u5355\u636e\u6570\u91cf\u8d85\u8fc7\u9650\u5236:%s\u3002", (String)"WorkflowServiceImpl_159", (String)"bos-wf-engine", (Object[])new Object[0]), maxCount)), new Object[0]);
            }
            EvtJobEntity job = jobManager.createEventDispatchJob(params, variable);
            job.setBusinessKey(pkVal);
            ArrayList<EvtJobEntity> jobs = new ArrayList<EvtJobEntity>();
            Long id = ORM.create().genLongId("evt_job");
            job.setId(id);
            jobs.add(job);
            sb.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e8b\u4ef6\u5206\u53d1job\u3010%d\u3011\u3002", (String)"WorkflowServiceImpl_27", (String)"bos-wf-engine", (Object[])new Object[0]), id));
            this.sendAndInsertEventJobs(operation, entityNumber, jobs, sb, "");
        }
        catch (RuntimeException e) {
            sb.append(String.format(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowServiceImpl_32", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.getExceptionStacktrace(e)));
            if (e instanceof KDBizException && ((KDBizException)((Object)e)).getErrorCode() != null && "triggerEventMaxCountError".equalsIgnoreCase(((KDBizException)((Object)e)).getErrorCode().getCode())) {
                throw e;
            }
            throw new KDBizException((Throwable)e, new ErrorCode("triggerEventError", e.getMessage()), new Object[]{String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowServiceImpl_332", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage())});
        }
    }

    private void sendAndInsertEventJobs(final String operation, String entityNumber, final List<EvtJobEntity> jobs, StringBuilder sb, String appId) throws RuntimeException {
        try {
            boolean ifSendNotDirectly;
            EvtJobDAO dao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
            String dbRoute = DBRoute.workflow.getRouteKey();
            if (WfUtils.isNotEmpty(entityNumber)) {
                MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                dbRoute = entity.getDBRouteKey();
            } else if (WfUtils.isNotEmpty(appId)) {
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
                dbRoute = appMeta.getAppElement().getDbRoute();
            }
            dao.insert(jobs, operation, WfUtils.isEmpty(entityNumber) ? "" : entityNumber, dbRoute);
            IndicatorInfo indicatorInfo = new IndicatorInfo("businessEventEntityNumber", (Object)entityNumber, jobs.size());
            indicatorInfo.addToSpecialProperty("createDate", (Object)WfUtils.now());
            WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
            sb.append(String.format(ResManager.loadKDString((String)"jobs\u5165\u5e93\u3010%s\u3011\uff1b", (String)"WorkflowServiceImpl_33", (String)"bos-wf-engine", (Object[])new Object[0]), dbRoute));
            final String key = String.format("release-evtJobMsg-%1$s-%2$s", entityNumber, operation);
            boolean bl = ifSendNotDirectly = WfConfigurationUtil.ifSendMqDirect() == false && ThreadTruck.get((Object)"ifEventFromApi") == null && operation != null && operation.trim().length() > 0 && jobs != null && jobs.size() > 0;
            if (ifSendNotDirectly) {
                WfJobThreadTruck.put(key, "false");
            }
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onEnded(boolean rollbacked) {
                    if (rollbacked) {
                        WorkflowServiceImpl.this.logger.debug(String.format("rollback is true,don't send.%s", operation));
                        if (WfJobThreadTruck.exists(key)) {
                            WfJobThreadTruck.remove(key);
                        }
                        return;
                    }
                    if (ifSendNotDirectly && "false".equalsIgnoreCase((String)WfJobThreadTruck.get(key))) {
                        WfJobThreadTruck.remove(key);
                        HashMap<Long, String> evtJobMsg = (HashMap<Long, String>)WfJobThreadTruck.get("evtJobMsg");
                        if (evtJobMsg == null) {
                            evtJobMsg = new HashMap<Long, String>();
                        }
                        evtJobMsg.put(((EvtJobEntity)jobs.get(0)).getId(), String.format("%1$s,%2$s,%3$s", ((EvtJobEntity)jobs.get(0)).getSource(), ((EvtJobEntity)jobs.get(0)).getAppNumForSubApp(), ((EvtJobEntity)jobs.get(0)).getProcessInstanceId()));
                        WfJobThreadTruck.put("evtJobMsg", evtJobMsg);
                        WorkflowServiceImpl.this.logger.debug(String.format("bec onEnded %s", WfUtils.mapToStr(evtJobMsg)));
                        return;
                    }
                    if (WfJobThreadTruck.exists(key)) {
                        WfJobThreadTruck.remove(key);
                    }
                    EvtJobUtil.sendMqDirect(jobs);
                }
            });
        }
        catch (Exception e) {
            if ("No transaction exists(ensure call begin before).".equals(e.getMessage())) {
                EvtJobUtil.sendMqDirect(jobs);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateParticipant(Long taskId, List<Long> userIds) {
        this.assertInServiceAndLog("updateParticipant", taskId, userIds);
        String markId = String.format("wf/updateparticipant/%s", taskId);
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                this.taskService = this.getTaskService();
                this.taskService.adminTransferTasks(String.valueOf(taskId), WfUtils.listToString(userIds, ","), (ILocaleString)new LocaleString(""), false);
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    public List<Map<String, Object>> getNextUserTaskNodeByBusinessKey(String businessKey) {
        try {
            this.assertInServiceAndLog("getNextUserTaskNode", businessKey);
            List<Map<String, Object>> result = this.getTaskService().getNextUserTaskNode(businessKey);
            return result;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public void batchCompleteCompositeTasks(Map<Long, Map<String, Object>> variables) {
        Long[] taskids;
        for (Long taskid : taskids = variables.keySet().toArray(new Long[0])) {
            Map<String, Object> map = variables.get(taskid);
            if (WfUtils.isEmpty((String)map.get("terminal"))) {
                map.put("terminal", "api");
            }
            variables.put(taskid, map);
        }
        this.assertInServiceAndLog(COMPLETETASK, variables);
        this.getTaskService().batchCompleteCompositeTasks(variables);
    }

    public Map<String, List<String>> canWithdraw(DynamicObject[] objs) {
        try {
            this.assertInServiceAndLog("canWithdraw", objs);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                HashMap<String, List<String>> notInProcessAndWfCanUnSubmit = new HashMap<String, List<String>>();
                ArrayList<String> pks = new ArrayList<String>(10);
                for (DynamicObject o : objs) {
                    pks.add(o.getPkValue().toString());
                }
                notInProcessAndWfCanUnSubmit.put("notInProcess", pks);
                return notInProcessAndWfCanUnSubmit;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        return this.taskService.canWithdraw(objs);
    }

    public void withdraw(DynamicObject obj, String operationName) {
        try {
            this.assertInServiceAndLog("withdraw", obj);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return;
            }
            throw e;
        }
        if (obj == null) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u64a4\u56de", (String)"WorkflowServiceImpl_3", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        String businessKey = obj.getPkValue().toString();
        this.taskService = this.getTaskService();
        this.runtimeService = this.getRuntimeService();
        if (WfConfigurationUtil.userOldWithdraw()) {
            boolean inProcess = this.runtimeService.inProcess(businessKey);
            if (inProcess) {
                this.taskService.withdrawProcess(businessKey, operationName);
            }
            return;
        }
        Map<String, List<String>> ret = this.taskService.canWithdraw(new DynamicObject[]{obj});
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        if (ret.get("wfCanWithdraw") != null && !ret.get("wfCanWithdraw").isEmpty()) {
            List<String> inProcessPks = ret.get("wfCanWithdraw");
            for (String businesskey : inProcessPks) {
                this.getTaskService().unsubmitBillAndProc(businesskey, params);
            }
        } else if (ret.get("wfCanWithdrawByAbandonProc") != null && !ret.get("wfCanWithdrawByAbandonProc").isEmpty()) {
            params.put("withdrawType", "abandon");
            List<String> inProcessPks = ret.get("wfCanWithdrawByAbandonProc");
            for (String businesskey : inProcessPks) {
                this.getTaskService().unsubmitBillAndProc(businesskey, params);
            }
        } else {
            List<String> causes = ret.get("notWithdrawCause");
            if (causes != null) {
                HashMap<String, String> notWithdrawCause = new HashMap<String, String>();
                for (String cause : causes) {
                    String[] arr = cause.split("_");
                    if (arr.length != 2) continue;
                    notWithdrawCause.put(arr[0], arr[1]);
                }
                String cause = (String)notWithdrawCause.get(businessKey);
                if (WfUtils.isNotEmpty(cause)) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{cause});
                }
            }
        }
    }

    public void billUnsubmit(DynamicObject[] objs, String operationName, Map<String, Object> params) {
        try {
            this.assertInServiceAndLog(BATCHWITHDRAW, objs, operationName);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return;
            }
            throw e;
        }
        if (objs == null || objs.length == 0) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u64a4\u56de", (String)"WorkflowServiceImpl_3", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        try {
            if (WfConfigurationUtil.userOldWithdraw()) {
                ArrayList<String> pks = new ArrayList<String>(16);
                for (DynamicObject obj : objs) {
                    pks.add(String.valueOf(obj.getPkValue()));
                }
                this.taskService.batchWithdrawProcess(pks.toArray(new String[0]), operationName);
                return;
            }
            String abandonPks = (String)params.get("abandonPks");
            if (WfUtils.isEmpty(abandonPks)) {
                abandonPks = "";
            }
            for (DynamicObject obj : objs) {
                String businesskey = String.valueOf(obj.getPkValue());
                params.put("withdrawType", "");
                if (abandonPks.contains(businesskey)) {
                    params.put("withdrawType", "abandon");
                }
                params.put("operationName", operationName);
                this.getTaskService().unsubmitBillAndProc(businesskey, params);
            }
        }
        catch (WFBizException e) {
            throw new KDBizException(e.getCause(), WFErrorCode.businessUnknowOperationError(), new Object[]{WfUtils.getExceptionStacktrace(e.getCause())});
        }
        catch (KDException e) {
            String tip = e.getMessage();
            if (tip != null && e.getErrorCode() != null) {
                tip = tip.replace(String.format(e.getErrorCode().getMessage(), ""), "");
            }
            throw new KDBizException((Throwable)e, e.getErrorCode(), new Object[]{tip});
        }
        catch (Exception e) {
            String exceptionMessage = WfUtils.isEmpty(e.getMessage()) ? ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u6682\u4e0d\u53ef\u4ee5\u64a4\u56de\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowServiceImpl_62", (String)"bos-wf-engine", (Object[])new Object[0]) : e.getMessage();
            throw new KDBizException((Throwable)e, WFErrorCode.withdrawErrorWithMessage(), new Object[]{exceptionMessage});
        }
    }

    public String batchWithdraw(DynamicObject[] objs, String operationName) {
        try {
            this.assertInServiceAndLog(BATCHWITHDRAW, objs, operationName);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return "";
            }
            throw e;
        }
        if (objs == null || objs.length == 0) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u64a4\u56de", (String)"WorkflowServiceImpl_3", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            List<String> bizJobIds;
            List<String> inProcessPks;
            Map<String, List<String>> ret = this.getTaskService().canWithdraw(objs);
            if (ret.get("wfCanWithdraw") != null) {
                inProcessPks = ret.get("wfCanWithdraw");
                for (String businesskey : inProcessPks) {
                    this.getTaskService().unsubmitBillAndProc(businesskey, params);
                }
            }
            if (ret.get("wfCanWithdrawByAbandonProc") != null) {
                params.put("withdrawType", "abandon");
                inProcessPks = ret.get("wfCanWithdrawByAbandonProc");
                for (String businesskey : inProcessPks) {
                    this.getTaskService().unsubmitBillAndProc(businesskey, params);
                }
            }
            if ((bizJobIds = ret.get("withdrawDeleteBizJobIds")) != null && !bizJobIds.isEmpty()) {
                return WfUtils.listToString(bizJobIds, ",");
            }
        }
        catch (WFBizException e) {
            throw new KDBizException(e.getCause(), WFErrorCode.businessUnknowOperationError(), new Object[]{WfUtils.getExceptionStacktrace(e.getCause())});
        }
        catch (KDException e) {
            String tip = e.getMessage();
            if (tip != null && e.getErrorCode() != null) {
                tip = tip.replace(String.format(e.getErrorCode().getMessage(), ""), "");
            }
            throw new KDBizException((Throwable)e, e.getErrorCode(), new Object[]{tip});
        }
        catch (Exception e) {
            String exceptionMessage = WfUtils.isEmpty(e.getMessage()) ? ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u6682\u4e0d\u53ef\u4ee5\u64a4\u56de\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowServiceImpl_62", (String)"bos-wf-engine", (Object[])new Object[0]) : e.getMessage();
            throw new KDBizException((Throwable)e, WFErrorCode.withdrawErrorWithMessage(), new Object[]{exceptionMessage});
        }
        return "";
    }

    public boolean inProcess(String businessKey) {
        try {
            this.assertInServiceAndLog("inProcess", businessKey);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return false;
            }
            throw e;
        }
        if (WfUtils.isEmpty(businessKey)) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u662f\u5426\u5728\u6d41\u7a0b\u4e2d", (String)"WorkflowServiceImpl_4", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        this.runtimeService = this.getRuntimeService();
        return this.runtimeService.inProcess(businessKey);
    }

    public ExtendedDataEntity[] getInProcessDataEntity(ExtendedDataEntity[] dataEntities) {
        try {
            this.assertInServiceAndLog("getInProcessDataEntity", dataEntities);
            if (dataEntities == null || dataEntities.length <= 0) {
                return dataEntities;
            }
            String entityNumber = dataEntities[0].getDataEntity().getDataEntityType().getName();
            if (!ProcessDefinitionUtil.existProcessDefinitionByEntityNumber(entityNumber)) {
                this.logger.debug(String.format("no process definition exists, entityNumber[%s].", entityNumber));
                return new ExtendedDataEntity[0];
            }
            List<String> entityPks = Arrays.stream(dataEntities).map(entity -> entity.getDataEntity().getPkValue().toString()).collect(Collectors.toList());
            String[] businessKeys = WfCacheHelper.getExecutingBusinesskeysByEntityNumber(entityNumber, entityPks);
            ArrayList<ExtendedDataEntity> inProcessExtendedDataEntity = new ArrayList<ExtendedDataEntity>();
            HashSet businessKeysSet = new HashSet(businessKeys.length);
            Collections.addAll(businessKeysSet, businessKeys);
            this.logger.debug(String.format("\u6b63\u5728\u5de5\u4f5c\u6d41\u4e2d\u6267\u884c\u7684pk[%s]", WfUtils.listToString(businessKeysSet, ",")));
            HashMap<String, ExtendedDataEntity> notInCacheEntitys = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
            HashMap<String, ExtendedDataEntity> inCacheEntitys = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
            for (ExtendedDataEntity i : dataEntities) {
                String pk = i.getDataEntity().getPkValue().toString();
                if (businessKeysSet.contains(pk)) {
                    inCacheEntitys.put(pk, i);
                    continue;
                }
                notInCacheEntitys.put(pk, i);
            }
            if (!notInCacheEntitys.isEmpty()) {
                String routeKey;
                this.logger.debug(String.format("\u4e0d\u5728\u7f13\u5b58\u4e2d\u7684pks[%s]", WfUtils.listToString(notInCacheEntitys.keySet(), ",")));
                Collection<ExtendedDataEntity> inWfDbObjs = this.getRuntimeService().getInProcessEntitys(notInCacheEntitys);
                HashSet<ExtendedDataEntity> inWfDbObjsSet = new HashSet<ExtendedDataEntity>(inWfDbObjs);
                inProcessExtendedDataEntity.addAll(inWfDbObjs);
                ArrayList<String> notInCacheAndNotInWfDbPks = new ArrayList<String>();
                for (Object ei : notInCacheEntitys.values()) {
                    if (inWfDbObjsSet.contains(ei)) continue;
                    notInCacheAndNotInWfDbPks.add(String.valueOf(ei.getDataEntity().getPkValue()));
                }
                ArrayList<String> onlyAddressPks = new ArrayList<String>();
                if (!notInCacheAndNotInWfDbPks.isEmpty()) {
                    for (String pk : notInCacheAndNotInWfDbPks) {
                        if (businessKeysSet.contains(pk) || !WfCacheHelper.existAddressPk(entityNumber, pk)) continue;
                        onlyAddressPks.add(pk);
                    }
                    notInCacheAndNotInWfDbPks.removeAll(onlyAddressPks);
                    this.logger.debug(String.format("\u83b7\u53d6\u8fd8\u6ca1\u6709\u8fc7\u6765\u7684\u5bfb\u5740\u6d88\u606f\u5254\u9664\u5df2\u7ecf\u5728\u8fd0\u884c\u7f13\u5b58\u4e2d\u7684[%s]", WfUtils.listToString(onlyAddressPks, ",")));
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)(routeKey = dataEntities[0].getDataEntity().getDataEntityType().getDBRouteKey())), (String)"t_wf_jobrecord") && !notInCacheAndNotInWfDbPks.isEmpty()) {
                    List<String> inBizDBJobPks = this.getRuntimeService().getInBizJobPks(routeKey, notInCacheAndNotInWfDbPks);
                    onlyAddressPks.addAll(inBizDBJobPks);
                }
                this.logger.debug(String.format("\u901a\u8fc7\u67e5\u8be2\u4e1a\u52a1\u8868\u83b7\u53d6\u7684\u5bfb\u5740\u6d88\u606f[%s]", WfUtils.listToString(onlyAddressPks, ",")));
                for (String apk : onlyAddressPks) {
                    ExtendedDataEntity ede = (ExtendedDataEntity)notInCacheEntitys.get(apk);
                    if (ede == null) continue;
                    inProcessExtendedDataEntity.add(ede);
                }
            }
            if (!inCacheEntitys.isEmpty()) {
                inProcessExtendedDataEntity.addAll(this.getRuntimeService().removeOnlyBizFlowEntitys(inCacheEntitys));
            }
            return inProcessExtendedDataEntity.toArray(new ExtendedDataEntity[inProcessExtendedDataEntity.size()]);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return new ExtendedDataEntity[0];
            }
            throw e;
        }
    }

    public List<Long> getApproverByBusinessKey(String businessKey) {
        try {
            try {
                this.assertInServiceAndLog("getApproverByBusinessKey", businessKey);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            if (WfUtils.isEmpty(businessKey)) {
                throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u5ba1\u6279\u4eba", (String)"WorkflowServiceImpl_5", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.taskService = this.getTaskService();
            return this.taskService.getApproverByBusinessKey(businessKey);
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    public List<Comment> getLastNodesComment(String businessKey) {
        try {
            try {
                this.assertInServiceAndLog("getLastNodesComment", businessKey);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            if (WfUtils.isEmpty(businessKey)) {
                throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6700\u8fd1\u5ba1\u6279\u8bb0", (String)"WorkflowServiceImpl_6", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.taskService = this.getTaskService();
            return this.taskService.getGetLastNodesCommentsByBusinesskey(businessKey);
        }
        catch (KDException e) {
            return null;
        }
    }

    public Map<String, List<Comment>> getLastNodesComments(List<String> businessKeys) {
        try {
            try {
                this.assertInServiceAndLog("getLastNodesComment", businessKeys);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyMap();
                }
                throw e;
            }
            if (businessKeys == null || businessKeys.isEmpty()) {
                throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6700\u8fd1\u5ba1\u6279\u8bb0", (String)"WorkflowServiceImpl_6", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.taskService = this.getTaskService();
            return this.taskService.getGetLastNodesCommentsByBusinesskeys(businessKeys);
        }
        catch (KDException e) {
            return null;
        }
    }

    public DynamicObjectCollection getCommentsByTaskId(Long taskId) {
        try {
            this.assertInServiceAndLog("getCommentsByTaskId", taskId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return null;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("taskid", (Object)taskId);
        ArchiveService.create().injectArchiveRouteInfo("wf_hicomment", condition);
        return this.taskService.getCommentsByTaskId(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskInfoAndParticipant(TaskInfo taskinfo, List<Long> userIds) {
        this.assertInServiceAndLog("updateTaskInfoAndParticipant", taskinfo, userIds);
        String markId = String.format("wf/updatetaskandparticipant/%s", taskinfo.getId());
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                this.taskService = this.getTaskService();
                this.taskService.updateTaskInfoAndParticipant(taskinfo, userIds);
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(Comment comment) {
        this.assertInServiceAndLog("addComment", comment);
        String markId = String.format("wf/updatecomment/%s", comment.getTaskId());
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                this.taskService = this.getTaskService();
                this.taskService.addComment(comment);
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    public void updateTrdRelatedProcComment(String relationValue, Comment comment) {
        this.assertInServiceAndLog("updateTrdRelatedProcComment", relationValue, comment);
        this.getTaskService().updateTrdRelatedProcComment(relationValue, comment);
    }

    public void addTrdComment(ThirdCommentInfo thirdCommentInfo) {
        Long taskId = thirdCommentInfo.getTaskId();
        String businesskey = thirdCommentInfo.getBusinesskey();
        Long processInstanceId = thirdCommentInfo.getProcessInstanceId();
        if (WfUtils.isEmpty(taskId) && WfUtils.isEmpty(businesskey) && WfUtils.isEmpty(processInstanceId)) {
            throw new KDException(WFErrorCode.emptyErrorCode(), new Object[]{"interface input parameter of [taskId or businessKey or procId] is empty"});
        }
        this.assertInServiceAndLog("addTrdComment", thirdCommentInfo);
        this.taskService = this.getTaskService();
        this.taskService.addTrdComment(thirdCommentInfo);
    }

    public void updateTrdComment(ThirdCommentInfo thirdCommentInfo) {
        this.assertInServiceAndLog("updateTrdComment", thirdCommentInfo);
        this.taskService = this.getTaskService();
        this.taskService.updateTrdComment(thirdCommentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommentWithAttachment(Comment comment, List<Map<String, Object>> attch) {
        this.assertInServiceAndLog("addComment", comment);
        String markId = String.format("wf/updatecomment/%s", comment.getTaskId());
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                this.taskService = this.getTaskService();
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (attch != null && !attch.isEmpty()) {
                    variables.put("procAttachInfos", SerializationUtils.toJsonString(attch));
                }
                this.taskService.addCommentWithAttachment(comment, variables);
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    public TaskInfo findTaskById(Long taskId) {
        try {
            this.assertInServiceAndLog("findTaskById", taskId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return null;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        return this.taskService.getTask(taskId);
    }

    public Comment createNewComment() {
        return new CommentEntityImpl();
    }

    public ThirdCommentInfo createNewTrdComment() {
        return new ThirdCommentInfo();
    }

    public IApprovalRecordItem createApprovalRecordItem() {
        return new ApprovalRecordItem();
    }

    public DynamicObjectCollection getToHandleTasksByUserId(int start, int limit, String uid) {
        try {
            this.assertInServiceAndLog("getToHandleTasksByUserId", start, limit, uid);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return null;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
            ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.parseLong(uid), start, limit, "toHandle", "").setEndType("pc");
            return this.taskService.getProcessDataForApi(processDataEntityQueryParams);
        }
        return this.taskService.getTasksDataForApi(start, limit, uid, null, "pc", Collections.emptyList(), "");
    }

    public DynamicObjectCollection getToHandleTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        return this.getToHandleTasksByUserId(start, limit, uid, sqlFilterMap, "");
    }

    public DynamicObjectCollection getToHandleTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap, String orderBy) {
        try {
            this.assertInServiceAndLog("getToHandleTasksByUserId", start, limit, uid, sqlFilterMap);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return null;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
            ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.parseLong(uid), start, limit, "toHandle", orderBy).setSqlFilterMap(sqlFilterMap);
            return this.taskService.getProcessDataForApi(processDataEntityQueryParams);
        }
        String filterSql = "";
        ArrayList<Object> params = new ArrayList<Object>();
        if (WfUtils.isNotEmpty(sqlFilterMap.get("subject"))) {
            filterSql = SUBJECTLIKESQL;
            params.add("%" + sqlFilterMap.get("subject") + "%");
        }
        if (WfUtils.isNotEmpty(sqlFilterMap.get("billno"))) {
            filterSql = filterSql + " and ( a.fbillno = ? ) ";
            params.add(sqlFilterMap.get("billno"));
        }
        if (WfUtils.isNotEmpty(sqlFilterMap.get("entityName"))) {
            filterSql = filterSql + " and ( b.fentityName like ? ) ";
            params.add(sqlFilterMap.get("entityName") + "%");
        }
        return this.taskService.getTasksDataForApi(start, limit, uid, filterSql, sqlFilterMap.get("terminalType"), params, orderBy);
    }

    public DynamicObjectCollection getHandledTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        return this.getHandledTasksByUserId(start, limit, uid, sqlFilterMap, "");
    }

    public DynamicObjectCollection getHandledTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap, String orderBy) {
        try {
            this.assertInServiceAndLog("getHandledTasksByUserId", start, limit, uid, sqlFilterMap);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return null;
            }
            throw e;
        }
        if (sqlFilterMap.containsKey("archiveRouteKey")) {
            ArchiveService.create().injectArchiveRouteInfo(sqlFilterMap.get("archiveRouteKey"));
        }
        this.taskService = this.getTaskService();
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.parseLong(uid), start, limit, "handled", orderBy).setEndType(sqlFilterMap.get("terminalType")).setSqlFilterMap(sqlFilterMap);
            return this.taskService.getProcessDataForApi(processDataEntityQueryParams);
        }
        String filterSql = "";
        ArrayList<Object> params = new ArrayList<Object>();
        if (WfUtils.isNotEmpty(sqlFilterMap.get("subject"))) {
            filterSql = SUBJECTLIKESQL;
            params.add("%" + sqlFilterMap.get("subject") + "%");
        }
        if (WfUtils.isNotEmpty(sqlFilterMap.get("billno"))) {
            filterSql = filterSql + " and ( a.fbillno = ? ) ";
            params.add(sqlFilterMap.get("billno"));
        }
        if (WfUtils.isNotEmpty(sqlFilterMap.get("entityName"))) {
            filterSql = filterSql + " and ( b.fentityName like ? ) ";
            params.add(sqlFilterMap.get("entityName") + "%");
        }
        return this.taskService.getHistoryTasksDataForApi(start, limit, uid, filterSql, sqlFilterMap.get("terminalType"), params, orderBy);
    }

    public DynamicObjectCollection getApplyTasksByStartId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        try {
            try {
                this.assertInServiceAndLog("getApplyTasksByStartId", start, limit, uid, sqlFilterMap);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return null;
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql()) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.parseLong(uid), start, limit, "toApply", "").setSqlFilterMap(sqlFilterMap);
                return this.taskService.getProcessDataForApi(processDataEntityQueryParams);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            String filterSql = "";
            if (WfUtils.isNotEmpty(sqlFilterMap.get("subject"))) {
                filterSql = SUBJECTLIKESQL;
                params.add("%" + sqlFilterMap.get("subject") + "%");
            }
            if (WfUtils.isNotEmpty(sqlFilterMap.get("entityName"))) {
                filterSql = filterSql + " and ( b.FENTRABILLNAME like ? ) ";
                params.add(sqlFilterMap.get("entityName") + "%");
            }
            return this.taskService.getApplyTasksDataForApi(start, limit, uid, filterSql, params);
        }
        catch (KDException e) {
            return null;
        }
    }

    public Map<String, List<Long>> getApproversMapByBusinessKeys(String[] businessKeyArr) {
        try {
            try {
                this.assertInServiceAndLog("getApproversMapByBusinessKeys", businessKeyArr);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyMap();
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            return this.taskService.getApproversMapByBusinessKeys(businessKeyArr);
        }
        catch (KDException e) {
            return Collections.emptyMap();
        }
    }

    public List<Object> getBusinessKeyByEntityNumberUIds(BusinessKeyQueryParams businessKeyQueryParams) {
        try {
            try {
                this.assertInServiceAndLog("getBusinessKeyByEntityNumberUIds", businessKeyQueryParams);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            if (WfUtils.isNullObject(businessKeyQueryParams)) {
                throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u4e3b\u952e", (String)"WorkflowServiceImpl_61", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.taskService = this.getTaskService();
            return this.taskService.getBusinessKeyByEntityNumberUIds(businessKeyQueryParams);
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    public Long getTaskCountByType(String uid, String type) {
        try {
            try {
                this.assertInServiceAndLog("getTaskCountByType", uid, type);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return 0L;
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            if (!WfConfigurationUtil.isNotQueryByNewSql() && ("handled".equals(type) && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete() != false || "toHandle".equals(type) && WfConfigurationUtil.isUpdateTaskToParticipantComplete() != false || "applyed".equals(type) || "toApply".equals(type))) {
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(type, Long.parseLong(uid)).setEndType("pc");
                return this.taskService.getProcessDataCountForApi(processDataEntityQueryParams);
            }
            return this.taskService.getTaskCenterDataCount(uid, type, null, "", Collections.emptyList());
        }
        catch (Exception e) {
            this.logger.warn("getTaskCountByType\u51fa\u9519\uff0c\u53c2\u6570\uff1auid=" + uid + "\uff1btype=" + type + "\uff1b\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            return 0L;
        }
    }

    public List<Map<String, Object>> getToHandleTasksMessage(Long userId, Integer topCount) {
        try {
            try {
                this.assertInServiceAndLog("getToHandleTasksMessage", userId, topCount);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            if (topCount < 1) {
                throw new KDException(WFErrorCode.getToHandleTasksMessageError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u76eetopCount < 1", (String)"WorkflowServiceImpl_7", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.taskService = this.getTaskService();
            return this.taskService.getToHandleTasksMessage(userId, topCount);
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    public List<Map<String, String>> getCommentForPrint(String businessKey) {
        try {
            try {
                this.assertInServiceAndLog("getCommentForPrint", businessKey);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            return this.taskService.getCommentForPrint(businessKey);
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    public Map<String, String> getApprovalRecordMeta() {
        HashMap<String, String> approvalRecordMeta = new HashMap<String, String>();
        approvalRecordMeta.put("assignee", ResManager.loadKDString((String)"\u5ba1\u6279\u4eba", (String)"WorkflowServiceImpl_8", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("activityName", ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"WorkflowServiceImpl_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("resultName", ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u679c", (String)"WorkflowServiceImpl_10", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("message", ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1", (String)"WorkflowServiceImpl_11", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("time", ResManager.loadKDString((String)"\u5ba1\u6279\u65f6\u95f4", (String)"WorkflowServiceImpl_12", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("throughRule", ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7\u89c4\u5219", (String)"WorkflowServiceImpl_13", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("auditPropName", ResManager.loadKDString((String)"\u4efb\u52a1\u5c5e\u6027", (String)"WorkflowServiceImpl_40", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("userNameFormatter", ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u663e\u793a\u4fe1\u606f", (String)"WorkflowServiceImpl_52", (String)"bos-wf-engine", (Object[])new Object[0]));
        approvalRecordMeta.put("signature", ResManager.loadKDString((String)"\u5ba1\u6279\u4eba\u7b7e\u540d", (String)"WorkflowServiceImpl_66", (String)"bos-wf-engine", (Object[])new Object[0]));
        return approvalRecordMeta;
    }

    public Collection<Map<String, Object>> getPrintMetaEntityNumber(String entityNumber) {
        try {
            try {
                this.assertInServiceAndLog("getPrintMetaEntityNumber", entityNumber);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            Collection<Map<String, String>> bizIdentifyKey = this.taskService.getBizIdentifyKeyByEntityNumber(entityNumber);
            ArrayList<Map<String, Object>> printMeta = new ArrayList<Map<String, Object>>(10);
            Map<String, String> meta = this.getApprovalRecordMeta();
            for (Map<String, String> bizKey : bizIdentifyKey) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("bizIdentifyKey", bizKey.get("bizIdentifyKey"));
                map.put("activityName", bizKey.get("activityName"));
                map.put("printMeta", meta);
                printMeta.add(map);
            }
            return printMeta;
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    public Collection<Map<String, String>> getCommentForPrintByType(String businessKey, String type) {
        return this.getPrintCommentWithParam(businessKey, type, new HashMap<String, Object>());
    }

    public Collection<Map<String, String>> getPrintCommentWithParam(String businessKey, String type, Map<String, Object> printParam) {
        try {
            try {
                this.assertInServiceAndLog("getBizIdentifyKeyByEntityNumber", businessKey, type, printParam);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            return this.taskService.getPrintCommentWithParam(businessKey, type, printParam);
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public void startProcessInstanceByKeyAndVersion(String busId, String processKey, String version, Map<String, Object> variables) {
        RuntimeService runtimeService;
        this.logger.debug(String.format("businessObject[%s] is preparing to start process[%s],version is [%s]", busId, processKey, version));
        this.assertInServiceAndLog("startProcessInstanceByKeyAndVersion", busId, processKey, version, variables);
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("_businessKey_", busId);
        if (variables.get("_initiator_") == null) {
            variables.put("_initiator_", RequestContext.get().getUserId());
        }
        if ((runtimeService = this.getRuntimeService()) != null) {
            runtimeService.signalEventReceivedAsync(processKey, version, variables);
        }
    }

    private void assertInServiceAndLog(Object ... args) {
        boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
        this.dispatchBizInvokeLog(args);
        if (!canRunWf) {
            throw new KDException(WFErrorCode.workflowEngineNotConfiguration(), new Object[0]);
        }
    }

    private void dispatchBizInvokeLog(Object ... args) {
        List<Object> params;
        if (args != null && (params = Arrays.asList(args)) != null && params.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String s1 = String.format("OuterInvoke-Method:[%s]", params.get(0));
            sb.append(s1).append("Params:[");
            for (int i = 1; i < params.size(); ++i) {
                sb.append(params.get(i)).append(",");
            }
            sb.append("]");
        }
    }

    public void viewFlowchart(String pageId, Object billId) {
        this.viewFlowchart(pageId, billId, null);
    }

    public void viewFlowchart(String pageId, Object billId, OpenStyle style) {
        this.viewFlowchart(pageId, style, billId, null);
    }

    public void viewFlowchart(String pageId, OpenStyle style, Object billId, Long procDefId) {
        this.viewFlowchart(pageId, style, null, billId, procDefId);
    }

    private void viewFlowchart(String pageId, OpenStyle style, String entityNumber, Object billId, Long procDefId) {
        WorkflowFormService.create().viewFlowchart(billId, entityNumber, pageId, style, procDefId);
    }

    public void viewFlowchartWithEntityNumber(String pageId, String entityNumber, Object billId) {
        this.viewFlowchart(pageId, null, entityNumber, billId, null);
    }

    public void viewFlowchartWithEntityNumber(String pageId, String entityNumber, Object billId, OpenStyle style) {
        this.viewFlowchart(pageId, style, entityNumber, billId, null);
    }

    public void viewFlowchartWithEntityNumber(String pageId, String entityNumber, Object billId, OpenStyle style, Long procDefId) {
        this.viewFlowchart(pageId, style, entityNumber, billId, procDefId);
    }

    public void showBillRelationGraph(String pageId, List<BillCard> billCards, String currentEntityNumber, String currentBusinessKey) {
        WorkflowFormService.create().showBillRelationGraph(pageId, billCards, currentEntityNumber, currentBusinessKey);
    }

    public boolean isUserBelongToRole(Long userId, String roleNumber) {
        return this.getManagementService().isUserBelongToRole(userId, roleNumber);
    }

    public DynamicObject[] getModelByAppId(String appId) {
        return this.getRepositoryService().getModelByAppId(appId);
    }

    public String getDeployModel(long modelId) {
        DeployFile deployFile = this.getRepositoryService().getDeployModel(modelId);
        String name = deployFile.getFileName();
        String content = deployFile.getFileContent();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(NAME, name);
        map.put(CONTENT, content);
        return SerializationUtils.toJsonString(map);
    }

    public void deployModel(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployModel.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployModel deployModel = (DeployModel)serializer.deserializeFromString(content, null);
        DynamicObject model = deployModel.getModels().get(0);
        QFilter filter = new QFilter("key", "=", (Object)model.getString("key"));
        boolean exist = QueryServiceHelper.exists((String)"wf_model", (QFilter[])new QFilter[]{filter});
        this.getRepositoryService().deployModel(deployModel, exist);
    }

    public DynamicObject[] getAllProcessCategory() {
        return this.getRepositoryService().getAllProcessCategory();
    }

    public DynamicObject[] getModelByProcessCategoryId(Long processCategoryId) {
        return this.getRepositoryService().getModelByProcessCategoryId(processCategoryId);
    }

    public List<IApprovalRecordGroup> getAllApprovalRecord(String businessKey) {
        try {
            this.assertInServiceAndLog("getAllApprovalRecord", businessKey);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return Collections.emptyList();
            }
            throw e;
        }
        if (WfUtils.isEmpty(businessKey)) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u5ba1\u6279\u8bb0\u5f55\u5f02\u5e38\u3002", (String)"WorkflowServiceImpl_14", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        this.taskService = this.getTaskService();
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)businessKey);
        ArchiveService.create().injectArchiveRouteInfo("wf_hiprocinst", condition);
        List<IApprovalRecordGroup> approvalRecordGroups = this.taskService.queryApprovalRecordForApi(null, businessKey);
        SignatureUtils.handleApprovalRecordGrpApiSignature(approvalRecordGroups);
        return approvalRecordGroups;
    }

    public List<IApprovalRecordGroup> getAllOriginalApprovalRecord(String businessKey, Long processInstanceId, Map<String, Object> params) {
        try {
            this.assertInServiceAndLog("getAllApprovalRecord", businessKey);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return Collections.emptyList();
            }
            throw e;
        }
        if (WfUtils.isEmpty(businessKey)) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u5ba1\u6279\u8bb0\u5f55\u5f02\u5e38\u3002", (String)"WorkflowServiceImpl_14", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        this.taskService = this.getTaskService();
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)businessKey);
        ArchiveService.create().injectArchiveRouteInfo("wf_hiprocinst", condition);
        params.put("isNotUsePlugin", "true");
        return this.taskService.queryApprovalRecord(businessKey, processInstanceId, params);
    }

    public List<IApprovalRecordGroup> getApprovalRecords(String entityNumber, String businessKey, boolean allRecord) {
        this.assertInServiceAndLog("getApprovalRecords", entityNumber, businessKey, allRecord);
        HashMap<String, Object> checkParams = new HashMap<String, Object>();
        checkParams.put("entityNumber", entityNumber);
        checkParams.put("businessKey", businessKey);
        this.checkParamsEmpty(checkParams);
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)businessKey);
        ArchiveService.create().injectArchiveRouteInfo("wf_hiprocinst", condition);
        this.taskService = this.getTaskService();
        List<IApprovalRecordGroup> approvalRecordGroups = this.taskService.queryApprovalRecord(businessKey, entityNumber, allRecord);
        SignatureUtils.handleApprovalRecordGrpApiSignature(approvalRecordGroups);
        return approvalRecordGroups;
    }

    private void checkParamsEmpty(Map<String, Object> checkParams) {
        if (null == checkParams || checkParams.isEmpty()) {
            return;
        }
        StringBuilder exceptionMsg = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = checkParams.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!WfUtils.isEmptyString(entry.getValue())) continue;
            exceptionMsg.append(entry.getKey()).append(",");
        }
        if (0 == exceptionMsg.length()) {
            return;
        }
        String checkMsgStr = exceptionMsg.substring(0, exceptionMsg.length() - 1);
        throw new KDBizException(String.format(TaskErrorCodeEnum.PARAMS_CHECK_ERROR_WITHPARAM.getDesc(), checkMsgStr));
    }

    public Long getTaskIdByBusinessKeyAndUserId(String businessKey, Long userId) {
        try {
            this.assertInServiceAndLog("getTaskIdByBusinessKeyAndUserId", businessKey, userId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return 0L;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        return this.taskService.getTaskIdByBusinessKeyAndUserId(businessKey, userId);
    }

    public void taskTransferNew(Long taskId, Long transfererId, String transferOpinion, Boolean transferSubscribe) {
        this.taskService = this.getTaskService();
        this.taskService.taskTransfer(taskId, transfererId, (ILocaleString)new LocaleString(transferOpinion), transferSubscribe, Long.parseLong(RequestContext.get().getUserId()), true);
    }

    public void taskTransferNew(Long taskId, Long transfererId, String transferOpinion, Boolean transferSubscribe, Long ownerId) {
        this.taskService = this.getTaskService();
        this.taskService.taskTransfer(taskId, transfererId, (ILocaleString)new LocaleString(transferOpinion), transferSubscribe, ownerId, Boolean.TRUE);
    }

    public void taskTransfer(Long taskId, Long transfererId, String transferOpinion, Boolean transferSubscribe) {
        this.taskService = this.getTaskService();
        this.taskService.taskTransfer(taskId, transfererId, (ILocaleString)new LocaleString(transferOpinion), transferSubscribe, Long.parseLong(RequestContext.get().getUserId()), true);
    }

    public void taskTransfer(Long taskId, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe) {
        this.taskService = this.getTaskService();
        this.taskService.taskTransfer(taskId, transfererId, transferOpinion, transferSubscribe, Long.parseLong(RequestContext.get().getUserId()), true);
    }

    public Map<String, Object> taskCirculate(Long taskId, List<Long> userIds, ILocaleString circulationMsg) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCirculation(taskId, userIds, circulationMsg, Long.valueOf(RequestContext.get().getUserId()));
    }

    public BatchOperateResult taskCirculateForBatch(List<Long> taskIds, List<Long> circulationUserIds, Long senderUserId, ILocaleString circulationMsg) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCirculateForBatch(taskIds, circulationUserIds, senderUserId, circulationMsg);
    }

    public String taskCoordinate(Long taskId, List<Long> userIds, ILocaleString coordinateMsg, Boolean isPublic) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCoordinateRequest(taskId, false, userIds, coordinateMsg, Long.parseLong(RequestContext.get().getUserId()), isPublic);
    }

    public String taskCoordinate(Long taskId, List<Long> userIds, ILocaleString coordinateMsg, Boolean isPublic, Long ownerId) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCoordinateRequest(taskId, Boolean.FALSE, userIds, coordinateMsg, ownerId, isPublic);
    }

    public String taskCoordinateNew(Long taskId, List<Long> userIds, ILocaleString coordinateMsg, Boolean isPublic, Long ownerId) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCoordinateRequest(taskId, Boolean.FALSE, userIds, coordinateMsg, ownerId, isPublic);
    }

    public String taskCoordinateRequestWithdraw(Long taskId, List<Long> coordinaterIds) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCoordinateRequestWithdraw(taskId, coordinaterIds);
    }

    public String taskCoordinateRequestWithdraw(Long taskId, List<Long> coordinaterIds, Long userId) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCoordinateRequestWithdraw(taskId, coordinaterIds, userId);
    }

    public Object getNodeProp(Long processInstanceId, String nodeId, String propName) {
        FlowElement elem;
        this.repositoryService = this.getRepositoryService();
        BpmnModel model = this.repositoryService.getBpmnModel(null, processInstanceId);
        if (model != null && (elem = model.getMainProcess().getFlowElement(nodeId)) != null) {
            try {
                return GraphCodecUtils.safeGetPropertyValue(elem, propName);
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        return null;
    }

    public List<Long> getWorkflowMultiLanguageIdsByAppId(String applicationId) {
        return ExtractMultiLanguageWordsUtil.getWorkflowMultiLanguageIds(applicationId);
    }

    public List<Long> getWorkflowModelMultiLanguageIdsByAppId(String applicationId) {
        return ExtractMultiLanguageWordsUtil.getWorkflowModelMultiLanguageIds(applicationId);
    }

    public List<Map<String, Object>> getWorkflowTemplateMultiLanguageIdsByCategoryId(Long categoryId) {
        return ExtractMultiLanguageWordsUtil.getWorkflowTemplateMultiLanguageIds(categoryId);
    }

    public List<Map<String, Object>> getWorkflowResourceIdsByCategoryId(Long categoryId) {
        return ExtractMultiLanguageWordsUtil.getWorkflowResourceIdsByCategoryId(categoryId);
    }

    public List<Map<String, Object>> getWorkflowModelResourceIdsByCategoryId(Long categoryId) {
        return ExtractMultiLanguageWordsUtil.getWorkflowModelResourceIdsByCategoryId(categoryId);
    }

    public Object getProcessCategoryData() {
        return ExtractMultiLanguageWordsUtil.getProcessCategoryData();
    }

    public Object getProcessTemplateCategoryData() {
        return ExtractMultiLanguageWordsUtil.getProcessTemplateCategoryData();
    }

    public Map<String, Object> getWorkflowMultiLanguageWords(Long resourceId) {
        return ExtractMultiLanguageWordsUtil.getMultiLanguageWords(resourceId);
    }

    public void applyWorkflowMultiLanguageWords(Map<String, Object> mutiLangDatas) {
        ExtractMultiLanguageWordsUtil.applyMultiLanguageWords(mutiLangDatas);
    }

    public void applyWorkflowMultiLanguageWords4ModelAndTpl(Map<String, Object> mutiLangDatas) {
        ExtractMultiLanguageWordsUtil.applyMultiLanguageWords4ModelAndTpl(mutiLangDatas);
    }

    public Map<String, Object> makeWorkflowMultiLanguagePackage(Map<String, Object> mutiLangDatas) {
        return ExtractMultiLanguageWordsUtil.makeMultiLanguagePackage(mutiLangDatas);
    }

    public Map<String, Object> makeWorkflowMultiLanguagePackage4ModelAndTpl(Map<String, Object> mutiLangDatas) {
        return ExtractMultiLanguageWordsUtil.makeMultiLanguagePackage4ModelAndTpl(mutiLangDatas);
    }

    public Long getProcessInstanceIdByBusinessKey(String businessKey) {
        return this.getRuntimeService().getProcInstIdByBusKey(businessKey);
    }

    public Map<String, Object> getProcessInstancePropertiesByBusinesskey(String businessKey) {
        return this.getRuntimeService().getProcInstPropertiesByBusKey(businessKey);
    }

    public Map<String, List<BizProcessStatus>> getBizProcessStatus(String[] businessKeys) {
        try {
            this.assertInServiceAndLog("getBizProcessStatus", businessKeys);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return Collections.emptyMap();
            }
            throw e;
        }
        this.runtimeService = this.getRuntimeService();
        return this.runtimeService.getBizProcessStatus(businessKeys);
    }

    public Map<String, List<BizProcessStatus>> getBizProcessStatus(String[] businessKeys, String name) {
        try {
            this.assertInServiceAndLog("getBizProcessStatus", businessKeys, name);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return Collections.emptyMap();
            }
            throw e;
        }
        this.runtimeService = this.getRuntimeService();
        return this.runtimeService.getBizProcessStatus(businessKeys, name);
    }

    public Map<String, Object> checkMetadataNumberUniqueness(String entityKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("numberHasExit", BillSummaryRebuildUtil.checkBillSummaryCfgNumber(entityKey));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildAllMetadataOfBillSummaryCfg(String summaryTplId, String billSummaryCfgNumber) {
        String threadLocalForWfsValue = threadLocalForWfs.get();
        if (WfUtils.isNotEmpty(threadLocalForWfsValue)) {
            return;
        }
        try {
            threadLocalForWfs.set("rebuildAllMetadataOfBillSummaryCfg");
            BillSummaryRebuildUtil.rebuildAllMetadataOfBillSummaryCfg(summaryTplId, billSummaryCfgNumber);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        finally {
            threadLocalForWfs.remove();
        }
    }

    public void rebuildBillSummaryConfigRuntimeMeta(DynamicObject billSummmaryConfigObject) {
        BillSummaryRebuildUtil.rebuildBillSummaryConfigRuntimeMeta(billSummmaryConfigObject);
    }

    @Override
    public void applyRuleToExistTask(Long userId, Long ruleId, String sence) {
        this.getTaskService().executeTaskRule(userId, ruleId, false);
    }

    public Map<String, Object> getWfAssignPersons(String formId, String opKey, DynamicObject dataEntity) {
        return this.getWfAssignPersons(formId, opKey, dataEntity, Collections.emptyMap());
    }

    public Map<String, Object> getWfAssignPersons(String formId, String opKey, DynamicObject dataEntity, Map<String, Object> param) {
        try {
            this.taskService = this.getTaskService();
        }
        catch (Exception e1) {
            return null;
        }
        try {
            boolean isThroughBasicCheck = AssignPersonUtil.basicCheck(formId, opKey);
            if (!isThroughBasicCheck) {
                return null;
            }
            return this.taskService.getWfAssignPersons(formId, opKey, dataEntity, param);
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                KDBizException exception = (KDBizException)((Object)e);
                if (WFErrorCode.stopProcessWhenNextPersonEmptyError().getCode().equals(exception.getErrorCode().getCode())) {
                    throw e;
                }
                if (WFErrorCode.stopProcessWhenAfterPersonStrategyNotSingle().getCode().equals(exception.getErrorCode().getCode())) {
                    throw e;
                }
                if (WFErrorCode.stopProcessWhenAfterPersonStrategyIsEmpty().getCode().equals(exception.getErrorCode().getCode())) {
                    throw e;
                }
                if (WFErrorCode.stopProcessWhenNextPersonEmptyConfigError().getCode().equals(exception.getErrorCode().getCode())) {
                    throw e;
                }
                if (WFErrorCode.stopProcessWhenAfterPersonStrategyNotNodes().getCode().equals(exception.getErrorCode().getCode())) {
                    throw e;
                }
            }
            this.logger.error(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    public Map<String, Object> getSensitiveFieldInfo(String entityId, DynamicObject[] dataEntities, String operationKey, Map<String, Object> wfVar, String category, boolean fromApi) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (null != this.taskService) {
            map = this.taskService.enterSensitiveFieldCmd(entityId, dataEntities, operationKey, wfVar, category, fromApi);
        }
        return map;
    }

    private DynamicObject getFullDataEntity(String entityId, DynamicObject dataEntity, Map<String, Object> wfVar) {
        if (wfVar != null && wfVar.get("byIds") != null && Boolean.parseBoolean(wfVar.get("byIds").toString()) && dataEntity != null && dataEntity.getPkValue() != null) {
            try {
                return WfUtils.findBusinessObject(dataEntity.getPkValue().toString(), entityId);
            }
            catch (Exception ex) {
                this.logger.warn("get wfmsg:" + WfUtils.getExceptionStacktrace(ex));
            }
        }
        return dataEntity;
    }

    public ListShowParameter getAllowPersonListShowParameter(Long processDefinitionId, Long processInstId, DynamicObject dataEntity, CloseCallBack closeCallBack) {
        UserTask userTask = this.getFirstUserTask(processDefinitionId);
        HashMap<String, String> variables = new HashMap<String, String>();
        if (WfUtils.isNotEmpty(processDefinitionId)) {
            variables.put("procdefid", processDefinitionId.toString());
        }
        if (WfUtils.isNotEmpty(processInstId)) {
            variables.put("procinstid", processInstId.toString());
        }
        if (userTask != null) {
            variables.put(NODEID, userTask.getId());
        }
        return this.getAllowPersonListShowParameter(variables, dataEntity, closeCallBack);
    }

    private UserTask getFirstUserTask(Long processDefinitionId) {
        BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(processDefinitionId, null);
        return BpmnModelUtil.getFirstUserTask(bpmnModel.getMainProcess());
    }

    public List<Map<String, Object>> getNextUserTaskNodeByModel(DynamicObject dataEntity, String operation, String entityNumber) {
        String businessKey = GetNextUseableUserTaskNodeUtil.getBusinessKeyFromBillModel(dataEntity);
        if (WfUtils.isNotEmpty(businessKey)) {
            QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey)};
            List<TaskEntity> taskEntities = this.getTaskService().findTasksByFilter(filters);
            if (WfUtils.isNotEmptyForCollection(taskEntities)) {
                TaskEntity taskEntity = taskEntities.get(0);
                HashMap<String, Object> variables = new HashMap<String, Object>();
                BusinessModelVariableScope variableScope = new BusinessModelVariableScope(dataEntity);
                UserTask userTask = ParticipantRangeUtil.getFlowElement(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId(), taskEntity.getTaskDefinitionKey(), variableScope);
                return this.getTaskService().getNextUserTaskNode(userTask, taskEntity, variables);
            }
        }
        return this.getNextUseableNodeInfoForFirstStart(dataEntity, operation, entityNumber, businessKey);
    }

    private List<Map<String, Object>> getNextUseableNodeInfoForFirstStart(DynamicObject dataEntity, String operation, String entityNumber, String businessKey) {
        UserTask userTask;
        Long processDefinitionId;
        List<Map<String, Object>> nextNodes;
        Object processDefIdObj;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(dataEntity);
        Map<String, Object> processDefMap = this.getRuntimeService().findFinalLatestProcessDefinitionByEntityType(dataEntity, businessKey, operation, entityNumber);
        if (WfUtils.isNotEmptyForMap(processDefMap) && WfUtils.isNotEmptyString(processDefIdObj = processDefMap.get("id")) && WfUtils.isNotEmptyForCollection(nextNodes = GetNextUseableUserTaskNodeUtil.getNextUseableUserTaskNode(processDefinitionId = Long.valueOf(Long.parseLong(processDefIdObj.toString())), (userTask = this.getFirstUserTask(processDefinitionId)).getId(), dataEntity))) {
            Map<String, Object> node = nextNodes.get(0);
            FlowNode flowNode = (FlowNode)node.get(NEXTNODE);
            UserTask nextNodeTask = ParticipantRangeUtil.getFlowElement(processDefinitionId, null, flowNode.getId(), variableScope);
            List<Object> userIds = ParticipantRangeUtil.getTaskDefinitionKeyPersons(nextNodeTask, businessKey, variableScope);
            ORM orm = ORM.create();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", userIds)};
            DynamicObjectCollection users = orm.query("bos_user", "id,name", qFilters);
            HashMap<String, UserTask> map = new HashMap<String, UserTask>();
            map.put(NEXTNODE, nextNodeTask);
            if (!"SSCApprove".equals(nextNodeTask.getType())) {
                map.put("users", (UserTask)users);
            }
            list.add(map);
        }
        return list;
    }

    public void setProcessInstanceVariable(Long procInstId, String variableName, Object value) {
        this.logger.debug(String.format("setProcessInstanceVariable: procInstId: %s, variableName: %s", procInstId, variableName));
        this.getRuntimeService().setProcessInstanceVariable(procInstId, variableName, value);
    }

    public void setDynPanticipant(Long taskId, List<Map<String, String>> list) {
        this.assertInServiceAndLog("getExecutionByTaskId", taskId, list);
        this.getTaskService().setDynParticipantVari(taskId, list);
    }

    public Map<String, Integer> getTaskCounts(String userId) {
        return this.getTaskService().getTaskCountForProcessAssistant(userId);
    }

    public List<Map<String, Object>> getApplyedProcessAssistant(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter) {
        return this.getTaskService().getApplyedTaskForProcessAssistant(userId, start, limit, starterOrSubjectFilter, timeFilter, null, null, null, null);
    }

    public List<Map<String, Object>> getApplyedProcessAssistantDatas(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, Map<String, Object> paramFilter) {
        String entityName = "";
        if (WfUtils.isNotEmptyString(paramFilter.get("entityName"))) {
            entityName = (String)paramFilter.get("entityName");
        }
        String beginDate = null;
        String endDate = null;
        if ("timecustom".equals(timeFilter)) {
            beginDate = (String)paramFilter.get("beginDate");
            endDate = (String)paramFilter.get("endDate");
        }
        if (paramFilter.containsKey("archiveRouteKey")) {
            ArchiveService.create().injectArchiveRouteInfo((String)paramFilter.get("archiveRouteKey"));
        }
        if (!WfConfigurationUtil.isNotQueryByNewSql()) {
            HashMap<String, String> sqlFilterMap = new HashMap<String, String>();
            sqlFilterMap.put("starterOrSubjectFilter", starterOrSubjectFilter);
            sqlFilterMap.put("timeFilter", timeFilter);
            sqlFilterMap.put("beginDate", beginDate);
            sqlFilterMap.put("endDate", endDate);
            sqlFilterMap.put("entityName", entityName);
            ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(userId, start, limit, "applyed", "").setSqlFilterMap(sqlFilterMap);
            return this.getTaskService().getProcessAssistantData(processDataEntityQueryParams);
        }
        return this.getTaskService().getApplyedTaskForProcessAssistant(userId, start, limit, starterOrSubjectFilter, timeFilter, null, beginDate, endDate, entityName);
    }

    public DynamicObjectCollection getApplyedProcessAssistantCollection(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, Map<String, Object> paramFilter) {
        String entityName = "";
        if (WfUtils.isNotEmptyString(paramFilter.get("entityName"))) {
            entityName = (String)paramFilter.get("entityName");
        }
        String beginDate = null;
        String endDate = null;
        if ("timecustom".equals(timeFilter)) {
            beginDate = (String)paramFilter.get("beginDate");
            endDate = (String)paramFilter.get("endDate");
        }
        if (paramFilter.containsKey("archiveRouteKey")) {
            ArchiveService.create().injectArchiveRouteInfo((String)paramFilter.get("archiveRouteKey"));
        }
        if (!WfConfigurationUtil.isNotQueryByNewSql()) {
            HashMap<String, String> sqlFilterMap = new HashMap<String, String>();
            sqlFilterMap.put("subject", starterOrSubjectFilter);
            sqlFilterMap.put("entrabillname", entityName);
            sqlFilterMap.put("timeFilter", timeFilter);
            sqlFilterMap.put("beginDate", beginDate);
            sqlFilterMap.put("endDate", endDate);
            ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(userId, start, limit, "applyed", "").setSqlFilterMap(sqlFilterMap);
            return this.getTaskService().getProcessDataForApi(processDataEntityQueryParams);
        }
        return this.getTaskService().getApplyedProcessAssistantCollection(userId, start, limit, starterOrSubjectFilter, timeFilter, null, beginDate, endDate, entityName);
    }

    public List<Map<String, Object>> getTaskEntityName(Long uid, String type) {
        return this.getTaskService().processAssisantGetEntityNumbers(uid, type);
    }

    public String batchAgreeTask(String taskIds, String opinion) {
        return this.batchAgreeTask(taskIds, opinion, "api");
    }

    public String batchAgreeTask(String taskIds, String opinion, String terminalWay) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("terminal", terminalWay);
        return this.getTaskService().updateBillAndCompleteForBatch(taskIds, (ILocaleString)new LocaleString(opinion), variables);
    }

    public String batchAgreeTaskWithUserId(String taskIds, ILocaleString opinion, Long userId) {
        String[] str = taskIds.split(",");
        ArrayList<Long> taskIdz = new ArrayList<Long>(str.length);
        for (String id : str) {
            taskIdz.add(Long.valueOf(id));
        }
        List<TaskEntity> taskEntities = this.getTaskService().findTasksByFilter(new QFilter[]{new QFilter("id", "in", taskIdz)});
        if (CollectionUtil.isEmpty(taskEntities)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("success", false);
            map.put("message", ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"workflowserviceimpl_158", (String)"bos-wf-engine", (Object[])new Object[0]));
            return SerializationUtils.toJsonString(map);
        }
        if (!WfConfigurationUtil.disableServiceApiPer() && !WfPermUtils.isTaskParticipant(taskIdz, userId)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("success", false);
            map.put("message", ResManager.loadKDString((String)"userId\u4e0d\u662f\u6240\u6709\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u6279\u91cf\u5904\u7406\u4efb\u52a1\u3002", (String)"workflowserviceimpl_58", (String)"bos-wf-engine", (Object[])new Object[0]));
            return SerializationUtils.toJsonString(map);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("terminal", "api");
        variables.put("userId", userId);
        return this.getTaskService().updateBillAndCompleteForBatch(taskIds, opinion, variables);
    }

    public String batchAgreeTask(String taskIds, ILocaleString opinion) {
        return this.batchAgreeTask(taskIds, opinion, "api");
    }

    public String batchAgreeTask(String taskIds, ILocaleString opinion, String terminalWay) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("terminal", terminalWay);
        return this.getTaskService().updateBillAndCompleteForBatch(taskIds, opinion, variables);
    }

    public String addSign(Long taskId, AddSignInfo addSignInfo) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        if (addSignInfo != null && ("http_api_addsignbefore".equals(addSignInfo.getAddSignType()) || "http_api_addsignafter".equals(addSignInfo.getAddSignType()))) {
            addSignInfo.setAddSignType(addSignInfo.getAddSignType().substring(9));
            String validate = workflowService.validateApi(taskId, "addsign", addSignInfo);
            if (validate != null) {
                throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
            }
        }
        return this.getTaskService().addSign(taskId, addSignInfo);
    }

    public String addSignByAdmin(Long procInstId, String activityId, AddSignInfo addSignInfo) {
        return this.getTaskService().addSignByAdmin(procInstId, activityId, addSignInfo);
    }

    public String addSignClear(Long taskId, String type) {
        return this.getTaskService().addSignClear(taskId, type);
    }

    public String addSignClearByAdmin(Long procinstId, String activityId) {
        return this.getTaskService().addSignClearByAdmin(procinstId, activityId);
    }

    public IPreComputorRecord getPreComputorRecord(Long procInstId) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(procInstId, "preComputor");
        if (validate != null) {
            throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
        }
        return this.getTaskService().getPreComputorRecord(procInstId);
    }

    public IPreComputorRecord getPreComputorRecordWithOutCurrentNodes(Long procInstId) {
        if (WfUtils.isEmpty(procInstId)) {
            return null;
        }
        IPreComputorRecord result = this.getPreComputorRecord(procInstId);
        Set<String> currentNodes = this.getRuntimeService().findCurrentNodesByProcInstId(procInstId);
        if (result != null && WfUtils.isNotEmptyForCollection(result.getPcrData())) {
            List pcrData = result.getPcrData();
            Iterator iterator = pcrData.iterator();
            while (iterator.hasNext()) {
                IPreComputorRecordItem item = (IPreComputorRecordItem)iterator.next();
                if (!currentNodes.contains(item.getNodeId())) continue;
                iterator.remove();
            }
        }
        return result;
    }

    public void updateBpmnModelPropertys(Long procInstId, String actId, Map<String, Map<String, Object>> params) {
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(actId) || WfUtils.isEmptyForMap(params)) {
            return;
        }
        this.getRuntimeService().updateBpmnModelPropertys(procInstId, actId, params);
    }

    public void createProcessAndStart(String businessKey, String operation, String entityNumber, Map<String, Object> variables, WFProcess wfProcess) {
        String prodefId = (String)variables.get("procdefid");
        if (WfUtils.isEmpty(prodefId)) {
            prodefId = "886006942529487872";
        }
        variables.put("procdefid", prodefId);
        variables.put("dynType", "freeflow");
        variables.put("entityNumber", entityNumber);
        variables.put("freeflowmodelstr", SerializationUtils.toJsonString((Object)wfProcess));
        try (TXHandle tx = TX.requiresNew();){
            this.tryTriggerProcess(businessKey, operation, entityNumber, variables);
        }
    }

    public void abandonProInstance(long proInstanceId) {
        ILocaleString cause = WFMultiLangConstants.getAbandonName();
        this.getManagementService().abandonProcessInstance(proInstanceId, cause);
    }

    @Override
    public void addExistTaskToFold(Long userId, Long folderId, boolean async) {
        this.getTaskService().executeFodler(userId, folderId, false);
    }

    public void addJointAuditParticipants(String businesskey, String nodeId, List<Long> userIds, Map<String, String> variables) {
        this.assertInServiceAndLog("addJointAuditParticipants", businesskey, nodeId, WfUtils.listToString(userIds, ","));
        this.getTaskService().addJointAuditParticipants(businesskey, nodeId, userIds, variables);
    }

    public void removeJointAuditParticipants(String businesskey, String nodeId, List<Long> userIds) {
        this.assertInServiceAndLog("removeJointAuditParticipants", businesskey, nodeId, WfUtils.listToString(userIds, ","));
        this.getTaskService().removeJointAuditParticipants(businesskey, nodeId, userIds);
    }

    public ListShowParameter getMobAllowPersonList(Map<String, String> variables, DynamicObject dataEntity, CloseCallBack closeCallBack) {
        String nextNodes;
        Long processDefinitionId = null;
        if (variables.get("procdefid") != null) {
            processDefinitionId = Long.parseLong(variables.get("procdefid"));
        }
        Long processInstId = null;
        if (variables.get("procinstid") != null) {
            processInstId = Long.parseLong(variables.get("procinstid"));
        }
        ListShowParameter formFormShow = null;
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(dataEntity);
        String nextNodeId = null;
        if (variables.get("nextNodeId") != null) {
            nextNodeId = variables.get("nextNodeId");
        }
        String nextNodeName = null;
        if (variables.get("nextnodename") != null) {
            nextNodeName = variables.get("nextnodename");
        }
        ArrayList<Object> selectedPersonValues = new ArrayList<Object>();
        if (variables.get("nextNodes") != null && WfUtils.isNotEmpty(nextNodes = variables.get("nextNodes"))) {
            List selectValues = (List)SerializationUtils.fromJsonString((String)nextNodes, List.class);
            for (Map selectValue : selectValues) {
                if (selectValue.get("assignee") == null) continue;
                List assignList = (List)selectValue.get("assignee");
                selectedPersonValues.addAll(assignList);
            }
        }
        Object pkValue = dataEntity.getPkValue();
        String businesskey = "";
        if (pkValue != null) {
            businesskey = String.valueOf(pkValue);
        }
        if (null != (formFormShow = ParticipantRangeUtil.getListShowParameter(processDefinitionId, nextNodeId, businesskey, closeCallBack, Boolean.TRUE, nextNodeName, selectedPersonValues, variableScope, processInstId))) {
            formFormShow.setCustomParam("billentity", (Object)dataEntity);
            if (variables.get("schemeid") != null) {
                formFormShow.setCustomParam("schemeid", (Object)Long.valueOf(variables.get("schemeid")));
            }
            if (dataEntity != null && dataEntity.getDataEntityType() != null) {
                String formNum = dataEntity.getDataEntityType().getName();
                formFormShow.setCustomParam("formnum", (Object)formNum);
            }
            formFormShow.setCustomParam("nodetype", (Object)"UserTask");
        }
        return formFormShow;
    }

    public ListShowParameter getAllowPersonListShowParameter(Map<String, String> variables, DynamicObject dataEntity, CloseCallBack closeCallBack) {
        this.logger.info("getAllowPersonListShowParameter variables:" + variables + ";dataEntity:" + dataEntity + ";");
        Long processDefinitionId = null;
        if (variables.get("procdefid") != null) {
            processDefinitionId = Long.parseLong(variables.get("procdefid"));
        }
        Long processInstId = null;
        if (variables.get("procinstid") != null) {
            processInstId = Long.parseLong(variables.get("procinstid"));
        }
        String nodeId = null;
        if (variables.get(NODEID) != null) {
            nodeId = variables.get(NODEID);
        }
        ListShowParameter formFormShow = null;
        String participantway = null;
        if (variables.get("participantway") != null) {
            participantway = variables.get("participantway");
        }
        String nextNodeName = null;
        if (variables.get("nextnodename") != null) {
            nextNodeName = variables.get("nextnodename");
        }
        if ("empty".equals(participantway)) {
            participantway = EMPTYALLOW;
        }
        formFormShow = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false);
        String participantscene = null;
        if (variables.get("participantscene") != null) {
            participantscene = variables.get("participantscene");
        }
        String caption = null;
        if ("assign".equals(participantscene)) {
            participantscene = AFTERASSIGNNODE;
            caption = nextNodeName != null ? String.format(ResManager.loadKDString((String)"\u6307\u5b9a[%s]\u53c2\u4e0e\u4eba", (String)"WorkflowServiceImpl_55", (String)"bos-wf-engine", (Object[])new Object[0]), nextNodeName) : ResManager.loadKDString((String)"\u6307\u5b9a\u540e\u7eed\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"WorkflowServiceImpl_46", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if ("only".equals(participantscene)) {
            participantscene = NEXTNODE;
            caption = nextNodeName != null ? String.format(ResManager.loadKDString((String)"\u6307\u5b9a[%s]\u53c2\u4e0e\u4eba", (String)"WorkflowServiceImpl_55", (String)"bos-wf-engine", (Object[])new Object[0]), nextNodeName) : ResManager.loadKDString((String)"\u6307\u5b9a\u4e0b\u4e00\u6b65\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"WorkflowServiceImpl_56", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        formFormShow.setCaption(caption);
        formFormShow.setShowTitle(false);
        formFormShow.setCustomParam("externalUserType", (Object)ALLINSTANCE);
        formFormShow.setCustomParam("processdefinitionid", (Object)processDefinitionId);
        formFormShow.setCustomParam("processinstanceid", (Object)processInstId);
        formFormShow.setCustomParam("taskdefinitionkey", (Object)nodeId);
        formFormShow.setCustomParam("personscence", (Object)participantscene);
        formFormShow.setCustomParam("personway", (Object)participantway);
        formFormShow.setCustomParam("nodetype", (Object)"UserTask");
        String nodeAssignValue = null;
        if (variables.get("nodeassignvalues") != null) {
            nodeAssignValue = variables.get("nodeassignvalues");
        }
        formFormShow.setCustomParam("nodeassignvalue", nodeAssignValue);
        formFormShow.setCustomParam("formnum", (Object)dataEntity.getDataEntityType().getName());
        String BusinessKey = null;
        Object pkValue = dataEntity.getPkValue();
        if (pkValue != null) {
            BusinessKey = String.valueOf(pkValue);
        }
        formFormShow.setCustomParam("parentPageId", (Object)variables.get("parentPageId"));
        formFormShow.setCustomParam("formid", (Object)BusinessKey);
        formFormShow.setMultiSelect(true);
        formFormShow.setFormId(WF_TASKNODEHANDLERLISTF7);
        formFormShow.setCloseCallBack(closeCallBack);
        formFormShow.setShowFrequent(true);
        return formFormShow;
    }

    @Override
    public boolean hasTrueCondition(String expression, VariableScope variableScope) {
        this.assertInServiceAndLog("hasTrueCondition", expression, variableScope);
        RuntimeService runtimeService = this.getRuntimeService();
        if (runtimeService != null) {
            return runtimeService.hasTrueCondition(expression, variableScope);
        }
        throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
    }

    public void suspendProcessInstanceByUserId(Long userId, ILocaleString suspendReason) {
        if (userId == null || userId == 0L || WfUtils.isEmpty(suspendReason)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkflowServiceImpl_43", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.getManagementService().suspendProcessInstanceAndRuleByUserId(userId, suspendReason);
    }

    public void activateProcessInstanceByUserId(Long userId) {
        if (userId == null || userId == 0L) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkflowServiceImpl_43", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.getManagementService().activateProcessInstanceAndRuleByUserId(userId);
    }

    public List<Map<String, Object>> getProcessWindowRecords(String businessKey) {
        return this.getTaskService().getProcessWindow(businessKey);
    }

    public List<Map<String, Object>> getProcessWindowRecords(Long procDefId, DynamicObject billObj) {
        return this.getTaskService().getProcessWindow(procDefId, billObj);
    }

    public void taskTransfer(Long taskId, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe, Map<String, Object> dynInfo) {
        this.taskService = this.getTaskService();
        this.taskService.taskTransfer(taskId, transfererId, transferOpinion, transferSubscribe, Long.parseLong(RequestContext.get().getUserId()), true, dynInfo);
    }

    public String taskCoordinate(Long taskId, List<Long> userIds, ILocaleString coordinateMsg, Boolean isPublic, Map<String, Object> dynInfo) {
        this.taskService = this.getTaskService();
        return this.taskService.taskCoordinateRequest(taskId, false, userIds, coordinateMsg, Long.parseLong(RequestContext.get().getUserId()), isPublic, dynInfo);
    }

    public void completeTask(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser) {
        this.completeTask(businessKey, nodeId, userId, decOptionNumber, auditMessage, checkUser, new HashMap<String, Object>());
    }

    public void completeTask(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser, Map<String, Object> variables) {
        this.assertInServiceAndLog(COMPLETETASK, businessKey, nodeId, userId, decOptionNumber, auditMessage);
        Long task = this.getTaskService().findCurTaskByBusinessKeyAndNodeId(businessKey, nodeId, userId, checkUser);
        if (task == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\uff0c\u6216\u4f20\u9012\u7ed9\u4e86\u4e0d\u53ef\u7528\u7684\u7528\u6237\u3002", (String)"WorkflowServiceImpl_18", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.completeTask(task, userId, decOptionNumber, auditMessage, variables);
    }

    public void completeTask(Long taskId, Long userId, String decOptionNumber, String auditMessage) {
        this.completeTask(taskId, userId, decOptionNumber, auditMessage, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTask(Long taskId, Long userId, String decOptionNumber, String auditMessage, Map<String, Object> variables) {
        block16: {
            this.assertInServiceAndLog(COMPLETETASK, taskId, userId, decOptionNumber, auditMessage, variables);
            if (WfUtils.isEmpty(decOptionNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51b3\u7b56\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowServiceImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            String markId = String.format("wf/taskcomplete/%s", taskId);
            boolean flag = false;
            try {
                if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                    Object rejectBackToNodeObj;
                    flag = true;
                    boolean varify = true;
                    if (WfUtils.isEmptyForMap(variables)) {
                        variables = new HashMap<String, Object>();
                    } else {
                        Object varifyObj = variables.get("verify");
                        if (varifyObj instanceof Boolean) {
                            varify = (Boolean)varifyObj;
                        }
                    }
                    Object auditMessageVariables = variables.get("auditMessage");
                    if (!(auditMessageVariables instanceof ILocaleString)) {
                        variables.put("auditMessage", auditMessage);
                    }
                    variables.put("auditNumber", decOptionNumber);
                    if (WfUtils.isEmpty((String)variables.get("terminal"))) {
                        variables.put("terminal", "api");
                    }
                    if ((rejectBackToNodeObj = variables.get("rejectBackToNode")) == null) {
                        variables.put("allowRejectAndGoBack", "false");
                        variables.put("rejectBackToNode", "false");
                    } else {
                        variables.put("allowRejectAndGoBack", String.valueOf(rejectBackToNodeObj));
                        variables.put("rejectBackToNode", String.valueOf(rejectBackToNodeObj));
                    }
                    String jsonObject = null;
                    jsonObject = varify ? this.getTaskService().completeWithCheck(taskId, userId, variables) : this.getTaskService().updateBillAndComplete(taskId, userId, variables);
                    if (jsonObject != null && WfUtils.isNotEmpty(jsonObject)) {
                        JSONObject val = JSON.parseObject((String)jsonObject);
                        if (val != null) {
                            boolean ret = val.getBoolean("success");
                            String msg = val.getString("result");
                            if (!ret) {
                                throw new KDBizException(msg);
                            }
                            break block16;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u80fd\u6b63\u786e\u5b8c\u6210\u3002", (String)"WorkflowServiceImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u80fd\u6b63\u786e\u5b8c\u6210\u3002", (String)"WorkflowServiceImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u88ab\u9501\u5b9a\uff0c\u53ef\u80fd\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowServiceImpl_51", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            finally {
                if (flag) {
                    WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void completeTaskForNewPage(Long taskId, Long userId, String decOptionNumber, String auditMessage, Map<String, Object> variables) {
        this.assertInServiceAndLog(COMPLETETASK, taskId, userId, decOptionNumber, auditMessage, variables);
        if (WfUtils.isEmpty(decOptionNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51b3\u7b56\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowServiceImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        boolean varify = true;
        if (WfUtils.isEmptyForMap(variables)) {
            variables = new HashMap<String, Object>();
        } else {
            Object varifyObj = variables.get("verify");
            if (varifyObj instanceof Boolean) {
                varify = (Boolean)varifyObj;
            }
        }
        Object auditMessageVariables = variables.get("auditMessage");
        if (!(auditMessageVariables instanceof ILocaleString)) {
            variables.put("auditMessage", auditMessage);
        }
        variables.put("auditNumber", decOptionNumber);
        if (WfUtils.isEmpty((String)variables.get("terminal"))) {
            variables.put("terminal", "api");
        }
        String jsonObject = null;
        jsonObject = varify ? this.getTaskService().completeWithCheck(taskId, userId, variables) : this.getTaskService().updateBillAndComplete(taskId, userId, variables);
        if (jsonObject == null || !WfUtils.isNotEmpty(jsonObject)) throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u80fd\u6b63\u786e\u5b8c\u6210\u3002", (String)"WorkflowServiceImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        JSONObject val = JSON.parseObject((String)jsonObject);
        if (val == null) throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u80fd\u6b63\u786e\u5b8c\u6210\u3002", (String)"WorkflowServiceImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        boolean ret = val.getBoolean("success");
        String msg = val.getString("result");
        if (ret) return;
        throw new KDBizException(msg);
    }

    @Override
    public void completeCallActivity(Long executionId, Map<String, Object> variablesForParent) {
        this.runtimeService.completeCallActivity(executionId, variablesForParent);
    }

    public Map<String, Object> taskReminders(Long processInstanceId, ILocaleString reminderMsg, String type) {
        this.taskService = this.getTaskService();
        return this.taskService.taskReminders(processInstanceId, reminderMsg, type);
    }

    public Map<String, Object> taskReminders(Long processInstanceId, ILocaleString reminderMsg) {
        this.taskService = this.getTaskService();
        return this.taskService.taskReminders(processInstanceId, reminderMsg, "submit");
    }

    public BatchOperateResult taskReminders(Long[] processInstanceIds, ILocaleString reminderMsg) {
        return this.getTaskService().taskReminders(processInstanceIds, reminderMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCoordinateReply(Long taskId, ILocaleString taskCoordinateOpinion, List<Map<String, Object>> attch) {
        this.assertInServiceAndLog("taskCoordinateReply", taskId, taskCoordinateOpinion, attch);
        String markId = String.format("wf/lockjob/%s", taskId);
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                this.taskService = this.getTaskService();
                TaskEntity taskEntity = this.taskService.createTaskQuery().addFilter("id", taskId).singleResult();
                if (taskEntity == null) {
                    throw new WFException(TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
                }
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (attch != null && !attch.isEmpty()) {
                    variables.put("procAttachInfos", SerializationUtils.toJsonString(attch));
                }
                this.taskService.taskCoordinateReply(taskId, taskCoordinateOpinion, variables);
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCoordinateReply(Long taskId, ILocaleString taskCoordinateOpinion, List<Map<String, Object>> attch, Long userId) {
        this.assertInServiceAndLog("taskCoordinateReply", taskId, taskCoordinateOpinion, attch);
        String markId = String.format("wf/lockjob/%s", taskId);
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                this.taskService = this.getTaskService();
                TaskEntity taskEntity = this.taskService.createTaskQuery().addFilter("id", taskId).singleResult();
                if (taskEntity == null) {
                    throw new WFException(TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
                }
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (attch != null && !attch.isEmpty()) {
                    variables.put("procAttachInfos", SerializationUtils.toJsonString(attch));
                }
                this.taskService.taskCoordinateReply(taskId, taskCoordinateOpinion, variables, userId);
            }
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    public ILocaleString getProcessSubjectByBusinessKey(String businessKey) {
        return this.getTaskService().getProcessSubjectByBusinessKey(businessKey);
    }

    public List<Map<String, Object>> getOperationLogs(Long processInstanceId, String type) {
        List<OperationLogEntity> entities = this.getTaskService().getOperationLogs(processInstanceId, type);
        return this.getOperationLogInfos(entities);
    }

    private List<Map<String, Object>> getOperationLogInfos(List<OperationLogEntity> entities) {
        ArrayList operationLogs = null;
        if (WfUtils.isNotEmptyForCollection(entities)) {
            operationLogs = new ArrayList(entities.size());
            HashMap<String, Object> operationLog = null;
            Object opinion = null;
            for (OperationLogEntity operationLogEntity : entities) {
                operationLog = new HashMap<String, Object>(4);
                operationLog.put("ownerId", operationLogEntity.getOwnerId());
                operationLog.put("assigneeId", operationLogEntity.getAssigneeId());
                operationLog.put("opinion", WfUtils.isEmpty(operationLogEntity.getNOpinion()) ? operationLogEntity.getOpinion() : operationLogEntity.getNOpinion());
                operationLog.put("createDate", operationLogEntity.getCreateDate());
                operationLog.put("type", operationLogEntity.getType());
                operationLogs.add(operationLog);
            }
        }
        return operationLogs;
    }

    public List<Map<String, Object>> getOperationLogByTaskId(Long taskId) {
        List<OperationLogEntity> entities = this.getTaskService().getOperationLogByTaskId(taskId);
        return this.getOperationLogInfos(entities);
    }

    public FormShowParameter getAllowPersonParameter(Map<String, String> variables, DynamicObject dataEntity, CloseCallBack closeCallBack, String scene) {
        ListShowParameter parameter = null;
        if ("pc".equals(scene)) {
            parameter = this.getAllowPersonListShowParameter(variables, dataEntity, closeCallBack);
        } else if ("mob".equals(scene)) {
            ListShowParameter mobParameter = this.getMobAllowPersonList(variables, dataEntity, closeCallBack);
            parameter = ParticipantRangeUtil.getAllowPersonParameterForMob(mobParameter, closeCallBack);
        }
        return parameter;
    }

    public void withdrawTaskByBusinessKeyAndUserId(String businessKey, Long userId) {
        if (WfUtils.isEmpty(businessKey)) {
            throw new KDException(WFErrorCode.businessKeynullError(), new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u64a4\u56de", (String)"WorkflowServiceImpl_3", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        try {
            Long hiTaskId = this.getTaskService().getLatestHiTaskIdByBusinessKeyAndUserId(businessKey, userId);
            if (!WfUtils.isNotEmpty(hiTaskId)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u5df2\u529e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u548c\u7528\u6237\u53c2\u6570\u7684\u6709\u6548\u6027\u3002", (String)"UpgradeWithdrawTaskCmd_112", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.getTaskService().withdrawTask(hiTaskId, null);
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                throw e;
            }
            throw new KDBizException(e.getCause(), new ErrorCode("wf.withdrawTaskByBusinessKeyAndUserId", "%s"), new Object[]{e.getMessage()});
        }
    }

    public List<WFDecisionOption> getApprovalDecisionOptions(Long taskId) {
        return this.getTaskService().getApprovalDecisionOptions(taskId);
    }

    public List<WFRejectNodesModel> getRejectNodes(Long taskId, String decisionOptionNumber) {
        return this.getTaskService().getRejectNode(taskId, decisionOptionNumber);
    }

    public List<IApprovalRecordGroup> getAllApprovalRecordInclCoordinate(String businessKey) {
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)businessKey);
        ArchiveService.create().injectArchiveRouteInfo("wf_hiprocinst", condition);
        return this.getTaskService().getAllApprovalRecordInclCoordinate(businessKey);
    }

    public List<Long> getAutoCoorinateUsers(Long taskId) {
        return this.getTaskService().getAutoCoorinateUsers(taskId);
    }

    public Map<String, Object> getPageVariables(Long taskId) {
        return this.getTaskService().getPageVariables(taskId);
    }

    public List<Map<String, String>> getAuditAllowModifiedFields(Long taskId, String type) {
        return this.getTaskService().getAuditAllowModifiedFields(taskId, type);
    }

    public BillPageAttributeConfig getBillPageAttributeConfig(Long taskId, String type) {
        return this.getTaskService().getBillPageAttributeConfig(taskId, type);
    }

    public Map<String, Map<String, List<Long>>> getNextUseableUserAndScope(Long taskId, String auditNumber) {
        return this.getTaskService().getNextUseableUserAndScope(taskId, auditNumber);
    }

    public void assignNextParticipant(Long taskId, Map<String, List<String>> dynParticipants) {
        this.getTaskService().assignNextParticipant(taskId, dynParticipants);
    }

    public Boolean existProcDefByEntityNumber(String entityNumber) {
        return this.getRuntimeService().existProcDefByEntityNumber(entityNumber);
    }

    public List<String> getArchiveRouteKeys(String archiveEntity, List<ArchiveRouteIndexCondition> archiveRouteIndexConditions) {
        try {
            if (archiveRouteIndexConditions == null || archiveRouteIndexConditions.isEmpty()) {
                return Collections.emptyList();
            }
            return ArchiveService.create().getArchiveRouteKeys(archiveEntity, archiveRouteIndexConditions);
        }
        catch (Exception e) {
            this.logger.error(String.format("getArchiveRouteKeys error:%s", WfUtils.getExceptionStacktrace(e)));
            return Collections.emptyList();
        }
    }

    public Map<String, Object> batchAuditByBusinesskeys(List<String> businessKeys, Map<String, Object> param) {
        if (WfUtils.isEmpty((String)param.get("terminal"))) {
            param.put("terminal", "api");
        }
        return this.getRepositoryService().batchAuditByBusinesskeys(businessKeys, param);
    }

    public void tryCloseBizFlow(List<String> bos) {
        this.getRuntimeService().tryCloseBizFlow(bos);
    }

    public void tryMountTargetBySrcBill(Map<String, List<BusinessObject>> targets) {
        this.getRuntimeService().tryMountTargetBySrcBill(targets);
    }

    public void rejectToInnerNode(Long taskId, Long userId, String decOptionNumber, String auditMessage, List<String> innerNodeIds, boolean skipPath, Map<String, Object> variables) {
        this.assertInServiceAndLog("rejectToInnerNode", taskId, userId, decOptionNumber, auditMessage, innerNodeIds, variables);
        this.getTaskService().rejectToInnerNode(taskId, userId, decOptionNumber, auditMessage, innerNodeIds, skipPath, variables);
    }

    public List<Map<String, Object>> getRejectInnerNodes(Long procinstId, String activityId) {
        this.assertInServiceAndLog("rejectToInnerNode", procinstId, activityId);
        return this.getTaskService().getRejectInnerNodes(procinstId, activityId);
    }

    public List<EnabledProcessInfo> getEnabledProcesses(DynamicObject dataEntity, String operation) {
        return this.getRuntimeService().getEnabledProcesses(dataEntity, operation);
    }

    public long getEnabledProcessCount() {
        return this.getRepositoryService().getEnableProcessCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, Object> withdrawTransferTask(Long taskId, Long ownerId) {
        Map<String, Object> result = new HashMap<String, Object>();
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q3 = new QFilter("type", "=", (Object)"transfer");
        QFilter q5 = new QFilter("isadminforward", "=", (Object)Character.valueOf('0'));
        DynamicObject[] taskhandlelogs = BusinessDataServiceHelper.load((String)"wf_taskhandlelog", (String)"id,assigneeid,ownerid", (QFilter[])new QFilter[]{q1, q3, q5});
        if (taskhandlelogs.length == 0) {
            result.put(TaskErrorCodeEnum.NOT_EXTIS_HANDLE_LOG.getCode(), TaskErrorCodeEnum.NOT_EXTIS_HANDLE_LOG.getDesc());
            return result;
        }
        if (taskhandlelogs.length >= 2) {
            result.put(TaskErrorCodeEnum.EXTIS_TRANSFER_TWO.getCode(), TaskErrorCodeEnum.EXTIS_TRANSFER_TWO.getDesc());
            return result;
        }
        Long taskOwnerId = taskhandlelogs[0].getLong("ownerid");
        if (taskOwnerId != null && !taskOwnerId.equals(ownerId)) {
            result.put(TaskErrorCodeEnum.OWNERID_ISNOT_TASK_ASSIGNEE.getCode(), TaskErrorCodeEnum.OWNERID_ISNOT_TASK_ASSIGNEE.getDesc());
            return result;
        }
        Long transferId = taskhandlelogs[0].getLong("assigneeid");
        QFilter q4 = new QFilter("userid", "=", (Object)transferId);
        DynamicObject[] participants = BusinessDataServiceHelper.load((String)"wf_participant", (String)"id,type", (QFilter[])new QFilter[]{q1, q4});
        if (participants.length <= 0) {
            result.put(TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
            return result;
        }
        String taskType = participants[0].getString("type");
        if ("participant".equals(taskType)) {
            result = this.getTaskService().withdrawTansferTask(taskId, ownerId);
        } else {
            if (!"coordinate".equals(taskType)) {
                result.put(TaskErrorCodeEnum.TASKTYPENOTEXTIS.getCode(), String.format(TaskErrorCodeEnum.TASKTYPENOTEXTIS.getDesc(), taskType));
                return result;
            }
            this.getTaskService().withdrawTransferCoordinateTask(taskId, ownerId);
        }
        result.put("success", ResManager.loadKDString((String)"\u8f6c\u4ea4\u4efb\u52a1\u5df2\u64a4\u56de\u3002", (String)"workflowServiceImpl_57", (String)"bos-wf-engine", (Object[])new Object[0]));
        return result;
    }

    public void withdrawTask(Long taskId, Long userId) {
        this.getTaskService().withdrawTask(taskId, null, userId);
    }

    public void withdrawCoordinateTaskReply(Long historicTaskId, Long userId) {
        this.getTaskService().taskCoordinateWithdrawNewCmd(historicTaskId, userId);
    }

    public List<Map<String, Object>> getEnabledProcDefByEntityNumber(String entityNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("entrabill", "=", (Object)entityNumber), new QFilter("enable", "=", (Object)"enable")};
        RepositoryService service = this.getRepositoryService();
        String fields = "id,businessId,key,entrabillname,resourceid,enable,entrabill,entrabillid,orgunitid,creatorid,createdate,modifierid,modifydate,name,description,operation,version,type,modelId,versiondesc,versionstate,publishname,applicationid,orgviewid,primarysubprocess";
        String orderBy = String.format(ORDER_BY_DESC, "id");
        List entities = service.findEntitiesByFilters("wf_processdefinition", filters, fields, orderBy);
        ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>(entities.size());
        for (ProcessDefinitionEntity entity : entities) {
            JSONObject map = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)entity.getDynamicObject()));
            objects.add((Map<String, Object>)map);
        }
        return objects;
    }

    public Map<String, Object> getProcDefById(Long procDefId) {
        RepositoryService service = this.getRepositoryService();
        String fields = "id,businessId,key,entrabillname,resourceid,enable,entrabill,entrabillid,orgunitid,creatorid,createdate,modifierid,modifydate,name,description,operation,version,type,modelId,versiondesc,versionstate,publishname,applicationid,orgviewid,primarysubprocess";
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)service.findEntityById(procDefId, "wf_processdefinition", fields);
        JSONObject map = null;
        if (processDefinition != null) {
            map = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)processDefinition.getDynamicObject()));
        }
        return map;
    }

    public void disableProcess(Long procDefId) {
        RepositoryService service = this.getRepositoryService();
        service.suspendProcessDefinitionById(WfUtils.normalizeId(procDefId));
    }

    public void enableProcess(Long procDefId) {
        RepositoryService service = this.getRepositoryService();
        service.activateProcessDefinitionById(WfUtils.normalizeId(procDefId));
    }

    public Map<String, Object> getProcSchemeBySchemeId(Long schemeId) {
        RepositoryService service = this.getRepositoryService();
        String fields = DynamicConfigSchemeEntityManagerImpl.SELECT_APIFIELDS;
        DynamicConfigSchemeEntity entity = (DynamicConfigSchemeEntity)service.findEntityById(schemeId, "wf_processdynamicconfig", fields);
        JSONObject map = null;
        if (entity != null) {
            map = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)entity.getDynamicObject()));
        }
        return map;
    }

    public Map<String, Object> getProcSchemeBySchemeNumber(String schemeNumber) {
        RepositoryService service = this.getRepositoryService();
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)schemeNumber)};
        String fields = DynamicConfigSchemeEntityManagerImpl.SELECT_APIFIELDS;
        String orderBy = String.format(ORDER_BY_DESC, "id");
        List entitys = service.findEntitiesByFilters("wf_processdynamicconfig", filters, fields, orderBy);
        JSONObject map = null;
        if (!WfUtils.isEmptyForCollection(entitys)) {
            map = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)((DynamicConfigSchemeEntity)entitys.get(0)).getDynamicObject()));
        }
        return map;
    }

    public List<WFFlowElement> getProcElementsByProcDefId(Long procDefId) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("procDefId", procDefId);
        return this.getRepositoryService().getProcessElements(params);
    }

    public List<WFFlowElement> getProcElementsBySchemeId(Long schemeId) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("schemeId", schemeId);
        return this.getRepositoryService().getSchemeProcessElements(params);
    }

    public List<WFFlowElement> getProcElementsBySchemeNumber(String schemeNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("schemeNumber", schemeNumber);
        return this.getRepositoryService().getSchemeProcessElements(params);
    }

    public List<Map<String, Object>> getProcSchemesByProcDefId(Long procDefId) {
        RepositoryService service = this.getRepositoryService();
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId)};
        String fields = DynamicConfigSchemeEntityManagerImpl.SELECT_APIFIELDS;
        String orderBy = String.format(ORDER_BY_DESC, "id");
        List entitys = service.findEntitiesByFilters("wf_processdynamicconfig", filters, fields, orderBy);
        ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>(entitys.size());
        for (DynamicConfigSchemeEntity entity : entitys) {
            JSONObject map = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)entity.getDynamicObject()));
            objects.add((Map<String, Object>)map);
        }
        return objects;
    }

    public Map<String, Object> getProcDefByNumberAndVerson(String processNumber, String version) {
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber)};
        if (WfUtils.isNotEmpty(version)) {
            filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber), new QFilter("version", "=", (Object)version)};
        }
        RepositoryService service = this.getRepositoryService();
        String fields = "id,businessId,key,entrabillname,resourceid,enable,entrabill,entrabillid,orgunitid,creatorid,createdate,modifierid,modifydate,name,description,operation,version,type,modelId,versiondesc,versionstate,publishname,applicationid,orgviewid,primarysubprocess";
        String orderBy = String.format(ORDER_BY_DESC, "id");
        List entities = service.findEntitiesByFilters("wf_processdefinition", filters, fields, orderBy);
        JSONObject map = null;
        if (!WfUtils.isEmptyForCollection(entities)) {
            map = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)((ProcessDefinitionEntity)entities.get(0)).getDynamicObject()));
        }
        return map;
    }

    public Map<String, Object> getVariablesByProcInstId(Long procInstId, String[] variableKeys) {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)procInstId), new QFilter(NAME, "in", (Object)variableKeys)};
        RepositoryService service = this.getRepositoryService();
        List entities = service.findEntitiesByFilters("wf_variableinstance", filters);
        HashMap<String, Object> result = new HashMap<String, Object>(variableKeys.length);
        for (VariableInstanceEntity entity : entities) {
            result.put(entity.getName(), entity.getValue());
        }
        return result;
    }

    public void suspendProcessInstanceByProcessInstanceId(Long processInstanceId) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(processInstanceId, "suspend");
        if (validate != null) {
            throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
        }
        workflowService.suspendProcessInstanceByProcessInstanceId(processInstanceId);
    }

    public void revokeSuspendProcessInstancesByIds(Long processInstanceId) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(processInstanceId, "revoke");
        if (validate != null) {
            throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
        }
        workflowService.revokeSuspendProcessInstancesByIds(null, processInstanceId);
    }

    public void abortProcessInstance(Long procInstId) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(procInstId, "abort");
        if (validate != null) {
            throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
        }
        workflowService.abandonProInstance(procInstId);
    }

    public void jumpToNode(Long procInstId, String destId, String srcId) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(procInstId, "jump", srcId, destId);
        if ("suspended".equals(validate)) {
            workflowService.jumpToNode(procInstId, destId, true, srcId);
            return;
        }
        if (validate != null) {
            throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
        }
        workflowService.jumpToNode(procInstId, destId, srcId);
    }

    public void jumpToNodeWithReason(Long procInstId, String destId, String srcId, ILocaleString reason) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(procInstId, "jump", srcId, destId);
        if ("suspended".equals(validate)) {
            workflowService.jumpToNode(procInstId, destId, true, srcId, reason);
            return;
        }
        if (validate != null) {
            throw new KDException(new ErrorCode(validate, EngineAPIExceptionEnum.getDescByCode(validate)), new Object[0]);
        }
        workflowService.jumpToNode(procInstId, destId, false, srcId, reason);
    }

    public WorkflowRoleResult updateWorkflowRole(List<WorkflowRole> roles) {
        this.assertInServiceAndLog("updateWorkflowRoleApi", roles);
        return this.getManagementService().updateWorkflowRoleApi(roles);
    }

    public Long getProcessInstanceIdByBusinessKeyAndEntityNumber(String businessKey, String entityNumber) {
        return this.getRuntimeService().getProcessInstanceIdByBusinessKeyAndEntityNumber(businessKey, entityNumber);
    }

    public List<Map<String, Object>> getNextMandatoryNodes(Long taskId) {
        return this.getTaskService().getNextMandatoryNodes(taskId);
    }

    public Map<String, List<ApprovalAttachmentInfo>> getProcessAttachmentsInfo(String entityNumber, String businessKey) {
        return this.getTaskService().getProcessAttachmentsInfo(entityNumber, businessKey);
    }

    public Map<String, List<Map<String, Object>>> getActInstInfo(String businessKey, List<String> actIds, boolean isOnlyCompleted) {
        return this.getHistoryService().getActInstInfo(businessKey, actIds, isOnlyCompleted);
    }

    public void withdrawByProcessInstanceId(Long processInstanceId) {
        try {
            this.assertInServiceAndLog("withdrawByProcessInstanceId", processInstanceId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return;
            }
            throw e;
        }
        this.getTaskService().withdrawByProcessInstanceId(processInstanceId);
    }

    public Map<String, List<String>> canWithdrawByProcessInstanceId(Long processInstanceId) {
        try {
            this.assertInServiceAndLog("canWithdrawByProcessInstanceId", processInstanceId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return Collections.emptyMap();
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        return this.taskService.canWithdrawByProcessInstanceId(processInstanceId);
    }

    public Long getTaskIdByProcessInstanceIdAndActivityIdAndUserId(Long processInstanceId, String activityId, Long userId) {
        try {
            this.assertInServiceAndLog("getTaskIdByProcessInstanceIdAndActivityIdAndUserId", processInstanceId, activityId, userId);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                return 0L;
            }
            throw e;
        }
        this.taskService = this.getTaskService();
        return this.taskService.getTaskIdByProcessInstanceIdAndActivityIdAndUserId(processInstanceId, activityId, userId);
    }

    public Map<String, Object> suspendTaskById(Long taskId, Long userId, ILocaleString suspendReason) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        return this.getTaskService().suspendTaskById(taskIds, userId, suspendReason, true);
    }

    public Map<String, Object> activateTaskById(Long taskId, Long userId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        return this.getTaskService().suspendTaskById(taskIds, userId, null, false);
    }

    public List<WFFlowNode> getRejectedPreNode(Long taskId) {
        try {
            try {
                this.assertInServiceAndLog("getBizIdentifyKeyByEntityNumber", taskId);
            }
            catch (KDException e) {
                if (e.getErrorCode().equals((Object)WFErrorCode.workflowEngineNotConfiguration())) {
                    return Collections.emptyList();
                }
                throw e;
            }
            this.taskService = this.getTaskService();
            return this.taskService.getRejectedPreNode(taskId);
        }
        catch (KDException e) {
            return Collections.emptyList();
        }
    }

    public void abandonRootProcessInstance(String businessKey) {
        this.getRuntimeService().abandonRootProcessInstance(businessKey);
    }

    public List<AuditPointResult> getAuditPointResultsByTaskId(Long taskId) {
        return this.getTaskService().getAuditPointResultsByTaskId(taskId);
    }

    public void makeProcessInst(ProcessInstData processInstData) {
        WorkflowDevopsService.create().makeProcessInst(processInstData);
    }

    public List<DynamicObject> findOperationLogByProcInstId(Long procInstId, String selectFeilds, String orderBy) {
        List<OperationLogEntity> entitys = this.getTaskService().findOperationLogByProcInstId(procInstId, selectFeilds, orderBy);
        if (WfUtils.isEmptyForCollection(entitys)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(entitys.size());
        for (OperationLogEntity entity : entitys) {
            result.add(entity.getDynamicObject());
        }
        return result;
    }

    public List<DynamicObject> findOperationLogByBusinessKey(String businessKey, String selectFeilds, String orderBy) {
        List<OperationLogEntity> entitys = this.getTaskService().findOperationLogByBusinessKey(businessKey, selectFeilds, orderBy);
        if (WfUtils.isEmptyForCollection(entitys)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(entitys.size());
        for (OperationLogEntity entity : entitys) {
            result.add(entity.getDynamicObject());
        }
        return result;
    }

    public List<Map<String, Object>> getAddressAndPreCompute(String operation, String entityNumber, String businessKey) {
        if (WfUtils.isEmpty(operation) || WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(businessKey)) {
            return Collections.emptyList();
        }
        return this.getTaskService().getAddressAndPreCompute(operation, entityNumber, businessKey);
    }

    public void addOneYunzhijiaCompletedChildTask(AddYunzhijiaTaskParam param) {
        this.getTaskService().addOneYunzhijiaCompletedChildTask(param);
    }

    public void addProcessRelationPerson(Long processInstanceId, List<Long> assigneeIds) {
        this.getTaskService().addProcessRelationPerson(processInstanceId, assigneeIds);
    }

    public void addProcessRelationPerson(String entityNumber, String businessKey, List<Long> assigneeIds) {
        Long processInstanceId = this.getProcessInstanceIdByBusinessKeyAndEntityNumber(businessKey, entityNumber);
        this.addProcessRelationPerson(processInstanceId, assigneeIds);
    }
}

