/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.PersonQueryParam;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.ParticipantPositionEntity;
import kd.bos.workflow.engine.impl.calculator.ParticipantExpressionParsing;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.service.WorkflowUserService;

public class WorkflowUserServiceImpl
implements WorkflowUserService {
    private static Log log = LogFactory.getLog(WorkflowUserServiceImpl.class);
    private static final String ID = "id";
    private static final String DPT = "dpt";
    private static final String ISPARTJOB = "ispartjob";
    private static final String SUPERIOR = "superior";
    private static final String ISINCHARGE = "isincharge";
    private static final String ENTRYENTITY = "entryentity";
    private static final String NAME = "name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getPerson(PersonQueryParam personQueryParam) {
        int count;
        if (personQueryParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkflowUserServiceImpl_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        PersonQueryType queryType = personQueryParam.getQueryType();
        log.debug(String.format("PersonQueryParam orgId[%s] userId[%s] queryType[%s] isQuerySuperior[%s]", personQueryParam.getOrgId(), personQueryParam.getUserId(), queryType, personQueryParam.isQuerySuperior()));
        String resultMsg = "";
        List<Object> resultList = new ArrayList();
        if (queryType == null) {
            resultMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkflowUserServiceImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            personQueryParam.setErrorMsg(resultMsg);
            return resultList;
        }
        try {
            switch (queryType) {
                case MANAGER_OF_SUPERIOR: {
                    resultList = this.getSuperior(personQueryParam);
                    break;
                }
                case MANAGER_OF_INDIRECT_SUPERIOR: {
                    resultList = this.getIndirectSuperior(personQueryParam);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            int count2;
            if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
                log.debug(String.format("getPerson[%s] error info[%s]", queryType, resultMsg));
            }
            if ((count2 = resultList.size()) == 0) {
                log.debug(String.format("getPerson[%s] count[0]", queryType));
            } else {
                StringBuilder idStr = new StringBuilder();
                for (Long l : resultList) {
                    idStr.append(',').append(String.valueOf(l));
                }
                log.debug(String.format("getPerson[%s] count[%s] userId[%s] ", queryType, count2, idStr.toString().substring(1)));
            }
            throw throwable;
        }
        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            log.debug(String.format("getPerson[%s] error info[%s]", queryType, resultMsg));
        }
        if ((count = resultList.size()) == 0) {
            log.debug(String.format("getPerson[%s] count[0]", queryType));
        } else {
            StringBuilder idStr = new StringBuilder();
            for (Long l : resultList) {
                idStr.append(',').append(String.valueOf(l));
            }
            log.debug(String.format("getPerson[%s] count[%s] userId[%s] ", queryType, count, idStr.toString().substring(1)));
        }
        personQueryParam.setErrorMsg(resultMsg);
        List breakUserIds = personQueryParam.getBreakUserIds();
        if (Utils.isListNotEmpty((List)breakUserIds)) {
            resultList.removeAll(breakUserIds);
        }
        return resultList;
    }

    private List<Long> getSuperior(PersonQueryParam personQueryParam) {
        Long superiorId;
        DynamicObject superior;
        List<Long> ret = new ArrayList<Long>();
        String resultMsg = "";
        long orgId = personQueryParam.getOrgId();
        long userId = personQueryParam.getUserId();
        if (orgId == 0L) {
            orgId = UserServiceHelper.getUserMainOrgId((long)userId);
        }
        if (orgId == 0L) {
            resultMsg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ec4\u7ec7ID\u53c2\u6570\u5e76\u4e14\u8be5\u4eba\u5458\u672a\u8bbe\u7f6e\u4e3b\u804c\u90e8\u95e8", (String)"WorkflowUserServiceImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            personQueryParam.setErrorMsg(resultMsg);
            return ret;
        }
        RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_5.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(orgId), "org"), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(userId), "user")));
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userPositions = UserServiceHelper.getPosition(userIds);
        if (WfUtils.isEmptyForCollection(userPositions)) {
            resultMsg = ResManager.loadKDString((String)"\u5c97\u4f4d\u4fe1\u606f\u4e3a\u7a7a", (String)"WorkflowUserServiceImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            personQueryParam.setErrorMsg(resultMsg);
            return ret;
        }
        HashMap<String, Object> mainDeptInfo = null;
        HashMap<String, Object> partJobDeptInfo = null;
        for (Map positions : userPositions) {
            if (null == positions.get(ENTRYENTITY)) {
                RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_7.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(userId), "user")));
                RunTimeLog.get().endBlock();
                continue;
            }
            List objectList = (List)positions.get(ENTRYENTITY);
            if (!WfUtils.isNotEmptyForCollection(objectList)) continue;
            for (Map m : objectList) {
                if (null == m.get(DPT)) continue;
                DynamicObject dept = (DynamicObject)m.get(DPT);
                if (!((Boolean)m.get(ISPARTJOB)).booleanValue()) {
                    mainDeptInfo = new HashMap<String, Object>();
                    mainDeptInfo.put(ID, dept.get(ID));
                    mainDeptInfo.put(SUPERIOR, m.get(SUPERIOR));
                    mainDeptInfo.put(ISINCHARGE, m.get(ISINCHARGE));
                    mainDeptInfo.put(NAME, dept.get(NAME));
                    continue;
                }
                if (orgId != (Long)dept.get(ID)) continue;
                partJobDeptInfo = new HashMap<String, Object>();
                partJobDeptInfo.put(ID, dept.get(ID));
                partJobDeptInfo.put(SUPERIOR, m.get(SUPERIOR));
                partJobDeptInfo.put(ISINCHARGE, m.get(ISINCHARGE));
                partJobDeptInfo.put(NAME, dept.get(NAME));
            }
        }
        if (WfConfigurationUtil.isDeptPrincipalPrefer() && null != mainDeptInfo && null != mainDeptInfo.get(SUPERIOR)) {
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_8.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(userId), "user"), mainDeptInfo.get(NAME)));
            superior = (DynamicObject)mainDeptInfo.get(SUPERIOR);
            superiorId = (Long)superior.get(ID);
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_6.getDesc(), WfUtils.isEmpty(superiorId) ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(Collections.singletonList(superiorId), "user")));
            ret.add(superiorId);
            this.getDownwardPositionByUserIdAndReferenceOrg(ret, orgId);
            RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_15.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(userId), "user"), RunTimeLog.get().collectAndSubstitution(ret, "user")));
            return ret;
        }
        if (null != partJobDeptInfo) {
            RunTimeLog.get().createBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_9.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(userId), "user"), partJobDeptInfo.get(NAME), partJobDeptInfo.get(NAME)));
            if (null != partJobDeptInfo.get(SUPERIOR)) {
                RunTimeLog.get().addlnLog(ParticipantParseProcess.PARTICIPANTRELEATION_10.getDesc());
                DynamicObject partJobSuperior = (DynamicObject)partJobDeptInfo.get(SUPERIOR);
                ret.add((Long)partJobSuperior.get(ID));
                this.getDownwardPositionByUserIdAndReferenceOrg(ret, orgId);
            } else if (WfConfigurationUtil.isUsePrincipalWhenSuperiorEmpty()) {
                ret = this.getManagersByDept((Map<String, Object>)partJobDeptInfo);
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_11.getDesc(), CollectionUtil.isEmpty(ret) ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(ret, "user")));
            } else {
                RunTimeLog.get().addlnLog(ParticipantParseProcess.PARTICIPANTRELEATION_26.getDesc());
            }
            RunTimeLog.get().endBlock();
        } else if (null != mainDeptInfo) {
            RunTimeLog.get().createBlock(ParticipantParseProcess.PARTICIPANTRELEATION_12.getDesc());
            if (null != mainDeptInfo.get(SUPERIOR)) {
                RunTimeLog.get().addlnLog(ParticipantParseProcess.PARTICIPANTRELEATION_13.getDesc());
                superior = (DynamicObject)mainDeptInfo.get(SUPERIOR);
                superiorId = (Long)superior.get(ID);
                ret.add(superiorId);
                this.getDownwardPositionByUserIdAndReferenceOrg(ret, orgId);
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_6.getDesc(), WfUtils.isEmpty(superiorId) ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(Collections.singletonList(superiorId), "user")));
            } else if (WfConfigurationUtil.isUsePrincipalWhenSuperiorEmpty()) {
                RunTimeLog.get().addlnLog(ParticipantParseProcess.PARTICIPANTRELEATION_14.getDesc());
                ret = this.getManagersByDept((Map<String, Object>)mainDeptInfo);
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_21.getDesc(), CollectionUtil.isEmpty(ret) ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(ret, "user")));
            } else {
                RunTimeLog.get().addlnLog(ParticipantParseProcess.PARTICIPANTRELEATION_20.getDesc());
            }
            RunTimeLog.get().endBlock();
        }
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_15.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(userId), "user"), CollectionUtil.isEmpty(ret) ? ParticipantParseProcess.NULL.getDesc() : RunTimeLog.get().collectAndSubstitution(ret, "user")));
        return ret;
    }

    private void getDownwardPositionByUserIdAndReferenceOrg(List<Long> userIds, long referenceOrg) {
        log.debug("\u8fdb\u5165\u4e86\u6307\u5b9a\u4eba\u5458\u7684\u5904\u7406\uff0c\u6839\u636e\u53c2\u4e0e\u4eba\u8bbe\u7f6e\u7684\u53c2\u7167\u7ec4\u7ec7\u8fdb\u884c\u5904\u7406");
        CommandContext commandContext = Context.getCommandContext();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(referenceOrg);
        List referOrgAllSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", orgIds, (boolean)true);
        if (referOrgAllSubordinateOrgs == null || referOrgAllSubordinateOrgs.isEmpty()) {
            log.debug(String.format("\u53c2\u7167\u7ec4\u7ec7\u4e3a:%s;\u53c2\u7167\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u6709%s\u4e2a\uff1b\u5206\u522b\u4e3a%s\u3002\u6240\u4ee5\u76f4\u63a5\u8fd4\u56de\uff0c\u4e0d\u653e\u5165commandcontext\u5904\u7406", referenceOrg, 0, null));
            return;
        }
        log.debug(String.format("\u53c2\u7167\u7ec4\u7ec7\u4e3a:%s;\u53c2\u7167\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u6709%s\u4e2a\uff1b\u5206\u522b\u4e3a%s", referenceOrg, referOrgAllSubordinateOrgs.size(), referOrgAllSubordinateOrgs.toString()));
        HashMap<Long, Map<Long, ILocaleString>> userDptPositionMap = new HashMap<Long, Map<Long, ILocaleString>>();
        this.getAllUserPosition(userIds, userDptPositionMap);
        this.deleteOutOfTargetOrg(referOrgAllSubordinateOrgs, userDptPositionMap);
        for (Long userId : userIds) {
            Map userDptPosition = (Map)userDptPositionMap.get(userId);
            if (userDptPosition == null || userDptPosition.isEmpty()) {
                log.debug(userId + "\u7684\u4e0e\u53c2\u7167\u7ec4\u7ec7\u76f8\u5173\u7684\u90e8\u95e8\u4e3a\u7a7a\uff0c\u7ee7\u7eed\u5faa\u73af\u5176\u4ed6\u4eba");
                continue;
            }
            if (userDptPosition.size() == 1) {
                Map.Entry userDptPositionOne = userDptPosition.entrySet().iterator().next();
                QFilter filter = new QFilter(ID, "=", userDptPositionOne.getKey());
                QFilter[] filters = new QFilter[]{filter};
                DynamicObject orgNameDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)NAME, (QFilter[])filters);
                ILocaleString orgName = orgNameDynamicObject.getLocaleString(NAME);
                log.debug("\u4e00\u4e2a\u804c\u4f4d\u6839\u636e\u53c2\u7167\u7ec4\u7ec7\u5254\u9664\u540e\u53ea\u5269\u4e00\u4e2a\u7684\u90e8\u95e8\u4e3a\uff1a" + orgName);
                ParticipantPositionEntity participantPositionEntity = new ParticipantPositionEntity(userId, (ILocaleString)userDptPositionOne.getValue(), "relation", orgName);
                commandContext.putUserPosoitionCache(participantPositionEntity);
                log.debug(String.format("%s\u7684\u4e0e\u53c2\u7167\u7ec4\u7ec7\u76f8\u5173\u7684\u90e8\u95e8\u4e3a1\u4e2a\uff0c\u5c06\u804c\u4f4d%s\u653e\u5165commandcontext\uff0c\u7ee7\u7eed\u5faa\u73af\u5176\u4ed6\u4eba", userId, userDptPositionOne.getValue()));
                continue;
            }
            ArrayList<Long> userDptIds = new ArrayList<Long>(userDptPosition.size());
            Set dptIdSet = userDptPosition.keySet();
            for (Long dptId : dptIdSet) {
                userDptIds.add(dptId);
            }
            log.debug(String.format("%s\u7684\u4e0e\u53c2\u7167\u7ec4\u7ec7\u76f8\u5173\u7684\u90e8\u95e8\u4e3a%s\u4e2a,\u5c06%s\u8fdb\u884c\u5c42\u7ea7\u5904\u7406", userId, userDptPosition.size(), ((Object)userDptIds).toString()));
            List<Long> orgIdList = ParticipantExpressionParsing.getParticipantExpressionParsing().getOrgIdList(userDptIds);
            if (orgIdList == null || orgIdList.size() != 1) continue;
            Long orgId = orgIdList.get(0);
            ILocaleString userPosition = (ILocaleString)userDptPosition.get(orgId);
            QFilter filter = new QFilter(ID, "=", (Object)orgId);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject orgNameDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)NAME, (QFilter[])filters);
            ILocaleString orgName = orgNameDynamicObject.getLocaleString(NAME);
            log.debug("\u591a\u4e2a\u804c\u4f4d\u6839\u636e\u53c2\u7167\u7ec4\u7ec7\u5254\u9664\u540e\u53ea\u5269\u4e00\u4e2a\u7684\u90e8\u95e8\u4e3a\uff1a" + orgName);
            ParticipantPositionEntity participantPositionEntity = new ParticipantPositionEntity(userId, userPosition, "relation", orgName);
            commandContext.putUserPosoitionCache(participantPositionEntity);
            log.debug(String.format("\u5c42\u7ea7\u5904\u7406\u540e\uff0c%s\u7684\u6700\u4e0a\u5c42\u7ec4\u7ec7\u53ea\u6709\u4e00\u4e2a\uff0c\u53d6%s\u7ec4\u7ec7\u7684\u804c\u4f4d%s", userId, orgId, userPosition.toString()));
        }
    }

    protected void deleteOutOfTargetOrg(List<Long> referOrgAllSubordinateOrgs, Map<Long, Map<Long, ILocaleString>> userDptPositionMap) {
        Set<Map.Entry<Long, Map<Long, ILocaleString>>> userDptPositionMapEntrySet = userDptPositionMap.entrySet();
        for (Map.Entry<Long, Map<Long, ILocaleString>> entry : userDptPositionMapEntrySet) {
            Map<Long, ILocaleString> dptPosition = entry.getValue();
            Iterator<Map.Entry<Long, ILocaleString>> dptPositionMapIter = dptPosition.entrySet().iterator();
            while (dptPositionMapIter.hasNext()) {
                Map.Entry<Long, ILocaleString> dptPositionEntry = dptPositionMapIter.next();
                Long dptId = dptPositionEntry.getKey();
                if (referOrgAllSubordinateOrgs.contains(dptId)) continue;
                dptPositionMapIter.remove();
            }
            log.debug(String.format("\u5220\u9664\u65e0\u5173\u7ec4\u7ec7\u540e\uff0c\u4eba\u5458%s\u5269\u4f59\u7684\u804c\u4f4d\u90e8\u95e8map\u4e3a\uff1a%s", entry.getKey(), dptPosition.toString()));
        }
    }

    protected void getAllUserPosition(List<Long> userIds, Map<Long, Map<Long, ILocaleString>> userDptPositionMap) {
        List userPositionList = UserServiceHelper.getPosition(userIds);
        log.debug(String.format("\u62ff\u5230\u6240\u6709\u4eba\u7684\u804c\u4f4d\u4fe1\u606f\uff0c\u4eba\u5458\u5206\u522b\u4e3a%s", userIds.toString()));
        for (Map userPositionMap : userPositionList) {
            List entryentityRows = (List)userPositionMap.get(ENTRYENTITY);
            if (entryentityRows == null || entryentityRows.isEmpty()) {
                log.debug("entryentityRows is null");
                continue;
            }
            HashMap<Long, ILocaleString> dptPositionMap = new HashMap<Long, ILocaleString>(entryentityRows.size());
            for (Map entryentityRow : entryentityRows) {
                DynamicObject dptDynamicObject = (DynamicObject)entryentityRow.get(DPT);
                Long userDptId = dptDynamicObject.getLong(ID);
                dptPositionMap.put(userDptId, (ILocaleString)entryentityRow.get("position"));
            }
            Long userId = (Long)userPositionMap.get(ID);
            userDptPositionMap.put(userId, dptPositionMap);
            log.debug(String.format("\u53c2\u4e0e\u4eba%s\u7684\u6240\u6709\u90e8\u95e8\u804c\u4f4d\u5173\u7cfb\u4e3a\uff1a%s", userId, userDptPositionMap.toString()));
        }
    }

    private List<Long> getManagersByDept(Map<String, Object> deptInfo) {
        long rootOrgId;
        ArrayList<Long> ret = new ArrayList();
        Object isInCharge = deptInfo.get(ISINCHARGE);
        long orgId = (Long)deptInfo.get(ID);
        if (null != isInCharge && ((Boolean)isInCharge).booleanValue() && WfUtils.isNotEmpty(rootOrgId = OrgUnitServiceHelper.getRootOrgId()) && rootOrgId != orgId) {
            List parentIds = OrgUnitServiceHelper.getSuperiorOrgs((String)"01", (long)orgId);
            if (WfUtils.isNotEmptyForCollection(parentIds)) {
                long parentId = (Long)parentIds.get(0);
                ret = UserServiceHelper.getManagersOfOrg((long)parentId);
                this.putRetPositionToCache(ret, parentId);
            }
            return ret;
        }
        ret = UserServiceHelper.getManagersOfOrg((long)orgId);
        this.putRetPositionToCache(ret, orgId);
        return ret;
    }

    private void putRetPositionToCache(List<Long> ret, long orgId) {
        log.debug("\u672a\u6307\u5b9a\u4eba\u5458\u5904\u7406\uff0c\u6839\u636e\u5173\u7cfb\u8ba1\u7b97\u7684\u4eba\u5458\uff0c\u540c\u7406\u5f97\u804c\u4f4d\u3002\u53c2\u7167\u7ec4\u7ec7\u4e3a\uff1a" + orgId);
        CommandContext commandContext = Context.getCommandContext();
        List userPositionList = UserServiceHelper.getPosition(ret);
        log.debug(String.format("\u5f97\u5230%s\u4e2a\u4eba\u7684\u804c\u4f4d\uff0c\u4eba\u5458\u5206\u522b\u4e3a\uff1a%s\uff1b\u4eba\u5458\u804c\u4f4d\u4fe1\u606f\u4e3a\uff1a%s", ret.size(), ret.toString(), userPositionList.toString()));
        block0: for (Map userPositionMap : userPositionList) {
            Long userId = (Long)userPositionMap.get(ID);
            List entryentityRows = (List)userPositionMap.get(ENTRYENTITY);
            log.debug(String.format("%s\u7684\u4efb\u804c\u4fe1\u606f\u4e3a%s", userId, entryentityRows));
            for (Map entryentityRow : entryentityRows) {
                DynamicObject dptDynamicObject = (DynamicObject)entryentityRow.get(DPT);
                long dptId = dptDynamicObject.getLong("masterid");
                if (dptId != orgId) continue;
                ILocaleString userPosition = (ILocaleString)entryentityRow.get("position");
                ILocaleString dptName = dptDynamicObject.getLocaleString(NAME);
                log.debug("\u672a\u6307\u5b9a\u4e0a\u7ea7\uff0c\u90e8\u95e8\u540d\u79f0\u4e3a\uff1a" + dptName);
                ParticipantPositionEntity participantPositionEntity = new ParticipantPositionEntity(userId, userPosition, "relation", dptName);
                commandContext.putUserPosoitionCache(participantPositionEntity);
                log.debug(String.format("%s\u5728\u53c2\u7167\u7ec4\u7ec7\u4e0b\u6709\u4efb\u804c\u4fe1\u606f\u4e3a\uff1a%s", userId, userPosition.toString()));
                continue block0;
            }
        }
    }

    private List<Long> getIndirectSuperior(PersonQueryParam personQueryParam) {
        ArrayList<Long> ret = new ArrayList<Long>();
        RunTimeLog.get().createBlock(ParticipantParseProcess.PARTICIPANTRELEATION_16.getDesc());
        Long orginUser = personQueryParam.getUserId();
        List<Long> superiorList = this.getSuperior(personQueryParam);
        List<Long> enableUsers = WfUtils.filterEnableUsers(superiorList);
        RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_17.getDesc(), RunTimeLog.get().collectAndSubstitution(superiorList, "user"), RunTimeLog.get().collectAndSubstitution(enableUsers, "user")));
        if (WfUtils.isNotEmptyForCollection(enableUsers)) {
            RunTimeLog.get().createBlock();
            for (Long superiorId : enableUsers) {
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_22.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(superiorId), "user")));
                personQueryParam.setUserId(superiorId.longValue());
                List<Long> superiods = this.getSuperior(personQueryParam);
                ret.addAll(superiods);
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_23.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(superiorId), "user"), RunTimeLog.get().collectAndSubstitution(superiods, "user")));
            }
            RunTimeLog.get().endBlock();
        }
        RunTimeLog.get().endBlock(String.format(ParticipantParseProcess.PARTICIPANTRELEATION_18.getDesc(), RunTimeLog.get().collectAndSubstitution(Collections.singletonList(orginUser), "user"), RunTimeLog.get().collectAndSubstitution(ret, "user")));
        return ret;
    }
}

