/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    protected static Log logger = LogFactory.getLog(HttpClientUtil.class);
    private static final int DEFAULT_CONNECTIONTIMEOUT = 3000;
    private static final int DEFAULT_READTIMEOUT = 5000;
    private static final String SCHEME_HTTPS = "https";
    private static final String HTTP_ERROR = "Http get error";

    private HttpClientUtil() {
    }

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        SystemDefaultHttpClient client = new SystemDefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        return client;
    }

    public static HttpClient wrapperHttpClient(HttpClient client) {
        if (client == null) {
            logger.debug("\u5ba2\u6237\u7aef\u5bf9\u8c61\u4e3a\u7a7a\u65f6,\u4f7f\u7528\u9ed8\u8ba4\u5ba2\u6237\u7aef");
            client = HttpClientUtil.createHttpClient(3000, 5000);
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme(SCHEME_HTTPS, 443, (SchemeSocketFactory)ssf));
            ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)mgr, client.getParams());
        }
        catch (Exception ex) {
            logger.error("\u5305\u88c5\u65e0\u8bc1\u4e66\u6821\u9a8c\u5ba2\u6237\u7aef\u5931\u8d25:" + ex.getMessage());
            return null;
        }
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return HttpClientUtil.postjson(url, header, json, 3000, 5000);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String data;
        block11: {
            String CONTENT_TYPE_TEXT_JSON = "text/json;";
            data = "";
            HttpClient client = HttpClientUtil.createHttpClient(connectionTimeout, readTimeout);
            HttpPost post = new HttpPost(url);
            URI uri = post.getURI();
            if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtil.wrapperHttpClient(client)) == null) {
                return data;
            }
            try {
                if (header != null && header.size() != 0) {
                    for (Map.Entry<String, String> entry : header.entrySet()) {
                        post.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
                se.setContentType("text/json;");
                post.setEntity((HttpEntity)se);
                HttpResponse response = client.execute((HttpUriRequest)post);
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity resEntity = response.getEntity();
                    Header respHeader = resEntity.getContentEncoding();
                    if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                        GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                        InputStream in = gzipEntity.getContent();
                        data = HttpClientUtil.getHTMLContent(in);
                    } else {
                        data = EntityUtils.toString((HttpEntity)resEntity);
                    }
                    break block11;
                }
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"HttpClientUtil_0", (String)"bos-wf-engine", (Object[])new Object[0]), response.getStatusLine()));
            }
            catch (IOException ex) {
                logger.error("Http postjson error", (Throwable)ex);
                throw ex;
            }
            finally {
                post.releaseConnection();
            }
        }
        return data;
    }

    public static String get(String url) throws Exception {
        return HttpClientUtil.get(url, 3000, 5000);
    }

    public static String get(String url, int connectionTimeout, int readTimeout) throws Exception {
        String content = null;
        HttpClient client = HttpClientUtil.createHttpClient(connectionTimeout, readTimeout);
        URI uri = URI.create(url);
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtil.wrapperHttpClient(client)) == null) {
            return content;
        }
        HttpGet request = new HttpGet();
        request.setURI(new URI(url));
        HttpResponse response = client.execute((HttpUriRequest)request);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            StringBuilder sb = new StringBuilder();
            String line = "";
            String nl = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(nl);
            }
            content = sb.toString();
        }
        return content;
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> body) {
        return HttpClientUtil.get(url, header, body, 3000, 5000);
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        String content = null;
        String strBody = "";
        if (body != null && body.size() != 0) {
            Iterator<Map.Entry<String, Object>> it = body.entrySet().iterator();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(body.size());
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                strBody = EntityUtils.toString((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(HTTP_ERROR, (Throwable)e);
            }
            catch (ParseException e) {
                logger.error(HTTP_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                logger.error(HTTP_ERROR, (Throwable)e);
            }
        }
        try {
            String destUrl = "";
            destUrl = StringUtils.isEmpty((String)strBody) ? url : url + "?" + strBody;
            HttpClient client = HttpClientUtil.createHttpClient(connectionTimeout, readTimeout);
            URI uri = URI.create(url);
            if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtil.wrapperHttpClient(client)) == null) {
                return content;
            }
            HttpGet request = new HttpGet();
            if (headers != null && headers.size() != 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
            }
            request.setURI(new URI(destUrl));
            HttpResponse response = client.execute((HttpUriRequest)request);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
                StringBuilder sb = new StringBuilder();
                String line = "";
                String nl = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                    sb.append(nl);
                }
                content = sb.toString();
            }
        }
        catch (Exception e) {
            logger.error(HTTP_ERROR, (Throwable)e);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            logger.error("getHTMLContent error", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error("getHTMLContent error", (Throwable)e);
            }
        }
        return sb.toString();
    }
}

