/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.util.concurrent;

import java.util.HashMap;
import java.util.List;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.util.concurrent.AbstractConcurrentInfoHandler;
import kd.bos.workflow.util.concurrent.pojo.ActivityIdAndNameInfo;

public class ActivityNameUpdater
extends AbstractConcurrentInfoHandler {
    private static Log logger = LogFactory.getLog(ActivityNameUpdater.class);

    public ActivityNameUpdater(String cacheInfo, ExecutionEntity execution) {
        super(cacheInfo, execution);
    }

    @Override
    public String calculateValue(CommandContext commandContext) {
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> execEntityList = executionMgr.findChildExecutionsByProcessInstanceId(this.execution.getProcessInstanceId());
        HashMap<String, ILocaleString> actNames = new HashMap<String, ILocaleString>(execEntityList.size());
        for (ExecutionEntity exec : execEntityList) {
            if (exec.isScope() || !exec.isActive() || exec.isDeleted() || exec.isBillExecution()) continue;
            FlowElement ele = exec.getCurrentFlowElement();
            if (exec.getCurrentFlowElement() == null || exec.getCurrentFlowElement() instanceof BoundaryEvent || !WfUtils.isNotEmpty(exec.getActivityName())) continue;
            String eleId = ele.getId();
            actNames.put(eleId, exec.getActivityName());
        }
        if (actNames.isEmpty()) {
            return "";
        }
        logger.debug(String.format("\u5f53\u524d\u5b9e\u4f8b\u4fe1\u606f%s", WfUtils.mapToString(actNames)));
        ILocaleString activityName = WfMultiLangUtils.jointCollectionLocaleString(actNames.values(), StandardTips.getComma());
        ActivityIdAndNameInfo info = new ActivityIdAndNameInfo();
        info.setActivityIds(WfUtils.listToString(actNames.keySet(), ","));
        info.setActivityNames((LocaleString)activityName);
        return SerializationUtils.toJsonString((Object)info);
    }

    @Override
    public void insertToDB(String value, CommandContext commandContext) {
        ExecutionEntity procinst = this.execution.getProcessInstance();
        if (WfUtils.isNotEmpty(value) && procinst != null) {
            ActivityIdAndNameInfo info = (ActivityIdAndNameInfo)SerializationUtils.fromJsonString((String)value, ActivityIdAndNameInfo.class);
            procinst.setActivityId(info.getActivityIds());
            procinst.setActivityName((ILocaleString)info.getActivityNames());
            commandContext.getExecutionEntityManager().update(procinst);
        }
    }
}

