/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.validation.ExecBaseElementValidator;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.BaseElementValidatorSet;

public class ExecBaseElementValidatorImpl
implements ExecBaseElementValidator {
    protected List<BaseElementValidatorSet> validatorSets;

    @Override
    public List<ValidationError> validate(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        ArrayList<ValidationError> allErrors = new ArrayList<ValidationError>();
        for (BaseElementValidatorSet validatorSet : this.validatorSets) {
            for (BaseElementValidatorImpl validator : validatorSet.getValidators()) {
                ArrayList<ValidationError> validatorErrors = new ArrayList<ValidationError>();
                validator.validate(flowElement, validatorErrors, keyMap);
                validator.collectValidationDatas(process, flowElement, validationDatas, keyMap);
                if (validatorErrors.isEmpty()) continue;
                for (ValidationError error : validatorErrors) {
                    error.setValidatorSetName(validatorSet.getName());
                }
                allErrors.addAll(validatorErrors);
            }
        }
        return allErrors;
    }

    @Override
    public List<BaseElementValidatorSet> getValidatorSets() {
        return this.validatorSets;
    }

    public void setValidatorSets(List<BaseElementValidatorSet> validatorSets) {
        this.validatorSets = validatorSets;
    }

    public void addValidatorSet(BaseElementValidatorSet validatorSet) {
        if (this.validatorSets == null) {
            this.validatorSets = new ArrayList<BaseElementValidatorSet>();
        }
        this.validatorSets.add(validatorSet);
    }
}

