/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.validation.ExecDataValidator;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.DataValidatorSet;

public class ExecDataValidatorImpl
implements ExecDataValidator {
    protected List<DataValidatorSet> validatorSets;

    @Override
    public List<ValidationError> validate(ValidationDataCollator validationDataCollator) {
        ArrayList<ValidationError> allErrors = new ArrayList<ValidationError>();
        for (DataValidatorSet validatorSet : this.validatorSets) {
            for (DataValidatorImpl validator : validatorSet.getValidators()) {
                ArrayList<ValidationError> validatorErrors = new ArrayList<ValidationError>();
                validator.validate(validationDataCollator, validatorErrors);
                if (validatorErrors.isEmpty()) continue;
                for (ValidationError error : validatorErrors) {
                    error.setValidatorSetName(validatorSet.getName());
                }
                allErrors.addAll(validatorErrors);
            }
        }
        return allErrors;
    }

    @Override
    public List<DataValidatorSet> getValidatorSets() {
        return this.validatorSets;
    }

    public void setValidatorSets(List<DataValidatorSet> validatorSets) {
        this.validatorSets = validatorSets;
    }

    public void addValidatorSet(DataValidatorSet validatorSet) {
        if (this.validatorSets == null) {
            this.validatorSets = new ArrayList<DataValidatorSet>();
        }
        this.validatorSets.add(validatorSet);
    }
}

