/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.validation.ExecMainProcessValidator;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.MainProcessValidatorImpl;
import kd.bos.workflow.validation.validator.MainProcessValidatorSet;

public class ExecMainProcessValidatorImpl
implements ExecMainProcessValidator {
    protected List<MainProcessValidatorSet> validatorSets;

    @Override
    public List<ValidationError> validate(Process mainProcess, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        ArrayList<ValidationError> allErrors = new ArrayList<ValidationError>();
        for (MainProcessValidatorSet validatorSet : this.validatorSets) {
            for (MainProcessValidatorImpl validator : validatorSet.getValidators()) {
                ArrayList<ValidationError> validatorErrors = new ArrayList<ValidationError>();
                validator.validate(mainProcess, validatorErrors, keyMap);
                validator.collectValidationDatas(mainProcess, validationDatas, keyMap);
                if (validatorErrors.isEmpty()) continue;
                for (ValidationError error : validatorErrors) {
                    error.setValidatorSetName(validatorSet.getName());
                }
                allErrors.addAll(validatorErrors);
            }
        }
        return allErrors;
    }

    @Override
    public List<MainProcessValidatorSet> getValidatorSets() {
        return this.validatorSets;
    }

    public void setValidatorSets(List<MainProcessValidatorSet> validatorSets) {
        this.validatorSets = validatorSets;
    }

    public void addValidatorSet(MainProcessValidatorSet validatorSet) {
        if (this.validatorSets == null) {
            this.validatorSets = new ArrayList<MainProcessValidatorSet>();
        }
        this.validatorSets.add(validatorSet);
    }
}

