/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.ValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public abstract class BaseElementValidatorImpl
extends ValidatorImpl {
    public void buildObjectInfo(FlowElement flowElement, Map<String, Object> keyMap) {
        switch (flowElement.getType()) {
            case "StartSignalEvent": {
                keyMap.put("objName", ResManager.loadKDString((String)"\u5f00\u59cb\u8282\u70b9", (String)"BaseElementValidatorImpl_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "SequenceFlow": {
                SequenceFlow flow = (SequenceFlow)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u7ebf(%s)", (String)"BaseElementValidatorImpl_27", (String)"bos-wf-engine", (Object[])new Object[0]), flow.getNumber()));
                break;
            }
            case "UserTask": {
                UserTask userTask = (UserTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u4eba\u5de5\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_17", (String)"bos-wf-engine", (Object[])new Object[0]), userTask.getName()));
                break;
            }
            case "AutoTask": {
                AutoTask autoTask = (AutoTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_18", (String)"bos-wf-engine", (Object[])new Object[0]), autoTask.getName()));
                break;
            }
            case "WaitTask": {
                WaitTask waitTask = (WaitTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_19", (String)"bos-wf-engine", (Object[])new Object[0]), waitTask.getName()));
                break;
            }
            case "AuditTask": {
                AuditTask auditTask1 = (AuditTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_20", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask1.getName()));
                break;
            }
            case "YunzhijiaTask": {
                AuditTask auditTask2 = (AuditTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_21", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask2.getName()));
                break;
            }
            case "SSCApprove": {
                AuditTask auditTask3 = (AuditTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_22", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask3.getName()));
                break;
            }
            case "SSCImageUpload": 
            case "SSCImageUploadNew": {
                UserTask uploadTask = (UserTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_23", (String)"bos-wf-engine", (Object[])new Object[0]), uploadTask.getName()));
                break;
            }
            case "BoundaryErrorEvent": {
                BoundaryEvent boundary = (BoundaryEvent)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u8fb9\u754c\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_24", (String)"bos-wf-engine", (Object[])new Object[0]), boundary.getName()));
                break;
            }
            case "EndNoneEvent": {
                keyMap.put("objName", ResManager.loadKDString((String)"\u7ed3\u675f\u8282\u70b9", (String)"BaseElementValidatorImpl_10", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "CallActivity": {
                CallActivity callActivity = (CallActivity)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b(%s)", (String)"BaseElementValidatorImpl_25", (String)"bos-wf-engine", (Object[])new Object[0]), callActivity.getName()));
                break;
            }
            case "RPATask": {
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"RPA\u8282\u70b9(%1$s)", (String)"BaseElementValidatorImpl_16", (String)"bos-wf-engine", (Object[])new Object[0]), flowElement.getName()));
                break;
            }
            case "BillTask": {
                BillTask billTask = (BillTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u5355\u636e\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_26", (String)"bos-wf-engine", (Object[])new Object[0]), billTask.getName()));
                break;
            }
            case "AutoMicroServiceTask": {
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5fae\u670d\u52a1\u8282\u70b9(%1$s)", (String)"BaseElementValidatorImpl_28", (String)"bos-wf-engine", (Object[])new Object[0]), flowElement.getName()));
                break;
            }
            case "NotifyTask": {
                NotifyTask notifyTask = (NotifyTask)flowElement;
                keyMap.put("objName", String.format(ResManager.loadKDString((String)"\u6d88\u606f\u8282\u70b9(%s)", (String)"BaseElementValidatorImpl_29", (String)"bos-wf-engine", (Object[])new Object[0]), notifyTask.getName()));
                break;
            }
        }
        keyMap.put("infoType", "error");
        keyMap.put("activityId", flowElement.getId());
    }

    public void validateBaseInfo(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMap) {
        FlowNode flowNode = (FlowNode)flowElement;
        if (flowNode.getIncomingFlows().isEmpty()) {
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            String info = ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u5165\u53e3\u7ebf", (String)"BaseElementValidatorImpl_12", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            errors.add(validationError);
            return;
        }
        if (flowNode.getOutgoingFlows().isEmpty()) {
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            FlowElement sourceEle = flowNode.getIncomingFlows().get(0).getSourceFlowElement();
            if (!(sourceEle instanceof BoundaryEvent) || !"BoundaryCompensateEvent".equals(((BoundaryEvent)sourceEle).getType())) {
                String info = ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u51fa\u53e3\u7ebf", (String)"BaseElementValidatorImpl_13", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError.setInfo(info);
                errors.add(validationError);
            }
        } else {
            List<String> sameSeqInfo = ValidatorUtil.getSameSequneceFlowInfo(flowNode);
            if (null != sameSeqInfo && !sameSeqInfo.isEmpty()) {
                for (String s : sameSeqInfo) {
                    ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                    validationError.setInfo(s);
                    errors.add(validationError);
                }
            } else if (ValidatorUtil.hasIllegalSequenceFlowOrNot(flowNode.getFork(), flowNode.getOutgoingFlows())) {
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                String info = ResManager.loadKDString((String)"\u51fa\u53e3\u7ebf\u8bbe\u7f6e\u6709\u8bef", (String)"BaseElementValidatorImpl_14", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError.setInfo(info);
                errors.add(validationError);
            }
        }
    }

    protected void validateParticipantValue(List<ParticipantModelEntityImpl> participants, List<ValidationError> errors, Map<String, Object> keyMap) {
        if (participants == null || participants.isEmpty()) {
            return;
        }
        for (ParticipantModelEntityImpl participant : participants) {
            String value = participant.getValue();
            if (value == null || value.length() <= 3000) continue;
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            String showValue = participant.getShowValue();
            String info = String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba%1$s\u8bbe\u7f6e\u8fc7\u591a\uff0c\u8d85\u8fc7\u6700\u5927\u9650\u5236\u3002", (String)"BaseElementValidatorImpl_15", (String)"bos-wf-engine", (Object[])new Object[0]), showValue != null ? showValue : "");
            validationError.setInfo(info);
            String property = (String)keyMap.get("property");
            if (property != null) {
                validationError.setProperty(property);
            }
            validationError.setInfoType("systemError");
            errors.add(validationError);
        }
    }

    public abstract void validate(FlowElement var1, List<ValidationError> var2, Map<String, Object> var3);

    public abstract void collectValidationDatas(Process var1, FlowElement var2, List<ValidationData> var3, Map<String, Object> var4);
}

