/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BillTaskCallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.impl.CallActivityValidator;
import kd.bos.workflow.validation.validator.impl.UserTaskValidator;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class BillTaskValidator
extends UserTaskValidator {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        BillTaskCallActivity billTaskCallActivity;
        String info;
        ValidationError validationError;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        super.validateCalculateParticipant(flowElement, errors, keyMap);
        super.validateBaseInfo(flowElement, errors, keyMap);
        BillTask billTask = (BillTask)flowElement;
        String objType2 = WFMultiLangConstants.getBasicInfo();
        if (WfUtils.isEmpty(billTask.getEntityNumber())) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillTaskValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType2);
            validationError.setInfoType("error");
            errors.add(validationError);
        }
        if (WfUtils.isEmpty(billTask.getSourceEntityNumber())) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillTaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType2);
            validationError.setInfoType("error");
            errors.add(validationError);
        }
        if (WfUtils.isEmpty(billTask.getProcessingPage())) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType2);
            validationError.setInfoType("error");
            errors.add(validationError);
        }
        if ((billTaskCallActivity = billTask.getBillTaskCallActivity()) != null && billTaskCallActivity.isEnableCallActivity()) {
            new CallActivityValidator().validateCallActivity(errors, keyMap, billTaskCallActivity);
        }
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        String processingPage;
        String sourceEntityNumber;
        BillTask billTask = (BillTask)flowElement;
        String objType1 = WFMultiLangConstants.getBasicInfo();
        String entityNumber = billTask.getEntityNumber();
        if (WfUtils.isNotEmpty(entityNumber)) {
            String info = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e ", (String)"BillTaskValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            this.collectBillData(validationDatas, keyMap, objType1, entityNumber, info);
        }
        if (WfUtils.isNotEmpty(sourceEntityNumber = billTask.getSourceEntityNumber())) {
            String info = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e ", (String)"BillTaskValidator_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            this.collectBillData(validationDatas, keyMap, objType1, sourceEntityNumber, info);
        }
        if (WfUtils.isNotEmpty(processingPage = billTask.getProcessingPage())) {
            String info = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762 ", (String)"BillTaskValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            this.collectBillData(validationDatas, keyMap, objType1, processingPage, info);
        }
        String bizEntityNumber = ConditionalRuleHelper.getEntryBillNumber(process, billTask.getId(), false);
        this.collectParticipatantInfo(process, validationDatas, keyMap, billTask, bizEntityNumber);
        this.collectMsgInfo(process, validationDatas, keyMap, billTask, bizEntityNumber);
        this.collectPluginInfo(validationDatas, keyMap, billTask);
        this.collectSkipRuleInfo(process, validationDatas, keyMap, billTask, bizEntityNumber);
        this.collectCirculateInfo(process, validationDatas, keyMap, billTask, bizEntityNumber);
        this.collectBillTaskCallActivity(process, validationDatas, keyMap, billTask, bizEntityNumber);
    }

    private void collectBillTaskCallActivity(Process process, List<ValidationData> validationDatas, Map<String, Object> keyMap, BillTask billTask, String bizEntityNumber) {
        BillTaskCallActivity billTaskCallActivity = billTask.getBillTaskCallActivity();
        if (billTaskCallActivity != null && !billTaskCallActivity.isEnableCallActivity()) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo.setInfoType("warning");
            validationInfo.setObjType(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u914d\u7f6e", (String)"BillTaskValidator_9", (String)"bos-wf-engine", (Object[])new Object[0]));
            validationInfo.setInfo("");
            validationDatas.add(ValidatorUtil.getValidationBillCallActivity("billCallActivity", billTask.getEntityNumber(), billTask.getEntityName(), validationInfo));
        }
    }

    private void collectBillSummaryData(List<ValidationData> validationDatas, Map<String, Object> keyMap, String objType1, String billSummary, String info) {
        ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
        validationInfo.setInfo(info);
        validationInfo.setObjType(objType1);
        String formatBillSummary = String.format("%s%s", billSummary, "$");
        validationDatas.add(ValidatorUtil.getValidationDataByBillSummary("billsummary", formatBillSummary, validationInfo));
    }

    private void collectBillData(List<ValidationData> validationDatas, Map<String, Object> keyMap, String objType1, String billNumber, String info) {
        ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
        validationInfo.setInfo(info);
        validationInfo.setObjType(objType1);
        validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", billNumber, validationInfo));
    }
}

