/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.AllowNextPersonSetting;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.AuditPoint;
import kd.bos.workflow.bpmn.model.AuditPointModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BatchApproveModel;
import kd.bos.workflow.bpmn.model.BatchRejectModel;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.BtnModel;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ExtendBtn;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipantRangeSettingModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.impl.UserTaskValidator;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class AuditTaskValidator
extends UserTaskValidator {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        String trigger;
        CirculateModel circulateModel;
        Object validationError;
        String nextNodeAssignValue;
        String personScene;
        AllowNextPersonSetting allowNextPersonSetting;
        AllowNextPersonSettingModel allowNextPersonSettingModel;
        BatchRejectModel batchReject;
        BatchApproveModel batchApprove;
        List<DecisionOption> decisionOptions;
        Object validationError2;
        List<ExtendBtn> extendBtns;
        ValidationError validationError3;
        String endType;
        String info;
        BillSetting billSetting;
        String info2;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        AuditTask auditTask = (AuditTask)flowElement;
        super.validateBaseInfo(flowElement, errors, keyMap);
        super.validateCalculateParticipant(flowElement, errors, keyMap);
        super.validateParticipantValue(auditTask, errors, keyMap);
        String objType2 = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"AuditTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        ParticipatantModel participantModel = auditTask.getParticipant();
        boolean checkParticipant = false;
        if (null != participantModel) {
            checkParticipant = participantModel.isAllowNoneParticipant();
        }
        if (!checkParticipant && (null == participantModel || null == participantModel.getParticipant() || participantModel.getParticipant().isEmpty())) {
            ValidationError validationError4 = ValidatorUtil.getValidationError(keyMap);
            String info3 = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError4.setInfo(info3);
            validationError4.setObjType(objType2);
            validationError4.setInfoType("error");
            validationError4.setProperty("participant");
            errors.add(validationError4);
        }
        String objType = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AuditTaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)auditTask.getEntityNumber())) {
            ValidationError validationError5 = ValidatorUtil.getValidationError(keyMap);
            info2 = ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError5.setInfo(info2);
            validationError5.setObjType(objType);
            validationError5.setProperty("entityNumber");
            errors.add(validationError5);
        }
        if ((billSetting = auditTask.getBillSetting()) != null && StringUtils.isEmpty((CharSequence)billSetting.getFormKey())) {
            ValidationError validationError6 = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u5185\u5d4c\u5355\u636e\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError6.setInfo(info);
            validationError6.setObjType(objType);
            validationError6.setProperty("formKey");
            errors.add(validationError6);
        }
        if (StringUtils.isEmpty((CharSequence)auditTask.getProcessingPage())) {
            info2 = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationError validationError7 = ValidatorUtil.getValidationError(keyMap);
            validationError7.setInfo(info2);
            validationError7.setObjType(objType);
            validationError7.setProperty("processingPage");
            errors.add(validationError7);
        }
        if ("all".equals(endType = auditTask.getEndType())) {
            if (StringUtils.isEmpty((CharSequence)auditTask.getProcessingMobilePage())) {
                info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e3a\u7a7a", (String)"AuditTaskValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError3 = ValidatorUtil.getValidationError(keyMap);
                validationError3.setInfo(info);
                validationError3.setObjType(objType);
                validationError3.setInfoType("warning");
                validationError3.setProperty("processingMobilePage");
                errors.add(validationError3);
            }
            if (billSetting != null && StringUtils.isEmpty((CharSequence)billSetting.getMobilFormKey())) {
                info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u5185\u5d4c\u5355\u636e\u9875\u9762\u4e3a\u7a7a", (String)"AuditTaskValidator_7", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError3 = ValidatorUtil.getValidationError(keyMap);
                validationError3.setInfo(info);
                validationError3.setObjType(objType);
                validationError3.setInfoType("warning");
                validationError3.setProperty("mobilFormKey");
                errors.add(validationError3);
            }
        }
        if ("mobile".equals(endType)) {
            if (StringUtils.isEmpty((CharSequence)auditTask.getProcessingMobilePage())) {
                info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError3 = ValidatorUtil.getValidationError(keyMap);
                validationError3.setInfo(info);
                validationError3.setObjType(objType);
                validationError3.setProperty("processingMobilePage");
                errors.add(validationError3);
            }
            if (billSetting != null && StringUtils.isEmpty((CharSequence)billSetting.getMobilFormKey())) {
                info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u5185\u5d4c\u5355\u636e\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_9", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError3 = ValidatorUtil.getValidationError(keyMap);
                validationError3.setInfo(info);
                validationError3.setObjType(objType);
                validationError3.setProperty("mobilFormKey");
                errors.add(validationError3);
            }
        }
        BtnModel btnModel = auditTask.getBtnModel();
        String objType1 = ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"AuditTaskValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (auditTask.isCompositeTasks()) {
            String info4 = ResManager.loadKDString((String)"\u805a\u5408\u5206\u652f\u4efb\u52a1", (String)"AuditTaskValidator_52", (String)"bos-wf-engine", (Object[])new Object[0]);
            this.validateDataSigned(auditTask, errors, info4, objType1, keyMap);
        }
        if (btnModel != null && btnModel.isExtendBtnsWhenMatch() && (extendBtns = btnModel.getExtendBtns()) != null && extendBtns.size() > 0) {
            for (ExtendBtn extendBtn : extendBtns) {
                String info5;
                if (StringUtils.isEmpty((CharSequence)extendBtn.getOperationNumber())) {
                    info5 = ResManager.loadKDString((String)"\u6269\u5c55\u4e1a\u52a1\u6309\u94ae \u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_11", (String)"bos-wf-engine", (Object[])new Object[0]);
                    validationError2 = ValidatorUtil.getValidationError(keyMap);
                    ((ValidationError)validationError2).setInfo(info5);
                    ((ValidationError)validationError2).setObjType(objType1);
                    ((ValidationError)validationError2).setProperty("extendBtns");
                    errors.add((ValidationError)validationError2);
                }
                if (StringUtils.isEmpty((CharSequence)extendBtn.getBtnName())) {
                    info5 = ResManager.loadKDString((String)"\u6269\u5c55\u4e1a\u52a1\u6309\u94ae \u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_12", (String)"bos-wf-engine", (Object[])new Object[0]);
                    validationError2 = ValidatorUtil.getValidationError(keyMap);
                    ((ValidationError)validationError2).setInfo(info5);
                    ((ValidationError)validationError2).setObjType(objType1);
                    ((ValidationError)validationError2).setProperty("extendBtns");
                    errors.add((ValidationError)validationError2);
                }
                if (!StringUtils.isEmpty((CharSequence)extendBtn.getBtnNumber())) continue;
                info5 = ResManager.loadKDString((String)"\u6269\u5c55\u4e1a\u52a1\u6309\u94ae \u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_13", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError2 = ValidatorUtil.getValidationError(keyMap);
                ((ValidationError)validationError2).setInfo(info5);
                ((ValidationError)validationError2).setObjType(objType1);
                ((ValidationError)validationError2).setProperty("extendBtns");
                errors.add((ValidationError)validationError2);
            }
        }
        if ((decisionOptions = auditTask.getDecisionOptions()) != null && decisionOptions.size() > 0) {
            int defaultDecisionOptions = 0;
            FlowElementsContainer parent = flowElement.getParentContainer();
            boolean isNoCodeFlow = parent instanceof Process && ModelType.NoCodeFlow.name().equals(((Process)parent).getProcessType());
            for (DecisionOption decisionOption : decisionOptions) {
                String auditType = decisionOption.getAuditType();
                if (WfUtils.isEmpty(auditType)) {
                    String info6 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879 \u5ba1\u6279\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_14", (String)"bos-wf-engine", (Object[])new Object[0]);
                    ValidationError validationError8 = ValidatorUtil.getValidationError(keyMap);
                    validationError8.setInfo(info6);
                    validationError8.setObjType(objType2);
                    validationError8.setProperty("decisionOptions");
                    errors.add(validationError8);
                } else if (!isNoCodeFlow && ("reject".equals(auditType) || "forceReject".equals(auditType))) {
                    List<SelectNodesModel> rejectOptions = decisionOption.getRejectOptions();
                    if (!(decisionOption.isRejectPreNodeScene() || decisionOption.isRejectToParentProcessScene() || rejectOptions != null && !rejectOptions.isEmpty())) {
                        boolean needApprove = true;
                        for (SequenceFlow sequenceFlow : auditTask.getOutgoingFlows()) {
                            if (sequenceFlow.getConditionalRule() == null || !WfUtils.isNotEmpty(sequenceFlow.getConditionalRule().getExpression())) continue;
                            Pattern pattern = Pattern.compile("auditNumber");
                            Matcher matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
                            if (matcher.find()) {
                                needApprove = false;
                                break;
                            }
                            pattern = Pattern.compile(sequenceFlow.getSourceFlowElement().getId() + "AuditNumber");
                            matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
                            if (!matcher.find()) continue;
                            needApprove = false;
                            break;
                        }
                        if (needApprove) {
                            String info7 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879 \u9a73\u56de\u65f6\u53ef\u9009\u8282\u70b9\u4e3a\u7a7a\uff0c\u5982\u65e0\u53ef\u9009\u6570\u636e\u53ef\u5ffd\u7565\u6b64\u9879", (String)"AuditTaskValidator_15", (String)"bos-wf-engine", (Object[])new Object[0]);
                            if ("forceReject".equals(auditType)) {
                                info7 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879 \u5f3a\u5236\u9a73\u56de\u65f6\u53ef\u9009\u8282\u70b9\u4e3a\u7a7a\uff0c\u5982\u65e0\u53ef\u9009\u6570\u636e\u53ef\u5ffd\u7565\u6b64\u9879", (String)"AuditTaskValidator_93", (String)"bos-wf-engine", (Object[])new Object[0]);
                            }
                            ValidationError validationError9 = ValidatorUtil.getValidationError(keyMap);
                            validationError9.setInfo(info7);
                            validationError9.setObjType(objType2);
                            validationError9.setInfoType("warning");
                            validationError9.setProperty("decisionOptions");
                            errors.add(validationError9);
                        }
                    } else {
                        BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
                        ArrayList<String> preNodeIds = new ArrayList<String>(bpmnModel.getMainProcess().getFlowElementList().size());
                        this.getPreNodeIds(auditTask, preNodeIds);
                        for (SelectNodesModel selectNodesModel : rejectOptions) {
                            if (preNodeIds.contains(selectNodesModel.getItemId())) continue;
                            ValidationError validationError10 = ValidatorUtil.getValidationError(keyMap);
                            validationError10.setInfo(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879 %s \u53ef\u9009\u8282\u70b9\u7684\u524d\u5e8f\u8282\u70b9\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"AuditTaskValidator_94", (String)"bos-wf-engine", (Object[])new Object[0]), decisionOption.getName()));
                            validationError10.setObjType(ResManager.loadKDString((String)"\u51b3\u7b56\u9879", (String)"AuditTaskValidator_95", (String)"bos-wf-engine", (Object[])new Object[0]));
                            validationError10.setInfoType("error");
                            errors.add(validationError10);
                        }
                    }
                }
                if (!decisionOption.isDefaultDecision()) continue;
                ++defaultDecisionOptions;
            }
            if (defaultDecisionOptions > 1) {
                validationError2 = ValidatorUtil.getValidationError(keyMap);
                ((ValidationError)validationError2).setInfo(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u5b58\u5728\u591a\u4e2a\u9ed8\u8ba4\u51b3\u7b56\u9879\uff0c\u8bf7\u4fee\u6539", (String)"AuditTaskValidator_96", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0]));
                ((ValidationError)validationError2).setObjType(ResManager.loadKDString((String)"\u51b3\u7b56\u9879", (String)"AuditTaskValidator_95", (String)"bos-wf-engine", (Object[])new Object[0]));
                ((ValidationError)validationError2).setInfoType("error");
                errors.add((ValidationError)validationError2);
            }
        }
        if (StringUtils.isEmpty((CharSequence)auditTask.getOperationStr())) {
            String info8 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_16", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationError validationError11 = ValidatorUtil.getValidationError(keyMap);
            validationError11.setInfo(info8);
            validationError11.setObjType(objType2);
            validationError11.setProperty("decisionOptions");
            errors.add(validationError11);
        }
        if (null != (batchApprove = auditTask.getBatchApprove()) && batchApprove.isBatchApprove() && WfUtils.isEmpty(batchApprove.getBatchApproveDec())) {
            String info9 = ResManager.loadKDString((String)"\u6279\u91cf\u540c\u610f \u51b3\u7b56\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_53", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationError validationError12 = ValidatorUtil.getValidationError(keyMap);
            validationError12.setInfo(info9);
            validationError12.setObjType(objType1);
            validationError12.setProperty("batchApproveDec");
            errors.add(validationError12);
        }
        if (null != (batchReject = auditTask.getBatchReject()) && batchReject.isBatchReject()) {
            if (WfUtils.isEmpty(batchReject.getBatchRejectDec())) {
                String info10 = ResManager.loadKDString((String)"\u6279\u91cf\u9a73\u56de\u51b3\u7b56\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_54", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError2 = ValidatorUtil.getValidationError(keyMap);
                ((ValidationError)validationError2).setInfo(info10);
                ((ValidationError)validationError2).setObjType(objType1);
                ((ValidationError)validationError2).setProperty("batchRejectDec");
                errors.add((ValidationError)validationError2);
            }
            String decisionScene = null;
            for (DecisionOption op : decisionOptions) {
                if (!op.getNumber().equals(batchReject.getBatchRejectDec())) continue;
                decisionScene = op.getDecisionScene();
            }
            if (WfUtils.isEmpty(batchReject.getBatchRejectNode()) && !"rejectToPreAuditNode".equals(decisionScene) && !"rejectToParentProcEditNode".equals(decisionScene)) {
                String info11 = ResManager.loadKDString((String)"\u6279\u91cf\u9a73\u56de\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_48", (String)"bos-wf-engine", (Object[])new Object[0]);
                ValidationError validationError13 = ValidatorUtil.getValidationError(keyMap);
                validationError13.setInfo(info11);
                validationError13.setObjType(objType1);
                validationError13.setProperty("batchRejectNode");
                errors.add(validationError13);
            }
        }
        if ((allowNextPersonSettingModel = auditTask.getAllowNextPersonSettingModel()) != null && allowNextPersonSettingModel.isAllowNextPersonWhenMatch() && (allowNextPersonSetting = allowNextPersonSettingModel.getAllowNextPersonSetting()) != null && "assign".equals(personScene = allowNextPersonSetting.getAllowNextPersonScene()) && StringUtils.isBlank((CharSequence)(nextNodeAssignValue = allowNextPersonSetting.getSceneNextNodeAssignValue()))) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            String info12 = ResManager.loadKDString((String)"\u540e\u7eed\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"MainProcessValidator_24", (String)"bos-wf-engine", (Object[])new Object[0]);
            ((ValidationError)validationError).setInfo(info12);
            ((ValidationError)validationError).setObjType(ResManager.loadKDString((String)"\u6307\u5b9a\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_51", (String)"bos-wf-engine", (Object[])new Object[0]));
            ((ValidationError)validationError).setInfoType("error");
            ((ValidationError)validationError).setProperty("allowNextPersonSetting");
            errors.add((ValidationError)validationError);
        }
        if ((circulateModel = auditTask.getCirculateModel()) != null && circulateModel.getCirculate() != null && circulateModel.isCirculateWhenMatch() && (trigger = circulateModel.getCirculate().getTrigger()) != null && CollectionUtils.isNotEmpty(decisionOptions) && !"start".equals(trigger) && !"end".equals(trigger)) {
            Boolean flag = Boolean.FALSE;
            for (DecisionOption option : decisionOptions) {
                String optionNumber = option.getNumber();
                if (!trigger.equals(optionNumber)) continue;
                flag = Boolean.TRUE;
                break;
            }
            if (!flag.booleanValue()) {
                validationError = ValidatorUtil.getValidationError(keyMap);
                ((ValidationError)validationError).setInfo(ResManager.loadKDString((String)"\u81ea\u52a8\u4f20\u9605\u7684\u89e6\u53d1\u65f6\u673a\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_50", (String)"bos-wf-engine", (Object[])new Object[0]));
                ((ValidationError)validationError).setObjType(ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"AuditTaskValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]));
                ((ValidationError)validationError).setInfoType("warning");
                ((ValidationError)validationError).setProperty("circulate");
                errors.add((ValidationError)validationError);
            }
        }
        super.validateSensitiveField(auditTask, errors, keyMap);
    }

    private void getPreNodeIds(FlowNode flowNode, List<String> preNodeIds) {
        List<SequenceFlow> incomingFlows = flowNode.getIncomingFlows();
        if (!incomingFlows.isEmpty()) {
            for (SequenceFlow sequenceFlow : incomingFlows) {
                FlowNode sourceFlowNode;
                if (null == sequenceFlow.getSourceFlowElement() || preNodeIds.contains((sourceFlowNode = (FlowNode)sequenceFlow.getSourceFlowElement()).getId())) continue;
                preNodeIds.add(sourceFlowNode.getId());
                this.getPreNodeIds(sourceFlowNode, preNodeIds);
            }
        }
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMapIn) {
        List<AuditPoint> auditPoints;
        AuditPointModel auditPointModel;
        ConditionalRuleEntityImpl conditionalRule;
        List<ExtendBtn> extendBtns;
        String operationWhenSubmit;
        String operationWhenSave;
        String operationWhenReject;
        ValidationInfo validationInfo;
        String info;
        String endType;
        BillSetting billSetting;
        String formKey;
        ValidationInfo validationInfo2;
        String info2;
        String entraBill;
        ParticipantRangeSettingModel participantRangeSetting;
        BatchRejectModel batchReject;
        String approveDec;
        ValidationInfo validationInfo3;
        String info3;
        List<DecisionOption> decisionOptions;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>(3);
        keyMap.putAll(keyMapIn);
        AuditTask auditTask = (AuditTask)flowElement;
        if (StringUtils.isEmpty((CharSequence)auditTask.getEntityNumber())) {
            return;
        }
        ParticipatantModel participantModel = auditTask.getParticipant();
        if (null != participantModel) {
            List<ParticipantModelEntityImpl> participant = participantModel.getParticipant();
            keyMap.put("objType", ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"AuditTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            if (participantModel.isAllowNoneParticipant()) {
                keyMap.put("infoType", "warning");
            }
            ValidatorUtil.collectValidationDatasFromParticipant(process, participant, validationDatas, keyMap, null);
            String expressionExtResult = ValidatorUtil.checkoutExpressionExt(participantModel.isDisplaySetting(), participantModel.getDisplayInfo());
            if (WfUtils.isNotEmpty(expressionExtResult)) {
                String info4 = String.format(ResManager.loadKDString((String)"\u5bf9\u8c61\u6269\u5c55\u5c5e\u6027 %1$s\u4e0d\u5b58\u5728 ", (String)"AuditTaskValidator_17", (String)"bos-wf-engine", (Object[])new Object[0]), expressionExtResult);
                String objType = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"AuditTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
                ValidationInfo validationInfo4 = ValidatorUtil.buildValidationInfo(keyMap);
                validationInfo4.setInfo(info4);
                validationInfo4.setObjType(objType);
                validationInfo4.setProperty("displayInfo");
                validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo4));
            }
        }
        keyMap.put("infoType", "error");
        Set<String> canRejectTaskIds = ValidatorUtil.getCanRejectTaskInfos(process);
        HashSet<String> rightTaskIds = new HashSet<String>();
        HashSet<String> rightAuditNumber = new HashSet<String>();
        List<Object> rightNodes = new ArrayList();
        try {
            BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
            rightNodes = BpmnModelUtil.getRejectNodes(bpmnModel, auditTask.getId());
        }
        catch (Exception e) {
            this.logger.error("get reject nodes failed!" + WfUtils.getExceptionStacktrace(e));
        }
        if (!rightNodes.isEmpty()) {
            for (int i = 0; i < rightNodes.size(); ++i) {
                FlowElement fe = (FlowElement)rightNodes.get(i);
                rightTaskIds.add(fe.getId());
            }
        }
        if ((decisionOptions = auditTask.getDecisionOptions()) != null && !decisionOptions.isEmpty()) {
            for (DecisionOption decisionOption : decisionOptions) {
                List<SelectNodesModel> rejectOptions;
                String auditType = decisionOption.getAuditType();
                if (WfUtils.isNotEmpty(decisionOption.getNumber())) {
                    rightAuditNumber.add(decisionOption.getNumber());
                }
                if (!"reject".equals(auditType) || null == (rejectOptions = decisionOption.getRejectOptions()) || rejectOptions.isEmpty()) continue;
                for (SelectNodesModel selectNodesModel : rejectOptions) {
                    String itemId = selectNodesModel.getItemId();
                    String itemName = selectNodesModel.getName();
                    String objType = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"AuditTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
                    if (!canRejectTaskIds.contains(itemId)) {
                        info3 = String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u53ef\u9a73\u56de\u8282\u70b9(%1$s)\u4e0d\u5b58\u5728", (String)"AuditTaskValidator_109", (String)"bos-wf-engine", (Object[])new Object[0]), itemName);
                        validationInfo3 = ValidatorUtil.buildValidationInfo(keyMap);
                        validationInfo3.setInfo(info3);
                        validationInfo3.setObjType(objType);
                        validationInfo3.setInfoType("systemError");
                        validationInfo3.setProperty("decisionOptions");
                        validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo3));
                        continue;
                    }
                    if (rightTaskIds.contains(itemId)) continue;
                    info3 = String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u53ef\u9a73\u56de\u8282\u70b9(%1$s)\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"AuditTaskValidator_108", (String)"bos-wf-engine", (Object[])new Object[0]), itemName);
                    validationInfo3 = ValidatorUtil.buildValidationInfo(keyMap);
                    validationInfo3.setInfo(info3);
                    validationInfo3.setObjType(objType);
                    validationInfo3.setInfoType("systemError");
                    validationInfo3.setProperty("decisionOptions");
                    validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo3));
                }
            }
        }
        String objType2 = ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"AuditTaskValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        BatchApproveModel batchApprove = auditTask.getBatchApprove();
        if (null != batchApprove && batchApprove.isBatchApprove() && WfUtils.isNotEmpty(approveDec = batchApprove.getBatchApproveDec()) && !rightAuditNumber.contains(approveDec)) {
            String info5 = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u540c\u610f\u51b3\u7b56\u9879\u9519\u8bef(%1$s)", (String)"AuditTaskValidator_191", (String)"bos-wf-engine", (Object[])new Object[0]), batchApprove.getBatchApproveDec());
            ValidationInfo validationInfo5 = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo5.setInfo(info5);
            validationInfo5.setObjType(objType2);
            validationInfo5.setInfoType("systemError");
            validationInfo5.setProperty("batchApproveDec");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo5));
        }
        if (null != (batchReject = auditTask.getBatchReject()) && batchReject.isBatchReject()) {
            String rNodeId;
            String rejectDec = batchReject.getBatchRejectDec();
            if (WfUtils.isNotEmpty(rejectDec) && !rightAuditNumber.contains(rejectDec)) {
                String info6 = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u9a73\u56de\u51b3\u7b56\u9879\u9519\u8bef(%1$s)", (String)"AuditTaskValidator_92", (String)"bos-wf-engine", (Object[])new Object[0]), batchReject.getBatchRejectDec());
                ValidationInfo validationInfo6 = ValidatorUtil.buildValidationInfo(keyMap);
                validationInfo6.setInfo(info6);
                validationInfo6.setObjType(objType2);
                validationInfo6.setInfoType("systemError");
                validationInfo6.setProperty("batchRejectDec");
                validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo6));
            }
            if (WfUtils.isNotEmpty(rNodeId = batchReject.getBatchRejectNode()) && !rightTaskIds.contains(rNodeId)) {
                String info7 = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u9a73\u56de\u8282\u70b9(%1$s)\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"AuditTaskValidator_192", (String)"bos-wf-engine", (Object[])new Object[0]), rNodeId);
                ValidationInfo validationInfo7 = ValidatorUtil.buildValidationInfo(keyMap);
                validationInfo7.setInfo(info7);
                validationInfo7.setObjType(objType2);
                validationInfo7.setInfoType("systemError");
                validationInfo7.setProperty("batchRejectNode");
                validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo7));
            }
        }
        if ((participantRangeSetting = auditTask.getParticipantRangeSetting()) != null && null != participantModel && participantModel.isPersonrangeformanual()) {
            List<ParticipantModelEntityImpl> participantAllow = participantRangeSetting.getParticipantAllow();
            keyMap.put("info", ResManager.loadKDString((String)"\u53ef\u9009\u53c2\u4e0e\u4eba\u8303\u56f4  ", (String)"AuditTaskValidator_22", (String)"bos-wf-engine", (Object[])new Object[0]));
            ValidatorUtil.collectValidationDatasFromParticipant(process, participantAllow, validationDatas, keyMap, null);
            List<ParticipantModelEntityImpl> participantBlackList = participantRangeSetting.getParticipantBlackList();
            keyMap.put("info", ResManager.loadKDString((String)"\u4e0d\u53ef\u9009\u4eba\u5458 ", (String)"AuditTaskValidator_23", (String)"bos-wf-engine", (Object[])new Object[0]));
            ValidatorUtil.collectValidationDatasFromParticipant(process, participantBlackList, validationDatas, keyMap, null);
        }
        String objType1 = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AuditTaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        String entityNumber = auditTask.getEntityNumber();
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            String info8 = String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)", (String)"AuditTaskValidator_124", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask.getEntityName());
            ValidationInfo validationInfo8 = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo8.setInfo(info8);
            validationInfo8.setObjType(objType1);
            validationInfo8.setProperty("entityNumber");
            validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", entityNumber, validationInfo8));
        }
        if (WfUtils.isNotEmpty(entraBill = (String)keyMap.get("entityNumber")) && !entraBill.equals(entityNumber)) {
            info2 = String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)\u4e0e\u6d41\u7a0b\u5355\u636e\u4e0d\u4e00\u81f4", (String)"AuditTaskValidator_125", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask.getEntityName());
            validationInfo2 = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo2.setInfo(info2);
            validationInfo2.setObjType(objType1);
            validationInfo2.setInfoType("warning");
            validationInfo2.setProperty("entityNumber");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo2));
        }
        if (StringUtils.isNotEmpty((CharSequence)auditTask.getProcessingPage()) && !"wf_approvalpage".equals(auditTask.getProcessingPage())) {
            info2 = String.format(ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762 \u5355\u636e(%1$s)", (String)"AuditTaskValidator_126", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask.getProcessingPage());
            validationInfo2 = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo2.setInfo(info2);
            validationInfo2.setObjType(objType1);
            validationInfo2.setProperty("processingPage");
            validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", auditTask.getProcessingPage(), validationInfo2));
        }
        if (StringUtils.isNotEmpty((CharSequence)(formKey = (billSetting = auditTask.getBillSetting()).getFormKey()))) {
            info3 = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u5185\u5d4c\u5355\u636e\u9875\u9762 ", (String)"AuditTaskValidator_27", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationInfo3 = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo3.setInfo(info3);
            validationInfo3.setObjType(objType1);
            validationInfo3.setProperty("processingMobilePage");
            validationDatas.add(ValidatorUtil.getValidationDataByBillEmbedded("bill", formKey, validationInfo3, entityNumber));
        }
        if ("all".equals(endType = auditTask.getEndType()) || "mobile".equals(endType)) {
            String mobilFormKey;
            String infoType1 = (String)keyMap.get("infoType");
            if ("all".equals(endType)) {
                infoType1 = "warning";
            }
            if (StringUtils.isNotEmpty((CharSequence)auditTask.getProcessingMobilePage())) {
                String info9 = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762 \u5355\u636e(%1$s)", (String)"AuditTaskValidator_128", (String)"bos-wf-engine", (Object[])new Object[0]), auditTask.getProcessingMobilePage());
                ValidationInfo validationInfo9 = ValidatorUtil.buildValidationInfo(keyMap);
                validationInfo9.setInfo(info9);
                validationInfo9.setObjType(objType1);
                validationInfo9.setInfoType(infoType1);
                validationInfo9.setProperty("processingMobilePage");
                validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", auditTask.getProcessingMobilePage(), validationInfo9));
            }
            if (StringUtils.isNotEmpty((CharSequence)(mobilFormKey = billSetting.getMobilFormKey())) && !"billSummary".equals(mobilFormKey)) {
                if (mobilFormKey.endsWith("$") || mobilFormKey.indexOf("_@_") != -1) {
                    info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u5185\u5d4c\u5355\u636e\u9875\u9762", (String)"AuditTaskValidator_29", (String)"bos-wf-engine", (Object[])new Object[0]);
                    validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    validationInfo.setInfo(info);
                    validationInfo.setObjType(objType1);
                    validationInfo.setInfoType(infoType1);
                    validationInfo.setProperty("mobilFormKey");
                    validationDatas.add(ValidatorUtil.getValidationDataByBillSummary("billsummary", mobilFormKey, validationInfo));
                } else {
                    info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u5185\u5d4c\u5355\u636e\u9875\u9762 ", (String)"AuditTaskValidator_30", (String)"bos-wf-engine", (Object[])new Object[0]);
                    validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    validationInfo.setInfo(info);
                    validationInfo.setObjType(objType1);
                    validationInfo.setInfoType(infoType1);
                    validationInfo.setProperty("mobilFormKey");
                    validationDatas.add(ValidatorUtil.getValidationDataByBillEmbedded("bill", mobilFormKey, validationInfo, entityNumber));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(operationWhenReject = billSetting.getOperationWhenReject()))) {
            ValidationInfo validationInfo10 = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo10.setObjType(objType1);
            validationInfo10.setProperty("operationWhenReject");
            if (ExternalInterfaceUtil.isValidValue(operationWhenReject)) {
                validationInfo10.setInfo(ResManager.loadKDString((String)"\u9a73\u56de\u63d0\u4ea4\u65f6\u6821\u9a8c ", (String)"AuditTaskValidator_46", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationDatas.add(ValidatorUtil.getValidationDataByExtItf(entityNumber, operationWhenReject, validationInfo10));
            } else {
                validationInfo10.setInfo(ResManager.loadKDString((String)"\u9a73\u56de\u63d0\u4ea4\u65f6\u6821\u9a8c \u64cd\u4f5c", (String)"AuditTaskValidator_31", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", entityNumber, operationWhenReject, validationInfo10));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(operationWhenSave = billSetting.getOperationWhenSave())) && billSetting.isFieldModified()) {
            info = ResManager.loadKDString((String)"\u4fdd\u5b58\u5355\u636e\u4fee\u6539\u65f6\u8c03\u7528\u5355\u636e \u64cd\u4f5c ", (String)"AuditTaskValidator_32", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType1);
            validationInfo.setProperty("operationWhenSave");
            validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", entityNumber, operationWhenSave, validationInfo));
        }
        if (StringUtils.isNotBlank((CharSequence)(operationWhenSubmit = billSetting.getOperationWhenSubmit()))) {
            validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo.setObjType(objType1);
            validationInfo.setProperty("operationWhenSubmit");
            if (ExternalInterfaceUtil.isValidValue(operationWhenSubmit)) {
                validationInfo.setInfo(ResManager.loadKDString((String)"\u540c\u610f\u63d0\u4ea4\u65f6\u6821\u9a8c ", (String)"AuditTaskValidator_47", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationDatas.add(ValidatorUtil.getValidationDataByExtItf(entityNumber, operationWhenSubmit, validationInfo));
            } else {
                validationInfo.setInfo(ResManager.loadKDString((String)"\u540c\u610f\u63d0\u4ea4\u65f6\u6821\u9a8c \u64cd\u4f5c", (String)"AuditTaskValidator_33", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", entityNumber, operationWhenSubmit, validationInfo));
            }
        }
        this.collectMsgInfo(process, validationDatas, keyMap, auditTask, null);
        BtnModel btnModel = auditTask.getBtnModel();
        if (btnModel != null && (extendBtns = btnModel.getExtendBtns()) != null && extendBtns.size() > 0) {
            for (ExtendBtn extendBtn : extendBtns) {
                if (!StringUtils.isNotEmpty((CharSequence)extendBtn.getOperationNumber()) || !StringUtils.isNotEmpty((CharSequence)extendBtn.getBtnName()) || !StringUtils.isNotEmpty((CharSequence)extendBtn.getBtnNumber())) continue;
                String info10 = String.format(ResManager.loadKDString((String)"\u6269\u5c55\u4e1a\u52a1\u6309\u94ae \u64cd\u4f5c %1$s ", (String)"AuditTaskValidator_137", (String)"bos-wf-engine", (Object[])new Object[0]), extendBtn.getBtnName());
                ValidationInfo validationInfo11 = ValidatorUtil.buildValidationInfo(keyMap);
                validationInfo11.setInfo(info10);
                validationInfo11.setObjType(objType2);
                validationInfo11.setProperty("extendBtns");
                validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", entityNumber, extendBtn.getOperationNumber(), validationInfo11));
            }
        }
        this.collectSkipRuleInfo(process, validationDatas, keyMap, auditTask, null);
        this.collectCirculateInfo(process, validationDatas, keyMap, auditTask, null);
        if (null != auditTask.getAutoAudit() && auditTask.getAutoAudit().isAutoAuditWhenMatch() && null != (conditionalRule = auditTask.getAutoAudit().getAutoAuditCondition())) {
            keyMap.put("objType", objType2);
            keyMap.put("info", ResManager.loadKDString((String)"\u81ea\u52a8\u5ba1\u6279\u6761\u4ef6 ", (String)"AuditTaskValidator_40", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("ruleType", conditionalRule.getType());
            ValidatorUtil.collectValidationDatasFromConditionRules(process, conditionalRule.getEntryentity(), validationDatas, keyMap, null);
            ValidatorUtil.validateAfterAuditFromConditionRules(process, conditionalRule.getExpression(), validationDatas, keyMap);
        }
        if (null != (auditPointModel = auditTask.getAuditPointModel()) && auditPointModel.isAuditPointWhenMatch() && null != (auditPoints = auditPointModel.getAuditPoints()) && auditPoints.size() > 0) {
            for (AuditPoint auditPoint : auditPoints) {
                ConditionalRuleEntity condRule = auditPoint.getBizrule();
                if (null == condRule) continue;
                keyMap.put("objType", objType2);
                keyMap.put("info", ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9 \u81ea\u52a8\u68c0\u67e5\u9879\u4e1a\u52a1\u89c4\u5219 ", (String)"AuditTaskValidator_41", (String)"bos-wf-engine", (Object[])new Object[0]));
                keyMap.put("ruleType", condRule.getType());
                ValidatorUtil.collectValidationDatasFromConditionRules(process, condRule.getEntryentity(), validationDatas, keyMap, null);
            }
        }
        this.collectPluginInfo(validationDatas, keyMap, auditTask);
    }

    protected void validateDataSigned(AuditTask auditTask, List<ValidationError> errors, String info, String objType, Map<String, Object> keyMap) {
        BillSetting billSetting = auditTask.getBillSetting();
        if (billSetting != null && WfConfigurationUtil.needDataSigned() && (billSetting.isDataSignedVerify() || billSetting.isDataSignedAdd())) {
            String errorInfo = ResManager.loadKDString((String)"\u4e0e\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u3001\u6dfb\u52a0\u6570\u5b57\u7b7e\u540d\u4e0d\u80fd\u540c\u65f6\u5f00\u542f\u3002", (String)"AuditTaskValidator_51", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            validationError.setInfo(ValidatorUtil.strConcat(info, errorInfo));
            validationError.setObjType(objType);
            validationError.setInfoType("warning");
            errors.add(validationError);
        }
    }
}

