/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class AutoTaskValidator
extends BaseElementValidatorImpl {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        super.validateBaseInfo(flowElement, errors, keyMap);
        AutoTask autoTask = (AutoTask)flowElement;
        String objType = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AutoTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)autoTask.getEntityId())) {
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            String info = ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AutoTaskValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType);
            errors.add(validationError);
        }
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMapIn) {
        List<String> extItfs;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        AutoTask autoTask = (AutoTask)flowElement;
        String entityId = autoTask.getEntityId();
        String entityNumber = MetadataDao.getEntityNumberById((String)entityId);
        String objType = ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f", (String)"AutoTaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)", (String)"AutoTaskValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]), autoTask.getEntityName());
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType);
            validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", entityNumber, validationInfo));
        }
        String entraBill = (String)keyMap.get("entityNumber");
        BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
        if (bpmnModel != null && ProcessType.AuditFlow.name().equals(bpmnModel.getMainProcess().getProcessType()) && WfUtils.isNotEmpty(entraBill) && !entraBill.equals(entityNumber)) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)\u4e0e\u6d41\u7a0b\u5355\u636e\u4e0d\u4e00\u81f4", (String)"AutoTaskValidator_26", (String)"bos-wf-engine", (Object[])new Object[0]), autoTask.getEntityName());
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType);
            validationInfo.setInfoType("warning");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
        }
        if ((extItfs = autoTask.getExtItf()) != null && extItfs.size() > 0) {
            for (String extItf : extItfs) {
                String classname;
                JSONObject value;
                JSONObject extItfObject = (JSONObject)JSONObject.parse((String)extItf);
                String type = extItfObject.getString("type");
                if ("operation".equals(type)) {
                    String info;
                    ValidationInfo validationInfo;
                    value = extItfObject.getJSONObject("value");
                    String operation = value.getString("forward");
                    String reOperation = value.getString("withdraw");
                    if (StringUtils.isNotBlank((CharSequence)operation)) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        info = String.format(ResManager.loadKDString((String)"\u670d\u52a1\u4fe1\u606f \u64cd\u4f5c %s", (String)"AutoTaskValidator_27", (String)"bos-wf-engine", (Object[])new Object[0]), value.getString("forward_name"));
                        validationInfo.setInfo(info);
                        validationInfo.setObjType(objType);
                        validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", entityNumber, operation, validationInfo));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)reOperation)) continue;
                    validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    info = String.format(ResManager.loadKDString((String)"\u670d\u52a1\u4fe1\u606f \u64cd\u4f5c %s", (String)"AutoTaskValidator_27", (String)"bos-wf-engine", (Object[])new Object[0]), value.getString("withdraw_name"));
                    validationInfo.setInfo(info);
                    validationInfo.setObjType(objType);
                    validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", entityNumber, reOperation, validationInfo));
                    continue;
                }
                if (!"script".equals(type) || !StringUtils.isNotBlank((CharSequence)(classname = (value = extItfObject.getJSONObject("value")).getString("number")))) continue;
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String info = String.format(ResManager.loadKDString((String)"\u670d\u52a1\u4fe1\u606f \u811a\u672c(%s)", (String)"AutoTaskValidator_28", (String)"bos-wf-engine", (Object[])new Object[0]), classname);
                validationInfo.setInfo(info);
                validationInfo.setObjType(objType);
                validationDatas.add(ValidatorUtil.getValidationDataByKSScript("ks", classname, validationInfo));
            }
        }
        List<MessageSendModel> inMsg = autoTask.getInMsg();
        keyMap.put("objType", ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5", (String)"AutoTaskValidator_7", (String)"bos-wf-engine", (Object[])new Object[0]));
        keyMap.put("info", ResManager.loadKDString((String)"\u8fdb\u5165\u8282\u70b9\u65f6\u6d88\u606f ", (String)"AutoTaskValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]));
        String bizEntityNumber = ConditionalRuleHelper.getEntryBillNumber(process, autoTask.getId(), false);
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, inMsg, validationDatas, keyMap, bizEntityNumber);
        List<MessageSendModel> outMsg = autoTask.getOutMsg();
        keyMap.put("info", ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6\u6d88\u606f ", (String)"AutoTaskValidator_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, outMsg, validationDatas, keyMap, bizEntityNumber);
    }
}

