/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class BillCallActivityValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getBillCallActivity();
        if (null != validationDatas && validationDatas.size() > 0) {
            HashSet<String> billNumbers = new HashSet<String>(validationDatas.size());
            for (ValidationData data : validationDatas) {
                billNumbers.add(data.getBillNumber());
            }
            QFilter keyFilter = new QFilter("entrabill", "in", billNumbers);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"enable");
            QFilter typeFilter = new QFilter("type", "=", (Object)ProcessType.AuditFlow.name());
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"wf_processdefinition", (String)"id,entrabill", (QFilter[])new QFilter[]{keyFilter, enableFilter, typeFilter});
            HashSet<String> billExist = new HashSet<String>(validationDatas.size());
            if (loads.length > 0) {
                for (DynamicObject load : loads) {
                    billExist.add(load.getString("entrabill"));
                }
            }
            for (ValidationData validationData : validationDatas) {
                if (!billExist.contains(validationData.getBillNumber())) continue;
                ValidationInfo vInfo = validationData.getValidationInfo();
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String showInfo = String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u5ba1\u6279\u6d41\uff0c\u8bf7\u5728\u5b50\u6d41\u7a0b\u914d\u7f6e\u4e2d\u8fdb\u884c\u914d\u7f6e", (String)"BillCallActivityValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]), validationData.getBillName());
                String info = ValidatorUtil.strConcat(vInfo.getInfo(), showInfo);
                validationError.setInfo(info);
                errors.add(validationError);
            }
        }
    }
}

