/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.List;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class BillFieldValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getBillField();
        if (null != validationDatas && validationDatas.size() > 0) {
            for (ValidationData validationData : validationDatas) {
                MainEntityType dataEntity;
                String billNumber = validationData.getBillNumber();
                String billField = validationData.getBillField();
                if (billField.contains(".")) {
                    billField = billField.split("\\.")[0];
                }
                if ((dataEntity = EntityMetadataCache.getDataEntityType((String)billNumber)) == null || dataEntity.getProperty(billField) != null) continue;
                ValidationInfo vInfo = validationData.getValidationInfo();
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info = String.format(vInfo.getInfo(), "(", dataEntity.getDisplayName(), ")");
                validationError.setInfo(info);
                errors.add(validationError);
            }
        }
    }
}

