/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class BillOperationValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getOperations();
        if (validationDatas != null && validationDatas.size() > 0) {
            int size = validationDatas.size();
            HashSet<String> billNumbers = new HashSet<String>(size);
            HashMap<String, ValidationData> vdMap = new HashMap<String, ValidationData>(size);
            HashSet<String> emptyFormIds = new HashSet<String>(size);
            for (ValidationData validationData : validationDatas) {
                billNumbers.add(validationData.getBillNumber());
                vdMap.put(validationData.getBillNumber(), validationData);
            }
            if (billNumbers.size() > 0) {
                ValidationInfo vInfo;
                HashMap billsOperationsInfos = new HashMap(billNumbers.size());
                Iterator<Object> iterator = billNumbers.iterator();
                while (iterator.hasNext()) {
                    MetadataReader reader = new MetadataReader();
                    String billNumber = (String)iterator.next();
                    String formId = reader.loadIdByNumber(billNumber, MetaCategory.Form);
                    if (formId == null) {
                        ValidationData vData = (ValidationData)vdMap.get(billNumber);
                        vInfo = vData.getValidationInfo();
                        ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                        String info = ValidatorUtil.strConcat(vInfo.getInfo(), billNumber, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BillOperationValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                        validationError.setInfo(info);
                        errors.add(validationError);
                        emptyFormIds.add(billNumber);
                        continue;
                    }
                    FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
                    String entityId = formMetadata.getEntityId();
                    EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
                    List operations = metadata.getRootEntity().getOperations();
                    int infoSize = operations == null ? 0 : operations.size();
                    HashMap<String, Operation> billOperationsInfos = new HashMap<String, Operation>(infoSize);
                    if (null != operations && !operations.isEmpty()) {
                        for (Operation operation : operations) {
                            billOperationsInfos.put(operation.getKey(), operation);
                        }
                    }
                    billsOperationsInfos.put(billNumber, billOperationsInfos);
                }
                for (ValidationData validationData : validationDatas) {
                    Map billOperaionInfos;
                    Operation operation;
                    String billNumber = validationData.getBillNumber();
                    if (emptyFormIds.contains(billNumber) || (operation = (Operation)(billOperaionInfos = (Map)billsOperationsInfos.get(billNumber)).get(validationData.getBillOperation())) != null) continue;
                    vInfo = validationData.getValidationInfo();
                    String operationCode = validationData.getBillOperation();
                    ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                    String info = ValidatorUtil.strConcat(vInfo.getInfo(), operationCode, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BillOperationValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                    validationError.setInfo(info);
                    errors.add(validationError);
                }
            }
        }
    }
}

