/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class BillSummaryValidator
extends DataValidatorImpl {
    private static final String NUMBER = "number";

    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getSummarys();
        ArrayList<ValidationData> oldValidationDatas = new ArrayList<ValidationData>();
        ArrayList<ValidationData> newValidationDatas = new ArrayList<ValidationData>();
        HashSet<String> oldBillSummary = new HashSet<String>();
        HashSet<String> newBillSummary = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(validationDatas)) {
            for (ValidationData validationData : validationDatas) {
                String[] split;
                String billSummary = validationData.getBillSummary();
                if (StringUtils.isEmpty((CharSequence)billSummary)) continue;
                if (billSummary.endsWith("$")) {
                    newBillSummary.add(billSummary.substring(0, billSummary.length() - 1));
                    newValidationDatas.add(validationData);
                    continue;
                }
                if (billSummary.indexOf("_@_") == -1 || (split = billSummary.split("_@_")).length != 2) continue;
                oldBillSummary.add(split[1]);
                oldValidationDatas.add(validationData);
            }
            this.validateNewBillSummary(newValidationDatas, newBillSummary, errors);
            this.validateOldBillSummary(oldValidationDatas, oldBillSummary, errors);
        }
    }

    private void validateOldBillSummary(List<ValidationData> oldValidationDatas, Set<String> oldBillSummary, List<ValidationError> errors) {
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "in", oldBillSummary)};
        String selectFields = "number,enable,billtype,entryentity.fieldkey,entryentity.fieldname";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_mobileformconfig", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> summaryInfos = new HashMap<String, DynamicObject>();
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                summaryInfos.put(dynamicObject.getString(NUMBER), dynamicObject);
            }
        }
        String mobileDes = ResManager.loadKDString((String)"\u79fb\u52a8\u5355\u636e\u6458\u8981", (String)"BillSummaryValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        MetadataReader reader = new MetadataReader();
        for (ValidationData validationData : oldValidationDatas) {
            String billNumber;
            String billSummary = validationData.getBillSummary().split("_@_")[1];
            DynamicObject summaryInfo = (DynamicObject)summaryInfos.get(billSummary);
            ValidationInfo vInfo = validationData.getValidationInfo();
            String info = vInfo.getInfo();
            if (summaryInfo == null) {
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u4e0d\u5b58\u5728", (String)"BillSummaryValidator_100", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary));
                validationError.setInfo(info1);
                errors.add(validationError);
                continue;
            }
            boolean enable = summaryInfo.getBoolean("enable");
            if (!enable) {
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u672a\u542f\u7528", (String)"BillSummaryValidator_102", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary));
                validationError.setInfo(info1);
                errors.add(validationError);
            }
            if (StringUtils.isEmpty((CharSequence)(billNumber = summaryInfo.getString("billtype_id")))) {
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillSummaryValidator_103", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary));
                validationError.setInfo(info1);
                errors.add(validationError);
                continue;
            }
            String entityId = reader.loadIdByNumber(billNumber, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            Map<String, EntityItem<?>> mapItems = this.getItems(entityMetadata);
            DynamicObjectCollection fields = (DynamicObjectCollection)summaryInfo.get("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)fields)) continue;
            for (DynamicObject field : fields) {
                String fieldKey = field.getString("fieldkey");
                if (mapItems.get(fieldKey) != null) continue;
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff08\u65e7\uff09\u5b57\u6bb5%3$s(%4$s)\u4e0d\u5b58\u5728", (String)"BillSummaryValidator_104", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary, field.getString("fieldname"), fieldKey));
                validationError.setInfo(info1);
                errors.add(validationError);
            }
        }
    }

    private void validateNewBillSummary(List<ValidationData> newValidationDatas, Set<String> newBillSummary, List<ValidationError> errors) {
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "in", newBillSummary)};
        String selectFields = "number,enable,billtype,entryentity.fieldkey,entryentity.fieldname";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_mbillsummary_cfg", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> summaryInfos = new HashMap<String, DynamicObject>();
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                summaryInfos.put(dynamicObject.getString(NUMBER), dynamicObject);
            }
        }
        String mobileDes = ResManager.loadKDString((String)"\u79fb\u52a8\u5355\u636e\u6458\u8981", (String)"BillSummaryValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        MetadataReader reader = new MetadataReader();
        for (ValidationData validationData : newValidationDatas) {
            String billNumber;
            String billSummary = validationData.getBillSummary().substring(0, validationData.getBillSummary().length() - 1);
            DynamicObject summaryInfo = (DynamicObject)summaryInfos.get(billSummary);
            ValidationInfo vInfo = validationData.getValidationInfo();
            String info = vInfo.getInfo();
            if (summaryInfo == null) {
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u4e0d\u5b58\u5728", (String)"BillSummaryValidator_100", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary));
                validationError.setInfo(info1);
                errors.add(validationError);
                continue;
            }
            boolean enable = summaryInfo.getBoolean("enable");
            if (!enable) {
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u672a\u542f\u7528", (String)"BillSummaryValidator_102", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary));
                validationError.setInfo(info1);
                errors.add(validationError);
            }
            if (StringUtils.isEmpty((CharSequence)(billNumber = summaryInfo.getString("billtype_id")))) {
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillSummaryValidator_103", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary));
                validationError.setInfo(info1);
                errors.add(validationError);
                continue;
            }
            String entityId = reader.loadIdByNumber(billNumber, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            Map<String, EntityItem<?>> mapItems = this.getItems(entityMetadata);
            DynamicObjectCollection fields = (DynamicObjectCollection)summaryInfo.get("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)fields)) continue;
            for (DynamicObject field : fields) {
                String fieldKey = field.getString("fieldkey");
                if (mapItems.get(fieldKey) != null) continue;
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"%1$s(%2$s) \u5b57\u6bb5 %3$s(%4$s)\u4e0d\u5b58\u5728 ", (String)"BillSummaryValidator_106", (String)"bos-wf-engine", (Object[])new Object[0]), mobileDes, billSummary, field.getLocaleString("fieldname").getLocaleValue(), fieldKey));
                validationError.setInfo(info1);
                errors.add(validationError);
            }
        }
    }

    private Map<String, EntityItem<?>> getItems(EntityMetadata entityMetadata) {
        HashMap mapItems = new HashMap(2);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            mapItems.put(item.getKey(), item);
        }
        return mapItems;
    }
}

