/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicFormMappingEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class BillValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getBills();
        this.validateForDynamicFormMapping(validationDatas);
        HashSet<String> billNumbers = new HashSet<String>(2);
        for (ValidationData validationData : validationDatas) {
            billNumbers.add(validationData.getBillNumber());
        }
        String selectFields = "id,number,name,modeltype";
        QFilter idFilter = new QFilter("number", "in", billNumbers);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection billObjects = QueryServiceHelper.query((String)"bos_formmeta", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> billInfos = new HashMap<String, DynamicObject>();
        if (billObjects.size() > 0) {
            for (DynamicObject userObject : billObjects) {
                if ("BaseFormModel".equals(userObject.getString("modeltype")) || "BillFormModel".equals(userObject.getString("modeltype"))) {
                    billInfos.put(userObject.getString("number") + "_mob", userObject);
                }
                billInfos.put(userObject.getString("number"), userObject);
            }
        }
        for (ValidationData validationData : validationDatas) {
            String billNumber = validationData.getBillNumber();
            DynamicObject billInfo = (DynamicObject)billInfos.get(billNumber);
            if (billInfo != null) continue;
            ValidationInfo vInfo = validationData.getValidationInfo();
            ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
            String info = ValidatorUtil.strConcat(vInfo.getInfo(), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BillValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            validationError.setInfo(info);
            Map<String, Object> map = validationData.getGeneralMap();
            if (map != null && map.containsKey("isBizFlowEntityValid") && ((Boolean)map.get("isBizFlowEntityValid")).booleanValue()) {
                validationError.setActivityId((String)map.get("nodeId"));
                validationError.setEntityNumber(billNumber);
                validationError.setBizFlowEntityValidError(Boolean.TRUE);
            }
            errors.add(validationError);
        }
    }

    private void validateForDynamicFormMapping(List<ValidationData> validationDatas) {
        HashSet<String> entryBills = new HashSet<String>(2);
        for (ValidationData validationData : validationDatas) {
            if (null == validationData || null == validationData.getEntryBill()) continue;
            entryBills.add(validationData.getEntryBill());
        }
        if (entryBills.isEmpty()) {
            return;
        }
        Iterator<ValidationData> ite = validationDatas.iterator();
        ValidationData data = null;
        Object dynamicFormNumber = null;
        DynamicObject dynamicFormNumberObj = null;
        String billNumber = null;
        ManagementService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        List<DynamicFormMappingEntity> entityNumbers = service.getEnableDynamicFormMappingEntitiesByEntityNumbers(entryBills);
        for (DynamicFormMappingEntity entity : entityNumbers) {
            if (null == entity || null == (dynamicFormNumberObj = entity.getDynamicFormNumber()) || WfUtils.isEmptyString(dynamicFormNumber = dynamicFormNumberObj.get("number"))) continue;
            while (ite.hasNext()) {
                data = ite.next();
                if (null == data || null == (billNumber = data.getBillNumber())) continue;
                if (billNumber.contains("&mfm") && billNumber.split("&mfm")[0].equals(dynamicFormNumber)) {
                    ite.remove();
                    continue;
                }
                if (!billNumber.contains("&dfm") || !billNumber.split("&dfm")[0].equals(dynamicFormNumber)) continue;
                ite.remove();
            }
        }
    }
}

