/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.ValidatorImpl;

public class BpmnModelValidator
extends ValidatorImpl {
    private Log logger = LogFactory.getLog(this.getClass());

    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        boolean isAtLeastOneExecutable = this.validateAtLeastOneExecutable(bpmnModel, errors);
        if (isAtLeastOneExecutable) {
            for (Process process : bpmnModel.getProcesses()) {
                if (!process.isExecutable()) {
                    this.addWarning(errors, "activiti-specific-process-definition-not-executable", process, process, "Process definition is not executable. Please verify that this is intentional.");
                }
                this.handleProcessConstraints(bpmnModel, process, errors);
            }
        }
        this.handleBPMNModelConstraints(bpmnModel, errors);
    }

    protected void handleProcessConstraints(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        if (process.getId() != null && process.getId().length() > 255) {
            this.addError(errors, "activiti-process-definition-id-too-long", process, "The id of the process definition must not contain more than 255 characters");
        }
        if (process.getName() != null && process.getName().length() > 255) {
            this.addError(errors, "activiti-process-definition-name-too-long", process, "The name of the process definition must not contain more than 255 characters");
        }
        if (process.getDocumentation() != null && process.getDocumentation().length() > 2000) {
            this.addError(errors, "activiti-process-definition-documentation-too-long", process, "The documentation of the process definition must not contain more than 2000 characters");
        }
    }

    protected void handleBPMNModelConstraints(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getTargetNamespace() != null && bpmnModel.getTargetNamespace().length() > 255) {
            this.addError(errors, "activiti-bpmn-model-target-namespace-too-long", "The targetNamespace of the bpmn model must not contain more than 255 characters");
        }
    }

    protected boolean validateAtLeastOneExecutable(BpmnModel bpmnModel, List<ValidationError> errors) {
        int nrOfExecutableDefinitions = 0;
        for (Process process : bpmnModel.getProcesses()) {
            if (!process.isExecutable()) continue;
            ++nrOfExecutableDefinitions;
        }
        if (nrOfExecutableDefinitions == 0) {
            this.addError(errors, "activiti-process-definition-not-executable", "All process definition are set to be non-executable (property 'isExecutable' on process). This is not allowed.");
        }
        return nrOfExecutableDefinitions > 0;
    }

    public List<String> validateBpmnModel(BpmnModel bpmnModel) {
        ArrayList<String> result = new ArrayList<String>();
        Process process = bpmnModel.getMainProcess();
        List<StartEvent> startEvents = process.findFlowElementsOfType(StartEvent.class);
        if (startEvents != null && startEvents.size() == 1) {
            StartEvent se = startEvents.get(0);
            result.addAll(this.validateStartEvent(se));
        } else {
            result.add(ResManager.loadKDString((String)"\u6d41\u7a0b\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9\u3002", (String)"BpmnModelValidator_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (!result.isEmpty()) {
            return result;
        }
        List<EndEvent> endEvents = process.findFlowElementsOfType(EndEvent.class);
        if (endEvents != null && endEvents.size() == 1) {
            EndEvent ee = endEvents.get(0);
            result.addAll(this.validateEndEvent(ee));
        } else {
            result.add(ResManager.loadKDString((String)"\u6d41\u7a0b\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9\u3002", (String)"BpmnModelValidator_16", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (!result.isEmpty()) {
            return result;
        }
        List<FlowElement> elements = process.getFlowElementList();
        if (ProcessType.AuditFlow.name().equals(process.getProcessType())) {
            int pair = 0;
            for (FlowElement e : elements) {
                if (!(e instanceof FlowNode)) continue;
                FlowNode node = (FlowNode)e;
                if (node.getFork() != null && node.getFork().booleanValue() && "leavewhenallmeet".equals(node.getOutSet())) {
                    ++pair;
                }
                if (node.getJoin() == null || !node.getJoin().booleanValue() || !"enterwhenallarrive".equals(node.getInSet())) continue;
                --pair;
            }
            if (pair > 0) {
                result.add(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e2d\u62c6\u5206\u548c\u6c47\u805a\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\u3002", (String)"BpmnModelValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            } else if (pair < 0) {
                result.add(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e2d\u62c6\u5206\u548c\u6c47\u805a\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\u3002", (String)"BpmnModelValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            try {
                if (result.isEmpty()) {
                    process.getForkJoinModels();
                    process.getNodeAffectJoinNodeComeFlow();
                }
            }
            catch (Exception e) {
                result.add(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e2d\u62c6\u5206\u548c\u6c47\u805a\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\u3002", (String)"BpmnModelValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        for (FlowElement element : elements) {
            if (element instanceof StartEvent) {
                this.logger.debug("empty infos for StartEvent!");
                continue;
            }
            if (element instanceof EndEvent) {
                this.logger.debug("empty infos for EndEvent!");
                continue;
            }
            if (element instanceof BoundaryEvent) {
                result.addAll(this.validateBoundaryEvent((BoundaryEvent)element));
                continue;
            }
            result.addAll(this.validateFlowElement(element));
        }
        this.validateBoundaryBraches(process, result);
        return result;
    }

    private void validateBoundaryBraches(Process process, List<String> result) {
        Map<String, List<FlowNode>> boundaryNodes = process.getBoundaryNodes();
        if (!boundaryNodes.isEmpty()) {
            for (Map.Entry<String, List<FlowNode>> entry : boundaryNodes.entrySet()) {
                for (FlowNode fn : entry.getValue()) {
                    if (fn.getFork() != null && fn.getFork().booleanValue() && "leavewhenallmeet".equals(fn.getOutSet())) {
                        result.add(ResManager.loadKDString((String)"\u8fb9\u754c\u4e8b\u4ef6\u5185\u8282\u70b9\u4e0d\u652f\u6301\u5206\u652f\u6c47\u805a\u3002", (String)"BpmnModelValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                        return;
                    }
                    if (fn.getJoin() == null || !fn.getJoin().booleanValue()) continue;
                    result.add(ResManager.loadKDString((String)"\u8fb9\u754c\u4e8b\u4ef6\u5185\u8282\u70b9\u4e0d\u652f\u6301\u5206\u652f\u6c47\u805a\u3002", (String)"BpmnModelValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private List<String> validateBoundaryEvent(BoundaryEvent boundary) {
        ArrayList<String> result = new ArrayList<String>();
        if (boundary.getOutgoingFlows().isEmpty()) {
            result.add(String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u5fc5\u987b\u6709\u51fa\u53e3\u7ebf\u3002", (String)"BpmnModelValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]), boundary.getName(), boundary.getId()));
        }
        if (!boundary.getIncomingFlows().isEmpty()) {
            result.add(String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u4e0d\u80fd\u6709\u5165\u53e3\u7ebf\u3002", (String)"BpmnModelValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]), boundary.getName(), boundary.getId()));
        }
        return result;
    }

    public List<String> validateStartEvent(StartEvent start) {
        ArrayList<String> result = new ArrayList<String>();
        if (!start.getIncomingFlows().isEmpty()) {
            result.add(String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u5fc5\u987b\u662f\u8d77\u59cb\u4f4d\u7f6e\u7684\u8282\u70b9\uff0c\u4e0d\u80fd\u6709\u5165\u53e3\u7ebf\u3002", (String)"BpmnModelValidator_7", (String)"bos-wf-engine", (Object[])new Object[0]), start.getName(), start.getId()));
        }
        if (start.getOutgoingFlows().isEmpty()) {
            result.add(String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u540e\u9762\u5fc5\u987b\u8fde\u63a5\u5176\u4ed6\u8282\u70b9\u3002", (String)"BpmnModelValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]), start.getName(), start.getId()));
        }
        return result;
    }

    public List<String> validateEndEvent(EndEvent end) {
        ArrayList<String> result = new ArrayList<String>();
        if (!end.getOutgoingFlows().isEmpty()) {
            result.add(String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u5fc5\u987b\u662f\u7ec8\u6b62\u4f4d\u7f6e\u7684\u8282\u70b9\uff0c\u4e0d\u80fd\u6709\u51fa\u53e3\u7ebf\u3002", (String)"BpmnModelValidator_9", (String)"bos-wf-engine", (Object[])new Object[0]), end.getName(), end.getId()));
        }
        if (end.getIncomingFlows().isEmpty()) {
            result.add(String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u524d\u9762\u5fc5\u987b\u8fde\u63a5\u5176\u4ed6\u8282\u70b9\u3002", (String)"BpmnModelValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]), end.getName(), end.getId()));
        }
        return result;
    }

    public List<String> validateFlowElement(FlowElement element) {
        ArrayList<String> result = new ArrayList<String>();
        if (element instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)element;
            if (WfUtils.isEmpty(subProcess.getSubProcessId())) {
                result.add(this.getFormattedTip(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u7684\u5b50\u6d41\u7a0b\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BpmnModelValidator_11", (String)"bos-wf-engine", (Object[])new Object[0]), subProcess.getName(), subProcess.getId()));
            }
            return result;
        }
        if (element instanceof FlowNode) {
            FlowElement sourceEle;
            FlowNode node = (FlowNode)element;
            if (node.getIncomingFlows().isEmpty()) {
                result.add(this.getFormattedTip(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u5fc5\u987b\u6709\u5165\u53e3\u7ebf\u3002", (String)"BpmnModelValidator_12", (String)"bos-wf-engine", (Object[])new Object[0]), node.getName(), node.getId()));
            }
            if (!(!node.getOutgoingFlows().isEmpty() || (sourceEle = node.getIncomingFlows().get(0).getSourceFlowElement()) instanceof BoundaryEvent && "BoundaryCompensateEvent".equals(((BoundaryEvent)sourceEle).getType()))) {
                result.add(this.getFormattedTip(ResManager.loadKDString((String)"%1$s\u8282\u70b9[%2$s]\u5fc5\u987b\u6709\u51fa\u53e3\u7ebf\u3002", (String)"BpmnModelValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]), node.getName(), node.getId()));
            }
        } else if (element instanceof SequenceFlow) {
            SequenceFlow flow = (SequenceFlow)element;
            if (WfUtils.isEmpty(flow.getSourceRef())) {
                result.add(this.getFormattedTip(ResManager.loadKDString((String)"%1$s\u8fde\u7ebf[%2$s]\u5fc5\u987b\u6709\u6e90\u8282\u70b9\u3002", (String)"BpmnModelValidator_13", (String)"bos-wf-engine", (Object[])new Object[0]), flow.getName(), flow.getId()));
            }
            if (WfUtils.isEmpty(flow.getTargetRef())) {
                result.add(this.getFormattedTip(ResManager.loadKDString((String)"%1$s\u8fde\u7ebf[%2$s]\u5fc5\u987b\u6709\u76ee\u6807\u8282\u70b9\u3002", (String)"BpmnModelValidator_14", (String)"bos-wf-engine", (Object[])new Object[0]), flow.getName(), flow.getId()));
            }
        }
        return result;
    }

    private String getFormattedTip(String tpl, String name, String id) {
        name = WfUtils.isNotEmpty(name) ? name : "";
        id = id.substring(id.lastIndexOf(95) + 1);
        return String.format(tpl, name, id);
    }
}

