/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class CallActivityValidator
extends BaseElementValidatorImpl {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        super.validateBaseInfo(flowElement, errors, keyMap);
        CallActivity callActivity = (CallActivity)flowElement;
        this.validateCallActivity(errors, keyMap, callActivity);
    }

    public void validateCallActivity(List<ValidationError> errors, Map<String, Object> keyMap, CallActivity callActivity) {
        String addressKey;
        String groupInfo = ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5f15\u7528\u65b9\u5f0f", (String)"CallActivityValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        if ("bindByProdefId".equals(callActivity.getCalledWay())) {
            String info = ResManager.loadKDString((String)"\u7ed1\u5b9a\u7684\u5b50\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u6216\u88ab\u7981\u7528", (String)"CallActivityValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            Long callProcessId = callActivity.getCallProcessId();
            if (WfUtils.isEmpty(callProcessId)) {
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                validationError.setInfo(info);
                validationError.setObjType(groupInfo);
                errors.add(validationError);
                return;
            }
            Long newCallProcessId = this.getNewestVersionBmpnModelId(callActivity.getCallProcessNumber());
            if (WfUtils.isEmpty(newCallProcessId)) {
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                validationError.setInfo(info);
                validationError.setObjType(groupInfo);
                errors.add(validationError);
                return;
            }
            ArrayList<String> tempAllprocessIds = new ArrayList<String>();
            boolean closeLoop = this.getCloseLoop(callActivity, tempAllprocessIds);
            if (closeLoop) {
                info = ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5b58\u5728\u95ed\u73af\u8c03\u7528", (String)"CallActivityValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                validationError.setInfo(info);
                errors.add(validationError);
            }
            ArrayList<Long> processIds = new ArrayList<Long>(1);
            processIds.add(newCallProcessId);
            RepositoryService repositoryService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
            List<ValidationError> result = repositoryService.validateProcesses(processIds);
            if (CollectionUtil.isNotEmpty(result)) {
                errors.addAll(result);
            }
        } else if ("processAddress".equals(callActivity.getCalledWay()) && WfUtils.isEmpty(addressKey = callActivity.getAddressKey())) {
            String info = ResManager.loadKDString((String)"\u5bfb\u5740\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CallActivityValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            validationError.setInfo(info);
            validationError.setObjType(groupInfo);
            errors.add(validationError);
        }
    }

    private boolean getCloseLoop(CallActivity callActivity, List<String> tempAllprocessIds) {
        Long newCallProcessId;
        FlowElementsContainer parentProcess = callActivity.getParentContainer();
        if (parentProcess instanceof Process) {
            String id = ((Process)parentProcess).getId();
            if (!tempAllprocessIds.contains(id)) {
                tempAllprocessIds.add(id);
            } else {
                return true;
            }
        }
        if ("bindByProdefId".equals(callActivity.getCalledWay()) && WfUtils.isNotEmpty(newCallProcessId = this.getNewestVersionBmpnModelId(callActivity.getCallProcessNumber()))) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcDefId(newCallProcessId);
            List<FlowElement> flowElements = bpmnModel.getMainProcess().getFlowElementList();
            for (FlowElement flowElement : flowElements) {
                CallActivity childCallActivity;
                boolean closeLoop;
                if (!"CallActivity".equals(flowElement.getType()) || (closeLoop = this.getCloseLoop(childCallActivity = (CallActivity)flowElement, tempAllprocessIds))) continue;
                return closeLoop;
            }
        }
        return false;
    }

    private Long getNewestVersionBmpnModelId(String callProcessNumber) {
        QFilter q1 = new QFilter("key", "=", (Object)callProcessNumber);
        QFilter q2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject[] dynamicObjects = null;
        try {
            dynamicObjects = BusinessDataServiceHelper.load((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{q1, q2});
        }
        catch (Exception e) {
            return null;
        }
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0].getLong("id");
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        CallActivity callActivity = (CallActivity)flowElement;
        String bizEntityNumber = ConditionalRuleHelper.getEntryBillNumber(process, callActivity.getId(), false);
        List<MessageSendModel> inMsg = callActivity.getInMsg();
        keyMap.put("objType", ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5", (String)"CallActivityValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]));
        keyMap.put("info", ResManager.loadKDString((String)"\u8fdb\u5165\u8282\u70b9\u65f6\u6d88\u606f ", (String)"CallActivityValidator_11", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, inMsg, validationDatas, keyMap, bizEntityNumber);
        List<MessageSendModel> outMsg = callActivity.getOutMsg();
        keyMap.put("info", ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6\u6d88\u606f ", (String)"CallActivityValidator_12", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, outMsg, validationDatas, keyMap, bizEntityNumber);
    }
}

