/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class ExtItfValidator
extends DataValidatorImpl {
    private Log log = LogFactory.getLog(this.getClass());
    private Map<String, Map<String, Operation>> entityOperations = new HashMap<String, Map<String, Operation>>();

    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> datas = validationDataCollator.getExtItfs();
        if (datas == null || datas.isEmpty()) {
            return;
        }
        for (ValidationData data : datas) {
            String entityNumber = data.getBillNumber();
            ValidationInfo info = data.getValidationInfo();
            String extItf = data.getExtItf();
            String type = ExternalInterfaceUtil.getExtItfType(extItf);
            String typeName = ExternalInterfaceType.getTypeName(type);
            String value = ExternalInterfaceUtil.getExtItfValue(extItf);
            if ("operation".equals(type)) {
                this.validateOperations(info, typeName, value, entityNumber, errors);
                continue;
            }
            if (!WfUtils.isEmpty(value)) continue;
            ValidationError error = ValidatorUtil.getValidationError(info);
            error.setInfo(ValidatorUtil.strConcat(info.getInfo(), String.format(ResManager.loadKDString((String)"%s \u4e0d\u80fd\u4e3a\u7a7a\u3002 ", (String)"ExtItfValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]), typeName)));
            errors.add(error);
        }
    }

    private void validateOperations(ValidationInfo info, String typeName, String operExtItf, String entityNumber, List<ValidationError> errors) {
        String withdrawOper;
        HashMap<String, Object> opers = ExternalInterfaceUtil.castJSONToMap(operExtItf);
        String forwardOper = (String)opers.get("forward");
        if (WfUtils.isNotEmpty(forwardOper)) {
            this.validateOperation(info, typeName, entityNumber, forwardOper, errors);
        }
        if (WfUtils.isNotEmpty(withdrawOper = (String)opers.get("withdraw"))) {
            this.validateOperation(info, typeName, entityNumber, withdrawOper, errors);
        }
    }

    private void validateOperation(ValidationInfo info, String typeName, String entityNumber, String operation, List<ValidationError> errors) {
        Operation entityOper = this.getOperation(entityNumber, operation);
        if (entityOper == null) {
            ValidationError error = ValidatorUtil.getValidationError(info);
            error.setInfo(ValidatorUtil.strConcat(info.getInfo(), String.format(ResManager.loadKDString((String)"%1$s %2$s \u4e0d\u5b58\u5728", (String)"ExtItfValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]), typeName, operation)));
            errors.add(error);
        }
    }

    private Operation getOperation(String entityNumber, String operationKey) {
        Map<String, Operation> operationMap = this.entityOperations.get(entityNumber);
        if (operationMap == null) {
            operationMap = new HashMap<String, Operation>();
            List<Operation> operations = this.getEntityOperations(entityNumber);
            if (operations != null) {
                for (Operation operation : operations) {
                    operationMap.put(operation.getKey(), operation);
                }
            }
            this.entityOperations.put(entityNumber, operationMap);
        }
        return operationMap.get(operationKey);
    }

    private List<Operation> getEntityOperations(String entityNumber) {
        try {
            MetadataReader reader = new MetadataReader();
            String formId = reader.loadIdByNumber(entityNumber, MetaCategory.Form);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
            String entityId = formMetadata.getEntityId();
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            return metadata.getRootEntity().getOperations();
        }
        catch (Exception e) {
            this.log.error(String.format("get %s operations error! %s", entityNumber, WfUtils.getExceptionStacktrace(e)));
            return null;
        }
    }
}

