/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class KScriptValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getKs();
        if (validationDatas != null && !validationDatas.isEmpty()) {
            HashSet<String> classnames = new HashSet<String>(validationDatas.size());
            for (ValidationData validationData : validationDatas) {
                classnames.add(validationData.getKsScript());
            }
            QFilter idFilter = new QFilter("classname", "in", classnames);
            DynamicObjectCollection KSObjects = QueryServiceHelper.query((String)"ide_pluginscript", (String)"id,txt_scriptnumber,classname", (QFilter[])new QFilter[]{idFilter});
            HashMap<String, DynamicObject> ksInfos = new HashMap<String, DynamicObject>(KSObjects.size());
            for (DynamicObject ksObject : KSObjects) {
                ksInfos.put(ksObject.getString("classname"), ksObject);
            }
            for (ValidationData validationData : validationDatas) {
                DynamicObject ksInfo = (DynamicObject)ksInfos.get(validationData.getKsScript());
                if (ksInfo != null) continue;
                ValidationInfo vInfo = validationData.getValidationInfo();
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info = ValidatorUtil.strConcat(vInfo.getInfo(), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"KScriptValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError.setInfo(info);
                errors.add(validationError);
            }
        }
    }
}

