/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class OrgValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getOrgs();
        if (null != validationDatas && validationDatas.size() > 0) {
            HashSet<Long> orgs = new HashSet<Long>(validationDatas.size());
            for (ValidationData validationData : validationDatas) {
                orgs.add(Long.parseLong(validationData.getOrg()));
            }
            String selectFields = "id,number,enable";
            QFilter idFilter = new QFilter("id", "in", orgs);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObjectCollection orgObjects = QueryServiceHelper.query((String)"bos_org", (String)selectFields, (QFilter[])filters);
            HashMap<String, DynamicObject> orgInfos = new HashMap<String, DynamicObject>();
            if (orgObjects.size() > 0) {
                for (DynamicObject orgObject : orgObjects) {
                    orgInfos.put(orgObject.getString("id"), orgObject);
                }
            }
            for (ValidationData validationData : validationDatas) {
                String orgId = validationData.getOrg();
                DynamicObject orgObject = (DynamicObject)orgInfos.get(orgId);
                ValidationInfo vInfo = validationData.getValidationInfo();
                String info = vInfo.getInfo();
                if (orgObject != null) continue;
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"OrgValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError.setInfo(info1);
                errors.add(validationError);
            }
        }
    }
}

