/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class PositionValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getPositions();
        if (WfUtils.isNotEmptyForCollection(validationDatas)) {
            HashSet positionIds = new HashSet(validationDatas.size());
            validationDatas.forEach(validationData -> {
                String positionIdStr = validationData.getPositionId();
                Optional.ofNullable(positionIdStr).ifPresent(userId -> positionIds.add(Long.valueOf(userId)));
            });
            DynamicObjectCollection positionObjects = QueryServiceHelper.query((String)"bos_position", (String)"id,enable,name", (QFilter[])new QFilter[]{new QFilter("id", "in", positionIds)});
            HashMap positions = new HashMap(positionObjects.size());
            positionObjects.forEach(p -> positions.put(p.getString("id"), p));
            Map peopleUnderPosition = UserServiceHelper.getPeopleUnderPosition(positionIds);
            for (ValidationData validationData2 : validationDatas) {
                String info1;
                ValidationError validationError;
                String positionId = validationData2.getPositionId();
                DynamicObject positionInfo = (DynamicObject)positions.get(positionId);
                ValidationInfo vInfo = validationData2.getValidationInfo();
                String info = vInfo.getInfo();
                boolean isMacroExpression = positionId.matches("\\$?\\{\\s*proc\\..+?\\}");
                if (isMacroExpression) continue;
                if (positionInfo == null) {
                    validationError = ValidatorUtil.getValidationError(vInfo);
                    info1 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"UserValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                    validationError.setInfo(info1);
                    errors.add(validationError);
                    continue;
                }
                if (!positionInfo.getBoolean("enable")) {
                    validationError = ValidatorUtil.getValidationError(vInfo);
                    info1 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u672a\u542f\u7528", (String)"UserValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                    validationError.setInfo(info1);
                    validationError.setInfoType("warning");
                    errors.add(validationError);
                }
                Set users = (Set)peopleUnderPosition.get(Long.valueOf(positionId));
                List<Object> enablePeople = new ArrayList(1);
                if (WfUtils.isNotEmptyForCollection(users)) {
                    enablePeople = users.stream().filter(user -> user.getBoolean("enable")).collect(Collectors.toList());
                }
                if (!WfUtils.isEmptyForCollection(enablePeople)) continue;
                ValidationError validationError2 = ValidatorUtil.getValidationError(vInfo);
                String info12 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u4e0b\u7684\u6240\u6709\u4eba\u5458\u5168\u90e8\u6ca1\u6709\u542f\u7528", (String)"PositionValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError2.setInfo(info12);
                validationError2.setInfoType("warning");
                errors.add(validationError2);
            }
        }
    }
}

