/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.RPATask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class RPATaskValidator
extends BaseElementValidatorImpl {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        super.validateBaseInfo(flowElement, errors, keyMap);
        RPATask rpaTask = (RPATask)flowElement;
        if (WfUtils.isEmpty(rpaTask.getRpaProcCode())) {
            this.addValidationError(errors, keyMap, ResManager.loadKDString((String)"RPA\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RPATaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty(rpaTask.getRpaRobotId())) {
            this.addValidationError(errors, keyMap, ResManager.loadKDString((String)"RPA\u673a\u5668\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"RPATaskValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        String entityNumber = rpaTask.getEntityNumber();
        String entraBill = (String)keyMap.get("entityNumber");
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            this.addValidationError(errors, keyMap, ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"RPATaskValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else {
            boolean isAuditFlow;
            BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
            boolean bl = isAuditFlow = bpmnModel != null && ProcessType.AuditFlow.name().equals(bpmnModel.getMainProcess().getProcessType());
            if (isAuditFlow && !entityNumber.equals(entraBill)) {
                this.addValidationError(errors, keyMap, ResManager.loadKDString((String)"\u5355\u636e\u4e0e\u6d41\u7a0b\u5355\u636e\u4e0d\u4e00\u81f4", (String)"RPATaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
    }

    private void addValidationError(List<ValidationError> errors, Map<String, Object> keyMap, String info) {
        String objType = ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f", (String)"RPATaskValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
        validationError.setInfo(info);
        validationError.setObjType(objType);
        errors.add(validationError);
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
    }
}

