/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.impl.BillValidator;
import kd.bos.workflow.validation.validator.impl.UserValidator;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class RoleValidator
extends DataValidatorImpl {
    private static final String APPROVALPOSITION = "approvalposition";
    private static final String USER = "user";
    private static final String ROLETYPE = "roletype";

    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getRoles();
        ArrayList<ValidationData> dimensionDatas = new ArrayList<ValidationData>(0);
        if (validationDatas != null && validationDatas.size() > 0) {
            HashSet<Long> roleNumbers = new HashSet<Long>(validationDatas.size());
            for (ValidationData validationData : validationDatas) {
                roleNumbers.add(Long.parseLong(validationData.getRoleNumber()));
            }
            DynamicObject[] roleObjects = BusinessDataServiceHelper.load((String)"wf_role", (String)"roletype, roleentry.user,number,roleentry.alternateuser,roledimension,roletype,roleentry.approvalposition", (QFilter[])new QFilter[]{new QFilter("id", "in", roleNumbers)});
            HashMap<String, DynamicObject> roleInfos = new HashMap<String, DynamicObject>();
            if (roleObjects.length > 0) {
                for (DynamicObject roleObject : roleObjects) {
                    roleInfos.put(roleObject.getString("id"), roleObject);
                }
            }
            ArrayList<ValidationData> userIds = new ArrayList<ValidationData>();
            block2: for (ValidationData validationData : validationDatas) {
                DynamicObjectCollection roleentrys;
                String info1;
                String roleDimension;
                DynamicObject roleInfo = (DynamicObject)roleInfos.get(validationData.getRoleNumber());
                ValidationInfo vInfo = validationData.getValidationInfo();
                HashMap<String, Object> keyMap = new HashMap<String, Object>();
                keyMap.put("defaultDescription", vInfo.getDefaultDescription());
                keyMap.put("title", vInfo.getTitle());
                keyMap.put("secondTitle", vInfo.getSecondTitle());
                keyMap.put("objName", vInfo.getObjName());
                keyMap.put("objType", vInfo.getObjType());
                keyMap.put("infoType", vInfo.getInfoType());
                String info = vInfo.getInfo();
                if (roleInfo == null) {
                    ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                    String info12 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"RoleValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                    validationError.setInfo(info12);
                    errors.add(validationError);
                    continue;
                }
                Map<String, Object> map = validationData.getGeneralMap();
                if (map != null && map.containsKey("dimensionValidation") && ((Boolean)map.get("dimensionValidation")).booleanValue() && WfUtils.isNotEmptyString(roleDimension = roleInfo.getString("roledimension"))) {
                    Map<String, Object> dimensionInfos = WfRoleDimensionUtil.getDimensionInfos(roleDimension);
                    List rd = (List)dimensionInfos.get("dimensions");
                    for (RoleDimension dimension : rd) {
                        String entityNumber = dimension.getEntityNumber();
                        info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"\u91cc\u7684\u7ef4\u5ea6\u8bbe\u7f6e(%s)", (String)"RoleValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]), entityNumber));
                        keyMap.put("info", info1);
                        ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        dimensionDatas.add(ValidatorUtil.getValidationDataByBill("bill", entityNumber, validationInfo));
                    }
                }
                if ((roleentrys = roleInfo.getDynamicObjectCollection("roleentry")).size() > 0) {
                    for (DynamicObject roleentry : roleentrys) {
                        DynamicObject obj = WfRoleDimensionUtil.getRoleEntryRoleEntryCoreObjByRoleType(roleentry, roleInfo.getString(ROLETYPE));
                        DynamicObject alternateuserObjecty = roleentry.getDynamicObject("alternateuser");
                        if (null == obj && null == alternateuserObjecty) {
                            ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                            info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"(\u7f16\u7801\uff1a%s)\u91cc\u7684\u4eba\u5458\u7f3a\u5931", (String)"RoleValidator_12", (String)"bos-wf-engine", (Object[])new Object[0]), roleInfo.get("number")));
                            validationError.setInfo(info1);
                            errors.add(validationError);
                            continue block2;
                        }
                        List<DynamicObject> users = WfRoleDimensionUtil.getUserFromRoleEntryCoreFieldByRoleType(roleentry, roleInfo.getString(ROLETYPE));
                        if (WfUtils.isNotEmptyForCollection(users)) {
                            users.forEach(user -> {
                                String userId = user.getString("id");
                                String userNumber = user.getString("number");
                                String userName = user.getString("name");
                                String info1 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"\u91cc\u7684\u4eba\u5458(%s)", (String)"RoleValidator_13", (String)"bos-wf-engine", (Object[])new Object[0]), ValidatorUtil.strConcat(userName, userNumber)));
                                keyMap.put("info", info1);
                                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                                userIds.add(ValidatorUtil.getValidationDataByUser(USER, userId, validationInfo));
                            });
                        }
                        if (null == alternateuserObjecty) continue;
                        String userId = alternateuserObjecty.getString("id");
                        String userNumber = alternateuserObjecty.getString("number");
                        String userName = alternateuserObjecty.getString("name");
                        String info13 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"\u91cc\u7684\u4eba\u5458(%s)", (String)"RoleValidator_13", (String)"bos-wf-engine", (Object[])new Object[0]), ValidatorUtil.strConcat(userName, userNumber)));
                        keyMap.put("info", info13);
                        ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        userIds.add(ValidatorUtil.getValidationDataByUser(USER, userId, validationInfo));
                    }
                    continue;
                }
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info14 = ValidatorUtil.strConcat(info, String.format(ResManager.loadKDString((String)"(\u7f16\u7801\uff1a%s)\u91cc\u65e0\u4eba\u5458\u660e\u7ec6", (String)"RoleValidator_14", (String)"bos-wf-engine", (Object[])new Object[0]), roleInfo.get("number")));
                validationError.setInfo(info14);
                errors.add(validationError);
            }
            if (userIds.size() > 0) {
                ValidationDataCollator userValidationDataCollator = new ValidationDataCollator();
                userValidationDataCollator.setUserIds(userIds);
                new UserValidator().validate(userValidationDataCollator, errors);
            }
            if (dimensionDatas.size() > 0) {
                ValidationDataCollator dimensionValidationDataCollator = new ValidationDataCollator();
                dimensionValidationDataCollator.setBills(dimensionDatas);
                new BillValidator().validate(dimensionValidationDataCollator, errors);
            }
        }
    }
}

