/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class SSCApproveTaskValidator
extends BaseElementValidatorImpl {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        String trigger;
        CirculateModel circulateModel;
        String info;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        super.validateBaseInfo(flowElement, errors, keyMap);
        AuditTask sscApproveTask = (AuditTask)flowElement;
        String objType = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AuditTaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        String entityNumber = sscApproveTask.getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType);
            errors.add(validationError);
        } else {
            String entraBill = (String)keyMap.get("entityNumber");
            if (WfUtils.isNotEmpty(entraBill) && !entraBill.equals(entityNumber)) {
                info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)\u4e0e\u6d41\u7a0b\u5355\u636e\u4e0d\u4e00\u81f4", (String)"AuditTaskValidator_125", (String)"bos-wf-engine", (Object[])new Object[0]), sscApproveTask.getEntityName());
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                validationError.setInfo(info);
                validationError.setObjType(objType);
                errors.add(validationError);
            }
        }
        String objType2 = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"AuditTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        List<DecisionOption> decisionOptions = sscApproveTask.getDecisionOptions();
        if (decisionOptions != null && decisionOptions.size() > 0) {
            for (DecisionOption decisionOption : decisionOptions) {
                String auditType = decisionOption.getAuditType();
                if (WfUtils.isEmpty(auditType)) {
                    String info2 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879 \u5ba1\u6279\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_14", (String)"bos-wf-engine", (Object[])new Object[0]);
                    ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                    validationError.setInfo(info2);
                    validationError.setObjType(objType2);
                    errors.add(validationError);
                    continue;
                }
                if (!"reject".equals(auditType)) continue;
                List<SelectNodesModel> rejectOptions = decisionOption.getRejectOptions();
                if (decisionOption.isRejectPreNodeScene() || rejectOptions != null && !rejectOptions.isEmpty()) continue;
                boolean needApprove = true;
                for (SequenceFlow sequenceFlow : sscApproveTask.getOutgoingFlows()) {
                    if (sequenceFlow.getConditionalRule() == null || !WfUtils.isNotEmpty(sequenceFlow.getConditionalRule().getExpression())) continue;
                    Pattern pattern = Pattern.compile("auditNumber");
                    Matcher matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
                    if (matcher.find()) {
                        needApprove = false;
                        break;
                    }
                    pattern = Pattern.compile(sequenceFlow.getSourceFlowElement().getId() + "AuditNumber");
                    matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
                    if (!matcher.find()) continue;
                    needApprove = false;
                    break;
                }
                if (!needApprove) continue;
                String info3 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879 \u9a73\u56de\u65f6\u53ef\u9009\u8282\u70b9\u4e3a\u7a7a\uff0c\u5982\u65e0\u53ef\u9009\u6570\u636e\u53ef\u5ffd\u7565\u6b64\u9879", (String)"AuditTaskValidator_15", (String)"bos-wf-engine", (Object[])new Object[0]);
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                validationError.setInfo(info3);
                validationError.setObjType(objType2);
                validationError.setInfoType("warning");
                errors.add(validationError);
            }
        }
        if (StringUtils.isEmpty((CharSequence)sscApproveTask.getOperationStr())) {
            String info4 = ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u4e0d\u80fd\u4e3a\u7a7a", (String)"AuditTaskValidator_16", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
            validationError.setInfo(info4);
            validationError.setObjType(objType2);
            errors.add(validationError);
        }
        if ((circulateModel = sscApproveTask.getCirculateModel()) != null && circulateModel.getCirculate() != null && circulateModel.isCirculateWhenMatch() && (trigger = circulateModel.getCirculate().getTrigger()) != null && CollectionUtils.isNotEmpty(decisionOptions) && !"start".equals(trigger) && !"end".equals(trigger)) {
            Boolean flag = Boolean.FALSE;
            for (DecisionOption option : decisionOptions) {
                String optionNumber = option.getNumber();
                if (!trigger.equals(optionNumber)) continue;
                flag = Boolean.TRUE;
                break;
            }
            if (!flag.booleanValue()) {
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                validationError.setInfo(ResManager.loadKDString((String)"\u81ea\u52a8\u4f20\u9605\u7684\u89e6\u53d1\u65f6\u673a\u4e0d\u80fd\u4e3a\u7a7a", (String)"SSCApproveTaskValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError.setObjType(ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"AuditTaskValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError.setInfoType("warning");
                errors.add(validationError);
            }
        }
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        List<DecisionOption> decisionOptions;
        AuditTask sscApproveTask = (AuditTask)flowElement;
        Set<String> canRejectTaskIds = ValidatorUtil.getCanRejectTaskInfos(process);
        List<Object> rightNodes = new ArrayList();
        try {
            BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
            rightNodes = BpmnModelUtil.getRejectNodes(bpmnModel, sscApproveTask.getId());
        }
        catch (Exception e) {
            this.logger.error("get reject nodes failed!" + WfUtils.getExceptionStacktrace(e));
        }
        HashSet<String> rightTaskIds = new HashSet<String>(rightNodes.size());
        if (!rightNodes.isEmpty()) {
            for (int i = 0; i < rightNodes.size(); ++i) {
                FlowElement fe = (FlowElement)rightNodes.get(i);
                rightTaskIds.add(fe.getId());
            }
        }
        if ((decisionOptions = sscApproveTask.getDecisionOptions()) != null && !decisionOptions.isEmpty()) {
            for (DecisionOption decisionOption : decisionOptions) {
                List<SelectNodesModel> rejectOptions;
                String auditType = decisionOption.getAuditType();
                if (!"reject".equals(auditType) || null == (rejectOptions = decisionOption.getRejectOptions()) || rejectOptions.isEmpty()) continue;
                for (SelectNodesModel selectNodesModel : rejectOptions) {
                    ValidationInfo validationInfo;
                    String info;
                    String itemId = selectNodesModel.getItemId();
                    String itemName = selectNodesModel.getName();
                    String objType = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"AuditTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
                    if (!canRejectTaskIds.contains(itemId)) {
                        info = String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u53ef\u9a73\u56de\u8282\u70b9(%1$s)\u4e0d\u5b58\u5728", (String)"AuditTaskValidator_109", (String)"bos-wf-engine", (Object[])new Object[0]), itemName);
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        validationInfo.setInfo(info);
                        validationInfo.setObjType(objType);
                        validationInfo.setInfoType("systemError");
                        validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
                        continue;
                    }
                    if (rightTaskIds.contains(itemId)) continue;
                    info = String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u51b3\u7b56\u9879\u53ef\u9a73\u56de\u8282\u70b9(%1$s)\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"AuditTaskValidator_119", (String)"bos-wf-engine", (Object[])new Object[0]), itemName);
                    validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    validationInfo.setInfo(info);
                    validationInfo.setObjType(objType);
                    validationInfo.setInfoType("systemError");
                    validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
                }
            }
        }
    }
}

