/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class SequenceflowValidator
extends BaseElementValidatorImpl {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        BillRelationshipModel billConversionInfo;
        String info;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        SequenceFlow flow = (SequenceFlow)flowElement;
        if (WfUtils.isEmpty(flow.getSourceRef())) {
            info = ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u6e90\u8282\u70b9", (String)"SequenceflowValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            this.addErrorInfo(errors, keyMap, info);
        }
        if (WfUtils.isEmpty(flow.getTargetRef())) {
            info = ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u76ee\u6807\u8282\u70b9", (String)"SequenceflowValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            this.addErrorInfo(errors, keyMap, info);
        }
        if ((billConversionInfo = flow.getBillRelationshipModel()) != null && "botpTargetBills".equals(billConversionInfo.getRelationType())) {
            String info2;
            String conversionMode = billConversionInfo.getConversionMode();
            if (WfUtils.isEmpty(conversionMode)) {
                info2 = ResManager.loadKDString((String)"\u8f6c\u6362\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"SequenceflowValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                this.addErrorInfo(errors, keyMap, info2);
            } else if ("auto".equals(billConversionInfo.getConversionMode())) {
                if (WfUtils.isEmpty(billConversionInfo.getConversionMethod())) {
                    info2 = ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (String)"SequenceflowValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]);
                    this.addErrorInfo(errors, keyMap, info2);
                }
                if (WfUtils.isEmpty(billConversionInfo.getAfteroperation())) {
                    info2 = ResManager.loadKDString((String)"\u4e0b\u63a8\u540e\u6267\u884c\u76ee\u6807\u5355\u7684\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a", (String)"SequenceflowValidator_7", (String)"bos-wf-engine", (Object[])new Object[0]);
                    this.addErrorInfo(errors, keyMap, info2);
                }
            }
            if (WfUtils.isEmpty(billConversionInfo.getConversionType())) {
                info2 = ResManager.loadKDString((String)"\u8f6c\u6362\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"SequenceflowValidator_8", (String)"bos-wf-engine", (Object[])new Object[0]);
                this.addErrorInfo(errors, keyMap, info2);
            }
            if (WfUtils.isEmpty(billConversionInfo.getConversionTime())) {
                info2 = ResManager.loadKDString((String)"\u8f6c\u6362\u65f6\u673a\u4e0d\u80fd\u4e3a\u7a7a", (String)"SequenceflowValidator_9", (String)"bos-wf-engine", (Object[])new Object[0]);
                this.addErrorInfo(errors, keyMap, info2);
            }
        }
    }

    public void addErrorInfo(List<ValidationError> errors, Map<String, Object> keyMap, String info) {
        ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
        validationError.setInfo(info);
        errors.add(validationError);
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMapIn) {
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        SequenceFlow flow = (SequenceFlow)flowElement;
        ConditionalRuleEntity conditionalRule = flow.getConditionalRule();
        if (conditionalRule != null) {
            List<ConditionalEntity> rules = conditionalRule.getEntryentity();
            keyMap.put("objType", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"SequenceflowValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("info", ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219 ", (String)"SequenceflowValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("ruleType", conditionalRule.getType());
            String bizEntityNumber = ConditionalRuleHelper.getEntryBillNumber(process, flow.getId(), false);
            ValidatorUtil.collectValidationDatasFromConditionRules(process, rules, validationDatas, keyMap, bizEntityNumber);
            ValidatorUtil.validateAfterAuditFromConditionRules(process, conditionalRule.getExpression(), validationDatas, keyMap);
        }
        String procNum = process.getNumber();
        if (null == flow.getSourceFlowElement() || null == flow.getTargetFlowElement() || procNum.equals(flow.getSourceRef()) || procNum.equals(flow.getTargetRef())) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7ebf\uff0c\u9700\u8981\u4fee\u590d\u6d41\u7a0b", (String)"SequenceflowValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationInfo.setInfo(info);
            validationInfo.setInfoType("systemError");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
        }
    }
}

