/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.AllowNextPersonSetting;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SensitiveField;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class UserTaskValidator
extends BaseElementValidatorImpl {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        String trigger;
        String nextNodeAssignValue;
        String personScene;
        AllowNextPersonSetting allowNextPersonSetting;
        AllowNextPersonSettingModel allowNextPersonSettingModel;
        String info;
        ValidationError validationError;
        String endType;
        String info2;
        ValidationError validationError2;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        UserTask userTask = (UserTask)flowElement;
        super.validateBaseInfo(flowElement, errors, keyMap);
        this.validateCalculateParticipant(flowElement, errors, keyMap);
        this.validateParticipantValue(userTask, errors, keyMap);
        String objType = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"UserTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)userTask.getEntityNumber())) {
            validationError2 = ValidatorUtil.getValidationError(keyMap);
            info2 = ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserTaskValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError2.setInfo(info2);
            validationError2.setObjType(objType);
            validationError2.setProperty("entityNumber");
            errors.add(validationError2);
        }
        if (StringUtils.isEmpty((CharSequence)userTask.getProcessingPage())) {
            validationError2 = ValidatorUtil.getValidationError(keyMap);
            info2 = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserTaskValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError2.setInfo(info2);
            validationError2.setObjType(objType);
            validationError2.setProperty("processingPage");
            errors.add(validationError2);
        }
        if ("all".equals(endType = userTask.getEndType()) && StringUtils.isEmpty((CharSequence)userTask.getProcessingMobilePage())) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e3a\u7a7a", (String)"UserTaskValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType);
            validationError.setInfoType("warning");
            validationError.setProperty("processingMobilePage");
            errors.add(validationError);
        }
        if ("mobile".equals(endType) && StringUtils.isEmpty((CharSequence)userTask.getProcessingMobilePage())) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserTaskValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info);
            validationError.setObjType(objType);
            validationError.setProperty("processingMobilePage");
            errors.add(validationError);
        }
        if (!ProcessType.NoCodeFlow.name().equals(keyMap.get("processType")) && StringUtils.isEmpty((CharSequence)userTask.getOperationStr())) {
            validationError = ValidatorUtil.getValidationError(keyMap);
            String objType1 = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            String info3 = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u53ef\u9009\u62e9\u7684\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserTaskValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError.setInfo(info3);
            validationError.setObjType(objType1);
            validationError.setProperty("decisionOptions");
            errors.add(validationError);
        }
        if ((allowNextPersonSettingModel = userTask.getAllowNextPersonSettingModel()) != null && allowNextPersonSettingModel.isAllowNextPersonWhenMatch() && (allowNextPersonSetting = allowNextPersonSettingModel.getAllowNextPersonSetting()) != null && "assign".equals(personScene = allowNextPersonSetting.getAllowNextPersonScene()) && StringUtils.isBlank((CharSequence)(nextNodeAssignValue = allowNextPersonSetting.getSceneNextNodeAssignValue()))) {
            ValidationError validationError3 = ValidatorUtil.getValidationError(keyMap);
            String info4 = ResManager.loadKDString((String)"\u540e\u7eed\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"MainProcessValidator_24", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationError3.setInfo(info4);
            validationError3.setObjType(ResManager.loadKDString((String)"\u6307\u5b9a\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_51", (String)"bos-wf-engine", (Object[])new Object[0]));
            validationError3.setInfoType("error");
            validationError3.setProperty("allowNextPersonSetting");
            errors.add(validationError3);
        }
        List<DecisionOption> decisionOptions = userTask.getDecisionOptions();
        CirculateModel circulateModel = userTask.getCirculateModel();
        if (circulateModel != null && circulateModel.getCirculate() != null && circulateModel.isCirculateWhenMatch() && (trigger = circulateModel.getCirculate().getTrigger()) != null && CollectionUtils.isNotEmpty(decisionOptions) && !"start".equals(trigger) && !"end".equals(trigger)) {
            Boolean flag = Boolean.FALSE;
            for (DecisionOption option : decisionOptions) {
                String optionNumber = option.getNumber();
                if (!trigger.equals(optionNumber)) continue;
                flag = Boolean.TRUE;
                break;
            }
            if (!flag.booleanValue()) {
                ValidationError validationError4 = ValidatorUtil.getValidationError(keyMap);
                validationError4.setInfo(ResManager.loadKDString((String)"\u81ea\u52a8\u4f20\u9605\u7684\u89e6\u53d1\u65f6\u673a\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserTaskValidator_24", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError4.setObjType(ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"AuditTaskValidator_10", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError4.setInfoType("warning");
                validationError4.setProperty("circulate");
                errors.add(validationError4);
            }
        }
        this.validateSensitiveField(userTask, errors, keyMap);
    }

    protected void validateParticipantValue(UserTask userTask, List<ValidationError> errors, Map<String, Object> keyMap) {
        ParticipatantModel participatantModel = userTask.getParticipant();
        if (participatantModel != null) {
            HashMap<String, Object> participantKeyMap = new HashMap<String, Object>(keyMap);
            participantKeyMap.put("property", "participant");
            participantKeyMap.put("objType", ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]));
            super.validateParticipantValue(participatantModel.getParticipant(), errors, participantKeyMap);
        }
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMapIn) {
        String processingPage;
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        UserTask userTask = (UserTask)flowElement;
        String entityNumber = userTask.getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        String objType1 = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"UserTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)userTask.getEntityNumber())) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)", (String)"UserTaskValidator_100", (String)"bos-wf-engine", (Object[])new Object[0]), userTask.getEntityName());
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType1);
            validationInfo.setProperty("entityNumber");
            validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", userTask.getEntityNumber(), validationInfo));
        }
        String entraBill = (String)keyMap.get("entityNumber");
        BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
        if (bpmnModel != null && ProcessType.AuditFlow.name().equals(bpmnModel.getMainProcess().getProcessType()) && WfUtils.isNotEmpty(entraBill) && !entraBill.equals(userTask.getEntityNumber())) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)\u4e0e\u6d41\u7a0b\u5355\u636e\u4e0d\u4e00\u81f4", (String)"UserTaskValidator_25", (String)"bos-wf-engine", (Object[])new Object[0]), userTask.getEntityName());
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType1);
            validationInfo.setInfoType("warning");
            validationInfo.setProperty("entityNumber");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
        }
        if (StringUtils.isNotEmpty((CharSequence)(processingPage = userTask.getProcessingPage()))) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = ResManager.loadKDString((String)"PC\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762 ", (String)"UserTaskValidator_12", (String)"bos-wf-engine", (Object[])new Object[0]);
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType1);
            validationInfo.setProperty("processingPage");
            validationDatas.add(ValidatorUtil.getValidationDataByBillEmbedded("bill", processingPage, validationInfo, entityNumber));
        }
        String endType = userTask.getEndType();
        String processingMobilePage = userTask.getProcessingMobilePage();
        if ("all".equals(endType) || "mobile".equals(endType)) {
            String infoType1 = (String)keyMap.get("infoType");
            if ("all".equals(endType)) {
                infoType1 = "warning";
            }
            if (StringUtils.isNotEmpty((CharSequence)processingMobilePage)) {
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String info = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5ba1\u6279\u5904\u7406\u9875\u9762 ", (String)"UserTaskValidator_13", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationInfo.setInfo(info);
                validationInfo.setObjType(objType1);
                validationInfo.setInfoType(infoType1);
                validationInfo.setProperty("processingMobilePage");
                validationDatas.add(ValidatorUtil.getValidationDataByBillEmbedded("bill", processingMobilePage, validationInfo, entityNumber));
            }
        }
        String bizEntityNumber = ConditionalRuleHelper.getEntryBillNumber(process, userTask.getId(), false);
        this.collectParticipatantInfo(process, validationDatas, keyMap, userTask, bizEntityNumber);
        this.collectMsgInfo(process, validationDatas, keyMap, userTask, bizEntityNumber);
        this.collectSkipRuleInfo(process, validationDatas, keyMap, userTask, bizEntityNumber);
        this.collectCirculateInfo(process, validationDatas, keyMap, userTask, bizEntityNumber);
        this.collectPluginInfo(validationDatas, keyMap, userTask);
    }

    protected void collectParticipatantInfo(Process process, List<ValidationData> validationDatas, Map<String, Object> keyMap, UserTask userTask, String bizEntityNumber) {
        String operationStr;
        ParticipatantModel participantModel = userTask.getParticipant();
        if (null != participantModel) {
            List<ParticipantModelEntityImpl> participant = participantModel.getParticipant();
            keyMap.put("objType", ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]));
            ValidatorUtil.collectValidationDatasFromParticipant(process, participant, validationDatas, keyMap, bizEntityNumber);
            String expressionExtResult = ValidatorUtil.checkoutExpressionExt(participantModel.isDisplaySetting(), participantModel.getDisplayInfo());
            if (WfUtils.isNotEmpty(expressionExtResult)) {
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String info = String.format(ResManager.loadKDString((String)"\u5bf9\u8c61\u6269\u5c55\u5c5e\u6027%s\u4e0d\u5b58\u5728 ", (String)"UserTaskValidator_56", (String)"bos-wf-engine", (Object[])new Object[0]), expressionExtResult);
                String objType = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationInfo.setInfo(info);
                validationInfo.setObjType(objType);
                validationInfo.setProperty("displayInfo");
                validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(operationStr = userTask.getOperationStr()))) {
            String[] operations;
            for (String operation : operations = operationStr.split(",")) {
                String operationName = this.getOperationName(operation, userTask);
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String objType = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"UserTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                String info = String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u53ef\u9009\u62e9\u7684\u64cd\u4f5c %s", (String)"UserTaskValidator_9", (String)"bos-wf-engine", (Object[])new Object[0]), operationName);
                validationInfo.setInfo(info);
                validationInfo.setObjType(objType);
                validationInfo.setProperty("decisionOptions");
                validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", userTask.getEntityNumber(), operation, validationInfo));
            }
        }
    }

    protected void collectCirculateInfo(Process process, List<ValidationData> validationDatas, Map<String, Object> keyMap, UserTask userTask, String bizEntityNumber) {
        List<ParticipantModelEntityImpl> participantList;
        CirculateModel circulateModel = userTask.getCirculateModel();
        if (null != circulateModel && circulateModel.isCirculateWhenMatch() && null != circulateModel.getCirculate() && null != circulateModel.getCirculate().getParticipant() && CollectionUtils.isNotEmpty(participantList = circulateModel.getCirculate().getParticipant())) {
            for (ParticipantModelEntityImpl p : participantList) {
                ConditionalRuleEntity condRule = p.getCondrule();
                if (null == condRule) continue;
                keyMap.put("objType", ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"UserTaskValidator_17", (String)"bos-wf-engine", (Object[])new Object[0]));
                keyMap.put("info", String.format(ResManager.loadKDString((String)"\u81ea\u52a8%s \u6761\u4ef6\u89c4\u5219  ", (String)"UserTaskValidator_19", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
                keyMap.put("ruleType", condRule.getType());
                ValidatorUtil.collectValidationDatasFromConditionRules(process, condRule.getEntryentity(), validationDatas, keyMap, bizEntityNumber);
                ValidatorUtil.validateAfterAuditFromConditionRules(process, condRule.getExpression(), validationDatas, keyMap);
            }
        }
    }

    protected void collectSkipRuleInfo(Process process, List<ValidationData> validationDatas, Map<String, Object> keyMap, UserTask userTask, String bizEntityNumber) {
        ConditionalRuleEntity conditionalRule = userTask.getSkipCondition();
        if (null != conditionalRule) {
            keyMap.put("objType", ResManager.loadKDString((String)"\u8282\u70b9\u63a7\u5236", (String)"UserTaskValidator_17", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("info", ResManager.loadKDString((String)"\u8df3\u8fc7\u6761\u4ef6 ", (String)"UserTaskValidator_18", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("ruleType", conditionalRule.getType());
            ValidatorUtil.collectValidationDatasFromConditionRules(process, conditionalRule.getEntryentity(), validationDatas, keyMap, bizEntityNumber);
            ValidatorUtil.validateAfterAuditFromConditionRules(process, conditionalRule.getExpression(), validationDatas, keyMap);
        }
    }

    protected void collectPluginInfo(List<ValidationData> validationDatas, Map<String, Object> keyMap, UserTask userTask) {
        JSONObject flowRecordFormat;
        String type;
        List<ActivitiListener> executionListeners = userTask.getExecutionListeners();
        keyMap.put("objType", ResManager.loadKDString((String)"\u63d2\u4ef6", (String)"UserTaskValidator_20", (String)"bos-wf-engine", (Object[])new Object[0]));
        keyMap.put("info", ResManager.loadKDString((String)"\u8fdb\u5165(\u79bb\u5f00)\u8282\u70b9\u65f6\u6267\u884c ", (String)"UserTaskValidator_21", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromActivitiListener(executionListeners, validationDatas, userTask.getEntityNumber(), keyMap);
        List<ActivitiListener> taskListeners = userTask.getTaskListeners();
        keyMap.put("info", ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u65f6\u6267\u884c ", (String)"UserTaskValidator_22", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromActivitiListener(taskListeners, validationDatas, userTask.getEntityNumber(), keyMap);
        String flowRecordFormatter = userTask.getFlowRecordFormatter();
        if (StringUtils.isNotEmpty((CharSequence)flowRecordFormatter) && "script".equals(type = (flowRecordFormat = (JSONObject)JSONObject.parse((String)flowRecordFormatter)).getString("type"))) {
            JSONObject value = flowRecordFormat.getJSONObject("value");
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String objType2 = ResManager.loadKDString((String)"\u63d2\u4ef6", (String)"UserTaskValidator_20", (String)"bos-wf-engine", (Object[])new Object[0]);
            String info = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u8bb0\u5f55\u683c\u5f0f\u5316\u63d2\u4ef6 (%s)", (String)"UserTaskValidator_23", (String)"bos-wf-engine", (Object[])new Object[0]), value.getString("number"));
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType2);
            validationDatas.add(ValidatorUtil.getValidationDataByKSScript("ks", value.getString("number"), validationInfo));
        }
    }

    protected void collectMsgInfo(Process process, List<ValidationData> validationDatas, Map<String, Object> keyMap, UserTask userTask, String bizEntityNumber) {
        List<MessageSendModel> inMsg = userTask.getInMsg();
        keyMap.put("objType", ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5", (String)"UserTaskValidator_14", (String)"bos-wf-engine", (Object[])new Object[0]));
        keyMap.put("info", ResManager.loadKDString((String)"\u8fdb\u5165\u8282\u70b9\u65f6\u6d88\u606f ", (String)"UserTaskValidator_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, inMsg, validationDatas, keyMap, bizEntityNumber);
        List<MessageSendModel> outMsg = userTask.getOutMsg();
        keyMap.put("info", ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6\u6d88\u606f ", (String)"UserTaskValidator_16", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, outMsg, validationDatas, keyMap, bizEntityNumber);
    }

    private String getOperationName(String operation, UserTask userTask) {
        String operationName = "";
        List<DecisionOption> decisionOptions = userTask.getDecisionOptions();
        if (CollectionUtils.isNotEmpty(decisionOptions)) {
            for (DecisionOption decisionOption : decisionOptions) {
                if (operation == null || !operation.equals(decisionOption.getNumber())) continue;
                operationName = decisionOption.getName();
                break;
            }
        }
        return operationName;
    }

    protected void validateCalculateParticipant(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMap) {
        List<ActivitiListener> executionListeners = flowElement.getExecutionListeners();
        if (WfUtils.isNotEmptyForCollection(executionListeners)) {
            int num = 0;
            for (ActivitiListener executionListener : executionListeners) {
                if (!"calculate_participant".equals(executionListener.getOperation())) continue;
                ++num;
            }
            if (num > 1) {
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                String objType = ResManager.loadKDString((String)"\u63d2\u4ef6", (String)"UserTaskValidator_20", (String)"bos-wf-engine", (Object[])new Object[0]);
                String info = ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u53c2\u4e0e\u4eba\u65f6\uff0c\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u8282\u70b9\u4efb\u52a1\u63d2\u4ef6", (String)"UserTaskValidator_52", (String)"bos-wf-engine", (Object[])new Object[0]);
                validationError.setInfo(info);
                validationError.setObjType(objType);
                validationError.setInfoType("error");
                errors.add(validationError);
            }
        }
    }

    protected void validateSensitiveField(UserTask userTask, List<ValidationError> errors, Map<String, Object> keyMap) {
        SensitiveField sensitiveField = userTask.getSensitiveField();
        if (sensitiveField == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)userTask.getEntityId(), (MetaCategory)MetaCategory.Entity);
        Set<String> itemsSet = this.getItems(entityMetadata);
        String sensitiveFieldData = sensitiveField.getSensitiveFieldData();
        if (WfUtils.isNotEmpty(sensitiveFieldData)) {
            List sensitiveFieldList = (List)SerializationUtils.fromJsonString((String)sensitiveFieldData, List.class);
            for (Map sensitiveFieldMap : sensitiveFieldList) {
                if (itemsSet.contains(sensitiveFieldMap.get("fieldkey"))) continue;
                HashMap fieldnameMap = (HashMap)sensitiveFieldMap.get("fieldname");
                ValidationError validationError = ValidatorUtil.getValidationError(keyMap);
                String objType = ResManager.loadKDString((String)"\u5173\u952e\u5b57\u6bb5", (String)"UserTaskValidator_53", (String)"bos-wf-engine", (Object[])new Object[0]);
                String info = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5( %s )\u4e0d\u5b58\u5728", (String)"UserTaskValidator_54", (String)"bos-wf-engine", (Object[])new Object[0]), fieldnameMap.get(RequestContext.get().getLang().name()));
                validationError.setInfo(info);
                validationError.setObjType(objType);
                validationError.setInfoType("error");
                validationError.setProperty("sensitiveFieldData");
                errors.add(validationError);
            }
        }
    }

    private Set<String> getItems(EntityMetadata entityMetadata) {
        List items = entityMetadata.getItems();
        HashSet<String> itemsSet = new HashSet<String>(items.size());
        for (EntityItem item : items) {
            itemsSet.add(item.getKey());
        }
        return itemsSet;
    }
}

