/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.DataValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class UserValidator
extends DataValidatorImpl {
    @Override
    public void validate(ValidationDataCollator validationDataCollator, List<ValidationError> errors) {
        List<ValidationData> validationDatas = validationDataCollator.getUserIds();
        if (validationDatas != null && validationDatas.size() > 0) {
            HashSet<Long> userIds = new HashSet<Long>(validationDatas.size());
            for (ValidationData validationData : validationDatas) {
                String userIdStr = validationData.getUserId();
                if (userIdStr == null || !userIdStr.matches("^\\d+$")) continue;
                userIds.add(Long.parseLong(validationData.getUserId()));
            }
            String selectFields = "id,enable,name";
            QFilter idFilter = new QFilter("id", "in", userIds);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObjectCollection userObjects = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters);
            HashMap<String, DynamicObject> userInfos = new HashMap<String, DynamicObject>();
            if (userObjects.size() > 0) {
                for (DynamicObject userObject : userObjects) {
                    userInfos.put(userObject.getString("id"), userObject);
                }
            }
            for (ValidationData validationData : validationDatas) {
                String userId = validationData.getUserId();
                DynamicObject userInfo = (DynamicObject)userInfos.get(userId);
                ValidationInfo vInfo = validationData.getValidationInfo();
                String info = vInfo.getInfo();
                boolean isMacroExpression = userId.matches("\\$?\\{\\s*proc\\..+?\\}");
                if (isMacroExpression) continue;
                if (userInfo == null) {
                    ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                    String info1 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"UserValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                    validationError.setInfo(info1);
                    errors.add(validationError);
                    continue;
                }
                Boolean enable = userInfo.getBoolean("enable");
                if (enable.booleanValue()) continue;
                ValidationError validationError = ValidatorUtil.getValidationError(vInfo);
                String info1 = ValidatorUtil.strConcat(info, ResManager.loadKDString((String)"\u672a\u542f\u7528", (String)"UserValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationError.setInfo(info1);
                validationError.setInfoType("warning");
                errors.add(validationError);
            }
        }
    }
}

