/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.TimingModel;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;
import kd.bos.workflow.validation.validator.BaseElementValidatorImpl;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class WaitTaskValidator
extends BaseElementValidatorImpl {
    @Override
    public void validate(FlowElement flowElement, List<ValidationError> errors, Map<String, Object> keyMapIn) {
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        keyMap.put("infoType", "systemError");
        super.validateBaseInfo(flowElement, errors, keyMap);
    }

    @Override
    public void collectValidationDatas(Process process, FlowElement flowElement, List<ValidationData> validationDatas, Map<String, Object> keyMapIn) {
        super.buildObjectInfo(flowElement, keyMapIn);
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.putAll(keyMapIn);
        WaitTask waitTask = (WaitTask)flowElement;
        String entityId = waitTask.getEntityId();
        String entityNumber = MetadataDao.getEntityNumberById((String)entityId);
        String objType = ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f", (String)"WaitTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)", (String)"WaitTaskValidator_100", (String)"bos-wf-engine", (Object[])new Object[0]), waitTask.getEntityName());
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType);
            validationDatas.add(ValidatorUtil.getValidationDataByBill("bill", entityNumber, validationInfo));
        }
        BpmnModel bpmnModel = (BpmnModel)keyMap.get("bpmnModel");
        String entraBill = (String)keyMap.get("entityNumber");
        if (bpmnModel != null && ProcessType.AuditFlow.name().equals(bpmnModel.getMainProcess().getProcessType()) && WfUtils.isNotEmpty(entraBill) && !entraBill.equals(entityNumber)) {
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            String info = String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)\u4e0e\u6d41\u7a0b\u5355\u636e\u4e0d\u4e00\u81f4", (String)"WaitTaskValidator_102", (String)"bos-wf-engine", (Object[])new Object[0]), waitTask.getEntityName());
            validationInfo.setInfo(info);
            validationInfo.setObjType(objType);
            validationInfo.setInfoType("warning");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
        }
        String bizEntityNumber = ConditionalRuleHelper.getEntryBillNumber(process, waitTask.getId(), false);
        TimingModel timingModel = waitTask.getTimingModel();
        if (null != timingModel && null != timingModel.getCondition()) {
            ConditionalRuleEntity condRule = timingModel.getCondition();
            keyMap.put("objType", ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f", (String)"WaitTaskValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("info", ResManager.loadKDString((String)"\u5b9a\u65f6\u8bbe\u7f6e \u6761\u4ef6\u89c4\u5219 ", (String)"WaitTaskValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            keyMap.put("ruleType", condRule.getType());
            ValidatorUtil.collectValidationDatasFromConditionRules(process, condRule.getEntryentity(), validationDatas, keyMap, bizEntityNumber);
        }
        List<MessageSendModel> inMsg = waitTask.getInMsg();
        keyMap.put("objType", ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5", (String)"WaitTaskValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        keyMap.put("info", ResManager.loadKDString((String)"\u8fdb\u5165\u8282\u70b9\u65f6\u6d88\u606f ", (String)"WaitTaskValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, inMsg, validationDatas, keyMap, bizEntityNumber);
        List<MessageSendModel> outMsg = waitTask.getOutMsg();
        keyMap.put("info", ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6\u6d88\u606f ", (String)"WaitTaskValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        ValidatorUtil.collectValidationDatasFromMessageSendModel(process, outMsg, validationDatas, keyMap, bizEntityNumber);
    }
}

