/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.util;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BpmnNodeValidateUtil {
    public static WorkflowService getService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    public static void removeValidateDatas(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)BpmnNodeValidateUtil.getService().getRepositoryService().findEntityById(procInstId, "wf_hiprocinst", "businessKey");
        WfCacheHelper.removeTestingPlanData(String.format("%s_%s", "validated", procInstEntity.getBusinessKey()));
    }

    public static void recordValidateFailed(Long testingPlanId, String message) {
        DynamicObject testingPlan = BusinessDataServiceHelper.loadSingle((Object)testingPlanId, (String)"wf_testingplan");
        testingPlan.set("state", (Object)"failed");
        testingPlan.set("endtime", (Object)WfUtils.now());
        boolean isAutoTest = testingPlan.getBoolean("autotest");
        if (isAutoTest) {
            String msg = String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25\u3002%s", (String)"BpmnNodeValidateUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), message);
            BpmnNodeValidateUtil.saveErrorInfo(testingPlan, msg);
        } else {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6d4b\u8bd5\u5931\u8d25\u3002\u539f\u56e0\uff1a%2$s%3$s", (String)"BpmnNodeValidateUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]), "<p style=\"color:red;\">", message, "</p>");
            BpmnNodeValidateUtil.saveValidateMessage(testingPlan, msg);
        }
    }

    public static void markTestingPlanSuccess(Long planId) {
        RepositoryService repositoryService = BpmnNodeValidateUtil.getService().getRepositoryService();
        TestingPlanEntity testingPlan = (TestingPlanEntity)repositoryService.findEntityById(planId, "wf_testingplan");
        testingPlan.setState("successed");
        testingPlan.setEndTime(WfUtils.now());
        repositoryService.saveOrUpdateEntity(testingPlan);
    }

    public static void markTestingPlanTerminated(Long planId) {
        RepositoryService repositoryService = BpmnNodeValidateUtil.getService().getRepositoryService();
        TestingPlanEntity testingPlan = (TestingPlanEntity)repositoryService.findEntityById(planId, "wf_testingplan");
        testingPlan.setState("terminated");
        testingPlan.setEndTime(WfUtils.now());
        repositoryService.saveOrUpdateEntity(testingPlan);
    }

    public static void markTestingPlanPassed(Long planId, ILocaleString description) {
        RepositoryService repositoryService = BpmnNodeValidateUtil.getService().getRepositoryService();
        TestingPlanEntity testingPlan = (TestingPlanEntity)repositoryService.findEntityById(planId, "wf_testingplan");
        if ("successed".equals(testingPlan.getState())) {
            testingPlan.setPassed(true);
            testingPlan.setDescription(description);
            repositoryService.saveOrUpdateEntity(testingPlan);
        }
    }

    public static void recordValidateInfo(Long testingPlanId, String message) {
        DynamicObject testingPlan = BusinessDataServiceHelper.loadSingle((Object)testingPlanId, (String)"wf_testingplan");
        BpmnNodeValidateUtil.saveValidateMessage(testingPlan, message);
    }

    public static Date getEndTimeByTestingPlanId(Long planId) {
        TestingPlanEntity testingPlan = (TestingPlanEntity)BpmnNodeValidateUtil.getService().getRepositoryService().findEntityById(planId, "wf_testingplan");
        return null == testingPlan ? null : testingPlan.getEndTime();
    }

    private static void saveValidateMessage(DynamicObject testingPlan, String message) {
        String record = testingPlan.getString("resultinfo");
        testingPlan.set("resultinfo", (Object)(record + message));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{testingPlan});
    }

    private static void saveErrorInfo(DynamicObject testingPlan, String message) {
        String errorInfo = testingPlan.getString("errorinfo");
        testingPlan.set("errorinfo", (Object)(errorInfo + message));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{testingPlan});
    }
}

