/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validation.validator.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.comparetype.CompareTypesUtils;
import kd.bos.workflow.engine.comparetype.WfCompareTypeDto;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.engine.impl.cmd.task.CRRDimenTypeConstant;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.validation.ValidationData;
import kd.bos.workflow.validation.ValidationDataCollator;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.ValidationInfo;

public class ValidatorUtil {
    private static Log logger = LogFactory.getLog(ValidatorUtil.class);
    private static final String VALUE = "value";
    private static final String NUMBER = "number";
    private static final String TYPE = "type";

    public static ValidationError getValidationError(Map<String, Object> param) {
        ValidationError error = new ValidationError();
        error.setDefaultDescription(ValidatorUtil.getStringValueByKey(param, "defaultDescription"));
        error.setTitle(ValidatorUtil.getStringValueByKey(param, "title"));
        error.setSecondTitle(ValidatorUtil.getStringValueByKey(param, "secondTitle"));
        error.setObjName(ValidatorUtil.getStringValueByKey(param, "objName"));
        error.setObjType(ValidatorUtil.getStringValueByKey(param, "objType"));
        error.setInfo(ValidatorUtil.getStringValueByKey(param, "info"));
        error.setInfoType(ValidatorUtil.getStringValueByKey(param, "infoType"));
        error.setActivityId(ValidatorUtil.getStringValueByKey(param, "activityId"));
        return error;
    }

    public static ValidationError getValidationError(ValidationInfo validationInfo) {
        ValidationError error = new ValidationError();
        error.setDefaultDescription(validationInfo.getDefaultDescription());
        error.setTitle(validationInfo.getTitle());
        error.setSecondTitle(validationInfo.getSecondTitle());
        error.setObjName(validationInfo.getObjName());
        error.setObjType(validationInfo.getObjType());
        error.setInfo(validationInfo.getInfo());
        error.setInfoType(validationInfo.getInfoType());
        error.setActivityId(validationInfo.getActivityId());
        error.setProperty(validationInfo.getProperty());
        return error;
    }

    public static ValidationInfo buildValidationInfo(Map<String, Object> param) {
        ValidationInfo validationInfo = new ValidationInfo();
        validationInfo.setDefaultDescription(ValidatorUtil.getStringValueByKey(param, "defaultDescription"));
        validationInfo.setTitle(ValidatorUtil.getStringValueByKey(param, "title"));
        validationInfo.setSecondTitle(ValidatorUtil.getStringValueByKey(param, "secondTitle"));
        validationInfo.setObjName(ValidatorUtil.getStringValueByKey(param, "objName"));
        validationInfo.setObjType(ValidatorUtil.getStringValueByKey(param, "objType"));
        validationInfo.setInfo(ValidatorUtil.getStringValueByKey(param, "info"));
        validationInfo.setInfoType(ValidatorUtil.getStringValueByKey(param, "infoType"));
        validationInfo.setActivityId(ValidatorUtil.getStringValueByKey(param, "activityId"));
        return validationInfo;
    }

    private static String getStringValueByKey(Map<String, Object> param, String key) {
        String ret = "";
        if (null != param.get(key)) {
            return (String)param.get(key);
        }
        return ret;
    }

    public static ValidationData getValidationDataByBill(String type, String bill, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setBillNumber(bill);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByBillEmbedded(String type, String bill, ValidationInfo validationInfo, String entryBill) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setBillNumber(bill);
        validationData.setValidationInfo(validationInfo);
        validationData.setEntryBill(entryBill);
        return validationData;
    }

    public static ValidationData getValidationDataByRoleBillField(String type, String bill, String billField, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setBillField(billField);
        validationData.setBillNumber(bill);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByBillOperation(String type, String bill, String billOperation, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setBillNumber(bill);
        validationData.setBillOperation(billOperation);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByExtItf(String billNumber, String extItf, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType("extItf");
        validationData.setBillNumber(billNumber);
        validationData.setExtItf(extItf);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByBillSummary(String type, String billSummary, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setBillSummary(billSummary);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationBillCallActivity(String type, String billNumber, String billName, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setBillNumber(billNumber);
        validationData.setBillName(billName);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByRole(String type, String roleNumber, ValidationInfo validationInfo) {
        return ValidatorUtil.getValidationDataByRole(type, roleNumber, new HashMap<String, Object>(0), validationInfo);
    }

    public static ValidationData getValidationDataByRole(String type, String roleNumber, Map<String, Object> map, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setRoleNumber(roleNumber);
        validationData.setGeneralMap(map);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByUser(String type, String userId, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setUserId(userId);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByKSScript(String type, String ksScript, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setKsScript(ksScript);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByOrg(String type, String orgId, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setOrg(orgId);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static ValidationData getValidationDataByCondRule(String type, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static void collectValidationDatasFromParticipant(Process process, List<ParticipantModelEntityImpl> participant, List<ValidationData> validationDatas, Map<String, Object> keyMap, String bizEntityNumber) {
        if (participant != null && !participant.isEmpty()) {
            int countNum = 0;
            int countElse = 0;
            HashSet<Long> roleIdSet = new HashSet<Long>(participant.size());
            for (ParticipantModelEntityImpl participantModelEntityImpl : participant) {
                String type = participantModelEntityImpl.getType();
                if (!"role".equals(type)) continue;
                roleIdSet.add(participantModelEntityImpl.getRoleId());
            }
            DynamicObjectCollection roleCollection = QueryServiceHelper.query((String)"wf_role", (String)"id,roledimension", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIdSet)});
            HashMap<Long, String> dimensionMap = new HashMap<Long, String>(roleCollection.size());
            for (DynamicObject role : roleCollection) {
                dimensionMap.put(role.getLong("id"), role.getString("roleDimension"));
            }
            for (ParticipantModelEntityImpl participantModelEntityImpl : participant) {
                ConditionalRuleEntity conditionalRule;
                ValidationInfo validationInfo;
                String personsStr;
                DynamicObject dynamicObject = participantModelEntityImpl.getDynamicObject();
                String type = participantModelEntityImpl.getType();
                Boolean defaultCond = participantModelEntityImpl.getDefaultCondition();
                if (WfUtils.isNotEmptyString(defaultCond) && defaultCond.booleanValue()) {
                    ++countElse;
                }
                if ("person".equals(type)) {
                    String[] persons;
                    personsStr = dynamicObject.getString(VALUE);
                    for (String person : persons = personsStr.split(",")) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        String info1 = ValidatorUtil.strConcat(validationInfo.getInfo(), String.format(ResManager.loadKDString((String)"\u4eba\u5458(%1$s)", (String)"ValidatorUtil_6", (String)"bos-wf-engine", (Object[])new Object[0]), person));
                        validationInfo.setInfo(info1);
                        validationInfo.setProperty("participant");
                        validationDatas.add(ValidatorUtil.getValidationDataByUser("user", person, validationInfo));
                    }
                } else if ("role".equals(type)) {
                    String roleId = String.valueOf(participantModelEntityImpl.getRoleId());
                    String roleDesc = participantModelEntityImpl.getValue();
                    ValidationInfo validationInfo2 = ValidatorUtil.buildValidationInfo(keyMap);
                    String info1 = ValidatorUtil.strConcat(validationInfo2.getInfo(), String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272(%1$s)", (String)"ValidatorUtil_7", (String)"bos-wf-engine", (Object[])new Object[0]), roleDesc));
                    validationInfo2.setInfo(info1);
                    HashMap<String, Object> map = new HashMap<String, Object>(1);
                    map.put("dimensionValidation", Boolean.TRUE);
                    validationDatas.add(ValidatorUtil.getValidationDataByRole("role", roleId, map, validationInfo2));
                    ValidatorUtil.checkBillFieldForParticipant((String)dimensionMap.get(participantModelEntityImpl.getRoleId()), process, participantModelEntityImpl, validationDatas, keyMap, bizEntityNumber);
                } else if ("plugin".equals(type)) {
                    String valueStr = dynamicObject.getString(VALUE);
                    JSONObject value = (JSONObject)JSONObject.parse((String)valueStr);
                    String pluginType = value.getString(TYPE);
                    if ("script".equals(pluginType)) {
                        String ksScript = ((JSONObject)JSONObject.parse((String)value.getString(VALUE))).getString(NUMBER);
                        ValidationInfo validationInfo3 = ValidatorUtil.buildValidationInfo(keyMap);
                        String info1 = ValidatorUtil.strConcat(validationInfo3.getInfo(), String.format(ResManager.loadKDString((String)"\u63d2\u4ef6(%1$s)", (String)"ValidatorUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]), ksScript));
                        validationInfo3.setInfo(info1);
                        validationDatas.add(ValidatorUtil.getValidationDataByKSScript("ks", ksScript, validationInfo3));
                    }
                } else if (!"relation".equals(type) && "position".equals(type)) {
                    String[] positions;
                    personsStr = dynamicObject.getString(VALUE);
                    for (String position : positions = personsStr.split(",")) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        String info = ValidatorUtil.strConcat(validationInfo.getInfo(), String.format(ResManager.loadKDString((String)"\u5c97\u4f4d(%1$s)", (String)"ValidatorUtil_6_2", (String)"bos-wf-engine", (Object[])new Object[0]), position));
                        validationInfo.setInfo(info);
                        validationDatas.add(ValidatorUtil.getValidationDataByPosition("position", position, validationInfo));
                    }
                }
                if (null == (conditionalRule = participantModelEntityImpl.getCondrule())) continue;
                if (countNum == 0) {
                    String info1 = ValidatorUtil.strConcat((String)keyMap.get("info"), ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219 ", (String)"ValidatorUtil_9", (String)"bos-wf-engine", (Object[])new Object[0]));
                    keyMap.put("info", info1);
                }
                keyMap.put("ruleType", conditionalRule.getType());
                ValidatorUtil.collectValidationDatasFromConditionRules(process, conditionalRule.getEntryentity(), validationDatas, keyMap, bizEntityNumber);
                ++countNum;
                ValidatorUtil.validateAfterAuditFromConditionRules(process, conditionalRule.getExpression(), validationDatas, keyMap);
            }
            if (countElse > 1) {
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String info1 = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u903b\u8f91\u7b26\u5b58\u5728\u591a\u4e2a \u5426\u5219", (String)"ValidatorUtil_18", (String)"bos-wf-engine", (Object[])new Object[0]));
                validationInfo.setInfo(info1);
                validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
            }
        }
    }

    private static ValidationData getValidationDataByPosition(String type, String positionId, ValidationInfo validationInfo) {
        ValidationData validationData = new ValidationData();
        validationData.setType(type);
        validationData.setPositionId(positionId);
        validationData.setValidationInfo(validationInfo);
        return validationData;
    }

    public static void collectValidationDatasFromMessageSendModel(Process process, List<MessageSendModel> msg, List<ValidationData> validationDatas, Map<String, Object> keyMap, String bizEntityNumber) {
        if (msg != null && !msg.isEmpty()) {
            int countNum = 0;
            for (MessageSendModel messageSendModel : msg) {
                List<ParticipantModelEntityImpl> receiver = messageSendModel.getReceiver();
                ValidatorUtil.collectValidationDatasFromParticipant(process, receiver, validationDatas, keyMap, bizEntityNumber);
                ConditionalRuleEntity conditionalRule = messageSendModel.getRule();
                if (null == conditionalRule) continue;
                List<ConditionalEntity> condRules = conditionalRule.getEntryentity();
                if (countNum == 0) {
                    keyMap.put("info", ValidatorUtil.strConcat((String)keyMap.get("info"), ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219 ", (String)"ValidatorUtil_9", (String)"bos-wf-engine", (Object[])new Object[0])));
                }
                keyMap.put("ruleType", conditionalRule.getType());
                ValidatorUtil.collectValidationDatasFromConditionRules(process, condRules, validationDatas, keyMap, bizEntityNumber);
                ++countNum;
            }
        }
    }

    public static void collectValidationDatasFromActivitiListener(List<ActivitiListener> executionListeners, List<ValidationData> validationDatas, String billNumber, Map<String, Object> keyMap) {
        if (executionListeners != null && !executionListeners.isEmpty()) {
            ActivitiListener executionListener;
            String implementation;
            Iterator<ActivitiListener> iterator = executionListeners.iterator();
            while (iterator.hasNext() && !WfUtils.isEmpty(implementation = (executionListener = iterator.next()).getImplementation())) {
                String classname;
                JSONObject value;
                JSONObject activity = (JSONObject)JSONObject.parse((String)implementation);
                String type = activity.getString(TYPE);
                if ("operation".equals(type)) {
                    String info1;
                    ValidationInfo validationInfo;
                    value = activity.getJSONObject(VALUE);
                    String operation = value.getString("forward");
                    String reOperation = value.getString("withdraw");
                    if (StringUtils.isNotBlank((CharSequence)operation)) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        info1 = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u64cd\u4f5c ", (String)"ValidatorUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]), value.getString("forward_name"));
                        validationInfo.setInfo(info1);
                        validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", billNumber, operation, validationInfo));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)reOperation)) continue;
                    validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    info1 = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u64cd\u4f5c ", (String)"ValidatorUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]), value.getString("withdraw_name"));
                    validationInfo.setInfo(info1);
                    validationDatas.add(ValidatorUtil.getValidationDataByBillOperation("billoperation", billNumber, reOperation, validationInfo));
                    continue;
                }
                if (!"script".equals(type) || !StringUtils.isNotBlank((CharSequence)(classname = (value = activity.getJSONObject(VALUE)).getString(NUMBER)))) continue;
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String info1 = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u811a\u672c ", (String)"ValidatorUtil_10", (String)"bos-wf-engine", (Object[])new Object[0]), classname);
                validationInfo.setInfo(info1);
                validationDatas.add(ValidatorUtil.getValidationDataByKSScript("ks", classname, validationInfo));
            }
        }
    }

    private static void checkBillFieldForParticipant(String roleDimension, Process mainProcess, ParticipantModelEntityImpl participantModelEntityImpl, List<ValidationData> validationDatas, Map<String, Object> keyMap, String bizEntityNumber) {
        String info1;
        String entityNumber = (String)keyMap.get("entityNumber");
        if (ProcessType.BizFlow.name().equals(mainProcess.getProcessType()) && WfUtils.isNotEmpty(bizEntityNumber)) {
            entityNumber = bizEntityNumber;
        }
        String businessOrg = participantModelEntityImpl.getBusinessOrgField();
        String dimensionField = participantModelEntityImpl.getDimensionField();
        if (WfUtils.isNotEmpty(businessOrg)) {
            if (WfUtils.isJSONObject(businessOrg)) {
                JSONObject parseObject = JSONObject.parseObject((String)businessOrg);
                String selectType = String.valueOf(parseObject.get((Object)"selectType"));
                String string = (String)parseObject.get((Object)"parseInfo");
                if (CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(selectType)) {
                    ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    String newParseInfo = ExpressionCalculatorUtil.removeFieldPrefix(string);
                    info1 = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7\u672a\u80fd\u5728\u5355\u636e\u5b9e\u4f53\u4e0a\u627e\u5230\u5bf9\u5e94\u5b57\u6bb5:", (String)"ValidatorUtil_24", (String)"bos-wf-engine", (Object[])new Object[0]), newParseInfo);
                    validationInfo.setInfo(info1);
                    validationDatas.add(ValidatorUtil.getValidationDataByRoleBillField("billField", entityNumber, newParseInfo, validationInfo));
                }
            } else {
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String newBusinessOrg = ExpressionCalculatorUtil.removeFieldPrefix(businessOrg);
                String string = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7\u672a\u80fd\u5728\u5355\u636e\u5b9e\u4f53\u4e0a\u627e\u5230\u5bf9\u5e94\u5b57\u6bb5:", (String)"ValidatorUtil_24", (String)"bos-wf-engine", (Object[])new Object[0]), newBusinessOrg);
                validationInfo.setInfo(string);
                validationDatas.add(ValidatorUtil.getValidationDataByRoleBillField("billField", entityNumber, newBusinessOrg, validationInfo));
            }
        }
        Map dimensionMap = new HashMap(0);
        if (WfUtils.isNotEmpty(dimensionField)) {
            dimensionMap = (Map)SerializationUtils.fromJsonString((String)dimensionField, Map.class);
            for (Map.Entry entry : dimensionMap.entrySet()) {
                JSONObject obj = JSONObject.parseObject((String)((String)entry.getValue()));
                String selectType = String.valueOf(obj.get((Object)"selectType"));
                String parseInfo = (String)obj.get((Object)"parseInfo");
                if (!CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(selectType)) continue;
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                String newParseInfo = ExpressionCalculatorUtil.removeFieldPrefix(parseInfo);
                String info13 = ValidatorUtil.strConcat(validationInfo.getInfo(), ResManager.loadKDString((String)"\u53c2\u7167\u7ef4\u5ea6%1$s%2$s%3$s\u672a\u80fd\u5728\u5355\u636e\u5b9e\u4f53\u4e0a\u627e\u5230\u5bf9\u5e94\u5b57\u6bb5:", (String)"ValidatorUtil_25", (String)"bos-wf-engine", (Object[])new Object[0]), newParseInfo);
                validationInfo.setInfo(info13);
                validationDatas.add(ValidatorUtil.getValidationDataByRoleBillField("billField", entityNumber, newParseInfo, validationInfo));
            }
        }
        if (WfUtils.isNotEmpty(roleDimension)) {
            StringBuilder delNumber = new StringBuilder();
            Map<String, Object> map = WfRoleDimensionUtil.getDimensionInfos(roleDimension);
            List list = (List)map.get("dimensions");
            for (RoleDimension dimension : list) {
                if (dimensionMap.containsKey(dimension.getEntityNumber())) continue;
                DynamicObject dynObject = WfRoleDimensionUtil.getObjectType(dimension.getEntityNumber());
                if (WfUtils.isNullObject(dynObject)) {
                    delNumber = delNumber.append(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"ValidatorUtil_26", (String)"bos-wf-engine", (Object[])new Object[0])).append(dimension.getIndex().charAt(dimension.getIndex().length() - 1)).append("\u3001");
                    continue;
                }
                delNumber = delNumber.append(dynObject.getDataEntityType().getDisplayName().getLocaleValue()).append("\u3001");
            }
            if (delNumber.length() != 0) {
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                info1 = ValidatorUtil.strConcat(ResManager.loadKDString((String)"\u53c2\u7167\u7ef4\u5ea6\u672a\u8bbe\u7f6e:", (String)"ValidatorUtil_27", (String)"bos-wf-engine", (Object[])new Object[0]), delNumber.substring(0, delNumber.length() - 1));
                validationInfo.setInfo(info1);
                validationInfo.setInfoType("warning");
                ValidationData validationData = new ValidationData();
                validationData.setType("default");
                validationData.setValidationInfo(validationInfo);
                validationDatas.add(validationData);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void collectValidationDatasFromConditionRules(Process mainProcess, List<ConditionalEntity> conditionRules, List<ValidationData> validationDatas, Map<String, Object> keyMap, String bizEntityNumber) {
        if (null != conditionRules && !conditionRules.isEmpty()) {
            entityNumber = (String)keyMap.get("entityNumber");
            metadata = null;
            if (ProcessType.BizFlow.name().equals(mainProcess.getProcessType()) && WfUtils.isNotEmpty(bizEntityNumber)) {
                entityNumber = bizEntityNumber;
                metadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            }
            if (null == metadata) {
                metadata = (EntityMetadata)keyMap.get("billEntityMeta");
            }
            for (ConditionalEntity conditionalEntity : conditionRules) {
                option = conditionalEntity.getOperation();
                valueType = conditionalEntity.getValuetype();
                if ("fieldVal".equals(valueType)) continue;
                expression = expressionObj = conditionalEntity.getParamnumber();
                if ((expressionObj.contains("value=") || expressionObj.contains("value =")) && (matcher = (pattern = Pattern.compile("value=([\\w\\.]+)")).matcher(expressionObj)).find()) {
                    expression = matcher.group(1).trim();
                }
                eNum = "";
                if (WfUtils.isEmpty(conditionalEntity.getEntitynumber())) {
                    try {
                        param = new HashMap<String, Object>();
                        param.putAll(keyMap);
                        param.put("validateFlag", Boolean.TRUE);
                        param.put("entityNumber", entityNumber);
                        prop = ExpressionPropUtils.getPropByExpression(expression, metadata, mainProcess, param);
                        if (null == prop) ** GOTO lbl44
                        if (!"F7".equals(prop.getControlType())) continue;
                        eNum = prop.getEntityNumber();
                        compareTypeDtoList = CompareTypesUtils.get().getCompareTypesByType(prop.getControlType(), eNum);
                        if (null == compareTypeDtoList || compareTypeDtoList.isEmpty()) ** GOTO lbl44
                        for (CompareTypeDto c : compareTypeDtoList) {
                            if (null == option || !option.equals(c.getId()) || !(c instanceof WfCompareTypeDto)) continue;
                            eNum = ((WfCompareTypeDto)c).getEntityId();
                        }
                    }
                    catch (KDException e) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        info1 = ValidatorUtil.strConcat(new String[]{validationInfo.getInfo(), e.getMessage()});
                        validationInfo.setInfo(info1);
                        validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
                    }
                } else {
                    eNum = conditionalEntity.getEntitynumber();
                }
lbl44:
                // 5 sources

                if (!WfUtils.isNotEmpty(eNum) || !"bos_user".equals(eNum) && !"wf_role".equals(eNum) && !"bos_org".equals(eNum) && !"wf_orgtype".equals(eNum)) continue;
                valueList = new ArrayList<Map>();
                valueObject = conditionalEntity.getValue();
                if (WfUtils.isNotEmptyString(valueObject)) {
                    valueObjectString = valueObject.toString();
                    if (valueObjectString.startsWith("[")) {
                        retList = SerializationUtils.fromJsonStringToList((String)valueObjectString, Map.class);
                        valueList.addAll(retList);
                    } else {
                        valueMap = (Map)JSON.parse((String)valueObjectString);
                        valueList.add(valueMap);
                    }
                }
                if (valueList == null || valueList.isEmpty()) continue;
                block4: for (i = 0; i < valueList.size(); ++i) {
                    number = (String)((Map)valueList.get(i)).get("number");
                    id = (String)((Map)valueList.get(i)).get("value");
                    if ("bos_user".equals(eNum)) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        info1 = ValidatorUtil.strConcat(new String[]{validationInfo.getInfo(), String.format(ResManager.loadKDString((String)"\u4eba\u5458(%1$s)", (String)"ValidatorUtil_6", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{WfUtils.isEmpty(number) != false ? "" : "(" + number + ")"})});
                        validationInfo.setInfo(info1);
                        validationDatas.add(ValidatorUtil.getValidationDataByUser("user", id, validationInfo));
                    }
                    if ("wf_role".equals(eNum)) {
                        roleId = (String)((Map)valueList.get(i)).get("value");
                        roleDesc = (String)((Map)valueList.get(i)).get("alias");
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        info1 = ValidatorUtil.strConcat(new String[]{validationInfo.getInfo(), String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272(%1$s)", (String)"ValidatorUtil_7", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{roleDesc})});
                        validationInfo.setInfo(info1);
                        validationDatas.add(ValidatorUtil.getValidationDataByRole("role", roleId, validationInfo));
                    }
                    if ("bos_org".equals(eNum)) {
                        validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                        info1 = ValidatorUtil.strConcat(new String[]{validationInfo.getInfo(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7(%1$s)", (String)"ValidatorUtil_11", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{number})});
                        validationInfo.setInfo(info1);
                        validationDatas.add(ValidatorUtil.getValidationDataByOrg("org", id, validationInfo));
                    }
                    if (!"wf_orgtype".equals(eNum)) continue;
                    orgTypeId = (String)((Map)valueList.get(i)).get("value");
                    orgTypeNumber = (String)((Map)valueList.get(i)).get("number");
                    orgObjects = QueryServiceHelper.query((String)"wf_orgtype", (String)"status,entryentity.orgid,entryentity.orgnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(orgTypeId))});
                    validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                    info = WfUtils.transBlank(validationInfo.getInfo());
                    orgTpNum = WfUtils.transBlank(orgTypeNumber);
                    if (null != orgObjects && !orgObjects.isEmpty()) {
                        for (DynamicObject dObject : orgObjects) {
                            status = dObject.getString("status");
                            orgId = dObject.getString("entryentity.orgid");
                            orgNumber = dObject.getString("entryentity.orgnumber");
                            if ("1".equals(status)) {
                                if (WfUtils.isEmpty(orgNumber)) {
                                    validationInfo.setInfo(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u7c7b\u578b(\u7f16\u7801\uff1a%2$s)\u6240\u5c5e\u7ec4\u7ec7\u7f3a\u5931\u3002", (String)"ValidatorUtil_14", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{info, orgTpNum}));
                                    validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
                                    continue block4;
                                }
                                validationInfo.setInfo(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u7c7b\u578b(\u7f16\u7801\uff1a%2$s)\u6240\u5c5e\u7ec4\u7ec7(%3$s)", (String)"ValidatorUtil_15", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{info, orgTpNum, WfUtils.transBlank(orgNumber)}));
                                validationDatas.add(ValidatorUtil.getValidationDataByOrg("org", orgId, validationInfo));
                                continue;
                            }
                            validationInfo.setInfo(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u7c7b\u578b(\u7f16\u7801\uff1a%2$s)\u672a\u542f\u7528", (String)"ValidatorUtil_16", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{info, orgTpNum}));
                            validationInfo.setInfoType("warning");
                            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
                            continue block4;
                        }
                        continue;
                    }
                    validationInfo.setInfo(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u7c7b\u578b(\u7f16\u7801\uff1a%2$s)\u6240\u5c5e\u7ec4\u7ec7\u7f3a\u5931\u3002", (String)"ValidatorUtil_14", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[]{info, orgTpNum}));
                    validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
                }
            }
        }
    }

    public static void validateAfterAuditFromConditionRules(Process mainProcess, String conditionRule, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        if (mainProcess.getAfterAudit() != null && mainProcess.getAfterAudit().getAfterAuditbtn().booleanValue() && (conditionRule.contains("AuditTask") || conditionRule.contains("proc.lastAssignee"))) {
            StringBuilder sb = new StringBuilder();
            if (conditionRule.contains("AuditNumber")) {
                sb.append(ResManager.loadKDString((String)"\u51b3\u7b56\u7ed3\u679c", (String)"ValidatorUtil_28", (String)"bos-wf-engine", (Object[])new Object[0])).append("\u3001");
            }
            if (conditionRule.contains("Comment")) {
                sb.append(ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1", (String)"ValidatorUtil_29", (String)"bos-wf-engine", (Object[])new Object[0])).append("\u3001");
            }
            if (conditionRule.contains("ExecutionType")) {
                sb.append(ResManager.loadKDString((String)"\u6267\u884c\u7c7b\u578b", (String)"ValidatorUtil_30", (String)"bos-wf-engine", (Object[])new Object[0])).append("\u3001");
            }
            if (conditionRule.contains("Assignee")) {
                sb.append(ResManager.loadKDString((String)"\u8282\u70b9\u5904\u7406\u4eba", (String)"ValidatorUtil_31", (String)"bos-wf-engine", (Object[])new Object[0])).append("\u3001");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
                validationInfo.setInfo(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u5e94\u7528\u4e86%s\uff0c\u53ef\u80fd\u5bfc\u81f4\u8ba1\u7b97\u91cd\u590d\u5ba1\u6279\u573a\u666f\u51fa\u73b0\u504f\u5dee", (String)"ValidatorUtil_32", (String)"bos-wf-engine", (Object[])new Object[0]), sb.toString()));
                validationInfo.setInfoType("warning");
                validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
            }
        }
    }

    public static void validateAfterAuditFromReferencePerson(Process mainProcess, String referencePerson, List<ValidationData> validationDatas, Map<String, Object> keyMap) {
        if (mainProcess.getAfterAudit() != null && mainProcess.getAfterAudit().getAfterAuditbtn().booleanValue() && referencePerson.contains("Assignee")) {
            String info = ResManager.loadKDString((String)"\u8282\u70b9\u5904\u7406\u4eba", (String)"ValidatorUtil_31", (String)"bos-wf-engine", (Object[])new Object[0]);
            ValidationInfo validationInfo = ValidatorUtil.buildValidationInfo(keyMap);
            validationInfo.setInfo(String.format(ResManager.loadKDString((String)"\u5173\u7cfb\u7c7b\u578b\u53c2\u4e0e\u4eba\u7684\u53c2\u7167\u4eba\u5e94\u7528\u4e86%s\uff0c\u53ef\u80fd\u5bfc\u81f4\u8ba1\u7b97\u91cd\u590d\u5ba1\u6279\u573a\u666f\u51fa\u73b0\u504f\u5dee", (String)"ValidatorUtil_33", (String)"bos-wf-engine", (Object[])new Object[0]), info));
            validationInfo.setInfoType("warning");
            validationDatas.add(ValidatorUtil.getValidationDataByCondRule("condrule", validationInfo));
        }
    }

    public static ValidationDataCollator collatValidationDatas(List<ValidationData> validationDatas) {
        ValidationDataCollator validationDataCollator = new ValidationDataCollator();
        ArrayList<ValidationData> bills = new ArrayList<ValidationData>();
        ArrayList<ValidationData> summarys = new ArrayList<ValidationData>();
        ArrayList<ValidationData> ks = new ArrayList<ValidationData>();
        ArrayList<ValidationData> operations = new ArrayList<ValidationData>();
        ArrayList<ValidationData> extItfs = new ArrayList<ValidationData>();
        ArrayList<ValidationData> roles = new ArrayList<ValidationData>();
        ArrayList<ValidationData> userIds = new ArrayList<ValidationData>();
        ArrayList<ValidationData> orgs = new ArrayList<ValidationData>();
        ArrayList<ValidationData> rules = new ArrayList<ValidationData>();
        ArrayList<ValidationData> billCallActivity = new ArrayList<ValidationData>();
        ArrayList<ValidationData> billField = new ArrayList<ValidationData>();
        ArrayList<ValidationData> defaultValidationData = new ArrayList<ValidationData>();
        ArrayList<ValidationData> positions = new ArrayList<ValidationData>(validationDatas.size());
        for (ValidationData validationData : validationDatas) {
            switch (validationData.getType()) {
                case "bill": {
                    bills.add(validationData);
                    break;
                }
                case "billsummary": {
                    summarys.add(validationData);
                    break;
                }
                case "ks": {
                    ks.add(validationData);
                    break;
                }
                case "billoperation": {
                    operations.add(validationData);
                    break;
                }
                case "extItf": {
                    extItfs.add(validationData);
                    break;
                }
                case "role": {
                    roles.add(validationData);
                    break;
                }
                case "user": {
                    userIds.add(validationData);
                    break;
                }
                case "org": {
                    orgs.add(validationData);
                    break;
                }
                case "condrule": {
                    rules.add(validationData);
                    break;
                }
                case "billCallActivity": {
                    billCallActivity.add(validationData);
                    break;
                }
                case "billField": {
                    billField.add(validationData);
                    break;
                }
                case "default": {
                    defaultValidationData.add(validationData);
                    break;
                }
                case "position": {
                    positions.add(validationData);
                    break;
                }
            }
        }
        validationDataCollator.setBills(bills);
        validationDataCollator.setKs(ks);
        validationDataCollator.setOperations(operations);
        validationDataCollator.setExtItfs(extItfs);
        validationDataCollator.setSummarys(summarys);
        validationDataCollator.setUserIds(userIds);
        validationDataCollator.setRoles(roles);
        validationDataCollator.setOrgs(orgs);
        validationDataCollator.setRules(rules);
        validationDataCollator.setBillCallActivity(billCallActivity);
        validationDataCollator.setBillField(billField);
        validationDataCollator.setDefaultValidationData(defaultValidationData);
        validationDataCollator.setPositions(positions);
        return validationDataCollator;
    }

    public static String strConcat(String ... strs) {
        if (null == strs) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strs) {
            if (!WfUtils.isNotEmpty(s)) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean hasErrorInfo(List<ValidationError> errorList) {
        if (null == errorList || errorList.isEmpty()) {
            return false;
        }
        for (ValidationError e : errorList) {
            if (!"systemError".equals(e.getInfoType())) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getAllUserTaskInfos(Process process) {
        HashSet<String> ret = new HashSet<String>();
        if (null == process) {
            return ret;
        }
        List<FlowElement> flowElementList = process.getFlowElementList();
        for (FlowElement flowElement : flowElementList) {
            if (!(flowElement instanceof UserTask)) continue;
            ret.add(flowElement.getId());
        }
        return ret;
    }

    public static Set<String> getCanRejectTaskInfos(Process process) {
        HashSet<String> ret = new HashSet<String>();
        if (null == process) {
            return ret;
        }
        List<FlowElement> flowElementList = process.getFlowElementList();
        for (FlowElement flowElement : flowElementList) {
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof AutoTask) && !(flowElement instanceof CallActivity)) continue;
            ret.add(flowElement.getId());
        }
        return ret;
    }

    public static Set<String> getAllFlowElementIds(Process process) {
        HashSet<String> ret = new HashSet<String>(16);
        if (null == process) {
            return ret;
        }
        List<FlowElement> flowElementList = process.getFlowElementList();
        for (FlowElement flowElement : flowElementList) {
            ret.add(flowElement.getId());
        }
        return ret;
    }

    public static boolean hasIllegalSequenceFlowOrNot(Object fork, List<SequenceFlow> outgoingFlows) {
        boolean ret = false;
        if (null != fork && ((Boolean)fork).booleanValue()) {
            logger.debug("empty infos!");
        } else if (null != outgoingFlows && outgoingFlows.size() > 1) {
            ret = true;
            for (int i = 0; i < outgoingFlows.size(); ++i) {
                SequenceFlow goingFlow = outgoingFlows.get(i);
                if (null == goingFlow.getConditionalRule()) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static List<String> getSameSequneceFlowInfo(FlowNode flowNode) {
        ArrayList<String> ret = new ArrayList<String>(0);
        if (null != flowNode && null != flowNode.getOutgoingFlows() && flowNode.getOutgoingFlows().size() > 1) {
            String nodeName = flowNode.getName();
            HashMap<String, String> sMap = new HashMap<String, String>();
            for (SequenceFlow outSeq : flowNode.getOutgoingFlows()) {
                String targetRef = outSeq.getTargetRef();
                if (sMap.containsKey(targetRef)) {
                    if (null == outSeq.getTargetFlowElement()) continue;
                    String info = String.format(ResManager.loadKDString((String)"%1$s\u8282\u70b9\u5230%2$s\u8282\u70b9\u5b58\u5728\u91cd\u590d\u7ebf\u201c%3$s\u201d\u3002", (String)"ValidatorUtil_19", (String)"bos-wf-engine", (Object[])new Object[0]), nodeName, outSeq.getTargetFlowElement().getName(), outSeq.getNumber());
                    ret.add(info);
                    continue;
                }
                sMap.put(targetRef, "");
            }
        }
        return ret;
    }

    public static String checkoutExpressionExt(boolean displaySetting, String displayInfo) {
        String result;
        StringBuilder disappearExSB = new StringBuilder();
        if (WfUtils.isEmpty(displayInfo)) {
            return disappearExSB.toString();
        }
        if (displaySetting) {
            List<String> keys = ExpressionCalculatorUtil.getKeywords(displayInfo);
            if (keys == null || keys.isEmpty()) {
                return disappearExSB.toString();
            }
            int size = keys.size();
            ArrayList<String> expressionExtNumber = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                if (keys.get(i) == null || !keys.get(i).startsWith("mc_")) continue;
                expressionExtNumber.add(keys.get(i));
            }
            QFilter filter1 = new QFilter(NUMBER, "in", expressionExtNumber);
            QFilter[] filters = new QFilter[]{filter1};
            DynamicObjectCollection expressionExtColl = QueryServiceHelper.query((String)"wf_expressionext", (String)NUMBER, (QFilter[])filters);
            HashSet<String> numberSet = new HashSet<String>();
            if (expressionExtColl != null && !expressionExtColl.isEmpty()) {
                for (DynamicObject expressionExt : expressionExtColl) {
                    String number = (String)expressionExt.get(NUMBER);
                    numberSet.add(number);
                }
            }
            for (String expressionExtNumberOne : expressionExtNumber) {
                if (numberSet.contains(expressionExtNumberOne)) continue;
                disappearExSB.append(expressionExtNumberOne).append(',');
            }
        }
        if (WfUtils.isNotEmpty(result = disappearExSB.toString())) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

