/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.ext.fi.fircm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.engine.task.TaskInfo;

public class CreditApprovalNodeLeaveListener
implements ExecutionListener {
    private static final String NODE_TYPE_KEY_AUDIT = "AuditTask";
    private static final String NODE_TYPE_KEY_YZJ_AUDIT = "YunzhijiaTask";
    private static final String CREDITSUBSCOREINFO = "creditSubScoreInfo";

    public void notify(AgentExecution execution) {
        WorkflowElement flowElement = execution.getCurrentFlowElement();
        AgentTask currentTask = execution.getCurrentTask();
        if (flowElement == null || currentTask == null) {
            return;
        }
        String nodeType = flowElement.getType();
        String curTaskSelectedCreditRule = (String)currentTask.getVariable("creditscorerule");
        if (NODE_TYPE_KEY_AUDIT.equals(nodeType) && StringUtils.isNotEmpty((String)curTaskSelectedCreditRule) || NODE_TYPE_KEY_YZJ_AUDIT.equals(nodeType) && this.checkEnableCreditApprove(currentTask)) {
            HashMap<String, String> bizHandleData = new HashMap<String, String>(8);
            bizHandleData.put("entityNumber", execution.getEntityNumber());
            Long currentTaskId = execution.getCurrentTaskId();
            if (currentTaskId != null) {
                bizHandleData.put("currentTaskId", currentTaskId.toString());
            }
            bizHandleData.put("flowElementType", nodeType);
            bizHandleData.put("flowElementId", flowElement.getId());
            bizHandleData.put("flowElementName", flowElement.getName());
            bizHandleData.put("creditScoreRule", curTaskSelectedCreditRule);
            bizHandleData.put("auditType", (String)currentTask.getVariable("auditType"));
            bizHandleData.put("handleWay", (String)currentTask.getVariable("handleWay"));
            bizHandleData.put("creditSubScoreInfoStr", (String)currentTask.getVariable(CREDITSUBSCOREINFO));
            String creditScoreInfo = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"handleCreditScoreWhenWFNodeLeave", (Object[])new Object[]{bizHandleData});
            if (creditScoreInfo != null) {
                execution.setVariable(CREDITSUBSCOREINFO, (Object)creditScoreInfo);
            }
        }
    }

    private boolean checkEnableCreditApprove(AgentTask currentTask) {
        if (currentTask instanceof TaskInfo) {
            TaskInfo task = (TaskInfo)currentTask;
            String control = task.getControl();
            if (StringUtils.isEmpty((String)control)) {
                return false;
            }
            Map<String, Object> controlMap = this.getValueFromMapJson(control);
            if (controlMap == null) {
                return false;
            }
            return this.enableByCustomParam(controlMap) || this.enableByExtraNode(controlMap, task.getCategory());
        }
        return false;
    }

    private boolean enableByCustomParam(Map<String, Object> controlMap) {
        Object extras = controlMap.get("extras");
        if (extras == null) {
            return false;
        }
        if (!(extras instanceof Map)) {
            return false;
        }
        Map extrasMap = (Map)extras;
        Object credit = extrasMap.get("creditcontrol");
        return credit != null && "true".equalsIgnoreCase(credit.toString());
    }

    private boolean enableByExtraNode(Map<String, Object> controlMap, String nodeType) {
        Object nodeExtAudits = controlMap.get("extNum");
        if (nodeExtAudits == null) {
            return false;
        }
        if (!(nodeExtAudits instanceof List)) {
            return false;
        }
        List nodeExtAuditsList = (List)nodeExtAudits;
        return NODE_TYPE_KEY_AUDIT.equals(nodeType) && nodeExtAuditsList.contains("fircm_creditApprove#addCreditField") || NODE_TYPE_KEY_YZJ_AUDIT.equals(nodeType) && nodeExtAuditsList.contains("fircm_yzjCreditApprove#addCreditField");
    }

    private Map<String, Object> getValueFromMapJson(String mapJson) {
        if (StringUtils.isEmpty((String)mapJson)) {
            return null;
        }
        try {
            Map controlMap = (Map)SerializationUtils.fromJsonString((String)mapJson, Map.class);
            if (controlMap == null || controlMap.isEmpty()) {
                return null;
            }
            return controlMap;
        }
        catch (Exception e) {
            return null;
        }
    }
}

