/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.relservice;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.relservice.biz.BusinessEntityQuery;
import kd.bos.workflow.relservice.biz.BusinessObjectQuery;
import kd.bos.workflow.relservice.biz.DefaultBusinessEntityQuery;
import kd.bos.workflow.relservice.biz.DefaultBusinessObjectQuery;
import kd.bos.workflow.relservice.biz.ShowTrdBillPage;
import kd.bos.workflow.relservice.biz.context.BusinessObjectQueryContext;
import kd.bos.workflow.util.WfCommonUtil;

public final class BusinessObjectQueryHelper {
    private static Log logger = LogFactory.getLog(BusinessObjectQueryHelper.class);

    public static DynamicObject findBusinessObject(String businessKey, String entityNumber, String fields, BusinessObjectQueryContext context) {
        return BusinessObjectQueryHelper.getBusinessObjectProvider(entityNumber, context).findBusinessObject(businessKey, entityNumber, fields, context);
    }

    public static BusinessObjectQuery getBusinessObjectProvider(String entityNumber, BusinessObjectQueryContext context) {
        BusinessObjectQuery bo = null;
        try {
            String dataSource;
            if (context != null && "CT".equals(dataSource = context.getDataSourceType())) {
                String key = "CT_BO_" + entityNumber;
                bo = BusinessObjectQueryHelper.getBusinessObjectQueryExtension(key);
                if (bo == null) {
                    bo = BusinessObjectQueryHelper.getBusinessObjectQueryExtension("CT_BO_DEFAULT");
                }
                if (bo != null) {
                    return bo;
                }
            }
            String extName = "default";
            bo = BusinessObjectQueryHelper.getBusinessObjectQueryExtension(extName);
        }
        catch (Exception e) {
            logger.error(String.format("get business object error,entitynumber:%s,error is:%s", entityNumber, WfCommonUtil.getExceptionDetailStacktrace(e)));
        }
        if (bo == null) {
            return new DefaultBusinessObjectQuery();
        }
        return bo;
    }

    private static BusinessObjectQuery getBusinessObjectQueryExtension(String type) {
        BusinessObjectQuery bo = null;
        try {
            bo = (BusinessObjectQuery)ExtensionFactory.getExtensionFacotry(BusinessObjectQuery.class).getExtension(type);
        }
        catch (Exception e) {
            logger.error(String.format("type:[%s], error:[%s]", type, WfCommonUtil.getExceptionDetailStacktrace(e)));
        }
        return bo;
    }

    public static boolean exist(String entityNumber, Object businessKey, BusinessObjectQueryContext context) {
        return BusinessObjectQueryHelper.getBusinessObjectProvider(entityNumber, context).exist(entityNumber, businessKey, context);
    }

    private static BusinessEntityQuery getBusinessEntityProvider(String entityNumber) {
        BusinessEntityQuery be = null;
        try {
            String extName = "default";
            be = (BusinessEntityQuery)ExtensionFactory.getExtensionFacotry(BusinessEntityQuery.class).getExtension(extName);
        }
        catch (Exception e) {
            logger.error(String.format("get business entity error,entitynumber:%s,error is:%s", entityNumber, WfCommonUtil.getExceptionDetailStacktrace(e)));
        }
        if (be == null) {
            return new DefaultBusinessEntityQuery();
        }
        return be;
    }

    public static MainEntityType getDataEntityType(String entityNumber) {
        return BusinessObjectQueryHelper.getBusinessEntityProvider(entityNumber).getDataEntityType(entityNumber);
    }

    public static String buildTrdBillShowPageURL(String businessKey, String entityNumber, BusinessObjectQueryContext context) {
        if (context == null || StringUtils.isEmpty((CharSequence)context.getDataSourceType())) {
            return "";
        }
        String dataSource = "";
        ShowTrdBillPage openPage = null;
        String url = "";
        try {
            dataSource = context.getDataSourceType();
            if ("CT".equals(dataSource)) {
                String showPageUrl = "CT_SHOWPAGEURL_DEFAULT";
                openPage = (ShowTrdBillPage)ExtensionFactory.getExtensionFacotry(ShowTrdBillPage.class).getExtension(showPageUrl);
            }
            if (openPage != null) {
                url = openPage.buildTrdBillShowPageURL(businessKey, entityNumber, context);
            }
        }
        catch (Exception e) {
            logger.error(String.format("buildTrdBillShowPageURL error, message:[%s]", WfCommonUtil.getExceptionDetailStacktrace(e)));
        }
        return StringUtils.isEmpty((CharSequence)url) ? dataSource : url;
    }
}

