/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class WfCommonUtil {
    private static Log logger = LogFactory.getLog(WfCommonUtil.class);

    public static String getExceptionDetailStacktrace(Throwable exception) {
        if (exception == null) {
            return "exception is null!!!!";
        }
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    public static Date now() {
        return TimeServiceHelper.now();
    }

    public static boolean exist(String[] arr, String value) {
        for (String tmp : arr) {
            if (tmp == null || !tmp.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(ILocaleString value) {
        if (value == null || value.keySet().isEmpty()) {
            return true;
        }
        for (String key : value.keySet()) {
            if (!WfCommonUtil.isNotEmpty((String)value.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Long val) {
        return val == null || val == 0L;
    }

    public static boolean isNotEmpty(Long val) {
        return !WfCommonUtil.isEmpty(val);
    }

    public static Long normalizeId(long id) {
        if (id == 0L) {
            return null;
        }
        return id;
    }

    public static Long normalizeId(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        return id;
    }

    public static Long normalizeId(String val) {
        if (WfCommonUtil.isNotEmpty(val)) {
            return Long.parseLong(val) == 0L ? null : Long.valueOf(val);
        }
        return null;
    }

    public static String idToString(Long taskid) {
        if (taskid == null) {
            return null;
        }
        return String.valueOf(taskid);
    }

    public static Object normalizeId(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj == 0 ? null : obj;
        }
        if (obj instanceof Long) {
            return WfCommonUtil.normalizeId((Long)obj);
        }
        if (obj instanceof String) {
            return WfCommonUtil.normalizeId((String)obj);
        }
        return obj;
    }

    public static boolean isNotEmpty(ILocaleString value) {
        return !WfCommonUtil.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() <= 0;
    }

    public static boolean isNotEmpty(String value) {
        return !WfCommonUtil.isEmpty(value);
    }

    public static boolean isNullObject(Object obj) {
        return obj == null;
    }

    public static boolean isNotNullObject(Object obj) {
        return !WfCommonUtil.isNullObject(obj);
    }

    public static boolean isEmptyString(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String || value instanceof Number || value instanceof Character || value instanceof Boolean || value instanceof StringBuffer || value instanceof StringBuilder) {
            return WfCommonUtil.isEmpty(value.toString());
        }
        return false;
    }

    public static boolean isNotEmptyString(Object value) {
        if (value == null) {
            return false;
        }
        return WfCommonUtil.isNotEmpty(value.toString());
    }

    public static String subStringForMax(String value, int max) {
        if (value != null && value.length() > max) {
            return value.substring(0, max);
        }
        return value;
    }

    public static ILocaleString subILocaleString(ILocaleString value, int max) {
        if (value != null && !value.isEmpty()) {
            for (Map.Entry entry : value.entrySet()) {
                String val = (String)entry.getValue();
                value.put(entry.getKey(), (Object)WfCommonUtil.subStringForMax(val, max));
            }
        }
        return value;
    }

    public static Map<String, Object> getValueFromMapJson(String mapJson) {
        if (mapJson == null) {
            return null;
        }
        try {
            Map controlMap = (Map)SerializationUtils.fromJsonString((String)mapJson, Map.class);
            if (CollectionUtils.isEmpty((Map)controlMap)) {
                return null;
            }
            return controlMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getValueFromJson(Map<String, Object> map, String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName) || CollectionUtils.isEmpty(map)) {
            return null;
        }
        return map.get(fieldName);
    }

    public static boolean getBooleanValueFromJson(Map<String, Object> map, String fieldName) {
        Object forceSignatureObj = WfCommonUtil.getValueFromJson(map, fieldName);
        return BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)forceSignatureObj));
    }

    public static List<ServiceInfo> getServiceNodes() {
        ArrayList<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
        try {
            List services = ServiceInfoFactory.get().getServiceList();
            if (services != null) {
                serviceList.addAll(services);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return serviceList;
    }

    public static boolean isServiceNodeAlive(List<ServiceInfo> services, String executor) {
        boolean alive = false;
        try {
            for (ServiceInfo service : services) {
                if (!WfCommonUtil.getServiceNodeIpInstanceId(service.getIp(), service.getInstanceId()).equals(executor)) continue;
                alive = LivingServiceUtils.isInstanceAlive((String)service.getInstanceId());
                break;
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return alive;
    }

    public static String getServiceNodeIpInstanceId(String ip, String instanceId) {
        int maxLength = 60;
        if (instanceId != null && instanceId.length() > maxLength) {
            return String.format("%s;%s", ip, instanceId.subSequence(instanceId.length() - maxLength, instanceId.length()));
        }
        return String.format("%s;%s", ip, instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeBOSServiceByAppId(String appId, String serviceName, String methodName, Object ... paras) {
        try {
            Object object = DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)serviceName, (String)methodName, (Object[])paras);
            return object;
        }
        finally {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult executeOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        try {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
            return operationResult;
        }
        finally {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult executeOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        try {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
            return operationResult;
        }
        finally {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
    }
}

