/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.cmd;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.analysis.datasource.DataSetDataSource;
import kd.bos.workflow.analysis.datasource.IDataRow;
import kd.bos.workflow.analysis.datasource.IDataSource;
import kd.bos.workflow.analysis.entity.WorkflowAnalysisEntity;
import kd.bos.workflow.analysis.model.YearsInfo;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public abstract class AbstractInitAnalysisDatasCmd<T extends WorkflowAnalysisEntity>
implements Command<Void> {
    protected String procDefIdField = "PROCDEFID";
    protected String instanceCountField = "INSTANCECOUNT";
    protected String totalDurationField = "SUMDURATION";
    protected String totalRealDurationField = "SUMREALDURATION";
    private int limit = 5000;
    private SimpleDateFormat dateFormat = WorkflowAnalysisUtils.getYearsDateFormat();
    private SimpleDateFormat timeFormat = WorkflowAnalysisUtils.getRunningTimeDateFormat();
    private Date runningTime = new Date();
    private String fieldKey = "key";
    private String fieldType = "type";
    private String fieldValue = "value";
    protected Log log = LogFactory.getLog(this.getClass());

    public Void execute(CommandContext commandContext) {
        String handledYears;
        YearsInfo toBeHandled;
        if (!this.isReady()) {
            this.log.debug("not ready, ignore.");
            return null;
        }
        YearsInfo theSameMonth = this.getTheSameMonthYears();
        String theSameMonthYears = theSameMonth.getYears();
        this.executeByMonth(commandContext, theSameMonth, false);
        String lastMonthYears = null;
        if (this.isCrossMonth(theSameMonthYears)) {
            YearsInfo lastMonth = this.getLastMonthYears();
            lastMonthYears = lastMonth.getYears();
            this.executeByMonth(commandContext, lastMonth, false);
        }
        if ((toBeHandled = this.getToBeHandledYearsInfo(handledYears = (String)WfConfigurationUtil.getConfigCenterVal((String)this.getConfigKey()))) != null && !toBeHandled.getYears().equals(theSameMonthYears) && !toBeHandled.getYears().equals(lastMonthYears)) {
            this.executeByMonth(commandContext, toBeHandled, true);
        } else {
            this.saveRunningInfo(lastMonthYears != null ? lastMonthYears : theSameMonthYears, true);
        }
        return null;
    }

    private boolean isReady() {
        boolean enableWorkCalendar = WorkflowAnalysisUtils.isEnableWorkCalendar();
        boolean isReady = WorkflowAnalysisUtils.isUpdateRealDurationReady();
        this.log.info(String.format("check WorkCaneldar enable or ready, isOpenWorkCalendar: %s; isCompleteUpdateApprovedDuration: %s", enableWorkCalendar, isReady));
        return !enableWorkCalendar || isReady;
    }

    protected void executeByMonth(CommandContext commandContext, YearsInfo yearsInfo, boolean saveConfig) {
        this.clearDatas(yearsInfo.getYears());
        this.initDatasByMonth(commandContext, yearsInfo, saveConfig);
    }

    protected void initDatasByMonth(CommandContext commandContext, YearsInfo yearsInfo, boolean saveConfig) {
        this.initDatas(commandContext, yearsInfo, this.getQueryDataSet(yearsInfo), saveConfig);
    }

    protected boolean initDatas(CommandContext commandContext, YearsInfo yearsInfo, IDataSource<?> dataSource, boolean saveConfig) {
        this.log.debug(String.format("[initAnalysisDatas] years: %s configKey: %s", yearsInfo.getYears(), this.getConfigKey()));
        String years = yearsInfo.getYears();
        int count = 1;
        WorkflowAnalysisEntity entity = null;
        boolean flag = false;
        HashMap<Long, List<T>> procDefEntitiesMap = new HashMap<Long, List<T>>(32);
        try (IDataSource<?> ds = dataSource;){
            Iterator<?> iter = ds.iterator();
            while (iter.hasNext()) {
                flag = false;
                IDataRow row = ds.getDataRow(iter.next());
                entity = (WorkflowAnalysisEntity)this.createAnalysisEntity();
                Long procDefId = row.getLong(this.procDefIdField);
                if (this.isIgnoredRow(row)) {
                    this.log.debug(String.format("The ProcessDefinition %s ignored.", procDefId));
                    continue;
                }
                ArrayList<WorkflowAnalysisEntity> list = (ArrayList<WorkflowAnalysisEntity>)procDefEntitiesMap.get(procDefId);
                if (list == null) {
                    list = new ArrayList<WorkflowAnalysisEntity>(32);
                    procDefEntitiesMap.put(procDefId, list);
                }
                list.add(entity);
                entity.setYears(years);
                entity.setProcDefId(procDefId);
                this.initEntityBasicInfo(entity, row);
                if (count++ < this.limit) continue;
                this.supplementInfoAndInsert(commandContext, procDefEntitiesMap);
                count = 1;
                flag = true;
                procDefEntitiesMap.clear();
            }
            if (!flag && entity != null) {
                this.supplementInfoAndInsert(commandContext, procDefEntitiesMap);
                flag = true;
            }
        }
        catch (Exception e) {
            this.clearDatas(years);
            flag = false;
            throw e;
        }
        if (saveConfig) {
            this.saveRunningInfo(years, entity != null);
        }
        return flag;
    }

    protected boolean isIgnoredRow(IDataRow row) {
        return this.isIgnoredProcessDefinition(row.getLong(this.procDefIdField));
    }

    protected DataSetDataSource getQueryDataSet(YearsInfo yearsInfo) {
        Object[] params = new Object[]{yearsInfo.getBegin(), yearsInfo.getEnd()};
        return new DataSetDataSource(DB.queryDataSet((String)this.getQueryAlgoKey(), (DBRoute)DBRoute.workflow, (String)this.getQuerySQL(), (Object[])params));
    }

    protected void saveRunningInfo(String years, boolean saveYears) {
        QFilter filter = new QFilter(this.fieldKey, "=", (Object)this.getRunningTimeConfigKey());
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
        datas.add(this.createConfigObject(this.getRunningTimeConfigKey(), this.timeFormat.format(this.runningTime)));
        if (saveYears) {
            filter.or(new QFilter(this.fieldKey, "=", (Object)this.getConfigKey()));
            datas.add(this.createConfigObject(this.getConfigKey(), years));
        }
        DeleteServiceHelper.delete((String)"wf_confcenter", (QFilter[])new QFilter[]{filter});
        SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
    }

    protected DynamicObject createConfigObject(String key, String value) {
        DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"wf_confcenter");
        config.set(this.fieldType, (Object)"global");
        config.set(this.fieldKey, (Object)key);
        config.set(this.fieldValue, (Object)value);
        return config;
    }

    protected void initEntityBasicInfo(T entity, IDataRow row) {
        entity.setInstanceCount(row.getInteger(this.instanceCountField));
        entity.setTotalDuration(row.getLong(this.totalDurationField));
        entity.setTotalRealDuration(row.getLong(this.totalRealDurationField));
    }

    protected void supplementInfoAndInsert(CommandContext commandContext, Map<Long, List<T>> procDefEntitiesMap) {
        List<DynamicObject> dynObjs = this.initProcessAndEntityInfo(commandContext, procDefEntitiesMap);
        this.initEntityOtherInfo(commandContext, procDefEntitiesMap);
        this.filterBeforeSaving(dynObjs);
        SaveServiceHelper.save((DynamicObject[])dynObjs.toArray(new DynamicObject[0]));
    }

    protected void filterBeforeSaving(List<DynamicObject> dynObjs) {
    }

    protected List<DynamicObject> initProcessAndEntityInfo(CommandContext commandContext, Map<Long, List<T>> procDefEntitiesMap) {
        DynamicObject[] entityObjects;
        String fields = this.getQueryProcDefFields();
        HashMap entityMap = new HashMap(32);
        ArrayList<WorkflowAnalysisEntity> list = null;
        List entities = null;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", procDefEntitiesMap.keySet())};
        List procDefs = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, fields, null);
        for (ProcessDefinitionEntity procDef : procDefs) {
            entities = procDefEntitiesMap.get(procDef.getId());
            if (entities == null || entities.isEmpty()) continue;
            String entityNumber = procDef.getEntraBill();
            list = (ArrayList<WorkflowAnalysisEntity>)entityMap.get(entityNumber);
            if (list == null) {
                list = new ArrayList<WorkflowAnalysisEntity>(32);
                entityMap.put(entityNumber, list);
            }
            for (WorkflowAnalysisEntity entity : entities) {
                list.add(entity);
                this.initEntityProcessInfo(procDef, entityNumber, entity);
            }
        }
        ArrayList<DynamicObject> dynObjs = new ArrayList<DynamicObject>(this.limit);
        filters = new QFilter[]{new QFilter("number", "in", entityMap.keySet())};
        for (DynamicObject entityObject : entityObjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"name,number", (QFilter[])filters)) {
            ILocaleString name = entityObject.getLocaleString("name");
            String number = entityObject.getString("number");
            entities = (List)entityMap.get(number);
            if (entities == null || entities.isEmpty()) continue;
            for (WorkflowAnalysisEntity entity : entities) {
                entity.setEntityName(name);
                dynObjs.add(entity.getDynamicObject());
            }
        }
        return dynObjs;
    }

    protected String getQueryProcDefFields() {
        return String.format("%s,%s,%s,%s,%s,%s", "id", "key", "name", "entrabill", "orgunitid", "type");
    }

    protected void initEntityProcessInfo(ProcessDefinitionEntity procDef, String entityNumber, T entity) {
        entity.setProcNumber(procDef.getKey());
        entity.setProcType(procDef.getType());
        entity.setProcName(procDef.getName());
        entity.setEntityNumber(entityNumber);
        entity.setOrgUnitId(procDef.getOrgUnitId());
    }

    protected void initEntityOtherInfo(CommandContext commandContext, Map<Long, List<T>> procDefEntitiesMap) {
    }

    protected YearsInfo getToBeHandledYearsInfo(String handledYears) {
        if (handledYears != null && handledYears.matches("^\\d{6}$")) {
            YearsInfo info = new YearsInfo();
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = this.dateFormat.parse(handledYears);
                calendar.setTime(date);
                info.setEnd(calendar.getTime());
                calendar.add(2, -1);
                info.setBegin(calendar.getTime());
                info.setYears(this.dateFormat.format(info.getBegin()));
                return info;
            }
            catch (ParseException e) {
                this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
                return this.getTheSameMonthYears();
            }
        }
        return null;
    }

    protected YearsInfo getTheSameMonthYears() {
        YearsInfo info = new YearsInfo();
        Calendar calendar = this.getFirstDayOfMonth();
        info.setBegin(calendar.getTime());
        calendar.add(2, 1);
        info.setEnd(calendar.getTime());
        info.setYears(this.dateFormat.format(info.getBegin()));
        return info;
    }

    protected YearsInfo getLastMonthYears() {
        YearsInfo info = new YearsInfo();
        Calendar calendar = this.getFirstDayOfMonth();
        info.setEnd(calendar.getTime());
        calendar.add(2, -1);
        info.setBegin(calendar.getTime());
        info.setYears(this.dateFormat.format(info.getBegin()));
        return info;
    }

    protected Calendar getFirstDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getProcDefIdField() {
        return this.procDefIdField;
    }

    public void setProcDefIdField(String procDefIdField) {
        this.procDefIdField = procDefIdField;
    }

    public String getInstanceCountField() {
        return this.instanceCountField;
    }

    public void setInstanceCountField(String instanceCountField) {
        this.instanceCountField = instanceCountField;
    }

    public String getTotalDurationField() {
        return this.totalDurationField;
    }

    public void setTotalDurationField(String totalDurationField) {
        this.totalDurationField = totalDurationField;
    }

    protected boolean isIgnoredProcessDefinition(Long procDefId) {
        return "886006942529487872".equals(String.valueOf(procDefId));
    }

    protected boolean isCrossMonth(String theSameMonthYears) {
        String timeRegex = "(\\d{4})-(\\d{2})-\\d{2} \\d{2}:\\d{2}:\\d{2}";
        String lastRunningTime = (String)WfConfigurationUtil.getConfigCenterVal((String)this.getRunningTimeConfigKey());
        if (lastRunningTime != null && lastRunningTime.matches(timeRegex)) {
            String lastYears = lastRunningTime.replaceFirst(timeRegex, "$1$2");
            return !theSameMonthYears.equals(lastYears);
        }
        return false;
    }

    protected abstract String getConfigKey();

    protected abstract String getRunningTimeConfigKey();

    protected abstract String getQuerySQL();

    protected abstract String getQueryAlgoKey();

    protected abstract void clearDatas(String var1);

    protected abstract T createAnalysisEntity();
}

