/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.analysis.cmd.AbstractInitAnalysisDatasCmd;
import kd.bos.workflow.analysis.datasource.IDataRow;
import kd.bos.workflow.analysis.datasource.ListDataSource;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntity;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntityManager;
import kd.bos.workflow.analysis.model.YearsInfo;
import kd.bos.workflow.analysis.util.WorkflowAnalysisUtils;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class InitNodeAnalysisDatasCmd
extends AbstractInitAnalysisDatasCmd<NodeAnalysisEntity> {
    private String nodeIdField = "NODEID";
    private String nodeNameField = "NODENAME";
    private String maxDurationField = "MAXDURATION";
    private String maxRealDurationField = "MAXREALDURATION";
    private Map<String, ElementType> elementTypeMap;
    private Set<String> ignoredStencils = new HashSet<String>();

    @Override
    protected String getQuerySQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("FPROCDEFID PROCDEFID, FTASKDEFKEY NODEID, COUNT(1) INSTANCECOUNT, SUM(FDURATION) SUMDURATION, MAX(FDURATION) MAXDURATION, SUM(FREALDURATION) SUMREALDURATION, MAX(FREALDURATION) MAXREALDURATION ");
        sql.append("FROM T_WF_HITASKINST ");
        sql.append("WHERE ");
        sql.append("FPROCESSTYPE = '").append(ModelType.AuditFlow.name()).append("' AND ");
        sql.append("FASSIGNEEID != 0 AND FEXECUTIONTYPE = 'byHand' AND FENDTIME BETWEEN ? AND ? ");
        sql.append("GROUP BY FPROCDEFID,FTASKDEFKEY;");
        return sql.toString();
    }

    @Override
    protected String getConfigKey() {
        return "workflow.analysis.nodeAnalysisInit";
    }

    @Override
    protected String getRunningTimeConfigKey() {
        return "workflow.analysis.nodeScheduleRunningTime";
    }

    @Override
    protected String getQueryAlgoKey() {
        return "nodeAnalysisTask.queryHiTaskInst";
    }

    @Override
    protected void clearDatas(String years) {
        this.getNodeAnalysisEntityManager().clearByYears(years);
    }

    @Override
    protected NodeAnalysisEntity createAnalysisEntity() {
        return (NodeAnalysisEntity)this.getNodeAnalysisEntityManager().create();
    }

    @Override
    protected boolean isIgnoredRow(IDataRow row) {
        String nodeId = row.getString(this.nodeIdField);
        for (String type : this.ignoredStencils) {
            if (nodeId.indexOf(type) <= -1) continue;
            return true;
        }
        return super.isIgnoredRow(row);
    }

    @Override
    protected void initDatasByMonth(CommandContext commandContext, YearsInfo yearsInfo, boolean saveConfig) {
        boolean initSSCApprove = false;
        try {
            this.log.debug(String.format("invoke ssc service, begin: %s, end: %s", yearsInfo.getBegin(), yearsInfo.getEnd()));
            initSSCApprove = this.initSSCApproveDatas(commandContext, yearsInfo);
        }
        catch (Exception e) {
            this.log.warn(String.format("invoke ssc service failed, %s.", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (initSSCApprove) {
            this.ignoredStencils.add("SSCApprove");
        }
        super.initDatasByMonth(commandContext, yearsInfo, saveConfig);
    }

    protected boolean initSSCApproveDatas(CommandContext commandContext, YearsInfo yearsInfo) {
        Object result = DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"GeneralDataService", (String)this.getSSCServiceMethod(), (Object[])new Object[]{yearsInfo.getBegin(), yearsInfo.getEnd()});
        if (result instanceof List) {
            this.ignoredStencils.remove("SSCApprove");
            return this.initDatas(commandContext, yearsInfo, new ListDataSource((List)result), false);
        }
        this.log.debug(String.format("the result is invalid. %s", result == null ? "null" : result.getClass().getCanonicalName()));
        return false;
    }

    protected String getSSCServiceMethod() {
        return "getTaskWfStaticsByNode";
    }

    @Override
    protected void initEntityBasicInfo(NodeAnalysisEntity entity, IDataRow row) {
        super.initEntityBasicInfo(entity, row);
        entity.setNodeId(row.getString(this.nodeIdField));
        entity.setMaxDuration(row.getLong(this.maxDurationField));
        entity.setMaxRealDuration(row.getLong(this.maxRealDurationField));
        String nodeName = row.getString(this.nodeNameField);
        if (WfUtils.isNotEmpty((String)nodeName)) {
            entity.setNodeName((ILocaleString)new LocaleString(nodeName));
        }
    }

    @Override
    protected void initEntityOtherInfo(CommandContext commandContext, Map<Long, List<NodeAnalysisEntity>> procDefEntitiesMap) {
        super.initEntityOtherInfo(commandContext, procDefEntitiesMap);
        Set<Long> procDefIds = procDefEntitiesMap.keySet();
        Map<String, ProcessInfoDetailEntity> nodeInfoMap = null;
        QFilter[] filters = new QFilter[]{new QFilter("procdefid", "in", procDefIds), new QFilter("schemetype", "in", (Object)"default")};
        String fields = String.format("%s,%s,%s,%s,%s,%s,%s", "procdefid", "activityid", "activityname", "activitytype", "activitytypename", "activityentityid", "activitynumber");
        List processInfos = commandContext.getProcessInfoEntityManager().findByQueryFilters(filters, fields, null);
        if (processInfos == null || processInfos.isEmpty()) {
            nodeInfoMap = this.getNodeInfoByParseModel(commandContext, procDefIds);
            this.setNodeInfoForEntity(procDefEntitiesMap, nodeInfoMap, procDefIds);
        } else {
            List details = null;
            HashSet<Long> dbProcDefIds = new HashSet<Long>(processInfos.size());
            nodeInfoMap = new HashMap<String, ProcessInfoDetailEntity>(processInfos.size() * 16);
            for (ProcessInfoEntity processInfo : processInfos) {
                Long procDefId = processInfo.getProcdefId();
                dbProcDefIds.add(procDefId);
                details = processInfo.getDetails();
                for (ProcessInfoDetailEntity detail : details) {
                    nodeInfoMap.put(this.getNodeInfoKey(procDefId, detail.getActivityId()), detail);
                }
            }
            this.setNodeInfoForEntity(procDefEntitiesMap, nodeInfoMap, dbProcDefIds);
            Sets.SetView ids = Sets.difference(procDefIds, dbProcDefIds);
            if (ids != null && !ids.isEmpty()) {
                nodeInfoMap = this.getNodeInfoByParseModel(commandContext, (Set<Long>)ids);
                this.setNodeInfoForEntity(procDefEntitiesMap, nodeInfoMap, (Set<Long>)ids);
            }
        }
    }

    private void setNodeInfoForEntity(Map<Long, List<NodeAnalysisEntity>> procDefEntitiesMap, Map<String, ProcessInfoDetailEntity> nodeInfoMap, Set<Long> procDefIds) {
        ProcessInfoDetailEntity detail = null;
        for (Long procDefId : procDefIds) {
            List<NodeAnalysisEntity> entities = procDefEntitiesMap.get(procDefId);
            for (NodeAnalysisEntity entity : entities) {
                String key = this.getNodeInfoKey(procDefId, entity.getNodeId());
                detail = nodeInfoMap.get(key);
                if (detail == null) {
                    this.log.debug(String.format("%s is a dynamic node. ", key));
                    this.setAddSignNodeInfo(entity);
                    continue;
                }
                if (WfUtils.isEmpty((ILocaleString)entity.getNodeName())) {
                    entity.setNodeName(detail.getActivityName());
                }
                entity.setNodeType(detail.getActivityType());
                entity.setNodeTypeName(detail.getActivityTypeName());
            }
        }
    }

    private void setAddSignNodeInfo(NodeAnalysisEntity entity) {
        String nodeId = entity.getNodeId();
        entity.setNodeName(WorkflowAnalysisUtils.getDynamicNodeLocaleStringName());
        String type = nodeId.replaceFirst("\\w+_([A-Z][a-zA-Z]+)\\d+", "$1");
        entity.setNodeType(type);
        entity.setNodeTypeName(this.getActivityTypeName(type));
    }

    private String getNodeInfoKey(Long procDefId, String nodeId) {
        return String.format("%s_%s", procDefId, nodeId);
    }

    private Map<String, ProcessInfoDetailEntity> getNodeInfoByParseModel(CommandContext commandContext, Set<Long> procDefIds) {
        HashMap<String, ProcessInfoDetailEntity> nodeInfoMap = new HashMap<String, ProcessInfoDetailEntity>(procDefIds.size() * 16);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", procDefIds)};
        String fields = String.format("%s,%s", "id", "resourceid");
        List procDefs = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, fields, null);
        HashMap<Long, Long> resProcMap = new HashMap<Long, Long>(procDefs.size());
        for (ProcessDefinitionEntity procDef : procDefs) {
            resProcMap.put(procDef.getResourceId(), procDef.getId());
        }
        filters = new QFilter[]{new QFilter("id", "in", resProcMap.keySet())};
        fields = String.format("%s,%s,%s", "id", "data", "content");
        List resources = commandContext.getResourceEntityManager().findByQueryFilters(filters, fields, null);
        for (ResourceEntity resource : resources) {
            Long procDefId = (Long)resProcMap.get(resource.getId());
            this.parseNodeInfoFromModelJSON(procDefId, resource, nodeInfoMap);
        }
        return nodeInfoMap;
    }

    private void parseNodeInfoFromModelJSON(Long procDefId, ResourceEntity resource, Map<String, ProcessInfoDetailEntity> nodeInfoMap) {
        JSONObject model = JSON.parseObject((String)resource.getData());
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatasFromResource((ResourceEntity)resource);
        JSONArray children = model.getJSONArray("childShapes");
        int size = children.size();
        ProcessInfoDetailEntityImpl detail = null;
        for (int i = 0; i < size; ++i) {
            JSONObject child = children.getJSONObject(i);
            JSONObject properties = child.getJSONObject("properties");
            JSONObject stencil = child.getJSONObject("stencil");
            String activityType = stencil.getString("id");
            if ("SequenceFlow".equals(activityType) || "StartSignalEvent".equals(activityType) || "EndNoneEvent".equals(activityType) || "AutoTask".equals(activityType)) continue;
            detail = new ProcessInfoDetailEntityImpl();
            String activityId = properties.getString("itemId");
            String multiKey = BpmnModelUtil.getActivityNameMultiKey((String)activityId);
            detail.setActivityId(activityId);
            detail.setActivityType(activityType);
            ILocaleString activityName = BpmnModelUtil.getMultiLangFieldValue((JSONObject)multiLangDatas, (String)multiKey, (String)properties.getString("name"));
            detail.setActivityName(activityName);
            detail.setActivityTypeName(this.getActivityTypeName(activityType));
            nodeInfoMap.put(this.getNodeInfoKey(procDefId, activityId), (ProcessInfoDetailEntity)detail);
        }
    }

    private void initElementTypeMap() {
        this.elementTypeMap = new HashMap<String, ElementType>();
        this.putElementTypes(GraphCodecUtils.getDomainType((String)"WorkflowModel"));
        String extModel = GraphCodecUtils.getExtendedModel((String)"WorkflowModel");
        if (extModel != null) {
            String[] modelIds;
            for (String modelId : modelIds = extModel.split(";")) {
                this.putElementTypes(GraphCodecUtils.getDomainType((String)modelId));
            }
        }
    }

    private void putElementTypes(DomainModelType domainModelType) {
        if (domainModelType != null) {
            this.getElementTypeMap().putAll(domainModelType.getElementTypes());
        }
    }

    private ILocaleString getActivityTypeName(String activityType) {
        ElementType elementType = this.getElementTypeMap().get(activityType);
        return elementType != null ? elementType.getName() : new LocaleString(activityType);
    }

    private Map<String, ElementType> getElementTypeMap() {
        if (this.elementTypeMap == null) {
            this.initElementTypeMap();
        }
        return this.elementTypeMap;
    }

    protected NodeAnalysisEntityManager getNodeAnalysisEntityManager() {
        return (NodeAnalysisEntityManager)Context.getCommandContext().getEntityManager(NodeAnalysisEntityManager.class);
    }
}

