/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.analysis.cmd.InitNodeAnalysisDatasCmd;
import kd.bos.workflow.analysis.datasource.IDataRow;
import kd.bos.workflow.analysis.entity.NodeAnalysisEntity;
import kd.bos.workflow.analysis.entity.PersonAnalysisEntity;
import kd.bos.workflow.analysis.entity.PersonAnalysisEntityManager;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class InitPersonAnalysisDatasCmd
extends InitNodeAnalysisDatasCmd {
    private String userIdField = "USERID";
    private Set<Long> invalidUserIds = new HashSet<Long>();

    @Override
    protected String getQuerySQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("FPROCDEFID PROCDEFID, FTASKDEFKEY NODEID, FASSIGNEEID USERID, COUNT(1) INSTANCECOUNT, SUM(FDURATION) SUMDURATION, MAX(FDURATION) MAXDURATION, SUM(FREALDURATION) SUMREALDURATION, MAX(FREALDURATION) MAXREALDURATION  ");
        sql.append("FROM T_WF_HITASKINST ");
        sql.append("WHERE ");
        sql.append("FPROCESSTYPE = '").append(ModelType.AuditFlow.name()).append("' AND ");
        sql.append("FASSIGNEEID != 0 AND FEXECUTIONTYPE = 'byHand' AND FENDTIME BETWEEN ? AND ? ");
        sql.append("GROUP BY FPROCDEFID,FTASKDEFKEY,FASSIGNEEID;");
        return sql.toString();
    }

    @Override
    protected String getSSCServiceMethod() {
        return "getTaskWfStaticsByUser";
    }

    @Override
    protected void initEntityBasicInfo(NodeAnalysisEntity entity, IDataRow row) {
        super.initEntityBasicInfo(entity, row);
        PersonAnalysisEntity analysisEntity = (PersonAnalysisEntity)entity;
        analysisEntity.setAssigneeId(row.getLong(this.userIdField));
    }

    @Override
    protected void initEntityOtherInfo(CommandContext commandContext, Map<Long, List<NodeAnalysisEntity>> procDefEntitiesMap) {
        DynamicObject[] users;
        super.initEntityOtherInfo(commandContext, procDefEntitiesMap);
        Long assigneeId = null;
        ArrayList<PersonAnalysisEntity> list = null;
        PersonAnalysisEntity analysisEntity = null;
        HashMap<Long, ArrayList<PersonAnalysisEntity>> userEntityMap = new HashMap<Long, ArrayList<PersonAnalysisEntity>>(32);
        for (List<NodeAnalysisEntity> entities : procDefEntitiesMap.values()) {
            for (NodeAnalysisEntity entity : entities) {
                analysisEntity = (PersonAnalysisEntity)entity;
                assigneeId = analysisEntity.getAssigneeId();
                if (WfUtils.isEmpty((Long)assigneeId)) continue;
                list = (ArrayList<PersonAnalysisEntity>)userEntityMap.get(assigneeId);
                if (list == null) {
                    list = new ArrayList<PersonAnalysisEntity>(32);
                    userEntityMap.put(assigneeId, list);
                }
                list.add(analysisEntity);
            }
        }
        this.invalidUserIds = new HashSet(userEntityMap.keySet());
        List entities = null;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userEntityMap.keySet())};
        for (DynamicObject user : users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number,picturefield", (QFilter[])filters)) {
            Long userId = user.getLong("id");
            ILocaleString name = user.getLocaleString("name");
            String number = user.getString("number");
            String avatar = user.getString("picturefield");
            entities = (List)userEntityMap.get(userId);
            for (PersonAnalysisEntity entity : entities) {
                entity.setAssignee(name);
                entity.setAssigneeNumber(number);
                entity.setAssigneeAvatar(avatar);
            }
            this.invalidUserIds.remove(userId);
        }
    }

    @Override
    protected void filterBeforeSaving(List<DynamicObject> dynObjs) {
        if (!this.invalidUserIds.isEmpty()) {
            Iterator<DynamicObject> iterator = dynObjs.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynObj = iterator.next();
                Long userId = dynObj.getLong("assigneeid");
                if (!this.invalidUserIds.contains(userId)) continue;
                iterator.remove();
            }
        } else {
            super.filterBeforeSaving(dynObjs);
        }
    }

    @Override
    protected String getConfigKey() {
        return "workflow.analysis.personAnalysisInit";
    }

    @Override
    protected String getRunningTimeConfigKey() {
        return "workflow.analysis.personScheduleRunningTime";
    }

    @Override
    protected String getQueryAlgoKey() {
        return "personAnalysisTask.queryHiTaskInst";
    }

    @Override
    protected void clearDatas(String years) {
        this.getPersonAnalysisEntityManager().clearByYears(years);
    }

    @Override
    protected PersonAnalysisEntity createAnalysisEntity() {
        return (PersonAnalysisEntity)this.getPersonAnalysisEntityManager().create();
    }

    @Override
    protected boolean isIgnoredProcessDefinition(Long procDefId) {
        return false;
    }

    protected PersonAnalysisEntityManager getPersonAnalysisEntityManager() {
        return (PersonAnalysisEntityManager)Context.getCommandContext().getEntityManager(PersonAnalysisEntityManager.class);
    }
}

