/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.analysis.cmd;

import kd.bos.workflow.analysis.cmd.AbstractInitAnalysisDatasCmd;
import kd.bos.workflow.analysis.entity.ProcAnalysisEntity;
import kd.bos.workflow.analysis.entity.ProcAnalysisEntityManager;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class InitProcAnalysisDatasCmd
extends AbstractInitAnalysisDatasCmd<ProcAnalysisEntity> {
    @Override
    protected String getQuerySQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("FPROCDEFID PROCDEFID, COUNT(1) INSTANCECOUNT, SUM(FDURATION) SUMDURATION, SUM(FREALDURATION) SUMREALDURATION ");
        sql.append("FROM T_WF_HIPROCINST ");
        sql.append("WHERE ");
        sql.append("FPROCESSTYPE = '").append(ModelType.AuditFlow.name()).append("' AND ");
        sql.append("FENDTYPE != '").append("20").append("' AND ");
        sql.append("FENDTIME BETWEEN ? AND ? ");
        sql.append("GROUP BY FPROCDEFID;");
        return sql.toString();
    }

    @Override
    protected String getConfigKey() {
        return "workflow.analysis.processAnalysisInit";
    }

    @Override
    protected String getRunningTimeConfigKey() {
        return "workflow.analysis.procScheduleRunningTime";
    }

    @Override
    protected String getQueryAlgoKey() {
        return "procAnalysisTask.queryHiProcInst";
    }

    @Override
    protected void clearDatas(String years) {
        this.getProcAnalysisEntityManager().clearByYears(years);
    }

    @Override
    protected ProcAnalysisEntity createAnalysisEntity() {
        return (ProcAnalysisEntity)this.getProcAnalysisEntityManager().create();
    }

    @Override
    protected String getQueryProcDefFields() {
        return String.format("%s,%s", super.getQueryProcDefFields(), "version");
    }

    @Override
    protected void initEntityProcessInfo(ProcessDefinitionEntity procDef, String entityNumber, ProcAnalysisEntity entity) {
        super.initEntityProcessInfo(procDef, entityNumber, entity);
        entity.setProcVersion(procDef.getVersion());
    }

    protected ProcAnalysisEntityManager getProcAnalysisEntityManager() {
        return (ProcAnalysisEntityManager)Context.getCommandContext().getEntityManager(ProcAnalysisEntityManager.class);
    }
}

